/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-21 20:47:09 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE `pcmdivi5users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=5045 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5ac_segments` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `key` char(13) NOT NULL,
  `list_screen_id` varchar(20) NOT NULL DEFAULT '',
  `user_id` bigint(20) DEFAULT NULL,
  `name` varchar(255) NOT NULL DEFAULT '',
  `url_parameters` mediumtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5admin_columns` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `list_id` varchar(20) NOT NULL DEFAULT '',
  `list_key` varchar(100) NOT NULL DEFAULT '',
  `title` varchar(255) NOT NULL DEFAULT '',
  `columns` mediumtext DEFAULT NULL,
  `settings` mediumtext DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  UNIQUE KEY `list_id` (`list_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5atai_assets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `wp_post_id` bigint(20) unsigned NOT NULL,
  `asset_id` varchar(128) NOT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `asset_id` (`asset_id`),
  KEY `idx_wp_posts` (`wp_post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5blc_filters` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `params` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5blc_instances` (
  `instance_id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `link_id` int(10) unsigned NOT NULL,
  `container_id` int(10) unsigned NOT NULL,
  `container_type` varchar(40) NOT NULL DEFAULT 'post',
  `link_text` text NOT NULL DEFAULT '',
  `parser_type` varchar(40) NOT NULL DEFAULT 'link',
  `container_field` varchar(250) NOT NULL DEFAULT '',
  `link_context` varchar(250) NOT NULL DEFAULT '',
  `raw_url` text NOT NULL,
  PRIMARY KEY (`instance_id`),
  KEY `link_id` (`link_id`),
  KEY `source_id` (`container_type`,`container_id`),
  KEY `parser_type` (`parser_type`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5blc_links` (
  `link_id` int(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` text CHARACTER SET utf8mb3 COLLATE utf8mb3_bin NOT NULL,
  `first_failure` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_success` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_check_attempt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `check_count` int(4) unsigned NOT NULL DEFAULT 0,
  `final_url` text CHARACTER SET latin1 COLLATE latin1_general_cs NOT NULL,
  `redirect_count` smallint(5) unsigned NOT NULL DEFAULT 0,
  `log` text NOT NULL,
  `http_code` smallint(6) NOT NULL DEFAULT 0,
  `status_code` varchar(100) DEFAULT '',
  `status_text` varchar(250) DEFAULT '',
  `request_duration` float NOT NULL DEFAULT 0,
  `timeout` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `broken` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `warning` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `may_recheck` tinyint(1) NOT NULL DEFAULT 1,
  `being_checked` tinyint(1) NOT NULL DEFAULT 0,
  `result_hash` varchar(200) NOT NULL DEFAULT '',
  `false_positive` tinyint(1) NOT NULL DEFAULT 0,
  `dismissed` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`link_id`),
  KEY `url` (`url`(150)),
  KEY `final_url` (`final_url`(150)),
  KEY `http_code` (`http_code`),
  KEY `broken` (`broken`),
  KEY `last_check_attempt` (`last_check_attempt`),
  KEY `may_recheck` (`may_recheck`),
  KEY `check_count` (`check_count`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5blc_synch` (
  `container_id` int(20) unsigned NOT NULL,
  `container_type` varchar(40) NOT NULL,
  `synched` tinyint(2) unsigned NOT NULL,
  `last_synch` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`container_type`,`container_id`),
  KEY `synched` (`synched`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_antibot` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) NOT NULL,
  `unlocked` tinyint(1) DEFAULT NULL,
  `unlocked_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_audit_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` int(11) NOT NULL,
  `event_type` varchar(255) NOT NULL,
  `action_type` varchar(255) NOT NULL,
  `site_url` varchar(255) NOT NULL,
  `user_id` int(11) NOT NULL,
  `context` varchar(255) NOT NULL,
  `ip` varchar(45) NOT NULL,
  `msg` varchar(255) NOT NULL,
  `blog_id` int(11) NOT NULL,
  `synced` int(11) NOT NULL,
  `ttl` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `event_type` (`event_type`(250)),
  KEY `action_type` (`action_type`(250)),
  KEY `user_id` (`user_id`),
  KEY `context` (`context`(250)),
  KEY `ip` (`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_email_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` int(11) NOT NULL,
  `source` varchar(255) NOT NULL,
  `to` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `source` (`source`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_lockout` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) DEFAULT NULL,
  `status` varchar(16) DEFAULT NULL,
  `lockout_message` text DEFAULT NULL,
  `release_time` int(11) DEFAULT NULL,
  `lock_time` int(11) DEFAULT NULL,
  `lock_time_404` int(11) DEFAULT NULL,
  `attempt` int(11) DEFAULT NULL,
  `attempt_404` int(11) DEFAULT NULL,
  `meta` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`),
  KEY `status` (`status`),
  KEY `attempt` (`attempt`),
  KEY `attempt_404` (`attempt_404`)
) ENGINE=MyISAM AUTO_INCREMENT=2545 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_lockout_log` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `log` text DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `date` int(11) DEFAULT NULL,
  `type` varchar(16) DEFAULT NULL,
  `user_agent` varchar(255) DEFAULT NULL,
  `blog_id` int(11) DEFAULT NULL,
  `tried` varchar(255) DEFAULT NULL,
  `country_iso_code` char(2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`),
  KEY `type` (`type`),
  KEY `tried` (`tried`(250)),
  KEY `country_iso_code` (`country_iso_code`),
  KEY `idx_ip_date` (`ip`,`date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_quarantine` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `defender_scan_item_id` int(10) unsigned DEFAULT NULL,
  `file_hash` char(53) NOT NULL,
  `file_full_path` text NOT NULL,
  `file_original_name` tinytext NOT NULL,
  `file_extension` varchar(16) DEFAULT NULL,
  `file_mime_type` varchar(64) DEFAULT NULL,
  `file_rw_permission` smallint(5) unsigned DEFAULT NULL,
  `file_owner` varchar(255) DEFAULT NULL,
  `file_group` varchar(255) DEFAULT NULL,
  `file_version` varchar(32) DEFAULT NULL,
  `file_category` tinyint(3) unsigned DEFAULT 0,
  `file_modified_time` datetime NOT NULL,
  `source_slug` varchar(255) NOT NULL,
  `created_time` datetime NOT NULL,
  `created_by` bigint(20) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pcmdivi5682da3d1756a3_defender_scan_item_id` (`defender_scan_item_id`),
  KEY `pcmdivi5682da3d1756a3_created_by` (`created_by`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_scan` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `percent` float NOT NULL,
  `total_tasks` tinyint(4) NOT NULL,
  `task_checkpoint` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `date_start` datetime NOT NULL,
  `date_end` datetime NOT NULL,
  `is_automation` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_scan_item` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL,
  `type` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  `raw_data` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`(250)),
  KEY `status` (`status`(250))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5defender_unlockout` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `ip` varchar(45) DEFAULT NULL,
  `type` varchar(16) NOT NULL,
  `email` varchar(255) NOT NULL,
  `status` varchar(16) NOT NULL,
  `timestamp` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `ip` (`ip`),
  KEY `type` (`type`),
  KEY `email` (`email`(250)),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5duplicator_pro_entities` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) NOT NULL,
  `data` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_addon_feed` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(8) unsigned NOT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `feed_order` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `addon_slug` varchar(50) DEFAULT NULL,
  `event_type` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `addon_form` (`addon_slug`,`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_draft_submissions` (
  `uuid` char(32) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` varchar(45) NOT NULL,
  `source_url` longtext NOT NULL,
  `submission` longtext NOT NULL,
  PRIMARY KEY (`uuid`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_entry` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `post_id` bigint(10) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_starred` tinyint(10) NOT NULL DEFAULT 0,
  `is_read` tinyint(10) NOT NULL DEFAULT 0,
  `ip` varchar(45) NOT NULL,
  `source_url` varchar(200) NOT NULL DEFAULT '',
  `user_agent` varchar(250) NOT NULL DEFAULT '',
  `currency` varchar(5) DEFAULT NULL,
  `payment_status` varchar(15) DEFAULT NULL,
  `payment_date` datetime DEFAULT NULL,
  `payment_amount` decimal(19,2) DEFAULT NULL,
  `payment_method` varchar(30) DEFAULT NULL,
  `transaction_id` varchar(50) DEFAULT NULL,
  `is_fulfilled` tinyint(10) DEFAULT NULL,
  `created_by` bigint(10) unsigned DEFAULT NULL,
  `transaction_type` tinyint(10) DEFAULT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'active',
  `source_id` bigint(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `form_id` (`form_id`),
  KEY `form_id_status` (`form_id`,`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_entry_meta` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL DEFAULT 0,
  `entry_id` bigint(10) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  `item_index` varchar(60) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `entry_id` (`entry_id`),
  KEY `meta_value` (`meta_value`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_entry_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `entry_id` int(10) unsigned NOT NULL,
  `user_name` varchar(250) DEFAULT NULL,
  `user_id` bigint(10) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `value` longtext DEFAULT NULL,
  `note_type` varchar(50) DEFAULT NULL,
  `sub_type` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `entry_id` (`entry_id`),
  KEY `entry_user_key` (`entry_id`,`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_form` (
  `id` mediumint(10) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(150) NOT NULL,
  `date_created` datetime NOT NULL,
  `date_updated` datetime DEFAULT NULL,
  `is_active` tinyint(10) NOT NULL DEFAULT 1,
  `is_trash` tinyint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_form_meta` (
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `entries_grid_meta` longtext DEFAULT NULL,
  `confirmations` longtext DEFAULT NULL,
  `notifications` longtext DEFAULT NULL,
  PRIMARY KEY (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_form_revisions` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `display_meta` longtext DEFAULT NULL,
  `date_created` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_form_view` (
  `id` bigint(10) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` mediumint(10) unsigned NOT NULL,
  `date_created` datetime NOT NULL,
  `ip` char(15) DEFAULT NULL,
  `count` mediumint(10) unsigned NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `date_created` (`date_created`),
  KEY `form_id` (`form_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5gf_rest_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5imagify_files` (
  `file_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `folder_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `file_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `path` varchar(191) NOT NULL DEFAULT '',
  `hash` varchar(32) NOT NULL DEFAULT '',
  `mime_type` varchar(100) NOT NULL DEFAULT '',
  `modified` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `width` smallint(2) unsigned NOT NULL DEFAULT 0,
  `height` smallint(2) unsigned NOT NULL DEFAULT 0,
  `original_size` int(4) unsigned NOT NULL DEFAULT 0,
  `optimized_size` int(4) unsigned DEFAULT NULL,
  `percent` smallint(2) unsigned DEFAULT NULL,
  `optimization_level` tinyint(1) unsigned DEFAULT NULL,
  `status` varchar(20) DEFAULT NULL,
  `error` varchar(255) DEFAULT NULL,
  `data` longtext DEFAULT NULL,
  PRIMARY KEY (`file_id`),
  UNIQUE KEY `path` (`path`),
  KEY `folder_id` (`folder_id`),
  KEY `optimization_level` (`optimization_level`),
  KEY `status` (`status`),
  KEY `modified` (`modified`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5imagify_folders` (
  `folder_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `path` varchar(191) NOT NULL DEFAULT '',
  `active` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`folder_id`),
  UNIQUE KEY `path` (`path`),
  KEY `active` (`active`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=25470 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5seopress_content_analysis` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `title` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `og_title` longtext DEFAULT NULL,
  `og_description` longtext DEFAULT NULL,
  `og_image` longtext DEFAULT NULL,
  `og_url` longtext DEFAULT NULL,
  `og_site_name` longtext DEFAULT NULL,
  `twitter_title` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_image_src` longtext DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `h1` longtext DEFAULT NULL,
  `h2` longtext DEFAULT NULL,
  `h3` longtext DEFAULT NULL,
  `images` longtext DEFAULT NULL,
  `meta_robots` longtext DEFAULT NULL,
  `meta_google` longtext DEFAULT NULL,
  `links_no_follow` longtext DEFAULT NULL,
  `outbound_links` longtext DEFAULT NULL,
  `internal_links` longtext DEFAULT NULL,
  `json_schemas` longtext DEFAULT NULL,
  `keywords` text DEFAULT NULL,
  `permalink` text DEFAULT NULL,
  `score` text DEFAULT NULL,
  `analysis_date` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_post_id` (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5seopress_seo_issues` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT 0,
  `issue_name` longtext DEFAULT '',
  `issue_desc` longtext DEFAULT '',
  `issue_type` text DEFAULT '',
  `issue_priority` text DEFAULT '',
  `issue_ignore` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_post_id` (`post_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5seopress_significant_keywords` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT 0,
  `word` varchar(100) DEFAULT '',
  `count` int(11) DEFAULT 0,
  `tf` float DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `idx_post_id` (`post_id`),
  KEY `idx_word` (`word`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5snapshot_action_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `action` varchar(255) NOT NULL,
  `details` text DEFAULT NULL,
  `performed_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `performed_at` (`performed_at`),
  KEY `action` (`action`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5trp_gettext_en_us` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` longtext NOT NULL,
  `translated` longtext DEFAULT NULL,
  `domain` longtext DEFAULT NULL,
  `status` int(20) DEFAULT NULL,
  `original_id` bigint(20) DEFAULT NULL,
  `plural_form` int(20) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `index_name` (`original`(100)),
  FULLTEXT KEY `original_fulltext` (`original`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5trp_gettext_original_meta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original_id` bigint(20) NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  UNIQUE KEY `meta_id` (`meta_id`),
  KEY `gettext_index_original_id` (`original_id`),
  KEY `gettext_meta_key` (`meta_key`(250))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `pcmdivi5trp_gettext_original_strings` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `original` text NOT NULL,
  `domain` text NOT NULL,
  `context` text DEFAULT NULL,
  `original_plural` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gettext_index_original` (`original`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT INTO `pcmdivi5users` VALUES 
("1","pcmadmin","$wp$2y$10$YYekg9u96seGdG9plHx1Yup0epM/9KC5NdL7oVMtF5Wl.iCFrokTy","pcmadmin","chris@pearlcitymedia.com","https://divi5.builtbypearlcitymedia.com","2025-05-19 15:28:49","","0","admin");

INSERT INTO `pcmdivi5usermeta` VALUES 
("1","1","nickname","pcmadmin"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","pcmdivi5capabilities","a:1:{s:13:\"administrator\";b:1;}"),
("13","1","pcmdivi5user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","1"),
("16","1","session_tokens","a:1:{s:64:\"f90092ca8e54a3a792b44ef532f7848ffd756a4ef646902fc1c37455face7013\";a:4:{s:10:\"expiration\";i:1761251842;s:2:\"ip\";s:14:\"192.249.120.85\";s:2:\"ua\";s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/141.0.0.0 Safari/537.36\";s:5:\"login\";i:1761079042;}}"),
("17","1","pcmdivi5dashboard_quick_press_last_post_id","41"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:10:\"69.49.89.0\";}"),
("19","1","_imagify_ignore_notices","a:1:{i:0;s:13:\"welcome-steps\";}"),
("20","1","trp_invalid_license_dismiss_notification","true"),
("21","1","duplicator_pro_created_format","1"),
("22","1","ame_rui_first_login_done","1"),
("23","1","manageedit-acf-post-typecolumnshidden","a:1:{i:0;s:7:\"acf-key\";}"),
("24","1","acf_user_settings","a:2:{s:19:\"post-type-first-run\";b:1;s:20:\"taxonomies-first-run\";b:1;}"),
("25","1","closedpostboxes_acf-post-type","a:0:{}"),
("26","1","metaboxhidden_acf-post-type","a:1:{i:0;s:7:\"slugdiv\";}"),
("27","1","manageedit-acf-taxonomycolumnshidden","a:1:{i:0;s:7:\"acf-key\";}");

INSERT INTO `pcmdivi5actionscheduler_groups` VALUES 
("1","action-scheduler-migration"),
("2","defender");

INSERT INTO `pcmdivi5blc_instances` VALUES 
("1","1","1","comment","A WordPress Commenter [comment]","url_field","comment_author_url","","https://wordpress.org/"),
("2","2","1","comment","Gravatar","link","comment_content","","https://gravatar.com/"),
("3","3","2","page","your dashboard","link","post_content","","https://divi5.builtbypearlcitymedia.com/wp-admin/");

INSERT INTO `pcmdivi5blc_links` VALUES 
("1","https://wordpress.org/","0000-00-00 00:00:00","2025-10-19 11:04:07","2025-10-19 11:04:07","2025-10-19 11:04:07","0","https://wordpress.org/","0","=== HTTP code : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 OK\r\nServer: nginx\r\nDate: Sun, 19 Oct 2025 11:04:07 GMT\r\nContent-Type: text/html; charset=UTF-8\r\nConnection: close\r\nVary: Accept-Encoding\r\nStrict-Transport-Security: max-age=3600\r\nX-Olaf: ⛄\r\nVary: accept, content-type\r\nLink: &lt;https://wordpress.org/wp-json/&gt;; rel=&quot;https://api.w.org/&quot;\r\nLink: &lt;https://wordpress.org/wp-json/wp/v2/pages/457&gt;; rel=&quot;alternate&quot;; title=&quot;JSON&quot;; type=&quot;application/json&quot;\r\nLink: &lt;https://w.org/&gt;; rel=shortlink\r\nX-Frame-Options: SAMEORIGIN\r\nContent-Encoding: br\r\nAlt-Svc: h3=&quot;:443&quot;; ma=86400\r\nX-nc: HIT ord 2\r\n\r\nRequest headers\n================\nHEAD / HTTP/1.1\r\nHost: wordpress.org\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://divi5.builtbypearlcitymedia.com\r\nConnection: close\r\n\r\n\nLink is valid.","200","","","0.164647","0","0","0","1","0","200|0|0|https://wordpress.org/","0","0"),
("2","https://gravatar.com/","0000-00-00 00:00:00","2025-10-19 11:04:07","2025-10-19 11:04:07","2025-10-19 11:04:07","0","https://gravatar.com/","0","=== HTTP code : 200 ===\n\nResponse headers\n================\nHTTP/1.1 200 OK\r\nServer: nginx\r\nDate: Sun, 19 Oct 2025 11:04:07 GMT\r\nContent-Type: text/html; charset=utf-8\r\nConnection: close\r\nVary: Accept-Encoding\r\nContent-Language: en\r\nP3P: CP=&quot;CAO PSA&quot;\r\nExpires: Wed, 11 Jan 1984 05:00:00 GMT\r\nCache-Control: no-cache, must-revalidate, max-age=0\r\nX-Frame-Options: SAMEORIGIN\r\nContent-Security-Policy: default-src gravatar.com *.gravatar.com; script-src gravatar.com *.gravatar.com *.wp.com *.google-analytics.com *.googletagmanager.com *.facebook.net apis.google.com/js/ &#039;nonce-680e5c4659d6&#039; &#039;nonce-3ecb4b04933a&#039; telegram.org/js/; style-src &#039;self&#039; gravatar.com *.gravatar.com *.wp.com fonts.googleapis.com &#039;nonce-3ecb4b04933a&#039; &#039;nonce-f69031da0cf2&#039; &#039;sha256-NE3gBSsVG0IdyINKOXv7oHDjOD1hoJpOCZQDS8LzvUc=&#039; &#039;sha256-biLFinpqYMtWHmXfkA1BPeCY0/fNt46SAZ+BBk5YUog=&#039; &#039;sha256-ONA8DqqhBTsIrZzU3/jZyRdkNkkAGEU74EH252dbGS8=&#039; &#039;sha256-uYx4ryugsGdahnaIId0IhtdPIgBkKBfNZg2/H0eWhqk=&#039; &#039;sha256-47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU=&#039; &#039;sha256-xi7Iu5TcqJkb4mlu0FHpAYfWWCETn5kNH3GPA4Coh4M=&#039; &#039;sha256-47DEQpj8HBSa+/TImW+5JCeuQeRkm5NMpJWZG3hSuFU=&#039; &#039;sha256-YrOy05n87EW8L5yLZin6THAZq/8Vb6v4uqVq1nOY9X8=&#039; &#039;sha256-Fw2RK+YpRih15zbXuAaoQAV98ZS+OLAX6wDQ2AkaEho=&#039; &#039;sha256-t9/679CRyrVA6r3JGaAzcO+diam/7WLn6KXJHJuOzUI=&#039; &#039;sha256-h0RPO0+/L+WC46JS6RvM6D3KN9C2LfMai6hxwzVFU2k=&#039; &#039;sha256-YIktaUP7IBRwVksGEOmRykAcO2jHTw97BHns4OnHTIw=&#039; &#039;sha256-MSTZvl0psO46WYZImeDzGMr7OqGRUy5RPDaeL19QpBk=&#039;; font-src data: gravatar.com *.gravatar.com *.wp.com fonts.gstatic.com; img-src data: https: blob:; media-src https://videos.files.wordpress.com/ s.gravatar.com blob:; frame-src gravatar.com *.gravatar.com automattic.crowdsignal.net widgets.wp.com td.doubleclick.net www.googletagmanager.com oauth.telegram.org; connect-src gravatar.com *.gravatar.com *.wp.com data: blob: *.google-analytics.com *.analytics.google.com analytics.google.com googleadservices.com www.googleadservices.com google.com https://public-api.wordpress.com/ *.pexels.com *.giphy.com *.google.com stats.g.doubleclick.net; object-src &#039;none&#039;; base-uri &#039;self&#039;; report-uri https://public-api.wordpress.com/csp/; worker-src &#039;self&#039; blob:;\r\nAlt-Svc: h3=&quot;:443&quot;; ma=86400\r\nStrict-Transport-Security: max-age=31536000; includeSubdomains; preload\r\nContent-Encoding: br\r\n\r\nRequest headers\n================\nHEAD / HTTP/1.1\r\nHost: gravatar.com\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://divi5.builtbypearlcitymedia.com\r\nConnection: close\r\n\r\n\nLink is valid.","200","","","0.103728","0","0","0","1","0","200|0|0|https://gravatar.com/","0","0"),
("3","https://divi5.builtbypearlcitymedia.com/wp-admin/","0000-00-00 00:00:00","2025-10-19 11:04:07","2025-10-19 11:04:07","2025-10-19 11:04:07","0","https://divi5.builtbypearlcitymedia.com/wp-login.php?redirect_to=https%3A%2F%2Fdivi5.builtbypearlcitymedia.com%2Fwp-admin%2F&reauth=1","1","=== HTTP code : 200 ===\n\nResponse headers\n================\nHTTP/1.1 302 Found\r\nServer: nginx/1.27.4\r\nDate: Sun, 19 Oct 2025 11:04:08 GMT\r\nContent-Type: text/html; charset=UTF-8\r\nTransfer-Encoding: chunked\r\nConnection: close\r\ncf-edge-cache: cache,platform=wordpress\r\nExpires: Wed, 11 Jan 1984 05:00:00 GMT\r\nCache-Control: no-cache, must-revalidate, max-age=0, no-store, private\r\nX-Redirect-By: WordPress\r\nContent-Encoding: gzip\r\nVary: Accept-Encoding\r\nLocation: https://divi5.builtbypearlcitymedia.com/wp-login.php?redirect_to=https%3A%2F%2Fdivi5.builtbypearlcitymedia.com%2Fwp-admin%2F&amp;reauth=1\r\nX-Proxy-Cache: BYPASS\r\n\r\nHTTP/1.1 200 OK\r\nServer: nginx/1.27.4\r\nDate: Sun, 19 Oct 2025 11:04:09 GMT\r\nContent-Type: text/html; charset=UTF-8\r\nTransfer-Encoding: chunked\r\nConnection: close\r\ncf-edge-cache: cache,platform=wordpress\r\nExpires: Wed, 11 Jan 1984 05:00:00 GMT\r\nCache-Control: no-cache, must-revalidate, max-age=0, no-store, private\r\nX-Frame-Options: SAMEORIGIN\r\nReferrer-Policy: strict-origin-when-cross-origin\r\nContent-Encoding: gzip\r\nVary: Accept-Encoding\r\nSet-Cookie: wordpress_test_cookie=WP%20Cookie%20check; path=/; secure; HttpOnly\r\nSet-Cookie: wordpress_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/wp-admin\r\nSet-Cookie: wordpress_sec_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/wp-admin\r\nSet-Cookie: wordpress_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/wp-content/plugins\r\nSet-Cookie: wordpress_sec_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/wp-content/plugins\r\nSet-Cookie: wordpress_logged_in_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpress_logged_in_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wp-settings-0=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wp-settings-time-0=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpress_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpress_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpress_sec_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpress_sec_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpressuser_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpresspass_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpressuser_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wordpresspass_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nSet-Cookie: wp-postpass_002d0837586000ca9aaa42896674c4e6=%20; expires=Sat, 19 Oct 2024 11:04:09 GMT; Max-Age=0; path=/\r\nX-Proxy-Cache: BYPASS\r\n\r\nRequest headers\n================\nGET /wp-login.php?redirect_to=https%3A%2F%2Fdivi5.builtbypearlcitymedia.com%2Fwp-admin%2F&amp;reauth=1 HTTP/1.1\r\nHost: divi5.builtbypearlcitymedia.com\r\nUser-Agent: WPMU DEV Broken Link Checker Local Engine\r\nAccept: */*\r\nAccept-Encoding: deflate, gzip, br\r\nReferer: https://divi5.builtbypearlcitymedia.com\r\nConnection: close\r\nRange: bytes=0-2048\r\n\r\n\nLink is valid.","200","","","0.924717","0","0","0","1","0","200|0|0|https://divi5.builtbypearlcitymedia.com/wp-login.php","0","0");

INSERT INTO `pcmdivi5blc_synch` VALUES 
("1","comment","1","2025-05-21 02:58:57"),
("1","post","1","2025-05-21 02:58:57"),
("2","page","1","2025-05-21 02:58:57");

INSERT INTO `pcmdivi5comments` VALUES 
("1","1","A WordPress Commenter","wapuu@wordpress.example","https://wordpress.org/","","2025-05-19 15:28:49","2025-05-19 15:28:49","Hi, this is a comment.\nTo get started with moderating, editing, and deleting comments, please visit the Comments screen in the dashboard.\nCommenter avatars come from <a href=\"https://gravatar.com/\">Gravatar</a>.","0","1","","comment","0","0");

INSERT INTO `pcmdivi5defender_lockout` VALUES 
("2253","192.249.120.85","normal","","0","1760524366","0","0","0","[]"),
("2254","34.196.51.17","normal","","0","1760524533","0","0","0","[]"),
("2255","18.204.159.253","normal","","0","1760527295","0","0","0","[]"),
("2256","50.6.3.4","normal","","0","1760541247","0","0","0","[]"),
("2257","213.136.93.169","normal","","0","1760541608","0","0","0","[]"),
("2258","158.220.116.163","normal","","0","1760541968","0","0","0","[]"),
("2259","23.180.120.244","normal","","0","1760542420","0","0","0","[]"),
("2260","167.172.253.253","normal","","0","1760542639","0","0","0","[]"),
("2261","117.208.192.107","normal","","0","1760542956","0","0","0","[]"),
("2262","103.11.101.122","normal","","0","1760543248","0","0","0","[]"),
("2263","103.166.182.115","normal","","0","1760543551","0","0","0","[]"),
("2264","50.6.109.250","normal","","0","1760543847","0","0","0","[]"),
("2265","167.172.113.201","normal","","0","1760544465","0","0","0","[]"),
("2266","185.49.20.76","normal","","0","1760544783","0","0","0","[]"),
("2267","52.221.97.93","normal","","0","1760545419","0","0","0","[]"),
("2268","114.55.74.90","normal","","0","1760545736","0","0","0","[]"),
("2269","190.215.106.243","normal","","0","1760546048","0","0","0","[]"),
("2270","162.243.62.9","normal","","0","1760546357","0","0","0","[]"),
("2271","89.46.110.149","normal","","0","1760546670","0","0","0","[]"),
("2272","88.198.106.177","normal","","0","1760546979","0","0","0","[]"),
("2273","34.93.16.66","normal","","0","1760547278","0","0","0","[]"),
("2274","185.75.143.243","normal","","0","1760547575","0","0","0","[]"),
("2275","103.28.36.199","normal","","0","1760548529","0","0","0","[]"),
("2276","213.230.65.2","normal","","0","1760549160","0","0","0","[]"),
("2277","92.205.167.152","normal","","0","1760549475","0","0","0","[]"),
("2278","104.248.45.30","normal","","0","1760549781","0","0","0","[]"),
("2279","192.241.179.13","normal","","0","1760550083","0","0","0","[]"),
("2280","190.6.176.90","normal","","0","1760550955","0","0","0","[]"),
("2281","57.151.82.21","normal","","0","1760551522","0","0","0","[]"),
("2282","91.206.200.73","normal","","0","1760552414","0","0","0","[]"),
("2283","103.77.207.75","normal","","0","1760552996","0","0","0","[]"),
("2284","185.61.154.35","normal","","0","1760553579","0","0","0","[]"),
("2285","50.87.184.28","normal","","0","1760554135","0","0","0","[]"),
("2286","47.242.236.143","normal","","0","1760554681","0","0","0","[]"),
("2287","51.79.250.168","normal","","0","1760555565","0","0","0","[]"),
("2288","198.211.125.40","normal","","0","1760555869","0","0","0","[]"),
("2289","20.171.207.250","normal","","0","1760556608","0","0","0","[]"),
("2290","145.79.6.127","normal","","0","1760556766","0","0","0","[]"),
("2291","77.104.73.130","normal","","0","1760557587","0","0","0","[]"),
("2292","192.250.228.62","normal","","0","1760557843","0","0","0","[]"),
("2293","68.183.135.252","normal","","0","1760558096","0","0","0","[]"),
("2294","18.139.13.90","normal","","0","1760558591","0","0","0","[]"),
("2295","165.227.140.18","normal","","0","1760559106","0","0","0","[]"),
("2296","188.166.45.210","normal","","0","1760559369","0","0","0","[]"),
("2297","103.124.95.168","normal","","0","1760559643","0","0","0","[]"),
("2298","103.205.211.78","normal","","0","1760559915","0","0","0","[]"),
("2299","159.89.97.218","normal","","0","1760560446","0","0","0","[]"),
("2300","4.240.89.23","normal","","0","1760560973","0","0","0","[]"),
("2301","185.179.24.46","normal","","0","1760561246","0","0","0","[]"),
("2302","139.162.83.71","normal","","0","1760561519","0","0","0","[]"),
("2303","167.99.71.235","normal","","0","1760561789","0","0","0","[]"),
("2304","81.88.53.143","normal","","0","1760562062","0","0","0","[]"),
("2305","23.180.120.243","normal","","0","1760562546","0","0","0","[]"),
("2306","138.68.184.195","normal","","0","1760562620","0","0","0","[]"),
("2307","20.245.239.65","normal","","0","1760562906","0","0","0","[]"),
("2308","81.88.53.43","normal","","0","1760563191","0","0","0","[]"),
("2309","65.254.81.60","normal","","0","1760564058","0","0","0","[]"),
("2310","89.235.79.29","normal","","0","1760564343","0","0","0","[]"),
("2311","123.1.133.4","normal","","0","1760564629","0","0","0","[]"),
("2312","103.74.118.39","normal","","0","1760565204","0","0","0","[]"),
("2313","113.192.8.160","normal","","0","1760565492","0","0","0","[]"),
("2314","128.199.23.132","normal","","0","1760565791","0","0","0","[]"),
("2315","64.90.38.74","normal","","0","1760566091","0","0","0","[]"),
("2316","14.194.98.247","normal","","0","1760566390","0","0","0","[]"),
("2317","8.137.149.112","normal","","0","1760585844","0","0","0","[]"),
("2318","162.240.6.87","normal","","0","1760586101","0","0","0","[]"),
("2319","173.255.240.195","normal","","0","1760586347","0","0","0","[]"),
("2320","42.96.17.195","normal","","0","1760586588","0","0","0","[]"),
("2321","172.105.63.250","normal","","0","1760586830","0","0","0","[]"),
("2322","198.177.125.119","normal","","0","1760587788","0","0","0","[]"),
("2323","143.198.155.199","normal","","0","1760589041","0","0","0","[]"),
("2324","103.221.222.131","normal","","0","1760590160","0","0","0","[]"),
("2325","182.253.58.243","normal","","0","1760590403","0","0","0","[]"),
("2326","178.121.4.49","normal","","0","1760590523","0","0","0","[]"),
("2327","45.4.172.186","normal","","0","1760590633","0","0","0","[]"),
("2328","54.37.151.241","normal","","0","1760590871","0","0","0","[]"),
("2329","162.214.208.138","normal","","0","1760591118","0","0","0","[]"),
("2330","192.227.184.130","normal","","0","1760591372","0","0","0","[]"),
("2331","132.148.72.207","normal","","0","1760591911","0","0","0","[]"),
("2332","103.6.196.61","normal","","0","1760592188","0","0","0","[]"),
("2333","161.35.90.249","normal","","0","1760592460","0","0","0","[]"),
("2334","138.68.229.116","normal","","0","1760593249","0","0","0","[]"),
("2335","206.81.24.74","normal","","0","1760593424","0","0","0","[]"),
("2336","217.172.189.100","normal","","0","1760593993","0","0","0","[]"),
("2337","162.241.217.39","normal","","0","1760594237","0","0","0","[]"),
("2338","92.205.231.61","normal","","0","1760594736","0","0","0","[]"),
("2339","151.80.151.56","normal","","0","1760594993","0","0","0","[]"),
("2340","52.224.179.197","normal","","0","1760595257","0","0","0","[]"),
("2341","165.22.223.164","normal","","0","1760595811","0","0","0","[]"),
("2342","89.46.109.92","normal","","0","1760596353","0","0","0","[]"),
("2343","89.46.106.152","normal","","0","1760596881","0","0","0","[]"),
("2344","159.89.127.165","normal","","0","1760597096","0","0","0","[]"),
("2345","192.241.128.246","normal","","0","1760597635","0","0","0","[]"),
("2346","34.74.243.195","normal","","0","1760598118","0","0","0","[]"),
("2347","146.190.140.214","normal","","0","1760598894","0","0","0","[]"),
("2348","103.82.22.166","normal","","0","1760599437","0","0","0","[]"),
("2349","89.144.145.213","normal","","0","1760600245","0","0","0","[]"),
("2350","188.245.173.68","normal","","0","1760600600","0","0","0","[]"),
("2351","162.240.28.193","normal","","0","1760601471","0","0","0","[]"),
("2352","162.241.216.65","normal","","0","1760601646","0","0","0","[]"),
("2353","165.227.214.30","normal","","0","1760601828","0","0","0","[]"),
("2354","47.236.12.137","normal","","0","1760602017","0","0","0","[]"),
("2355","83.217.72.249","normal","","0","1760602797","0","0","0","[]"),
("2356","84.247.144.53","normal","","0","1760603205","0","0","0","[]"),
("2357","45.119.84.18","normal","","0","1760603410","0","0","0","[]"),
("2358","35.225.238.220","normal","","0","1760603820","0","0","0","[]"),
("2359","103.169.160.163","normal","","0","1760604024","0","0","0","[]"),
("2360","185.25.117.32","normal","","0","1760604841","0","0","0","[]"),
("2361","185.59.44.29","normal","","0","1760605047","0","0","0","[]"),
("2362","31.214.174.194","normal","","0","1760605260","0","0","0","[]"),
("2363","208.109.32.191","normal","","0","1760605470","0","0","0","[]"),
("2364","171.244.34.211","normal","","0","1760606105","0","0","0","[]"),
("2365","37.27.188.222","normal","","0","1760606306","0","0","0","[]"),
("2366","167.99.72.37","normal","","0","1760606516","0","0","0","[]"),
("2367","143.198.45.116","normal","","0","1760606933","0","0","0","[]"),
("2368","165.227.177.101","normal","","0","1760607354","0","0","0","[]"),
("2369","192.144.234.15","normal","","0","1760607564","0","0","0","[]"),
("2370","127.0.0.1","normal","","0","1760607612","0","0","0","[]"),
("2371","159.65.158.125","normal","","0","1760607775","0","0","0","[]"),
("2372","160.22.122.134","normal","","0","1760607980","0","0","0","[]"),
("2373","91.151.84.154","normal","","0","1760608396","0","0","0","[]"),
("2374","207.154.247.73","normal","","0","1760608606","0","0","0","[]"),
("2375","209.38.230.167","normal","","0","1760608815","0","0","0","[]"),
("2376","139.59.253.161","normal","","0","1760609028","0","0","0","[]"),
("2377","34.231.159.9","normal","","0","1760609234","0","0","0","[]"),
("2378","46.245.76.50","normal","","0","1760609665","0","0","0","[]"),
("2379","139.59.189.244","normal","","0","1760610095","0","0","0","[]"),
("2380","31.11.36.228","normal","","0","1760610305","0","0","0","[]"),
("2381","103.186.64.110","normal","","0","1760610515","0","0","0","[]"),
("2382","108.179.219.178","normal","","0","1760610726","0","0","0","[]"),
("2383","5.160.146.1","normal","","0","1760610933","0","0","0","[]"),
("2384","135.125.183.119","normal","","0","1760611143","0","0","0","[]"),
("2385","194.38.135.180","normal","","0","1760611352","0","0","0","[]"),
("2386","23.254.250.184","normal","","0","1760611979","0","0","0","[]"),
("2387","116.118.45.196","normal","","0","1760612402","0","0","0","[]"),
("2388","148.72.214.194","normal","","0","1760612618","0","0","0","[]"),
("2389","111.229.111.163","normal","","0","1760612830","0","0","0","[]"),
("2390","173.236.154.166","normal","","0","1760613039","0","0","0","[]"),
("2391","103.149.169.120","normal","","0","1760613677","0","0","0","[]"),
("2392","103.75.187.239","normal","","0","1760614317","0","0","0","[]"),
("2393","152.32.251.112","normal","","0","1760614533","0","0","0","[]"),
("2394","91.134.91.127","normal","","0","1760615386","0","0","0","[]"),
("2395","34.90.192.194","normal","","0","1760615814","0","0","0","[]"),
("2396","51.255.71.164","normal","","0","1760616031","0","0","0","[]"),
("2397","178.62.201.7","normal","","0","1760616254","0","0","0","[]"),
("2398","103.149.169.122","normal","","0","1760616910","0","0","0","[]"),
("2399","5.202.15.246","normal","","0","1760618030","0","0","0","[]"),
("2400","20.203.75.63","normal","","0","1760618477","0","0","0","[]"),
("2401","142.171.182.233","normal","","0","1760619153","0","0","0","[]"),
("2402","87.248.156.150","normal","","0","1760619383","0","0","0","[]"),
("2403","185.46.8.16","normal","","0","1760619609","0","0","0","[]"),
("2404","185.2.4.33","normal","","0","1760619839","0","0","0","[]"),
("2405","51.161.172.100","normal","","0","1760620064","0","0","0","[]"),
("2406","92.114.50.2","normal","","0","1760620520","0","0","0","[]"),
("2407","128.199.0.160","normal","","0","1760621204","0","0","0","[]"),
("2408","95.216.154.58","normal","","0","1760621692","0","0","0","[]"),
("2409","51.89.244.59","normal","","0","1760622724","0","0","0","[]"),
("2410","185.17.41.205","normal","","0","1760623426","0","0","0","[]"),
("2411","128.199.44.17","normal","","0","1760623774","0","0","0","[]"),
("2412","162.241.126.57","normal","","0","1760624476","0","0","0","[]"),
("2413","125.253.121.223","normal","","0","1760625183","0","0","0","[]"),
("2414","82.223.216.36","normal","","0","1760625544","0","0","0","[]"),
("2415","198.199.80.246","normal","","0","1760625891","0","0","0","[]"),
("2416","50.62.183.174","normal","","0","1760626244","0","0","0","[]"),
("2417","92.204.53.8","normal","","0","1760626595","0","0","0","[]"),
("2418","185.231.115.91","normal","","0","1760627312","0","0","0","[]"),
("2419","101.78.165.58","normal","","0","1760628007","0","0","0","[]"),
("2420","162.241.224.155","normal","","0","1760628633","0","0","0","[]"),
("2421","44.243.52.80","normal","","0","1760629552","0","0","0","[]"),
("2422","34.87.147.222","normal","","0","1760630031","0","0","0","[]"),
("2423","177.52.160.19","normal","","0","1760631085","0","0","0","[]"),
("2424","64.227.37.170","normal","","0","1760631953","0","0","0","[]"),
("2425","185.177.72.30","normal","","0","1760632621","0","0","0","[]"),
("2426","138.68.187.114","normal","","0","1760633059","0","0","0","[]"),
("2427","162.241.151.167","normal","","0","1760633318","0","0","0","[]"),
("2428","160.30.113.129","normal","","0","1760633579","0","0","0","[]"),
("2429","81.88.53.133","normal","","0","1760634096","0","0","0","[]"),
("2430","57.128.87.159","normal","","0","1760634941","0","0","0","[]"),
("2431","91.224.90.83","normal","","0","1760635233","0","0","0","[]"),
("2432","162.214.78.123","normal","","0","1760635519","0","0","0","[]"),
("2433","135.125.66.80","normal","","0","1760636588","0","0","0","[]"),
("2434","103.169.160.74","normal","","0","1760636850","0","0","0","[]"),
("2435","203.217.101.237","normal","","0","1760637600","0","0","0","[]"),
("2436","35.247.159.133","normal","","0","1760638958","0","0","0","[]"),
("2437","51.68.224.123","normal","","0","1760640270","0","0","0","[]"),
("2438","40.123.197.157","normal","","0","1760640526","0","0","0","[]"),
("2439","77.68.30.96","normal","","0","1760642908","0","0","0","[]"),
("2440","162.214.121.103","normal","","0","1760643172","0","0","0","[]"),
("2441","46.101.1.225","normal","","0","1760644605","0","0","0","[]"),
("2442","205.210.31.104","normal","","0","1760645117","0","0","0","[]"),
("2443","198.235.24.244","normal","","0","1760658070","0","0","0","[]"),
("2444","198.235.24.16","normal","","0","1760659879","0","0","0","[]"),
("2445","109.196.70.232","normal","","0","1760665530","0","0","0","[]"),
("2446","205.210.31.86","normal","","0","1760666286","0","0","0","[]"),
("2447","46.182.133.125","normal","","0","1760667156","0","0","0","[]"),
("2448","167.99.182.39","normal","","0","1760674334","0","0","0","[]"),
("2449","79.174.45.173","normal","","0","1760680008","0","0","0","[]"),
("2450","205.210.31.16","normal","","0","1760681288","0","0","0","[]"),
("2451","91.235.245.252","normal","","0","1760695931","0","0","0","[]"),
("2452","212.175.227.94","normal","","0","1760697942","0","0","0","[]"),
("2453","44.249.3.119","normal","","0","1760703095","0","0","0","[]"),
("2454","147.185.132.255","normal","","0","1760721397","0","0","0","[]"),
("2455","4.227.36.0","normal","","0","1760729692","0","0","0","[]"),
("2456","198.235.24.19","normal","","0","1760735284","0","0","0","[]"),
("2457","188.113.166.81","normal","","0","1760737851","0","0","0","[]"),
("2458","31.134.187.171","normal","","0","1760740128","0","0","0","[]"),
("2459","147.185.132.183","normal","","0","1760760742","0","0","0","[]"),
("2460","139.59.231.238","normal","","0","1760769111","0","0","0","[]"),
("2461","162.243.163.138","normal","","0","1760774915","0","0","0","[]"),
("2462","84.18.117.209","normal","","0","1760781351","0","0","0","[]"),
("2463","81.177.58.197","normal","","0","1760783021","0","0","0","[]"),
("2464","205.210.31.41","normal","","0","1760793827","0","0","0","[]"),
("2465","138.68.86.32","normal","","0","1760801611","0","0","0","[]"),
("2466","77.51.4.176","normal","","0","1760819853","0","0","0","[]"),
("2467","206.189.225.181","normal","","0","1760832901","0","0","0","[]"),
("2468","72.18.130.250","normal","","0","1760839011","0","0","0","[]"),
("2469","185.137.234.111","normal","","0","1760841169","0","0","0","[]"),
("2470","103.42.117.165","normal","","0","1760843282","0","0","0","[]"),
("2471","91.92.241.199","normal","","0","1760844661","0","0","0","[]"),
("2472","18.141.225.240","normal","","0","1760844854","0","0","0","[]"),
("2473","208.109.235.107","normal","","0","1760845450","0","0","0","[]"),
("2474","147.185.132.105","normal","","0","1760846135","0","0","0","[]"),
("2475","47.239.91.132","normal","","0","1760847659","0","0","0","[]"),
("2476","142.93.143.8","normal","","0","1760848656","0","0","0","[]"),
("2477","162.241.217.111","normal","","0","1760852403","0","0","0","[]"),
("2478","50.6.174.16","normal","","0","1760854637","0","0","0","[]"),
("2479","205.210.31.205","normal","","0","1760855713","0","0","0","[]"),
("2480","37.18.61.9","normal","","0","1760856362","0","0","0","[]"),
("2481","157.230.219.118","normal","","0","1760857007","0","0","0","[]"),
("2482","103.38.161.197","normal","","0","1760859273","0","0","0","[]"),
("2483","82.223.122.37","normal","","0","1760863907","0","0","0","[]"),
("2484","198.235.24.255","normal","","0","1760865297","0","0","0","[]"),
("2485","38.45.64.39","normal","","0","1760873094","0","0","0","[]"),
("2486","50.62.183.56","normal","","0","1760881793","0","0","0","[]"),
("2487","45.131.155.101","normal","","0","1760891087","0","0","0","[]"),
("2488","205.210.31.142","normal","","0","1760891582","0","0","0","[]"),
("2489","95.154.198.138","normal","","0","1760891595","0","0","0","[]"),
("2490","158.255.80.210","normal","","0","1760898415","0","0","0","[]"),
("2491","107.190.140.138","normal","","0","1760901343","0","0","0","[]"),
("2492","162.241.224.248","normal","","0","1760903961","0","0","0","[]"),
("2493","128.199.81.144","normal","","0","1760914117","0","0","0","[]"),
("2494","173.249.144.86","normal","","0","1760916738","0","0","0","[]"),
("2495","3.237.67.75","normal","","0","1760919313","0","0","0","[]"),
("2496","131.108.210.112","normal","","0","1760922461","0","0","0","[]"),
("2497","67.207.163.194","normal","","0","1760926032","0","0","0","[]"),
("2498","139.59.116.230","normal","","0","1760929317","0","0","0","[]"),
("2499","132.196.86.143","normal","","0","1760930136","0","0","0","[]"),
("2500","67.23.231.154","normal","","0","1760932047","0","0","0","[]"),
("2501","147.124.214.16","normal","","0","1760934749","0","0","0","[]"),
("2502","198.235.24.147","normal","","0","1760936556","0","0","0","[]"),
("2503","185.252.234.215","normal","","0","1760937407","0","0","0","[]"),
("2504","93.86.61.74","normal","","0","1760939837","0","0","0","[]"),
("2505","185.26.73.80","normal","","0","1760944671","0","0","0","[]"),
("2506","184.168.126.97","normal","","0","1760944960","0","0","0","[]"),
("2507","167.71.175.236","normal","","0","1760945692","0","0","0","[]"),
("2508","142.93.0.66","normal","","0","1760948124","0","0","0","[]"),
("2509","138.68.82.23","normal","","0","1760985888","0","0","0","[]"),
("2510","20.171.207.118","normal","","0","1760989506","0","0","0","[]"),
("2511","134.209.25.199","normal","","0","1761022692","0","0","0","[]"),
("2512","205.210.31.132","normal","","0","1761026034","0","0","0","[]"),
("2513","92.38.32.19","normal","","0","1761029993","0","0","0","[]"),
("2514","185.98.76.64","normal","","0","1761032026","0","0","0","[]"),
("2515","176.65.149.195","normal","","0","1761042436","0","0","0","[]"),
("2516","209.172.2.50","normal","","0","1761049154","0","0","0","[]"),
("2517","66.132.153.114","normal","","0","1761051201","0","0","0","[]"),
("2518","44.193.254.10","normal","","0","1761051290","0","0","0","[]"),
("2519","199.45.155.96","normal","","0","1761051485","0","0","0","[]"),
("2520","93.157.22.238","normal","","0","1761062001","0","0","0","[]"),
("2521","209.172.2.60","normal","","0","1761070194","0","0","0","[]"),
("2522","170.106.196.7","normal","","0","1761072828","0","0","0","[]"),
("2523","173.224.122.237","normal","","0","1761073325","0","0","0","[]"),
("2524","116.193.190.94","normal","","0","1761073526","0","0","0","[]"),
("2525","91.194.90.113","normal","","0","1761074032","0","0","0","[]"),
("2526","104.236.5.222","normal","","0","1761074235","0","0","0","[]"),
("2527","64.227.8.16","normal","","0","1761074736","0","0","0","[]"),
("2528","18.143.201.41","normal","","0","1761074942","0","0","0","[]"),
("2529","186.250.243.186","normal","","0","1761075205","0","0","0","[]"),
("2530","124.6.61.130","normal","","0","1761075448","0","0","0","[]"),
("2531","147.185.132.46","normal","","0","1761076112","0","0","0","[]"),
("2532","122.165.162.156","normal","","0","1761076171","0","0","0","[]"),
("2533","123.31.12.39","normal","","0","1761076378","0","0","0","[]"),
("2534","124.71.169.49","normal","","0","1761076648","0","0","0","[]"),
("2535","46.105.71.74","normal","","0","1761076896","0","0","0","[]"),
("2536","198.235.24.171","normal","","0","1761077180","0","0","0","[]"),
("2537","95.217.234.28","normal","","0","1761077371","0","0","0","[]"),
("2538","178.128.166.101","normal","","0","1761077834","0","0","0","[]"),
("2539","46.245.76.52","normal","","0","1761078357","0","0","0","[]"),
("2540","100.42.230.27","normal","","0","1761078568","0","0","0","[]"),
("2541","69.49.89.52","normal","","0","1761079025","0","0","0","[]"),
("2542","150.158.50.113","normal","","0","1761079091","0","0","0","[]"),
("2543","133.167.118.212","normal","","0","1761079310","0","0","0","[]"),
("2544","75.119.208.120","normal","","0","1761079583","0","0","0","[]");

INSERT INTO `pcmdivi5defender_scan` VALUES 
("1","100","5","","finish","2025-05-21 09:59:00","2025-05-21 09:59:36","0");

INSERT INTO `pcmdivi5defender_scan_item` VALUES 
("1","1","core_integrity","active","{\"file\":\"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.wp-cli\\/\",\"type\":\"dir\"}"),
("2","1","plugin_integrity","active","{\"file\":\"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/advanced-custom-fields\\/acf.php\",\"type\":\"modified\"}"),
("3","1","malware","active","{\"0\":{\"identifier\":\"Suspicious_PHP_Code_Detection\",\"catches\":[{\"id\":\"malicious_file_upload\",\"offset\":6232,\"line\":199,\"mapper\":[{\"line\":199,\"range\":[21,95]}]}]},\"file\":\"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/duplicator-pro\\/classes\\/entities\\/class.brand.entity.php\"}");

INSERT INTO `pcmdivi5duplicator_pro_entities` VALUES 
("1","DUP_PRO_Global_Entity","{\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 2,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 32,\n    \"homepath_as_abspath\": false,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 20,\n    \"cleanup_mode\": 0,\n    \"cleanup_email\": \"chris@pearlcitymedia.com\",\n    \"auto_cleanup_hours\": 24,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"http:\\/\\/divi5.builtbypearlcitymedia.com\\/wp-admin\\/admin-ajax.php\",\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_name_mode\": \"simple\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1024,\n    \"gdrive_transfer_mode\": 0,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"onedrive_upload_chunksize_in_kb\": 3200,\n    \"manual_mode_storage_ids\": [\n        \"-2\"\n    ],\n    \"license_status\": 1,\n    \"license_expiration_time\": 1762289214,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": true,\n    \"lkp\": \"\",\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1761076112,\n    \"initial_activation_timestamp\": 1747678989,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"import_chunk_size\": 1024,\n    \"import_custom_path\": \"\",\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"notices\": {\n        \"dupArchiveSwitch\": true\n    }\n}"),
("2","DUP_PRO_Secure_Global_Entity","{\n    \"type\": \"DUP_PRO_Secure_Global_Entity\",\n    \"basic_auth_password\": null,\n    \"lkp\": \"\"\n}"),
("3","DUP_PRO_System_Global_Entity","{\n    \"type\": \"DUP_PRO_System_Global_Entity\",\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1761079627\n}"),
("4","DUP_PRO_Package_Template_Entity","{\n    \"type\": \"DUP_PRO_Package_Template_Entity\",\n    \"name\": \"Default\",\n    \"notes\": \"The default template.\",\n    \"filter_sites\": [],\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": [],\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"f9rnLm24ag8ijjISj5ae\\/kwtfHW4vxZIdfgpOdQtDgIQrAz\\/99SPv6gQ\\/hEFxhV4OS60SRZ07WZ+yWp2lFmMJA==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": false,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": true,\n    \"is_manual\": false\n}"),
("5","DUP_PRO_Package_Template_Entity","{\n    \"type\": \"DUP_PRO_Package_Template_Entity\",\n    \"name\": \"[Manual Mode]\",\n    \"notes\": \"\",\n    \"filter_sites\": \"\",\n    \"archive_export_onlydb\": 0,\n    \"archive_filter_on\": 0,\n    \"archive_filter_dirs\": \"\",\n    \"archive_filter_exts\": \"\",\n    \"archive_filter_files\": \"\",\n    \"archive_filter_names\": false,\n    \"database_filter_on\": 0,\n    \"databasePrefixFilter\": false,\n    \"databasePrefixSubFilter\": false,\n    \"database_filter_tables\": \"\",\n    \"database_compatibility_modes\": \"\",\n    \"installer_opts_secure_on\": 0,\n    \"installer_opts_secure_pass\": \"\",\n    \"installerPassowrd\": \"ZUAqFquer4wDzd\\/4i6AyEE3XOPAfRExG371V8Hvy8SPy5J4x5ppOs5YKOLfPg2EjIVeHs4Gwty4qVxP4vONg7g==\",\n    \"installer_opts_skip_scan\": 0,\n    \"installer_opts_db_host\": \"\",\n    \"installer_opts_db_name\": \"\",\n    \"installer_opts_db_user\": \"\",\n    \"installer_opts_cpnl_enable\": 0,\n    \"installer_opts_cpnl_host\": \"\",\n    \"installer_opts_cpnl_user\": \"\",\n    \"installer_opts_cpnl_pass\": \"\",\n    \"installer_opts_cpnl_db_action\": \"create\",\n    \"installer_opts_cpnl_db_host\": \"\",\n    \"installer_opts_cpnl_db_name\": \"\",\n    \"installer_opts_cpnl_db_user\": \"\",\n    \"installer_opts_brand\": -2,\n    \"is_default\": false,\n    \"is_manual\": true\n}");

INSERT INTO `pcmdivi5duplicator_pro_packages` VALUES 
("1","20250519_divi5blanktemplate","ab504878d245c7a72852_20250519183200","100","2025-05-19 18:32:14","pcmadmin","{\n    \"Created\": \"2025-05-19 18:32:00\",\n    \"Version\": \"4.5.5.1\",\n    \"VersionWP\": \"6.8.1\",\n    \"VersionDB\": \"10.6.22\",\n    \"VersionPHP\": \"8.2.28\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 1,\n    \"Name\": \"20250519_divi5blanktemplate\",\n    \"Hash\": \"ab504878d245c7a72852_20250519183200\",\n    \"NameHash\": \"20250519_divi5blanktemplate_ab504878d245c7a72852_20250519183200\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250519_divi5blanktemplate_ab504878d245c7a72852_20250519183200_scan.json\",\n    \"timer_start\": 1747679546.0776569843292236328125,\n    \"Runtime\": \"22.052 sec.\",\n    \"ExeSize\": \"114.06KB\",\n    \"ZipSize\": \"131.06MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.opcache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.tmb\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/bps-backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/old-cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/updraft\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wfcache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.htaccess\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.user.ini\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/php.ini\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/web.config\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20250519_divi5blanktemplate_ab504878d245c7a72852_20250519183200_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\",\n        \"Size\": 137422820,\n        \"Dirs\": null,\n        \"DirCount\": 5696,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 28811,\n        \"file_count\": 34507,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250519_divi5blanktemplate_ab504878d245c7a72852_20250519183200_installer.php\",\n        \"Size\": 116793,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"w8AMw9TdRTqzBCQqPHgR4yYubDnWbzjf7vQJIfvetJ7frUQ8PYZL3w8vTKGoOyHkuUd7fdUsoLcMRxfxwOVvOA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"builtbypearlcity_pcmdivi5\",\n            \"tablesBaseCount\": 38,\n            \"tablesFinalCount\": 38,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 406,\n            \"tablesSizeOnDisk\": 2221591,\n            \"tablesList\": {\n                \"pcmdivi5actionscheduler_actions\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 17932\n                },\n                \"pcmdivi5actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"pcmdivi5actionscheduler_groups\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 9256\n                },\n                \"pcmdivi5actionscheduler_logs\": {\n                    \"inaccurateRows\": 6,\n                    \"insertedRows\": 6,\n                    \"size\": 4432\n                },\n                \"pcmdivi5ac_segments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5admin_columns\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5atai_assets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5comments\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 7496\n                },\n                \"pcmdivi5duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 10640\n                },\n                \"pcmdivi5duplicator_pro_packages\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 1,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_addon_feed\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_draft_submissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_entry\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_entry_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5gf_entry_notes\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_revisions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_view\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5imagify_files\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5imagify_folders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5options\": {\n                    \"inaccurateRows\": 356,\n                    \"insertedRows\": 356,\n                    \"size\": 2047568\n                },\n                \"pcmdivi5postmeta\": {\n                    \"inaccurateRows\": 4,\n                    \"insertedRows\": 4,\n                    \"size\": 10712\n                },\n                \"pcmdivi5posts\": {\n                    \"inaccurateRows\": 6,\n                    \"insertedRows\": 6,\n                    \"size\": 20740\n                },\n                \"pcmdivi5seopress_content_analysis\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5seopress_seo_issues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5seopress_significant_keywords\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5terms\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 13352\n                },\n                \"pcmdivi5term_relationships\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 3093\n                },\n                \"pcmdivi5term_taxonomy\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 4136\n                },\n                \"pcmdivi5trp_gettext_en_us\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5trp_gettext_original_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5trp_gettext_original_strings\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5usermeta\": {\n                    \"inaccurateRows\": 21,\n                    \"insertedRows\": 21,\n                    \"size\": 11628\n                },\n                \"pcmdivi5users\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 8368\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.22\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 1965787,\n        \"File\": \"20250519_divi5blanktemplate_ab504878d245c7a72852_20250519183200_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20250519_divi5blanktemplate_ab504878d245c7a72852_20250519183200_database.sql\"\n    },\n    \"Status\": \"100.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1747679568,\n            \"stopped_timestamp\": 1747679569\n        }\n    ],\n    \"active_storage_id\": -2,\n    \"template_id\": 5\n}"),
("2","20250611_divi5blanktemplate","9b96b13caa7f0bba9002_20250611212008","100","2025-06-11 21:20:15","pcmadmin","{\n    \"Created\": \"2025-06-11 21:20:08\",\n    \"Version\": \"4.5.5.1\",\n    \"VersionWP\": \"6.8.1\",\n    \"VersionDB\": \"10.6.22\",\n    \"VersionPHP\": \"8.2.28\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 2,\n    \"Name\": \"20250611_divi5blanktemplate\",\n    \"Hash\": \"9b96b13caa7f0bba9002_20250611212008\",\n    \"NameHash\": \"20250611_divi5blanktemplate_9b96b13caa7f0bba9002_20250611212008\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250611_divi5blanktemplate_9b96b13caa7f0bba9002_20250611212008_scan.json\",\n    \"timer_start\": 1749676827.9317719936370849609375,\n    \"Runtime\": \"28.676 sec.\",\n    \"ExeSize\": \"114.06KB\",\n    \"ZipSize\": \"154.88MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.opcache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.tmb\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/bps-backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/old-cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/updraft\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wfcache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.htaccess\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.user.ini\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/php.ini\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/web.config\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20250611_divi5blanktemplate_9b96b13caa7f0bba9002_20250611212008_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\",\n        \"Size\": 162404806,\n        \"Dirs\": null,\n        \"DirCount\": 6762,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 33778,\n        \"file_count\": 40540,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250611_divi5blanktemplate_9b96b13caa7f0bba9002_20250611212008_installer.php\",\n        \"Size\": 116793,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Na5pWqu1Tk1WS8LGcutHPargNzNPPLNs2aDauyha9pZvk6c2DedzRgAnnwdDkA22\\/1ESly0LS7+Wzyj0jC59RQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"latin1_general_cs\",\n                \"utf8mb3_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"builtbypearlcity_pcmdivi5\",\n            \"tablesBaseCount\": 53,\n            \"tablesFinalCount\": 53,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 488,\n            \"tablesSizeOnDisk\": 7626235,\n            \"tablesList\": {\n                \"pcmdivi5actionscheduler_actions\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 18336\n                },\n                \"pcmdivi5actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"pcmdivi5actionscheduler_groups\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 9280\n                },\n                \"pcmdivi5actionscheduler_logs\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 4768\n                },\n                \"pcmdivi5ac_segments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5admin_columns\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5atai_assets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5blc_filters\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5blc_instances\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 5420\n                },\n                \"pcmdivi5blc_links\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 19012\n                },\n                \"pcmdivi5blc_synch\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 3136\n                },\n                \"pcmdivi5commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5comments\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 7496\n                },\n                \"pcmdivi5defender_antibot\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5defender_audit_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_email_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_lockout\": {\n                    \"inaccurateRows\": 25,\n                    \"insertedRows\": 25,\n                    \"size\": 23552\n                },\n                \"pcmdivi5defender_lockout_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_quarantine\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5defender_scan\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 2132\n                },\n                \"pcmdivi5defender_scan_item\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 13956\n                },\n                \"pcmdivi5defender_unlockout\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 10640\n                },\n                \"pcmdivi5duplicator_pro_packages\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 2,\n                    \"size\": 29536\n                },\n                \"pcmdivi5gf_addon_feed\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_draft_submissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_entry\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_entry_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5gf_entry_notes\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_revisions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_view\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_rest_api_keys\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5imagify_files\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5imagify_folders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5options\": {\n                    \"inaccurateRows\": 383,\n                    \"insertedRows\": 383,\n                    \"size\": 7324200\n                },\n                \"pcmdivi5postmeta\": {\n                    \"inaccurateRows\": 9,\n                    \"insertedRows\": 9,\n                    \"size\": 12268\n                },\n                \"pcmdivi5posts\": {\n                    \"inaccurateRows\": 6,\n                    \"insertedRows\": 6,\n                    \"size\": 23676\n                },\n                \"pcmdivi5seopress_content_analysis\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5seopress_seo_issues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5seopress_significant_keywords\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5snapshot_action_logs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5terms\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 13352\n                },\n                \"pcmdivi5term_relationships\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 3093\n                },\n                \"pcmdivi5term_taxonomy\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 4136\n                },\n                \"pcmdivi5trp_gettext_en_us\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5trp_gettext_original_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5trp_gettext_original_strings\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5usermeta\": {\n                    \"inaccurateRows\": 27,\n                    \"insertedRows\": 27,\n                    \"size\": 13064\n                },\n                \"pcmdivi5users\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 8368\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.22\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2203000,\n        \"File\": \"20250611_divi5blanktemplate_9b96b13caa7f0bba9002_20250611212008_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20250611_divi5blanktemplate_9b96b13caa7f0bba9002_20250611212008_database.sql\"\n    },\n    \"Status\": \"100.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1749676857,\n            \"stopped_timestamp\": 1749676857\n        }\n    ],\n    \"active_storage_id\": -2,\n    \"template_id\": 5\n}"),
("3","20250826_divi5blanktemplate","77e30c0fbf77d8a38605_20250826145509","100","2025-08-26 14:55:25","pcmadmin","{\n    \"Created\": \"2025-08-26 14:55:09\",\n    \"Version\": \"4.5.5.1\",\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"10.6.23\",\n    \"VersionPHP\": \"8.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 3,\n    \"Name\": \"20250826_divi5blanktemplate\",\n    \"Hash\": \"77e30c0fbf77d8a38605_20250826145509\",\n    \"NameHash\": \"20250826_divi5blanktemplate_77e30c0fbf77d8a38605_20250826145509\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20250826_divi5blanktemplate_77e30c0fbf77d8a38605_20250826145509_scan.json\",\n    \"timer_start\": 1756220139.211041927337646484375,\n    \"Runtime\": \"28.942 sec.\",\n    \"ExeSize\": \"114.06KB\",\n    \"ZipSize\": \"160.73MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.opcache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.tmb\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/bps-backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/old-cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/updraft\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wfcache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.htaccess\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.user.ini\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/php.ini\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/web.config\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"20250826_divi5blanktemplate_77e30c0fbf77d8a38605_20250826145509_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\",\n        \"Size\": 168537296,\n        \"Dirs\": null,\n        \"DirCount\": 6871,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 34778,\n        \"file_count\": 41649,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20250826_divi5blanktemplate_77e30c0fbf77d8a38605_20250826145509_installer.php\",\n        \"Size\": 116793,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"kLzfHi0Cr+GnW\\/Qqktmy2g4BMxc7MJy+tY3HVpcyuo+ELQo2wugXfWckYOWPi6Iq\\/Snpy\\/uY6Ur2JKUs1CQQ3g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"latin1_general_cs\",\n                \"utf8mb3_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"builtbypearlcity_pcmdivi5\",\n            \"tablesBaseCount\": 53,\n            \"tablesFinalCount\": 53,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 741,\n            \"tablesSizeOnDisk\": 7666655,\n            \"tablesList\": {\n                \"pcmdivi5actionscheduler_actions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 18336\n                },\n                \"pcmdivi5actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 3086\n                },\n                \"pcmdivi5actionscheduler_groups\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 2,\n                    \"size\": 9280\n                },\n                \"pcmdivi5actionscheduler_logs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4768\n                },\n                \"pcmdivi5ac_segments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5admin_columns\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5atai_assets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5blc_filters\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5blc_instances\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 5420\n                },\n                \"pcmdivi5blc_links\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 19048\n                },\n                \"pcmdivi5blc_synch\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 3136\n                },\n                \"pcmdivi5commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5comments\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 7496\n                },\n                \"pcmdivi5defender_antibot\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5defender_audit_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_email_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_lockout\": {\n                    \"inaccurateRows\": 290,\n                    \"insertedRows\": 290,\n                    \"size\": 40224\n                },\n                \"pcmdivi5defender_lockout_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_quarantine\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5defender_scan\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 2132\n                },\n                \"pcmdivi5defender_scan_item\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": 3,\n                    \"size\": 13956\n                },\n                \"pcmdivi5defender_unlockout\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 10640\n                },\n                \"pcmdivi5duplicator_pro_packages\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": 3,\n                    \"size\": 53248\n                },\n                \"pcmdivi5gf_addon_feed\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_draft_submissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_entry\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_entry_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5gf_entry_notes\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_revisions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_view\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_rest_api_keys\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5imagify_files\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5imagify_folders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5options\": {\n                    \"inaccurateRows\": 385,\n                    \"insertedRows\": 385,\n                    \"size\": 7324200\n                },\n                \"pcmdivi5postmeta\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": 7,\n                    \"size\": 12268\n                },\n                \"pcmdivi5posts\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": 5,\n                    \"size\": 23676\n                },\n                \"pcmdivi5seopress_content_analysis\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5seopress_seo_issues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 1024\n                },\n                \"pcmdivi5seopress_significant_keywords\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5snapshot_action_logs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5terms\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 13352\n                },\n                \"pcmdivi5term_relationships\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 3093\n                },\n                \"pcmdivi5term_taxonomy\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 4136\n                },\n                \"pcmdivi5trp_gettext_en_us\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5trp_gettext_original_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 4096\n                },\n                \"pcmdivi5trp_gettext_original_strings\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": 0,\n                    \"size\": 2048\n                },\n                \"pcmdivi5usermeta\": {\n                    \"inaccurateRows\": 27,\n                    \"insertedRows\": 27,\n                    \"size\": 13064\n                },\n                \"pcmdivi5users\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": 1,\n                    \"size\": 8368\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.23\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2255670,\n        \"File\": \"20250826_divi5blanktemplate_77e30c0fbf77d8a38605_20250826145509_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/tmp\\/20250826_divi5blanktemplate_77e30c0fbf77d8a38605_20250826145509_database.sql\"\n    },\n    \"Status\": \"100.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1756220168,\n            \"stopped_timestamp\": 1756220169\n        }\n    ],\n    \"active_storage_id\": -2,\n    \"template_id\": 5\n}"),
("4","kayfabeclique","4f0b8bef5ab840442037_20251021204646","20","2025-10-21 20:46:54","pcmadmin","{\n    \"Created\": \"2025-10-21 20:46:46\",\n    \"Version\": \"4.5.5.1\",\n    \"VersionWP\": \"6.8.2\",\n    \"VersionDB\": \"10.6.23\",\n    \"VersionPHP\": \"8.2.29\",\n    \"VersionOS\": \"Linux\",\n    \"ID\": 4,\n    \"Name\": \"kayfabeclique\",\n    \"Hash\": \"4f0b8bef5ab840442037_20251021204646\",\n    \"NameHash\": \"kayfabeclique_4f0b8bef5ab840442037_20251021204646\",\n    \"Type\": 0,\n    \"notes\": \"\",\n    \"StorePath\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"kayfabeclique_4f0b8bef5ab840442037_20251021204646_scan.json\",\n    \"timer_start\": 1761079628.27923107147216796875,\n    \"Runtime\": null,\n    \"ExeSize\": null,\n    \"ZipSize\": 0,\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -2,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": 0,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.opcache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.tmb\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/bps-backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/old-cache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/updraft\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wfcache\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.htaccess\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/.user.ini\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/php.ini\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/web.config\",\n            \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-config.php\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": 0,\n        \"FilterNames\": false,\n        \"File\": \"kayfabeclique_4f0b8bef5ab840442037_20251021204646_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\",\n        \"Size\": 490827869,\n        \"Dirs\": null,\n        \"DirCount\": 6907,\n        \"RecursiveLinks\": [],\n        \"Files\": null,\n        \"FileCount\": 34947,\n        \"file_count\": -1,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"Warning\": [],\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Warning\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null,\n            \"TreeWarning\": null\n        },\n        \"ListDelimiter\": \"\\n\",\n        \"throttleDelayInUs\": 0\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"kayfabeclique_4f0b8bef5ab840442037_20251021204646_installer.php\",\n        \"Size\": 0,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"sJ\\/kJXWYgs0FmEm9ZyWfSFLRxAXREnGRYFxttk1g+NuVSETUqaIKF2GH9zsf3sivaph41buH8I6AHLcLIKHpFA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": 0,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": 0,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"latin1_general_cs\",\n                \"utf8mb3_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"MyISAM\"\n            ],\n            \"isTablesUpperCase\": 0,\n            \"isNameUpperCase\": 0,\n            \"name\": \"builtbypearlcity_pcmdivi5\",\n            \"tablesBaseCount\": 53,\n            \"tablesFinalCount\": 53,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 751,\n            \"tablesSizeOnDisk\": 7694207,\n            \"tablesList\": {\n                \"pcmdivi5actionscheduler_actions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 18336\n                },\n                \"pcmdivi5actionscheduler_claims\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 3086\n                },\n                \"pcmdivi5actionscheduler_groups\": {\n                    \"inaccurateRows\": 2,\n                    \"insertedRows\": false,\n                    \"size\": 9280\n                },\n                \"pcmdivi5actionscheduler_logs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4768\n                },\n                \"pcmdivi5ac_segments\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5admin_columns\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5atai_assets\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5blc_filters\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5blc_instances\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 5420\n                },\n                \"pcmdivi5blc_links\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 19152\n                },\n                \"pcmdivi5blc_synch\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 3136\n                },\n                \"pcmdivi5commentmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5comments\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 7496\n                },\n                \"pcmdivi5defender_antibot\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5defender_audit_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_email_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_lockout\": {\n                    \"inaccurateRows\": 292,\n                    \"insertedRows\": false,\n                    \"size\": 47560\n                },\n                \"pcmdivi5defender_lockout_log\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5defender_quarantine\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5defender_scan\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 2132\n                },\n                \"pcmdivi5defender_scan_item\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 13956\n                },\n                \"pcmdivi5defender_unlockout\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5duplicator_pro_entities\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 10640\n                },\n                \"pcmdivi5duplicator_pro_packages\": {\n                    \"inaccurateRows\": 3,\n                    \"insertedRows\": false,\n                    \"size\": 73360\n                },\n                \"pcmdivi5gf_addon_feed\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_draft_submissions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_entry\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_entry_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5gf_entry_notes\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_revisions\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_form_view\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5gf_rest_api_keys\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 2048\n                },\n                \"pcmdivi5imagify_files\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5imagify_folders\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5links\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5options\": {\n                    \"inaccurateRows\": 392,\n                    \"insertedRows\": false,\n                    \"size\": 7324200\n                },\n                \"pcmdivi5postmeta\": {\n                    \"inaccurateRows\": 7,\n                    \"insertedRows\": false,\n                    \"size\": 12268\n                },\n                \"pcmdivi5posts\": {\n                    \"inaccurateRows\": 5,\n                    \"insertedRows\": false,\n                    \"size\": 23676\n                },\n                \"pcmdivi5seopress_content_analysis\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5seopress_seo_issues\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 1024\n                },\n                \"pcmdivi5seopress_significant_keywords\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 2048\n                },\n                \"pcmdivi5snapshot_action_logs\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5termmeta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5terms\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 13352\n                },\n                \"pcmdivi5term_relationships\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 3093\n                },\n                \"pcmdivi5term_taxonomy\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 4136\n                },\n                \"pcmdivi5trp_gettext_en_us\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 2048\n                },\n                \"pcmdivi5trp_gettext_original_meta\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 4096\n                },\n                \"pcmdivi5trp_gettext_original_strings\": {\n                    \"inaccurateRows\": 0,\n                    \"insertedRows\": false,\n                    \"size\": 2048\n                },\n                \"pcmdivi5usermeta\": {\n                    \"inaccurateRows\": 27,\n                    \"insertedRows\": false,\n                    \"size\": 13064\n                },\n                \"pcmdivi5users\": {\n                    \"inaccurateRows\": 1,\n                    \"insertedRows\": false,\n                    \"size\": 8368\n                }\n            },\n            \"varLowerCaseTables\": \"0\",\n            \"dbEngine\": \"MariaDB\",\n            \"version\": \"10.6.23\",\n            \"versionComment\": \"MariaDB Server\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 0,\n        \"File\": \"kayfabeclique_4f0b8bef5ab840442037_20251021204646_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": 0,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"MariaDB Server\",\n        \"dbStorePathPublic\": \"\\/home\\/builtbypearlcity\\/divi5.builtbypearlcitymedia.com\\/wp-content\\/backups-dup-pro\\/tmp\\/kayfabeclique_4f0b8bef5ab840442037_20251021204646_database.sql\"\n    },\n    \"Status\": \"20.0\",\n    \"schedule_id\": -1,\n    \"build_progress\": {\n        \"thread_start_time\": 1761079630,\n        \"initialized\": true,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 2,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [\n            \"pcmdivi5users\",\n            \"pcmdivi5usermeta\",\n            \"pcmdivi5actionscheduler_actions\",\n            \"pcmdivi5actionscheduler_claims\",\n            \"pcmdivi5actionscheduler_groups\",\n            \"pcmdivi5actionscheduler_logs\",\n            \"pcmdivi5ac_segments\",\n            \"pcmdivi5admin_columns\",\n            \"pcmdivi5atai_assets\",\n            \"pcmdivi5blc_filters\",\n            \"pcmdivi5blc_instances\",\n            \"pcmdivi5blc_links\",\n            \"pcmdivi5blc_synch\",\n            \"pcmdivi5commentmeta\",\n            \"pcmdivi5comments\",\n            \"pcmdivi5defender_antibot\",\n            \"pcmdivi5defender_audit_log\",\n            \"pcmdivi5defender_email_log\",\n            \"pcmdivi5defender_lockout\",\n            \"pcmdivi5defender_lockout_log\",\n            \"pcmdivi5defender_quarantine\",\n            \"pcmdivi5defender_scan\",\n            \"pcmdivi5defender_scan_item\",\n            \"pcmdivi5defender_unlockout\",\n            \"pcmdivi5duplicator_pro_entities\",\n            \"pcmdivi5duplicator_pro_packages\",\n            \"pcmdivi5gf_addon_feed\",\n            \"pcmdivi5gf_draft_submissions\",\n            \"pcmdivi5gf_entry\",\n            \"pcmdivi5gf_entry_meta\",\n            \"pcmdivi5gf_entry_notes\",\n            \"pcmdivi5gf_form\",\n            \"pcmdivi5gf_form_meta\",\n            \"pcmdivi5gf_form_revisions\",\n            \"pcmdivi5gf_form_view\",\n            \"pcmdivi5gf_rest_api_keys\",\n            \"pcmdivi5imagify_files\",\n            \"pcmdivi5imagify_folders\",\n            \"pcmdivi5links\",\n            \"pcmdivi5options\",\n            \"pcmdivi5postmeta\",\n            \"pcmdivi5posts\",\n            \"pcmdivi5seopress_content_analysis\",\n            \"pcmdivi5seopress_seo_issues\",\n            \"pcmdivi5seopress_significant_keywords\",\n            \"pcmdivi5snapshot_action_logs\",\n            \"pcmdivi5termmeta\",\n            \"pcmdivi5terms\",\n            \"pcmdivi5term_relationships\",\n            \"pcmdivi5term_taxonomy\",\n            \"pcmdivi5trp_gettext_en_us\",\n            \"pcmdivi5trp_gettext_original_meta\",\n            \"pcmdivi5trp_gettext_original_strings\"\n        ],\n        \"validationStage1\": false,\n        \"doneInit\": true,\n        \"doneFiltering\": true,\n        \"doneCreates\": true,\n        \"completed\": false,\n        \"startTime\": 1761079628.2901079654693603515625,\n        \"wasInterrupted\": true,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"countTotal\": 0,\n            \"impreciseTotalRows\": 752,\n            \"tables\": {\n                \"pcmdivi5users\": {\n                    \"start\": \"1\",\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5usermeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5actionscheduler_actions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5actionscheduler_claims\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5actionscheduler_groups\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5actionscheduler_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5ac_segments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5admin_columns\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5atai_assets\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5blc_filters\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5blc_instances\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5blc_links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5blc_synch\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5commentmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5comments\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_antibot\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_audit_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_email_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_lockout\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_lockout_log\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_quarantine\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_scan\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_scan_item\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5defender_unlockout\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5duplicator_pro_entities\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5duplicator_pro_packages\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_addon_feed\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_draft_submissions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_entry\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_entry_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_entry_notes\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_form\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_form_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_form_revisions\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_form_view\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5gf_rest_api_keys\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5imagify_files\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5imagify_folders\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5links\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5options\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5postmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5posts\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5seopress_content_analysis\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5seopress_seo_issues\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5seopress_significant_keywords\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5snapshot_action_logs\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5termmeta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5terms\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5term_relationships\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5term_taxonomy\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5trp_gettext_en_us\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5trp_gettext_original_meta\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                },\n                \"pcmdivi5trp_gettext_original_strings\": {\n                    \"start\": 0,\n                    \"end\": 0,\n                    \"count\": 0,\n                    \"create\": true\n                }\n            }\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": \"-2\",\n            \"archive_offset\": 0,\n            \"copied_installer\": false,\n            \"copied_archive\": false,\n            \"progress\": 0,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": false,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": null,\n            \"stopped_timestamp\": null\n        }\n    ],\n    \"active_storage_id\": -1,\n    \"template_id\": 5\n}");

INSERT INTO `pcmdivi5options` VALUES 
("1","cron","a:38:{i:1761079685;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1761079732;a:1:{s:20:\"blc_cron_check_links\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"10min\";s:4:\"args\";a:0:{}s:8:\"interval\";i:600;}}}i:1761080322;a:1:{s:26:\"wpdef_fetch_global_ip_list\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761080332;a:1:{s:22:\"firewall_clean_up_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761080400;a:1:{s:21:\"wdf_maybe_send_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:14:\"thirty_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1800;}}}i:1761081142;a:1:{s:26:\"rediscache_discard_metrics\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761081300;a:2:{s:30:\"seopress_matomo_analytics_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:30:\"seopress_google_analytics_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761082129;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1761083836;a:1:{s:22:\"wpmudev_scheduled_jobs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761083925;a:1:{s:25:\"snapshot4_add_empty_index\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761083937;a:2:{s:39:\"wpdef_firewall_send_compact_logs_to_api\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:41:\"wpdef_firewall_whitelist_server_public_ip\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761098400;a:1:{s:18:\"imagify_sync_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761103961;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761109129;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761110929;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761113700;a:1:{s:20:\"seopress_alerts_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761127122;a:3:{s:21:\"wpdef_clear_scan_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:45:\"wpdef_firewall_fetch_trusted_proxy_preset_ips\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:27:\"wpdef_log_rotational_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761127125;a:1:{s:25:\"snapshot4_clean_log_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761127132;a:3:{s:31:\"wpdef_firewall_clean_up_lockout\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}s:28:\"blc_cron_email_notifications\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:29:\"blc_cron_database_maintenance\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761127141;a:1:{s:29:\"wpdef_smart_ip_detection_ping\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761127142;a:1:{s:33:\"wpdef_firewall_clean_up_unlockout\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761127162;a:1:{s:36:\"snapshot_delete_old_user_action_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761132535;a:1:{s:22:\"wp_defender_clear_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761145200;a:1:{s:20:\"imagify_rating_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761146929;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761147161;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761155952;a:1:{s:17:\"gravityforms_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761156312;a:1:{s:44:\"rt_wp_nginx_helper_check_log_file_size_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761156900;a:3:{s:26:\"seopress_404_cron_cleaning\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:33:\"seopress_page_speed_insights_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:26:\"seopress_insights_gsc_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1761212424;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1761585293;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761586847;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761588900;a:1:{s:30:\"seopress_404_email_alerts_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761589264;a:1:{s:21:\"trp_plugin_optin_sync\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761624000;a:1:{s:46:\"imagify_update_library_size_calculations_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1761665329;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1763373522;a:2:{s:17:\"wpdef_sec_key_gen\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"sixty_days\";s:4:\"args\";a:0:{}s:8:\"interval\";i:5184000;}}s:31:\"wpdef_quarantine_delete_expired\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"thirty_days\";s:4:\"args\";a:0:{}s:8:\"interval\";i:2592000;}}}s:7:\"version\";i:2;}","on"),
("2","siteurl","https://divi5.builtbypearlcitymedia.com","on"),
("3","home","https://divi5.builtbypearlcitymedia.com","on"),
("4","blogname","Divi 5 Blank Template","on"),
("5","blogdescription","","on"),
("6","users_can_register","0","on"),
("7","admin_email","chris@pearlcitymedia.com","on"),
("8","start_of_week","1","on"),
("9","use_balanceTags","0","on"),
("10","use_smilies","1","on"),
("11","require_name_email","1","on"),
("12","comments_notify","1","on"),
("13","posts_per_rss","10","on"),
("14","rss_use_excerpt","0","on"),
("15","mailserver_url","mail.example.com","on"),
("16","mailserver_login","login@example.com","on"),
("17","mailserver_pass","","on"),
("18","mailserver_port","110","on"),
("19","default_category","1","on"),
("20","default_comment_status","open","on"),
("21","default_ping_status","open","on"),
("22","default_pingback_flag","1","on"),
("23","posts_per_page","10","on"),
("24","date_format","F j, Y","on"),
("25","time_format","g:i a","on"),
("26","links_updated_date_format","F j, Y g:i a","on"),
("27","comment_moderation","0","on"),
("28","moderation_notify","1","on"),
("29","permalink_structure","/index.php/%year%/%monthnum%/%day%/%postname%/","on"),
("30","rewrite_rules","a:359:{s:20:\"index.php/project/?$\";s:27:\"index.php?post_type=project\";s:50:\"index.php/project/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:45:\"index.php/project/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=project&feed=$matches[1]\";s:37:\"index.php/project/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=project&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:14:\"^sitemaps.xml$\";s:28:\"index.php?seopress_sitemap=1\";s:18:\"^sitemaps_xsl.xsl$\";s:32:\"index.php?seopress_sitemap_xsl=1\";s:24:\"^sitemaps_video_xsl.xsl$\";s:38:\"index.php?seopress_sitemap_video_xsl=1\";s:31:\"([^/]+?)-sitemap([0-9]+)?\\.xml$\";s:61:\"index.php?seopress_cpt=$matches[1]&seopress_paged=$matches[2]\";s:37:\"^broken-link-checker-review/([^/]*)/?\";s:33:\"index.php?user-review=$matches[1]\";s:41:\"^broken-link-checker-activation/([^/]*)/?\";s:44:\"index.php?blc-activate-recipient=$matches[1]\";s:35:\"^broken-link-checker-scan/([^/]*)/?\";s:39:\"index.php?blc-scan-complete=$matches[1]\";s:57:\"index.php/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:45:\"index.php/category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:54:\"index.php/tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:49:\"index.php/tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:30:\"index.php/tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:42:\"index.php/tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:24:\"index.php/tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:55:\"index.php/type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:50:\"index.php/type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:31:\"index.php/type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:43:\"index.php/type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:25:\"index.php/type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:66:\"index.php/layout_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?layout_category=$matches[1]&feed=$matches[2]\";s:61:\"index.php/layout_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?layout_category=$matches[1]&feed=$matches[2]\";s:42:\"index.php/layout_category/([^/]+)/embed/?$\";s:48:\"index.php?layout_category=$matches[1]&embed=true\";s:54:\"index.php/layout_category/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?layout_category=$matches[1]&paged=$matches[2]\";s:36:\"index.php/layout_category/([^/]+)/?$\";s:37:\"index.php?layout_category=$matches[1]\";s:61:\"index.php/layout_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?layout_tag=$matches[1]&feed=$matches[2]\";s:56:\"index.php/layout_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?layout_tag=$matches[1]&feed=$matches[2]\";s:37:\"index.php/layout_tag/([^/]+)/embed/?$\";s:43:\"index.php?layout_tag=$matches[1]&embed=true\";s:49:\"index.php/layout_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?layout_tag=$matches[1]&paged=$matches[2]\";s:31:\"index.php/layout_tag/([^/]+)/?$\";s:32:\"index.php?layout_tag=$matches[1]\";s:66:\"index.php/et_tb_item_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?et_tb_item_type=$matches[1]&feed=$matches[2]\";s:61:\"index.php/et_tb_item_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?et_tb_item_type=$matches[1]&feed=$matches[2]\";s:42:\"index.php/et_tb_item_type/([^/]+)/embed/?$\";s:48:\"index.php?et_tb_item_type=$matches[1]&embed=true\";s:54:\"index.php/et_tb_item_type/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?et_tb_item_type=$matches[1]&paged=$matches[2]\";s:36:\"index.php/et_tb_item_type/([^/]+)/?$\";s:37:\"index.php?et_tb_item_type=$matches[1]\";s:48:\"index.php/et_tb_item/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:58:\"index.php/et_tb_item/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:78:\"index.php/et_tb_item/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"index.php/et_tb_item/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"index.php/et_tb_item/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"index.php/et_tb_item/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"index.php/et_tb_item/([^/]+)/embed/?$\";s:58:\"index.php?post_type=et_tb_item&name=$matches[1]&embed=true\";s:41:\"index.php/et_tb_item/([^/]+)/trackback/?$\";s:52:\"index.php?post_type=et_tb_item&name=$matches[1]&tb=1\";s:49:\"index.php/et_tb_item/([^/]+)/page/?([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&paged=$matches[2]\";s:56:\"index.php/et_tb_item/([^/]+)/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?post_type=et_tb_item&name=$matches[1]&cpage=$matches[2]\";s:45:\"index.php/et_tb_item/([^/]+)(?:/([0-9]+))?/?$\";s:64:\"index.php?post_type=et_tb_item&name=$matches[1]&page=$matches[2]\";s:37:\"index.php/et_tb_item/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/et_tb_item/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/et_tb_item/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/et_tb_item/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/et_tb_item/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/et_tb_item/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:45:\"index.php/project/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"index.php/project/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"index.php/project/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"index.php/project/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"index.php/project/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"index.php/project/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"index.php/project/([^/]+)/embed/?$\";s:40:\"index.php?project=$matches[1]&embed=true\";s:38:\"index.php/project/([^/]+)/trackback/?$\";s:34:\"index.php?project=$matches[1]&tb=1\";s:58:\"index.php/project/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:53:\"index.php/project/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?project=$matches[1]&feed=$matches[2]\";s:46:\"index.php/project/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&paged=$matches[2]\";s:53:\"index.php/project/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?project=$matches[1]&cpage=$matches[2]\";s:42:\"index.php/project/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?project=$matches[1]&page=$matches[2]\";s:34:\"index.php/project/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"index.php/project/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"index.php/project/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"index.php/project/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"index.php/project/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"index.php/project/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:67:\"index.php/project_category/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:62:\"index.php/project_category/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?project_category=$matches[1]&feed=$matches[2]\";s:43:\"index.php/project_category/([^/]+)/embed/?$\";s:49:\"index.php?project_category=$matches[1]&embed=true\";s:55:\"index.php/project_category/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?project_category=$matches[1]&paged=$matches[2]\";s:37:\"index.php/project_category/([^/]+)/?$\";s:38:\"index.php?project_category=$matches[1]\";s:62:\"index.php/project_tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:57:\"index.php/project_tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project_tag=$matches[1]&feed=$matches[2]\";s:38:\"index.php/project_tag/([^/]+)/embed/?$\";s:44:\"index.php?project_tag=$matches[1]&embed=true\";s:50:\"index.php/project_tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project_tag=$matches[1]&paged=$matches[2]\";s:32:\"index.php/project_tag/([^/]+)/?$\";s:33:\"index.php?project_tag=$matches[1]\";s:50:\"index.php/seopress_bot/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:60:\"index.php/seopress_bot/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:80:\"index.php/seopress_bot/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"index.php/seopress_bot/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"index.php/seopress_bot/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:56:\"index.php/seopress_bot/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"index.php/seopress_bot/([^/]+)/embed/?$\";s:45:\"index.php?seopress_bot=$matches[1]&embed=true\";s:43:\"index.php/seopress_bot/([^/]+)/trackback/?$\";s:39:\"index.php?seopress_bot=$matches[1]&tb=1\";s:51:\"index.php/seopress_bot/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?seopress_bot=$matches[1]&paged=$matches[2]\";s:58:\"index.php/seopress_bot/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?seopress_bot=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/seopress_bot/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?seopress_bot=$matches[1]&page=$matches[2]\";s:39:\"index.php/seopress_bot/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"index.php/seopress_bot/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"index.php/seopress_bot/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"index.php/seopress_bot/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"index.php/seopress_bot/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"index.php/seopress_bot/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"index.php/seopress_404/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:60:\"index.php/seopress_404/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:80:\"index.php/seopress_404/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"index.php/seopress_404/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"index.php/seopress_404/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:56:\"index.php/seopress_404/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"index.php/seopress_404/([^/]+)/embed/?$\";s:45:\"index.php?seopress_404=$matches[1]&embed=true\";s:43:\"index.php/seopress_404/([^/]+)/trackback/?$\";s:39:\"index.php?seopress_404=$matches[1]&tb=1\";s:51:\"index.php/seopress_404/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?seopress_404=$matches[1]&paged=$matches[2]\";s:58:\"index.php/seopress_404/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?seopress_404=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/seopress_404/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?seopress_404=$matches[1]&page=$matches[2]\";s:39:\"index.php/seopress_404/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"index.php/seopress_404/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"index.php/seopress_404/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"index.php/seopress_404/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"index.php/seopress_404/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"index.php/seopress_404/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"index.php/et_theme_options/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:64:\"index.php/et_theme_options/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:84:\"index.php/et_theme_options/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/et_theme_options/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/et_theme_options/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:60:\"index.php/et_theme_options/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"index.php/et_theme_options/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_options&name=$matches[1]&embed=true\";s:47:\"index.php/et_theme_options/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_options&name=$matches[1]&tb=1\";s:55:\"index.php/et_theme_options/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_options&name=$matches[1]&paged=$matches[2]\";s:62:\"index.php/et_theme_options/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_options&name=$matches[1]&cpage=$matches[2]\";s:51:\"index.php/et_theme_options/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_options&name=$matches[1]&page=$matches[2]\";s:43:\"index.php/et_theme_options/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"index.php/et_theme_options/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"index.php/et_theme_options/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/et_theme_options/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/et_theme_options/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/et_theme_options/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:71:\"index.php/et_code_snippet_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:66:\"index.php/et_code_snippet_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:59:\"index.php?et_code_snippet_type=$matches[1]&feed=$matches[2]\";s:47:\"index.php/et_code_snippet_type/([^/]+)/embed/?$\";s:53:\"index.php?et_code_snippet_type=$matches[1]&embed=true\";s:59:\"index.php/et_code_snippet_type/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?et_code_snippet_type=$matches[1]&paged=$matches[2]\";s:41:\"index.php/et_code_snippet_type/([^/]+)/?$\";s:42:\"index.php?et_code_snippet_type=$matches[1]\";s:53:\"index.php/et_code_snippet/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:63:\"index.php/et_code_snippet/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:83:\"index.php/et_code_snippet/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:78:\"index.php/et_code_snippet/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:78:\"index.php/et_code_snippet/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:59:\"index.php/et_code_snippet/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"index.php/et_code_snippet/([^/]+)/embed/?$\";s:63:\"index.php?post_type=et_code_snippet&name=$matches[1]&embed=true\";s:46:\"index.php/et_code_snippet/([^/]+)/trackback/?$\";s:57:\"index.php?post_type=et_code_snippet&name=$matches[1]&tb=1\";s:54:\"index.php/et_code_snippet/([^/]+)/page/?([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&paged=$matches[2]\";s:61:\"index.php/et_code_snippet/([^/]+)/comment-page-([0-9]{1,})/?$\";s:70:\"index.php?post_type=et_code_snippet&name=$matches[1]&cpage=$matches[2]\";s:50:\"index.php/et_code_snippet/([^/]+)(?:/([0-9]+))?/?$\";s:69:\"index.php?post_type=et_code_snippet&name=$matches[1]&page=$matches[2]\";s:42:\"index.php/et_code_snippet/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"index.php/et_code_snippet/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"index.php/et_code_snippet/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"index.php/et_code_snippet/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"index.php/et_code_snippet/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"index.php/et_code_snippet/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"index.php/et_theme_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:64:\"index.php/et_theme_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:84:\"index.php/et_theme_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/et_theme_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/et_theme_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:60:\"index.php/et_theme_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"index.php/et_theme_builder/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_theme_builder&name=$matches[1]&embed=true\";s:47:\"index.php/et_theme_builder/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_theme_builder&name=$matches[1]&tb=1\";s:55:\"index.php/et_theme_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&paged=$matches[2]\";s:62:\"index.php/et_theme_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_theme_builder&name=$matches[1]&cpage=$matches[2]\";s:51:\"index.php/et_theme_builder/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_theme_builder&name=$matches[1]&page=$matches[2]\";s:43:\"index.php/et_theme_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"index.php/et_theme_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"index.php/et_theme_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/et_theme_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/et_theme_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/et_theme_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:49:\"index.php/et_template/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:59:\"index.php/et_template/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:79:\"index.php/et_template/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:74:\"index.php/et_template/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:74:\"index.php/et_template/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:55:\"index.php/et_template/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"index.php/et_template/([^/]+)/embed/?$\";s:59:\"index.php?post_type=et_template&name=$matches[1]&embed=true\";s:42:\"index.php/et_template/([^/]+)/trackback/?$\";s:53:\"index.php?post_type=et_template&name=$matches[1]&tb=1\";s:50:\"index.php/et_template/([^/]+)/page/?([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&paged=$matches[2]\";s:57:\"index.php/et_template/([^/]+)/comment-page-([0-9]{1,})/?$\";s:66:\"index.php?post_type=et_template&name=$matches[1]&cpage=$matches[2]\";s:46:\"index.php/et_template/([^/]+)(?:/([0-9]+))?/?$\";s:65:\"index.php?post_type=et_template&name=$matches[1]&page=$matches[2]\";s:38:\"index.php/et_template/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"index.php/et_template/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"index.php/et_template/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"index.php/et_template/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"index.php/et_template/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"index.php/et_template/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"index.php/et_header_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:64:\"index.php/et_header_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:84:\"index.php/et_header_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/et_header_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/et_header_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:60:\"index.php/et_header_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"index.php/et_header_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_header_layout&name=$matches[1]&embed=true\";s:47:\"index.php/et_header_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_header_layout&name=$matches[1]&tb=1\";s:55:\"index.php/et_header_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&paged=$matches[2]\";s:62:\"index.php/et_header_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_header_layout&name=$matches[1]&cpage=$matches[2]\";s:51:\"index.php/et_header_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_header_layout&name=$matches[1]&page=$matches[2]\";s:43:\"index.php/et_header_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"index.php/et_header_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"index.php/et_header_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/et_header_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/et_header_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/et_header_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:52:\"index.php/et_body_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:62:\"index.php/et_body_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:82:\"index.php/et_body_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/et_body_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:77:\"index.php/et_body_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:58:\"index.php/et_body_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:41:\"index.php/et_body_layout/([^/]+)/embed/?$\";s:62:\"index.php?post_type=et_body_layout&name=$matches[1]&embed=true\";s:45:\"index.php/et_body_layout/([^/]+)/trackback/?$\";s:56:\"index.php?post_type=et_body_layout&name=$matches[1]&tb=1\";s:53:\"index.php/et_body_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&paged=$matches[2]\";s:60:\"index.php/et_body_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:69:\"index.php?post_type=et_body_layout&name=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/et_body_layout/([^/]+)(?:/([0-9]+))?/?$\";s:68:\"index.php?post_type=et_body_layout&name=$matches[1]&page=$matches[2]\";s:41:\"index.php/et_body_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"index.php/et_body_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"index.php/et_body_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/et_body_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"index.php/et_body_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/et_body_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"index.php/et_footer_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:64:\"index.php/et_footer_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:84:\"index.php/et_footer_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/et_footer_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:79:\"index.php/et_footer_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:60:\"index.php/et_footer_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"index.php/et_footer_layout/([^/]+)/embed/?$\";s:64:\"index.php?post_type=et_footer_layout&name=$matches[1]&embed=true\";s:47:\"index.php/et_footer_layout/([^/]+)/trackback/?$\";s:58:\"index.php?post_type=et_footer_layout&name=$matches[1]&tb=1\";s:55:\"index.php/et_footer_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&paged=$matches[2]\";s:62:\"index.php/et_footer_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?post_type=et_footer_layout&name=$matches[1]&cpage=$matches[2]\";s:51:\"index.php/et_footer_layout/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?post_type=et_footer_layout&name=$matches[1]&page=$matches[2]\";s:43:\"index.php/et_footer_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"index.php/et_footer_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"index.php/et_footer_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/et_footer_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"index.php/et_footer_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"index.php/et_footer_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:62:\"index.php/layout_pack/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?layout_pack=$matches[1]&feed=$matches[2]\";s:57:\"index.php/layout_pack/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?layout_pack=$matches[1]&feed=$matches[2]\";s:38:\"index.php/layout_pack/([^/]+)/embed/?$\";s:44:\"index.php?layout_pack=$matches[1]&embed=true\";s:50:\"index.php/layout_pack/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?layout_pack=$matches[1]&paged=$matches[2]\";s:32:\"index.php/layout_pack/([^/]+)/?$\";s:33:\"index.php?layout_pack=$matches[1]\";s:62:\"index.php/layout_type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?layout_type=$matches[1]&feed=$matches[2]\";s:57:\"index.php/layout_type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?layout_type=$matches[1]&feed=$matches[2]\";s:38:\"index.php/layout_type/([^/]+)/embed/?$\";s:44:\"index.php?layout_type=$matches[1]&embed=true\";s:50:\"index.php/layout_type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?layout_type=$matches[1]&paged=$matches[2]\";s:32:\"index.php/layout_type/([^/]+)/?$\";s:33:\"index.php?layout_type=$matches[1]\";s:63:\"index.php/module_width/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?module_width=$matches[1]&feed=$matches[2]\";s:58:\"index.php/module_width/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?module_width=$matches[1]&feed=$matches[2]\";s:39:\"index.php/module_width/([^/]+)/embed/?$\";s:45:\"index.php?module_width=$matches[1]&embed=true\";s:51:\"index.php/module_width/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?module_width=$matches[1]&paged=$matches[2]\";s:33:\"index.php/module_width/([^/]+)/?$\";s:34:\"index.php?module_width=$matches[1]\";s:56:\"index.php/scope/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?scope=$matches[1]&feed=$matches[2]\";s:51:\"index.php/scope/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?scope=$matches[1]&feed=$matches[2]\";s:32:\"index.php/scope/([^/]+)/embed/?$\";s:38:\"index.php?scope=$matches[1]&embed=true\";s:44:\"index.php/scope/([^/]+)/page/?([0-9]{1,})/?$\";s:45:\"index.php?scope=$matches[1]&paged=$matches[2]\";s:26:\"index.php/scope/([^/]+)/?$\";s:27:\"index.php?scope=$matches[1]\";s:50:\"index.php/et_pb_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:60:\"index.php/et_pb_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:80:\"index.php/et_pb_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"index.php/et_pb_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:75:\"index.php/et_pb_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:56:\"index.php/et_pb_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:39:\"index.php/et_pb_layout/([^/]+)/embed/?$\";s:60:\"index.php?post_type=et_pb_layout&name=$matches[1]&embed=true\";s:43:\"index.php/et_pb_layout/([^/]+)/trackback/?$\";s:54:\"index.php?post_type=et_pb_layout&name=$matches[1]&tb=1\";s:51:\"index.php/et_pb_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&paged=$matches[2]\";s:58:\"index.php/et_pb_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:67:\"index.php?post_type=et_pb_layout&name=$matches[1]&cpage=$matches[2]\";s:47:\"index.php/et_pb_layout/([^/]+)(?:/([0-9]+))?/?$\";s:66:\"index.php?post_type=et_pb_layout&name=$matches[1]&page=$matches[2]\";s:39:\"index.php/et_pb_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:49:\"index.php/et_pb_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:69:\"index.php/et_pb_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"index.php/et_pb_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:64:\"index.php/et_pb_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:45:\"index.php/et_pb_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:42:\"index.php/feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:37:\"index.php/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:18:\"index.php/embed/?$\";s:21:\"index.php?&embed=true\";s:30:\"index.php/page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:51:\"index.php/comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:46:\"index.php/comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:27:\"index.php/comments/embed/?$\";s:21:\"index.php?&embed=true\";s:54:\"index.php/search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:49:\"index.php/search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:30:\"index.php/search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:42:\"index.php/search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:24:\"index.php/search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:57:\"index.php/author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:52:\"index.php/author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:33:\"index.php/author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:45:\"index.php/author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:27:\"index.php/author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:79:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:55:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:49:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:66:\"index.php/([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:42:\"index.php/([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:54:\"index.php/([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:36:\"index.php/([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:53:\"index.php/([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:48:\"index.php/([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:29:\"index.php/([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:41:\"index.php/([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:23:\"index.php/([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:68:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:78:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:98:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:93:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:74:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:63:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:67:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:87:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:75:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:82:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:71:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:57:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:67:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:87:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:82:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:63:\"index.php/[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:74:\"index.php/([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:61:\"index.php/([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:48:\"index.php/([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:37:\"index.php/.?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"index.php/.?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"index.php/.?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"index.php/.?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"index.php/.?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"index.php/(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:30:\"index.php/(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:50:\"index.php/(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:45:\"index.php/(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:38:\"index.php/(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:45:\"index.php/(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:34:\"index.php/(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}","on"),
("31","hack_file","0","on"),
("32","blog_charset","UTF-8","on"),
("33","moderation_keys","","off"),
("34","active_plugins","a:29:{i:0;s:31:\"query-monitor/query-monitor.php\";i:1;s:29:\"gravityforms/gravityforms.php\";i:2;s:57:\"acf-custom-database-tables/acf-custom-database-tables.php\";i:3;s:33:\"acf-extended-pro/acf-extended.php\";i:4;s:39:\"admin-columns-pro/admin-columns-pro.php\";i:5;s:33:\"admin-menu-editor/menu-editor.php\";i:6;s:34:\"advanced-custom-fields-pro/acf.php\";i:7;s:19:\"alttext-ai/atai.php\";i:8;s:43:\"broken-link-checker/broken-link-checker.php\";i:9;s:25:\"cloudflare/cloudflare.php\";i:10;s:33:\"divi-assistant/divi-assistant.php\";i:11;s:33:\"duplicator-pro/duplicator-pro.php\";i:12;s:57:\"gravityformsadvancedpostcreation/advancedpostcreation.php\";i:13;s:45:\"gravityformschainedselects/chainedselects.php\";i:14;s:19:\"imagify/imagify.php\";i:15;s:29:\"nginx-helper/nginx-helper.php\";i:16;s:51:\"onesignal-free-web-push-notifications/onesignal.php\";i:17;s:27:\"redis-cache/redis-cache.php\";i:18;s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";i:19;s:57:\"reveal-ids-for-wp-admin-25/reveal-ids-for-wp-admin-25.php\";i:20;s:37:\"snapshot-backups/snapshot-backups.php\";i:21;s:39:\"ultimate-branding/ultimate-branding.php\";i:22;s:29:\"wordpress-main/renderform.php\";i:23;s:27:\"wp-crontrol/wp-crontrol.php\";i:24;s:27:\"wp-defender/wp-defender.php\";i:25;s:32:\"wp-seopress-pro/seopress-pro.php\";i:26;s:24:\"wp-seopress/seopress.php\";i:27;s:40:\"wpmudev-updates/update-notifications.php\";i:28;s:23:\"zoho-flow/zoho-flow.php\";}","on"),
("35","category_base","","on"),
("36","ping_sites","https://rpc.pingomatic.com/","on"),
("37","comment_max_links","2","on"),
("38","gmt_offset","0","on"),
("39","default_email_category","1","on"),
("40","recently_edited","","off"),
("41","template","Divi","on"),
("42","stylesheet","Divi","on"),
("43","comment_registration","0","on"),
("44","html_type","text/html","on"),
("45","use_trackback","0","on"),
("46","default_role","subscriber","on"),
("47","db_version","60421","on"),
("48","uploads_use_yearmonth_folders","1","on"),
("49","upload_path","","on"),
("50","blog_public","1","on"),
("51","default_link_category","2","on"),
("52","show_on_front","posts","on"),
("53","tag_base","","on"),
("54","show_avatars","1","on"),
("55","avatar_rating","G","on"),
("56","upload_url_path","","on"),
("57","thumbnail_size_w","150","on"),
("58","thumbnail_size_h","150","on"),
("59","thumbnail_crop","1","on"),
("60","medium_size_w","300","on"),
("61","medium_size_h","300","on"),
("62","avatar_default","mystery","on"),
("63","large_size_w","1024","on"),
("64","large_size_h","1024","on"),
("65","image_default_link_type","none","on"),
("66","image_default_size","","on"),
("67","image_default_align","","on"),
("68","close_comments_for_old_posts","0","on"),
("69","close_comments_days_old","14","on"),
("70","thread_comments","1","on"),
("71","thread_comments_depth","5","on"),
("72","page_comments","0","on"),
("73","comments_per_page","50","on"),
("74","default_comments_page","newest","on"),
("75","comment_order","asc","on"),
("76","sticky_posts","a:0:{}","on"),
("77","widget_categories","a:0:{}","on"),
("78","widget_text","a:0:{}","on"),
("79","widget_rss","a:0:{}","on"),
("80","uninstall_plugins","a:5:{s:22:\"zoho-flow/settings.php\";s:19:\"zoho_flow_uninstall\";s:33:\"divi-assistant/divi-assistant.php\";s:16:\"pac_da_uninstall\";s:33:\"duplicator-pro/duplicator-pro.php\";a:2:{i:0;s:24:\"Duplicator\\Core\\Unistall\";i:1;s:8:\"unistall\";}s:40:\"wpmudev-updates/update-notifications.php\";a:2:{i:0;s:17:\"WPMUDEV_Dashboard\";i:1;s:16:\"uninstall_plugin\";}s:39:\"ultimate-branding/ultimate-branding.php\";s:30:\"branda_register_uninstall_hook\";}","off"),
("81","timezone_string","","on"),
("82","page_for_posts","0","on"),
("83","page_on_front","0","on"),
("84","default_post_format","0","on"),
("85","link_manager_enabled","0","on"),
("86","finished_splitting_shared_terms","1","on"),
("87","site_icon","0","on"),
("88","medium_large_size_w","768","on"),
("89","medium_large_size_h","0","on"),
("90","wp_page_for_privacy_policy","3","on"),
("91","show_comments_cookies_opt_in","1","on"),
("92","admin_email_lifespan","1763220529","on"),
("93","disallowed_keys","","off"),
("94","comment_previously_approved","1","on"),
("95","auto_plugin_theme_update_emails","a:0:{}","off"),
("96","auto_update_core_dev","enabled","on"),
("97","auto_update_core_minor","enabled","on"),
("98","auto_update_core_major","enabled","on"),
("99","wp_force_deactivated_plugins","a:0:{}","on"),
("100","wp_attachment_pages_enabled","0","on"),
("101","initial_db_version","58975","on"),
("102","pcmdivi5user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:102:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"et_support_center\";b:1;s:24:\"et_support_center_system\";b:1;s:31:\"et_support_center_remote_access\";b:1;s:31:\"et_support_center_documentation\";b:1;s:27:\"et_support_center_safe_mode\";b:1;s:22:\"et_support_center_logs\";b:1;s:20:\"manage_admin_columns\";b:1;s:21:\"Nginx Helper | Config\";b:1;s:26:\"Nginx Helper | Purge cache\";b:1;s:16:\"edit_redirection\";b:1;s:17:\"edit_redirections\";b:1;s:24:\"edit_others_redirections\";b:1;s:20:\"publish_redirections\";b:1;s:16:\"read_redirection\";b:1;s:25:\"read_private_redirections\";b:1;s:18:\"delete_redirection\";b:1;s:19:\"delete_redirections\";b:1;s:26:\"delete_others_redirections\";b:1;s:29:\"delete_published_redirections\";b:1;s:11:\"edit_schema\";b:1;s:12:\"edit_schemas\";b:1;s:19:\"edit_others_schemas\";b:1;s:15:\"publish_schemas\";b:1;s:11:\"read_schema\";b:1;s:20:\"read_private_schemas\";b:1;s:13:\"delete_schema\";b:1;s:14:\"delete_schemas\";b:1;s:21:\"delete_others_schemas\";b:1;s:24:\"delete_published_schemas\";b:1;s:25:\"seopress_manage_dashboard\";b:1;s:28:\"seopress_manage_titles_metas\";b:1;s:32:\"seopress_manage_xml_html_sitemap\";b:1;s:31:\"seopress_manage_social_networks\";b:1;s:25:\"seopress_manage_analytics\";b:1;s:24:\"seopress_manage_advanced\";b:1;s:21:\"seopress_manage_tools\";b:1;s:32:\"seopress_manage_instant_indexing\";b:1;s:19:\"seopress_manage_pro\";b:1;s:23:\"seopress_manage_schemas\";b:1;s:19:\"seopress_manage_bot\";b:1;s:23:\"seopress_manage_license\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","on"),
("103","fresh_site","1","off"),
("104","user_count","1","off"),
("105","widget_block","a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:154:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Posts</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:227:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Recent Comments</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:146:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Archives</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:150:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>Categories</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}","auto"),
("106","sidebars_widgets","a:9:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}s:9:\"sidebar-3\";a:0:{}s:9:\"sidebar-4\";a:0:{}s:9:\"sidebar-5\";a:0:{}s:9:\"sidebar-6\";a:0:{}s:9:\"sidebar-7\";a:0:{}s:13:\"array_version\";i:3;}","auto"),
("107","widget_pages","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("108","widget_calendar","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("109","widget_archives","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("110","widget_media_audio","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("111","widget_media_image","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("112","widget_media_gallery","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("113","widget_media_video","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("114","widget_meta","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("115","widget_search","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("116","widget_recent-posts","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("117","widget_recent-comments","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("118","widget_tag_cloud","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("119","widget_nav_menu","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("120","widget_custom_html","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("121","_transient_wp_core_block_css_files","a:2:{s:7:\"version\";s:5:\"6.8.1\";s:5:\"files\";a:536:{i:0;s:23:\"archives/editor-rtl.css\";i:1;s:27:\"archives/editor-rtl.min.css\";i:2;s:19:\"archives/editor.css\";i:3;s:23:\"archives/editor.min.css\";i:4;s:22:\"archives/style-rtl.css\";i:5;s:26:\"archives/style-rtl.min.css\";i:6;s:18:\"archives/style.css\";i:7;s:22:\"archives/style.min.css\";i:8;s:20:\"audio/editor-rtl.css\";i:9;s:24:\"audio/editor-rtl.min.css\";i:10;s:16:\"audio/editor.css\";i:11;s:20:\"audio/editor.min.css\";i:12;s:19:\"audio/style-rtl.css\";i:13;s:23:\"audio/style-rtl.min.css\";i:14;s:15:\"audio/style.css\";i:15;s:19:\"audio/style.min.css\";i:16;s:19:\"audio/theme-rtl.css\";i:17;s:23:\"audio/theme-rtl.min.css\";i:18;s:15:\"audio/theme.css\";i:19;s:19:\"audio/theme.min.css\";i:20;s:21:\"avatar/editor-rtl.css\";i:21;s:25:\"avatar/editor-rtl.min.css\";i:22;s:17:\"avatar/editor.css\";i:23;s:21:\"avatar/editor.min.css\";i:24;s:20:\"avatar/style-rtl.css\";i:25;s:24:\"avatar/style-rtl.min.css\";i:26;s:16:\"avatar/style.css\";i:27;s:20:\"avatar/style.min.css\";i:28;s:21:\"button/editor-rtl.css\";i:29;s:25:\"button/editor-rtl.min.css\";i:30;s:17:\"button/editor.css\";i:31;s:21:\"button/editor.min.css\";i:32;s:20:\"button/style-rtl.css\";i:33;s:24:\"button/style-rtl.min.css\";i:34;s:16:\"button/style.css\";i:35;s:20:\"button/style.min.css\";i:36;s:22:\"buttons/editor-rtl.css\";i:37;s:26:\"buttons/editor-rtl.min.css\";i:38;s:18:\"buttons/editor.css\";i:39;s:22:\"buttons/editor.min.css\";i:40;s:21:\"buttons/style-rtl.css\";i:41;s:25:\"buttons/style-rtl.min.css\";i:42;s:17:\"buttons/style.css\";i:43;s:21:\"buttons/style.min.css\";i:44;s:22:\"calendar/style-rtl.css\";i:45;s:26:\"calendar/style-rtl.min.css\";i:46;s:18:\"calendar/style.css\";i:47;s:22:\"calendar/style.min.css\";i:48;s:25:\"categories/editor-rtl.css\";i:49;s:29:\"categories/editor-rtl.min.css\";i:50;s:21:\"categories/editor.css\";i:51;s:25:\"categories/editor.min.css\";i:52;s:24:\"categories/style-rtl.css\";i:53;s:28:\"categories/style-rtl.min.css\";i:54;s:20:\"categories/style.css\";i:55;s:24:\"categories/style.min.css\";i:56;s:19:\"code/editor-rtl.css\";i:57;s:23:\"code/editor-rtl.min.css\";i:58;s:15:\"code/editor.css\";i:59;s:19:\"code/editor.min.css\";i:60;s:18:\"code/style-rtl.css\";i:61;s:22:\"code/style-rtl.min.css\";i:62;s:14:\"code/style.css\";i:63;s:18:\"code/style.min.css\";i:64;s:18:\"code/theme-rtl.css\";i:65;s:22:\"code/theme-rtl.min.css\";i:66;s:14:\"code/theme.css\";i:67;s:18:\"code/theme.min.css\";i:68;s:22:\"columns/editor-rtl.css\";i:69;s:26:\"columns/editor-rtl.min.css\";i:70;s:18:\"columns/editor.css\";i:71;s:22:\"columns/editor.min.css\";i:72;s:21:\"columns/style-rtl.css\";i:73;s:25:\"columns/style-rtl.min.css\";i:74;s:17:\"columns/style.css\";i:75;s:21:\"columns/style.min.css\";i:76;s:33:\"comment-author-name/style-rtl.css\";i:77;s:37:\"comment-author-name/style-rtl.min.css\";i:78;s:29:\"comment-author-name/style.css\";i:79;s:33:\"comment-author-name/style.min.css\";i:80;s:29:\"comment-content/style-rtl.css\";i:81;s:33:\"comment-content/style-rtl.min.css\";i:82;s:25:\"comment-content/style.css\";i:83;s:29:\"comment-content/style.min.css\";i:84;s:26:\"comment-date/style-rtl.css\";i:85;s:30:\"comment-date/style-rtl.min.css\";i:86;s:22:\"comment-date/style.css\";i:87;s:26:\"comment-date/style.min.css\";i:88;s:31:\"comment-edit-link/style-rtl.css\";i:89;s:35:\"comment-edit-link/style-rtl.min.css\";i:90;s:27:\"comment-edit-link/style.css\";i:91;s:31:\"comment-edit-link/style.min.css\";i:92;s:32:\"comment-reply-link/style-rtl.css\";i:93;s:36:\"comment-reply-link/style-rtl.min.css\";i:94;s:28:\"comment-reply-link/style.css\";i:95;s:32:\"comment-reply-link/style.min.css\";i:96;s:30:\"comment-template/style-rtl.css\";i:97;s:34:\"comment-template/style-rtl.min.css\";i:98;s:26:\"comment-template/style.css\";i:99;s:30:\"comment-template/style.min.css\";i:100;s:42:\"comments-pagination-numbers/editor-rtl.css\";i:101;s:46:\"comments-pagination-numbers/editor-rtl.min.css\";i:102;s:38:\"comments-pagination-numbers/editor.css\";i:103;s:42:\"comments-pagination-numbers/editor.min.css\";i:104;s:34:\"comments-pagination/editor-rtl.css\";i:105;s:38:\"comments-pagination/editor-rtl.min.css\";i:106;s:30:\"comments-pagination/editor.css\";i:107;s:34:\"comments-pagination/editor.min.css\";i:108;s:33:\"comments-pagination/style-rtl.css\";i:109;s:37:\"comments-pagination/style-rtl.min.css\";i:110;s:29:\"comments-pagination/style.css\";i:111;s:33:\"comments-pagination/style.min.css\";i:112;s:29:\"comments-title/editor-rtl.css\";i:113;s:33:\"comments-title/editor-rtl.min.css\";i:114;s:25:\"comments-title/editor.css\";i:115;s:29:\"comments-title/editor.min.css\";i:116;s:23:\"comments/editor-rtl.css\";i:117;s:27:\"comments/editor-rtl.min.css\";i:118;s:19:\"comments/editor.css\";i:119;s:23:\"comments/editor.min.css\";i:120;s:22:\"comments/style-rtl.css\";i:121;s:26:\"comments/style-rtl.min.css\";i:122;s:18:\"comments/style.css\";i:123;s:22:\"comments/style.min.css\";i:124;s:20:\"cover/editor-rtl.css\";i:125;s:24:\"cover/editor-rtl.min.css\";i:126;s:16:\"cover/editor.css\";i:127;s:20:\"cover/editor.min.css\";i:128;s:19:\"cover/style-rtl.css\";i:129;s:23:\"cover/style-rtl.min.css\";i:130;s:15:\"cover/style.css\";i:131;s:19:\"cover/style.min.css\";i:132;s:22:\"details/editor-rtl.css\";i:133;s:26:\"details/editor-rtl.min.css\";i:134;s:18:\"details/editor.css\";i:135;s:22:\"details/editor.min.css\";i:136;s:21:\"details/style-rtl.css\";i:137;s:25:\"details/style-rtl.min.css\";i:138;s:17:\"details/style.css\";i:139;s:21:\"details/style.min.css\";i:140;s:20:\"embed/editor-rtl.css\";i:141;s:24:\"embed/editor-rtl.min.css\";i:142;s:16:\"embed/editor.css\";i:143;s:20:\"embed/editor.min.css\";i:144;s:19:\"embed/style-rtl.css\";i:145;s:23:\"embed/style-rtl.min.css\";i:146;s:15:\"embed/style.css\";i:147;s:19:\"embed/style.min.css\";i:148;s:19:\"embed/theme-rtl.css\";i:149;s:23:\"embed/theme-rtl.min.css\";i:150;s:15:\"embed/theme.css\";i:151;s:19:\"embed/theme.min.css\";i:152;s:19:\"file/editor-rtl.css\";i:153;s:23:\"file/editor-rtl.min.css\";i:154;s:15:\"file/editor.css\";i:155;s:19:\"file/editor.min.css\";i:156;s:18:\"file/style-rtl.css\";i:157;s:22:\"file/style-rtl.min.css\";i:158;s:14:\"file/style.css\";i:159;s:18:\"file/style.min.css\";i:160;s:23:\"footnotes/style-rtl.css\";i:161;s:27:\"footnotes/style-rtl.min.css\";i:162;s:19:\"footnotes/style.css\";i:163;s:23:\"footnotes/style.min.css\";i:164;s:23:\"freeform/editor-rtl.css\";i:165;s:27:\"freeform/editor-rtl.min.css\";i:166;s:19:\"freeform/editor.css\";i:167;s:23:\"freeform/editor.min.css\";i:168;s:22:\"gallery/editor-rtl.css\";i:169;s:26:\"gallery/editor-rtl.min.css\";i:170;s:18:\"gallery/editor.css\";i:171;s:22:\"gallery/editor.min.css\";i:172;s:21:\"gallery/style-rtl.css\";i:173;s:25:\"gallery/style-rtl.min.css\";i:174;s:17:\"gallery/style.css\";i:175;s:21:\"gallery/style.min.css\";i:176;s:21:\"gallery/theme-rtl.css\";i:177;s:25:\"gallery/theme-rtl.min.css\";i:178;s:17:\"gallery/theme.css\";i:179;s:21:\"gallery/theme.min.css\";i:180;s:20:\"group/editor-rtl.css\";i:181;s:24:\"group/editor-rtl.min.css\";i:182;s:16:\"group/editor.css\";i:183;s:20:\"group/editor.min.css\";i:184;s:19:\"group/style-rtl.css\";i:185;s:23:\"group/style-rtl.min.css\";i:186;s:15:\"group/style.css\";i:187;s:19:\"group/style.min.css\";i:188;s:19:\"group/theme-rtl.css\";i:189;s:23:\"group/theme-rtl.min.css\";i:190;s:15:\"group/theme.css\";i:191;s:19:\"group/theme.min.css\";i:192;s:21:\"heading/style-rtl.css\";i:193;s:25:\"heading/style-rtl.min.css\";i:194;s:17:\"heading/style.css\";i:195;s:21:\"heading/style.min.css\";i:196;s:19:\"html/editor-rtl.css\";i:197;s:23:\"html/editor-rtl.min.css\";i:198;s:15:\"html/editor.css\";i:199;s:19:\"html/editor.min.css\";i:200;s:20:\"image/editor-rtl.css\";i:201;s:24:\"image/editor-rtl.min.css\";i:202;s:16:\"image/editor.css\";i:203;s:20:\"image/editor.min.css\";i:204;s:19:\"image/style-rtl.css\";i:205;s:23:\"image/style-rtl.min.css\";i:206;s:15:\"image/style.css\";i:207;s:19:\"image/style.min.css\";i:208;s:19:\"image/theme-rtl.css\";i:209;s:23:\"image/theme-rtl.min.css\";i:210;s:15:\"image/theme.css\";i:211;s:19:\"image/theme.min.css\";i:212;s:29:\"latest-comments/style-rtl.css\";i:213;s:33:\"latest-comments/style-rtl.min.css\";i:214;s:25:\"latest-comments/style.css\";i:215;s:29:\"latest-comments/style.min.css\";i:216;s:27:\"latest-posts/editor-rtl.css\";i:217;s:31:\"latest-posts/editor-rtl.min.css\";i:218;s:23:\"latest-posts/editor.css\";i:219;s:27:\"latest-posts/editor.min.css\";i:220;s:26:\"latest-posts/style-rtl.css\";i:221;s:30:\"latest-posts/style-rtl.min.css\";i:222;s:22:\"latest-posts/style.css\";i:223;s:26:\"latest-posts/style.min.css\";i:224;s:18:\"list/style-rtl.css\";i:225;s:22:\"list/style-rtl.min.css\";i:226;s:14:\"list/style.css\";i:227;s:18:\"list/style.min.css\";i:228;s:22:\"loginout/style-rtl.css\";i:229;s:26:\"loginout/style-rtl.min.css\";i:230;s:18:\"loginout/style.css\";i:231;s:22:\"loginout/style.min.css\";i:232;s:25:\"media-text/editor-rtl.css\";i:233;s:29:\"media-text/editor-rtl.min.css\";i:234;s:21:\"media-text/editor.css\";i:235;s:25:\"media-text/editor.min.css\";i:236;s:24:\"media-text/style-rtl.css\";i:237;s:28:\"media-text/style-rtl.min.css\";i:238;s:20:\"media-text/style.css\";i:239;s:24:\"media-text/style.min.css\";i:240;s:19:\"more/editor-rtl.css\";i:241;s:23:\"more/editor-rtl.min.css\";i:242;s:15:\"more/editor.css\";i:243;s:19:\"more/editor.min.css\";i:244;s:30:\"navigation-link/editor-rtl.css\";i:245;s:34:\"navigation-link/editor-rtl.min.css\";i:246;s:26:\"navigation-link/editor.css\";i:247;s:30:\"navigation-link/editor.min.css\";i:248;s:29:\"navigation-link/style-rtl.css\";i:249;s:33:\"navigation-link/style-rtl.min.css\";i:250;s:25:\"navigation-link/style.css\";i:251;s:29:\"navigation-link/style.min.css\";i:252;s:33:\"navigation-submenu/editor-rtl.css\";i:253;s:37:\"navigation-submenu/editor-rtl.min.css\";i:254;s:29:\"navigation-submenu/editor.css\";i:255;s:33:\"navigation-submenu/editor.min.css\";i:256;s:25:\"navigation/editor-rtl.css\";i:257;s:29:\"navigation/editor-rtl.min.css\";i:258;s:21:\"navigation/editor.css\";i:259;s:25:\"navigation/editor.min.css\";i:260;s:24:\"navigation/style-rtl.css\";i:261;s:28:\"navigation/style-rtl.min.css\";i:262;s:20:\"navigation/style.css\";i:263;s:24:\"navigation/style.min.css\";i:264;s:23:\"nextpage/editor-rtl.css\";i:265;s:27:\"nextpage/editor-rtl.min.css\";i:266;s:19:\"nextpage/editor.css\";i:267;s:23:\"nextpage/editor.min.css\";i:268;s:24:\"page-list/editor-rtl.css\";i:269;s:28:\"page-list/editor-rtl.min.css\";i:270;s:20:\"page-list/editor.css\";i:271;s:24:\"page-list/editor.min.css\";i:272;s:23:\"page-list/style-rtl.css\";i:273;s:27:\"page-list/style-rtl.min.css\";i:274;s:19:\"page-list/style.css\";i:275;s:23:\"page-list/style.min.css\";i:276;s:24:\"paragraph/editor-rtl.css\";i:277;s:28:\"paragraph/editor-rtl.min.css\";i:278;s:20:\"paragraph/editor.css\";i:279;s:24:\"paragraph/editor.min.css\";i:280;s:23:\"paragraph/style-rtl.css\";i:281;s:27:\"paragraph/style-rtl.min.css\";i:282;s:19:\"paragraph/style.css\";i:283;s:23:\"paragraph/style.min.css\";i:284;s:35:\"post-author-biography/style-rtl.css\";i:285;s:39:\"post-author-biography/style-rtl.min.css\";i:286;s:31:\"post-author-biography/style.css\";i:287;s:35:\"post-author-biography/style.min.css\";i:288;s:30:\"post-author-name/style-rtl.css\";i:289;s:34:\"post-author-name/style-rtl.min.css\";i:290;s:26:\"post-author-name/style.css\";i:291;s:30:\"post-author-name/style.min.css\";i:292;s:26:\"post-author/editor-rtl.css\";i:293;s:30:\"post-author/editor-rtl.min.css\";i:294;s:22:\"post-author/editor.css\";i:295;s:26:\"post-author/editor.min.css\";i:296;s:25:\"post-author/style-rtl.css\";i:297;s:29:\"post-author/style-rtl.min.css\";i:298;s:21:\"post-author/style.css\";i:299;s:25:\"post-author/style.min.css\";i:300;s:33:\"post-comments-form/editor-rtl.css\";i:301;s:37:\"post-comments-form/editor-rtl.min.css\";i:302;s:29:\"post-comments-form/editor.css\";i:303;s:33:\"post-comments-form/editor.min.css\";i:304;s:32:\"post-comments-form/style-rtl.css\";i:305;s:36:\"post-comments-form/style-rtl.min.css\";i:306;s:28:\"post-comments-form/style.css\";i:307;s:32:\"post-comments-form/style.min.css\";i:308;s:26:\"post-content/style-rtl.css\";i:309;s:30:\"post-content/style-rtl.min.css\";i:310;s:22:\"post-content/style.css\";i:311;s:26:\"post-content/style.min.css\";i:312;s:23:\"post-date/style-rtl.css\";i:313;s:27:\"post-date/style-rtl.min.css\";i:314;s:19:\"post-date/style.css\";i:315;s:23:\"post-date/style.min.css\";i:316;s:27:\"post-excerpt/editor-rtl.css\";i:317;s:31:\"post-excerpt/editor-rtl.min.css\";i:318;s:23:\"post-excerpt/editor.css\";i:319;s:27:\"post-excerpt/editor.min.css\";i:320;s:26:\"post-excerpt/style-rtl.css\";i:321;s:30:\"post-excerpt/style-rtl.min.css\";i:322;s:22:\"post-excerpt/style.css\";i:323;s:26:\"post-excerpt/style.min.css\";i:324;s:34:\"post-featured-image/editor-rtl.css\";i:325;s:38:\"post-featured-image/editor-rtl.min.css\";i:326;s:30:\"post-featured-image/editor.css\";i:327;s:34:\"post-featured-image/editor.min.css\";i:328;s:33:\"post-featured-image/style-rtl.css\";i:329;s:37:\"post-featured-image/style-rtl.min.css\";i:330;s:29:\"post-featured-image/style.css\";i:331;s:33:\"post-featured-image/style.min.css\";i:332;s:34:\"post-navigation-link/style-rtl.css\";i:333;s:38:\"post-navigation-link/style-rtl.min.css\";i:334;s:30:\"post-navigation-link/style.css\";i:335;s:34:\"post-navigation-link/style.min.css\";i:336;s:27:\"post-template/style-rtl.css\";i:337;s:31:\"post-template/style-rtl.min.css\";i:338;s:23:\"post-template/style.css\";i:339;s:27:\"post-template/style.min.css\";i:340;s:24:\"post-terms/style-rtl.css\";i:341;s:28:\"post-terms/style-rtl.min.css\";i:342;s:20:\"post-terms/style.css\";i:343;s:24:\"post-terms/style.min.css\";i:344;s:24:\"post-title/style-rtl.css\";i:345;s:28:\"post-title/style-rtl.min.css\";i:346;s:20:\"post-title/style.css\";i:347;s:24:\"post-title/style.min.css\";i:348;s:26:\"preformatted/style-rtl.css\";i:349;s:30:\"preformatted/style-rtl.min.css\";i:350;s:22:\"preformatted/style.css\";i:351;s:26:\"preformatted/style.min.css\";i:352;s:24:\"pullquote/editor-rtl.css\";i:353;s:28:\"pullquote/editor-rtl.min.css\";i:354;s:20:\"pullquote/editor.css\";i:355;s:24:\"pullquote/editor.min.css\";i:356;s:23:\"pullquote/style-rtl.css\";i:357;s:27:\"pullquote/style-rtl.min.css\";i:358;s:19:\"pullquote/style.css\";i:359;s:23:\"pullquote/style.min.css\";i:360;s:23:\"pullquote/theme-rtl.css\";i:361;s:27:\"pullquote/theme-rtl.min.css\";i:362;s:19:\"pullquote/theme.css\";i:363;s:23:\"pullquote/theme.min.css\";i:364;s:39:\"query-pagination-numbers/editor-rtl.css\";i:365;s:43:\"query-pagination-numbers/editor-rtl.min.css\";i:366;s:35:\"query-pagination-numbers/editor.css\";i:367;s:39:\"query-pagination-numbers/editor.min.css\";i:368;s:31:\"query-pagination/editor-rtl.css\";i:369;s:35:\"query-pagination/editor-rtl.min.css\";i:370;s:27:\"query-pagination/editor.css\";i:371;s:31:\"query-pagination/editor.min.css\";i:372;s:30:\"query-pagination/style-rtl.css\";i:373;s:34:\"query-pagination/style-rtl.min.css\";i:374;s:26:\"query-pagination/style.css\";i:375;s:30:\"query-pagination/style.min.css\";i:376;s:25:\"query-title/style-rtl.css\";i:377;s:29:\"query-title/style-rtl.min.css\";i:378;s:21:\"query-title/style.css\";i:379;s:25:\"query-title/style.min.css\";i:380;s:25:\"query-total/style-rtl.css\";i:381;s:29:\"query-total/style-rtl.min.css\";i:382;s:21:\"query-total/style.css\";i:383;s:25:\"query-total/style.min.css\";i:384;s:20:\"query/editor-rtl.css\";i:385;s:24:\"query/editor-rtl.min.css\";i:386;s:16:\"query/editor.css\";i:387;s:20:\"query/editor.min.css\";i:388;s:19:\"quote/style-rtl.css\";i:389;s:23:\"quote/style-rtl.min.css\";i:390;s:15:\"quote/style.css\";i:391;s:19:\"quote/style.min.css\";i:392;s:19:\"quote/theme-rtl.css\";i:393;s:23:\"quote/theme-rtl.min.css\";i:394;s:15:\"quote/theme.css\";i:395;s:19:\"quote/theme.min.css\";i:396;s:23:\"read-more/style-rtl.css\";i:397;s:27:\"read-more/style-rtl.min.css\";i:398;s:19:\"read-more/style.css\";i:399;s:23:\"read-more/style.min.css\";i:400;s:18:\"rss/editor-rtl.css\";i:401;s:22:\"rss/editor-rtl.min.css\";i:402;s:14:\"rss/editor.css\";i:403;s:18:\"rss/editor.min.css\";i:404;s:17:\"rss/style-rtl.css\";i:405;s:21:\"rss/style-rtl.min.css\";i:406;s:13:\"rss/style.css\";i:407;s:17:\"rss/style.min.css\";i:408;s:21:\"search/editor-rtl.css\";i:409;s:25:\"search/editor-rtl.min.css\";i:410;s:17:\"search/editor.css\";i:411;s:21:\"search/editor.min.css\";i:412;s:20:\"search/style-rtl.css\";i:413;s:24:\"search/style-rtl.min.css\";i:414;s:16:\"search/style.css\";i:415;s:20:\"search/style.min.css\";i:416;s:20:\"search/theme-rtl.css\";i:417;s:24:\"search/theme-rtl.min.css\";i:418;s:16:\"search/theme.css\";i:419;s:20:\"search/theme.min.css\";i:420;s:24:\"separator/editor-rtl.css\";i:421;s:28:\"separator/editor-rtl.min.css\";i:422;s:20:\"separator/editor.css\";i:423;s:24:\"separator/editor.min.css\";i:424;s:23:\"separator/style-rtl.css\";i:425;s:27:\"separator/style-rtl.min.css\";i:426;s:19:\"separator/style.css\";i:427;s:23:\"separator/style.min.css\";i:428;s:23:\"separator/theme-rtl.css\";i:429;s:27:\"separator/theme-rtl.min.css\";i:430;s:19:\"separator/theme.css\";i:431;s:23:\"separator/theme.min.css\";i:432;s:24:\"shortcode/editor-rtl.css\";i:433;s:28:\"shortcode/editor-rtl.min.css\";i:434;s:20:\"shortcode/editor.css\";i:435;s:24:\"shortcode/editor.min.css\";i:436;s:24:\"site-logo/editor-rtl.css\";i:437;s:28:\"site-logo/editor-rtl.min.css\";i:438;s:20:\"site-logo/editor.css\";i:439;s:24:\"site-logo/editor.min.css\";i:440;s:23:\"site-logo/style-rtl.css\";i:441;s:27:\"site-logo/style-rtl.min.css\";i:442;s:19:\"site-logo/style.css\";i:443;s:23:\"site-logo/style.min.css\";i:444;s:27:\"site-tagline/editor-rtl.css\";i:445;s:31:\"site-tagline/editor-rtl.min.css\";i:446;s:23:\"site-tagline/editor.css\";i:447;s:27:\"site-tagline/editor.min.css\";i:448;s:26:\"site-tagline/style-rtl.css\";i:449;s:30:\"site-tagline/style-rtl.min.css\";i:450;s:22:\"site-tagline/style.css\";i:451;s:26:\"site-tagline/style.min.css\";i:452;s:25:\"site-title/editor-rtl.css\";i:453;s:29:\"site-title/editor-rtl.min.css\";i:454;s:21:\"site-title/editor.css\";i:455;s:25:\"site-title/editor.min.css\";i:456;s:24:\"site-title/style-rtl.css\";i:457;s:28:\"site-title/style-rtl.min.css\";i:458;s:20:\"site-title/style.css\";i:459;s:24:\"site-title/style.min.css\";i:460;s:26:\"social-link/editor-rtl.css\";i:461;s:30:\"social-link/editor-rtl.min.css\";i:462;s:22:\"social-link/editor.css\";i:463;s:26:\"social-link/editor.min.css\";i:464;s:27:\"social-links/editor-rtl.css\";i:465;s:31:\"social-links/editor-rtl.min.css\";i:466;s:23:\"social-links/editor.css\";i:467;s:27:\"social-links/editor.min.css\";i:468;s:26:\"social-links/style-rtl.css\";i:469;s:30:\"social-links/style-rtl.min.css\";i:470;s:22:\"social-links/style.css\";i:471;s:26:\"social-links/style.min.css\";i:472;s:21:\"spacer/editor-rtl.css\";i:473;s:25:\"spacer/editor-rtl.min.css\";i:474;s:17:\"spacer/editor.css\";i:475;s:21:\"spacer/editor.min.css\";i:476;s:20:\"spacer/style-rtl.css\";i:477;s:24:\"spacer/style-rtl.min.css\";i:478;s:16:\"spacer/style.css\";i:479;s:20:\"spacer/style.min.css\";i:480;s:20:\"table/editor-rtl.css\";i:481;s:24:\"table/editor-rtl.min.css\";i:482;s:16:\"table/editor.css\";i:483;s:20:\"table/editor.min.css\";i:484;s:19:\"table/style-rtl.css\";i:485;s:23:\"table/style-rtl.min.css\";i:486;s:15:\"table/style.css\";i:487;s:19:\"table/style.min.css\";i:488;s:19:\"table/theme-rtl.css\";i:489;s:23:\"table/theme-rtl.min.css\";i:490;s:15:\"table/theme.css\";i:491;s:19:\"table/theme.min.css\";i:492;s:24:\"tag-cloud/editor-rtl.css\";i:493;s:28:\"tag-cloud/editor-rtl.min.css\";i:494;s:20:\"tag-cloud/editor.css\";i:495;s:24:\"tag-cloud/editor.min.css\";i:496;s:23:\"tag-cloud/style-rtl.css\";i:497;s:27:\"tag-cloud/style-rtl.min.css\";i:498;s:19:\"tag-cloud/style.css\";i:499;s:23:\"tag-cloud/style.min.css\";i:500;s:28:\"template-part/editor-rtl.css\";i:501;s:32:\"template-part/editor-rtl.min.css\";i:502;s:24:\"template-part/editor.css\";i:503;s:28:\"template-part/editor.min.css\";i:504;s:27:\"template-part/theme-rtl.css\";i:505;s:31:\"template-part/theme-rtl.min.css\";i:506;s:23:\"template-part/theme.css\";i:507;s:27:\"template-part/theme.min.css\";i:508;s:30:\"term-description/style-rtl.css\";i:509;s:34:\"term-description/style-rtl.min.css\";i:510;s:26:\"term-description/style.css\";i:511;s:30:\"term-description/style.min.css\";i:512;s:27:\"text-columns/editor-rtl.css\";i:513;s:31:\"text-columns/editor-rtl.min.css\";i:514;s:23:\"text-columns/editor.css\";i:515;s:27:\"text-columns/editor.min.css\";i:516;s:26:\"text-columns/style-rtl.css\";i:517;s:30:\"text-columns/style-rtl.min.css\";i:518;s:22:\"text-columns/style.css\";i:519;s:26:\"text-columns/style.min.css\";i:520;s:19:\"verse/style-rtl.css\";i:521;s:23:\"verse/style-rtl.min.css\";i:522;s:15:\"verse/style.css\";i:523;s:19:\"verse/style.min.css\";i:524;s:20:\"video/editor-rtl.css\";i:525;s:24:\"video/editor-rtl.min.css\";i:526;s:16:\"video/editor.css\";i:527;s:20:\"video/editor.min.css\";i:528;s:19:\"video/style-rtl.css\";i:529;s:23:\"video/style-rtl.min.css\";i:530;s:15:\"video/style.css\";i:531;s:19:\"video/style.min.css\";i:532;s:19:\"video/theme-rtl.css\";i:533;s:23:\"video/theme-rtl.min.css\";i:534;s:15:\"video/theme.css\";i:535;s:19:\"video/theme.min.css\";}}","on"),
("125","nonce_key","B;tr`z*+8Qn@_.|Mf~V#<iituyhd@$e|Z $EYt+PK<=58(J~vY>77zfj5F4kB1T3","off"),
("126","nonce_salt","S4Z!$lA7PtQ)B t.Ch0._VR`N>Gv_lLS^{rT2CyEzF>j)5hB;@A02mE 3GEQOFmG","off"),
("127","theme_mods_twentytwentyfive","a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1747674905;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}","off"),
("128","_transient_wp_styles_for_blocks","a:2:{s:4:\"hash\";s:32:\"cbea2fc575bfcde232609e267b441ae0\";s:6:\"blocks\";a:3:{s:11:\"core/button\";s:0:\"\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}","on"),
("129","recovery_keys","a:0:{}","off"),
("155","finished_updating_comment_type","1","auto"),
("168","current_theme","Divi","auto"),
("169","theme_mods_Divi","a:5:{i:0;b:0;s:18:\"custom_css_post_id\";i:-1;s:16:\"et_pb_css_synced\";s:3:\"yes\";s:18:\"nav_menu_locations\";a:0:{}s:39:\"et_updated_layouts_built_for_post_types\";s:3:\"yes\";}","on"),
("170","theme_switched","","auto"),
("171","et_pb_cache_notice","a:1:{s:23:\"5.0.0-public-alpha.14.1\";s:6:\"ignore\";}","auto"),
("176","et_core_version","5.0.0-public-alpha.14.1","auto"),
("178","et_divi","a:19:{s:39:\"static_css_custom_css_safety_check_done\";b:1;s:29:\"presets_storage_migrated_flag\";b:1;s:39:\"builder_global_presets_history_migrated\";b:1;s:29:\"custom_defaults_migrated_flag\";b:1;s:31:\"all_third_party_shortcode_slugs\";a:0:{}s:23:\"2_5_flush_rewrite_rules\";s:4:\"done\";s:31:\"divi_previous_installed_version\";s:0:\"\";s:29:\"divi_latest_installed_version\";s:23:\"5.0.0-public-alpha.14.1\";s:30:\"et_flush_rewrite_rules_library\";s:23:\"5.0.0-public-alpha.14.1\";s:27:\"divi_skip_font_subset_force\";b:1;s:27:\"et_pb_clear_templates_cache\";b:1;s:23:\"builder_custom_defaults\";O:8:\"stdClass\":0:{}s:33:\"customizer_settings_migrated_flag\";b:1;s:34:\"builder_custom_defaults_unmigrated\";b:0;s:15:\"divi_1_3_images\";s:7:\"checked\";s:21:\"et_pb_layouts_updated\";b:1;s:30:\"library_removed_legacy_layouts\";b:1;s:30:\"divi_2_4_documentation_message\";s:9:\"triggered\";s:14:\"et_global_data\";s:33:\"a:1:{s:13:\"global_colors\";a:0:{}}\";}","auto"),
("179","et_divi_builder_presets_history_meta","a:2:{s:5:\"index\";i:-1;s:4:\"size\";i:0;}","off"),
("180","et_divi_builder_global_presets_ng","O:8:\"stdClass\":0:{}","off"),
("181","widget_aboutmewidget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("182","widget_adsensewidget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("183","widget_advwidget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("184","shop_catalog_image_size","a:3:{s:5:\"width\";s:3:\"400\";s:6:\"height\";s:3:\"400\";s:4:\"crop\";i:1;}","auto"),
("185","shop_single_image_size","a:3:{s:5:\"width\";s:3:\"510\";s:6:\"height\";s:4:\"9999\";s:4:\"crop\";i:0;}","auto"),
("186","shop_thumbnail_image_size","a:3:{s:5:\"width\";s:3:\"157\";s:6:\"height\";s:3:\"157\";s:4:\"crop\";i:1;}","auto"),
("189","et_safe_mode_plugins_allowlist","a:9:{i:0;s:15:\"etdev/etdev.php\";i:1;s:15:\"bloom/bloom.php\";i:2;s:19:\"monarch/monarch.php\";i:3;s:29:\"divi-builder/divi-builder.php\";i:4;s:23:\"divi-dash/divi-dash.php\";i:5;s:27:\"ari-adminer/ari-adminer.php\";i:6;s:31:\"query-monitor/query-monitor.php\";i:7;s:27:\"woocommerce/woocommerce.php\";i:8;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";}","auto"),
("190","et_support_center_installed","true","auto"),
("191","et_images_temp_folder","/home/builtbypearlcity/divi5.builtbypearlcitymedia.com/wp-content/uploads/et_temp","auto"),
("192","et_schedule_clean_images_last_time","1761040023","auto"),
("195","et_bfb_settings","a:2:{s:10:\"enable_bfb\";s:2:\"on\";s:10:\"toggle_bfb\";s:2:\"on\";}","auto"),
("196","_transient_et_builder_show_bfb_welcome_modal","1","on"),
("197","et_support_center_setup_done","processed","auto"),
("200","et_automatic_updates_options","a:2:{s:8:\"username\";s:11:\"candersonnm\";s:7:\"api_key\";s:40:\"908be2aa5ba2e10a5e4875c1e944f109d811c6b6\";}","off"),
("203","et_support_site_id","(TojR!*XGSabDz+sUF=n","auto"),
("206","_site_transient_wp_plugin_dependencies_plugin_data","a:0:{}","off"),
("210","et_account_status","active","off"),
("211","_site_transient_et_update_plugins","O:8:\"stdClass\":3:{s:7:\"checked\";a:40:{s:45:\"aaa-option-optimizer/aaa-option-optimizer.php\";s:5:\"1.5.0\";s:39:\"admin-columns-pro/admin-columns-pro.php\";s:6:\"6.4.21\";s:33:\"admin-menu-editor/menu-editor.php\";s:4:\"1.14\";s:57:\"acf-custom-database-tables/acf-custom-database-tables.php\";s:5:\"1.1.4\";s:33:\"acf-extended-pro/acf-extended.php\";s:7:\"0.9.1.1\";s:53:\"advanced-database-cleaner-pro/advanced-db-cleaner.php\";s:5:\"3.2.9\";s:19:\"alttext-ai/atai.php\";s:6:\"1.10.5\";s:39:\"ultimate-branding/ultimate-branding.php\";s:6:\"3.4.24\";s:43:\"broken-link-checker/broken-link-checker.php\";s:5:\"2.4.6\";s:25:\"cloudflare/cloudflare.php\";s:6:\"4.12.8\";s:27:\"wp-defender/wp-defender.php\";s:5:\"5.4.1\";s:29:\"gravityforms/gravityforms.php\";s:6:\"2.9.20\";s:57:\"gravityformsadvancedpostcreation/advancedpostcreation.php\";s:5:\"1.5.0\";s:45:\"gravityformschainedselects/chainedselects.php\";s:5:\"1.8.0\";s:19:\"imagify/imagify.php\";s:5:\"2.2.6\";s:29:\"nginx-helper/nginx-helper.php\";s:5:\"2.3.5\";s:51:\"onesignal-free-web-push-notifications/onesignal.php\";s:5:\"3.2.1\";s:31:\"query-monitor/query-monitor.php\";s:6:\"3.19.0\";s:27:\"redis-cache/redis-cache.php\";s:5:\"2.6.5\";s:47:\"regenerate-thumbnails/regenerate-thumbnails.php\";s:5:\"3.1.6\";s:29:\"wordpress-main/renderform.php\";s:5:\"1.0.1\";s:57:\"reveal-ids-for-wp-admin-25/reveal-ids-for-wp-admin-25.php\";s:5:\"1.6.1\";s:24:\"wp-seopress/seopress.php\";s:5:\"9.0.1\";s:32:\"wp-seopress-pro/seopress-pro.php\";s:5:\"9.0.1\";s:35:\"google-site-kit/google-site-kit.php\";s:7:\"1.160.0\";s:37:\"snapshot-backups/snapshot-backups.php\";s:6:\"4.35.1\";s:43:\"the-events-calendar/the-events-calendar.php\";s:8:\"6.15.0.1\";s:31:\"tec-labs-wpai-add-on/plugin.php\";s:5:\"1.1.0\";s:33:\"translatepress-business/index.php\";s:5:\"1.3.7\";s:37:\"translatepress-multilingual/index.php\";s:6:\"2.10.1\";s:39:\"wpae-acf-add-on/wpae-acf-add-on-pro.php\";s:5:\"1.0.5\";s:45:\"wpae-user-add-on-pro/wpae-user-add-on-pro.php\";s:5:\"1.0.7\";s:39:\"wp-all-export-pro/wp-all-export-pro.php\";s:5:\"1.8.3\";s:35:\"wpai-acf-add-on/wpai-acf-add-on.php\";s:5:\"3.3.8\";s:37:\"wpai-user-add-on/wpai-user-add-on.php\";s:5:\"1.1.8\";s:39:\"wp-all-import-pro/wp-all-import-pro.php\";s:5:\"4.8.0\";s:27:\"wp-crontrol/wp-crontrol.php\";s:6:\"1.19.2\";s:40:\"wpmudev-updates/update-notifications.php\";s:7:\"4.11.29\";s:23:\"wp-rocket/wp-rocket.php\";s:8:\"3.17.3.1\";s:23:\"zoho-flow/zoho-flow.php\";s:6:\"2.14.1\";}s:8:\"response\";a:0:{}s:12:\"last_checked\";i:1761079049;}","off"),
("212","_site_transient_et_update_themes","O:8:\"stdClass\":3:{s:7:\"checked\";a:4:{s:4:\"Divi\";s:23:\"5.0.0-public-alpha.14.1\";s:16:\"twentytwentyfive\";s:3:\"1.2\";s:16:\"twentytwentyfour\";s:3:\"1.3\";s:17:\"twentytwentythree\";s:3:\"1.6\";}s:8:\"response\";a:1:{s:4:\"Divi\";a:4:{s:11:\"new_version\";s:17:\"5.0.0-public-beta\";s:5:\"theme\";s:4:\"Divi\";s:3:\"url\";s:54:\"https://www.elegantthemes.com/api/changelog/divi-5.txt\";s:7:\"package\";s:147:\"https://www.elegantthemes.com/api/api_downloads.php?api_update=1&theme=Divi_5&api_key=908be2aa5ba2e10a5e4875c1e944f109d811c6b6&username=candersonnm\";}}s:12:\"last_checked\";i:1761079049;}","off"),
("218","recently_activated","a:0:{}","off"),
("219","_acp_access_permissions","a:2:{i:0;s:5:\"usage\";i:1;s:6:\"update\";}","off"),
("224","ac_version","4.7.18","off"),
("225","acp_version","6.4.23","off"),
("226","_ac_colors_colors","a:8:{s:7:\"success\";s:7:\"#00a32a\";s:7:\"warning\";s:7:\"#dba617\";s:5:\"error\";s:7:\"#d63638\";s:4:\"info\";s:7:\"#72aee6\";s:11:\"success-alt\";s:7:\"#edfaef\";s:11:\"warning-alt\";s:7:\"#fcf9e8\";s:9:\"error-alt\";s:7:\"#fcf0f1\";s:8:\"info-alt\";s:7:\"#f0f6fc\";}","off"),
("227","_ac_colors_shipped_colors_version","6.8.2","off"),
("228","acp_periodic_update_plugins_check_hourly","1761082647","off"),
("229","acp_update_plugins_data","a:1:{s:17:\"admin-columns-pro\";a:9:{s:2:\"id\";i:0;s:4:\"slug\";s:17:\"admin-columns-pro\";s:11:\"new_version\";s:6:\"6.4.23\";s:12:\"requires_php\";s:3:\"7.2\";s:5:\"icons\";a:1:{s:3:\"svg\";s:78:\"https://www.admincolumns.com/wp-content/plugins/acp-api/assets/images/icon.svg\";}s:3:\"url\";s:28:\"https://www.admincolumns.com\";s:7:\"package\";s:142:\"https://api.admincolumns.com?command=download&product_key=admin-columns-pro&activation_key=7b92d7b5-25b2-40ad-8c9b-3190dc317e0b&version=6.4.23\";s:6:\"tested\";s:5:\"6.8.3\";s:8:\"requires\";s:3:\"5.9\";}}","off"),
("230","_transient_et_updated_plugins_data","O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1761079049;}","on"),
("231","acp_periodic_update_plugins_check","1761122245","off"),
("232","ac-deprecated-message-count_timestamp","1748280470","off"),
("233","ac-deprecated-message-count","0","off"),
("234","acp_activation_key","7b92d7b5-25b2-40ad-8c9b-3190dc317e0b","off"),
("235","acp_subscription_details","a:4:{s:6:\"status\";s:6:\"active\";s:14:\"renewal_method\";s:4:\"auto\";s:11:\"expiry_date\";i:1779204313;s:8:\"products\";a:12:{i:0;s:17:\"admin-columns-pro\";i:1;s:12:\"ac-addon-acf\";i:2;s:19:\"ac-addon-buddypress\";i:3;s:24:\"ac-addon-events-calendar\";i:4;s:21:\"ac-addon-gravityforms\";i:5;s:19:\"ac-addon-ninjaforms\";i:6;s:18:\"ac-addon-jetengine\";i:7;s:16:\"ac-addon-metabox\";i:8;s:13:\"ac-addon-pods\";i:9;s:14:\"ac-addon-types\";i:10;s:20:\"ac-addon-woocommerce\";i:11;s:18:\"ac-addon-yoast-seo\";}}","off"),
("236","acp_subscription_details_key","7b92d7b5-25b2-40ad-8c9b-3190dc317e0b","off"),
("238","acp_periodic_license_check","1761165444","off"),
("250","zoho_flow_next_suggestion_date_wordpress-org_1","O:8:\"DateTime\":3:{s:4:\"date\";s:26:\"2026-05-19 17:31:18.290878\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}","auto"),
("293","acf_first_activated_version","6.4.1","on"),
("294","acf_site_health","{\"version\":\"6.5.0.1\",\"plugin_type\":\"PRO\",\"update_source\":\"ACF Direct\",\"activated\":true,\"activated_url\":\"https:\\/\\/divi5.builtbypearlcitymedia.com\",\"license_type\":\"Freelancer\",\"license_status\":\"active\",\"subscription_expires\":1779212007,\"wp_version\":\"6.8.2\",\"mysql_version\":\"10.6.23-MariaDB-log\",\"is_multisite\":false,\"active_theme\":{\"name\":\"Divi\",\"version\":\"5.0.0-public-alpha.14.1\",\"theme_uri\":\"http:\\/\\/www.elegantthemes.com\\/gallery\\/divi\\/\",\"stylesheet\":false},\"active_plugins\":{\"admin-columns-pro\\/admin-columns-pro.php\":{\"name\":\"Admin Columns Pro\",\"version\":\"6.4.21\",\"plugin_uri\":\"https:\\/\\/www.admincolumns.com\"},\"admin-menu-editor\\/menu-editor.php\":{\"name\":\"Admin Menu Editor\",\"version\":\"1.14\",\"plugin_uri\":\"http:\\/\\/w-shadow.com\\/blog\\/2008\\/12\\/20\\/admin-menu-editor-for-wordpress\\/\"},\"acf-custom-database-tables\\/acf-custom-database-tables.php\":{\"name\":\"Advanced Custom Fields: Custom Database Tables\",\"version\":\"1.1.4\",\"plugin_uri\":\"https:\\/\\/www.hookturn.io\\/downloads\\/acf-custom-database-tables\"},\"acf-extended-pro\\/acf-extended.php\":{\"name\":\"Advanced Custom Fields: Extended PRO\",\"version\":\"0.9.1.1\",\"plugin_uri\":\"https:\\/\\/www.acf-extended.com\"},\"advanced-custom-fields-pro\\/acf.php\":{\"name\":\"Advanced Custom Fields PRO\",\"version\":\"6.5.0.1\",\"plugin_uri\":\"https:\\/\\/www.advancedcustomfields.com\"},\"alttext-ai\\/atai.php\":{\"name\":\"AltText.ai\",\"version\":\"1.10.5\",\"plugin_uri\":\"https:\\/\\/alttext.ai\\/product\"},\"ultimate-branding\\/ultimate-branding.php\":{\"name\":\"Branda Pro\",\"version\":\"3.4.24\",\"plugin_uri\":\"https:\\/\\/wpmudev.com\\/project\\/ultimate-branding\\/\"},\"broken-link-checker\\/broken-link-checker.php\":{\"name\":\"Broken Link Checker\",\"version\":\"2.4.6\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/broken-link-checker\\/\"},\"cloudflare\\/cloudflare.php\":{\"name\":\"Cloudflare\",\"version\":\"4.12.8\",\"plugin_uri\":\"https:\\/\\/blog.cloudflare.com\\/new-wordpress-plugin\\/\"},\"wp-defender\\/wp-defender.php\":{\"name\":\"Defender Pro\",\"version\":\"5.4.1\",\"plugin_uri\":\"https:\\/\\/wpmudev.com\\/project\\/wp-defender\\/\"},\"divi-assistant\\/divi-assistant.php\":{\"name\":\"Divi Assistant\",\"version\":\"1.1.2\",\"plugin_uri\":\"https:\\/\\/www.peeayecreative.com\\/product\\/divi-assistant\\/\"},\"duplicator-pro\\/duplicator-pro.php\":{\"name\":\"Duplicator Pro\",\"version\":\"4.5.5.1\",\"plugin_uri\":\"http:\\/\\/snapcreek.com\\/\"},\"gravityforms\\/gravityforms.php\":{\"name\":\"Gravity Forms\",\"version\":\"2.9.20\",\"plugin_uri\":\"https:\\/\\/gravityforms.com\"},\"gravityformsadvancedpostcreation\\/advancedpostcreation.php\":{\"name\":\"Gravity Forms Advanced Post Creation Add-On\",\"version\":\"1.5.0\",\"plugin_uri\":\"https:\\/\\/gravityforms.com\"},\"gravityformschainedselects\\/chainedselects.php\":{\"name\":\"Gravity Forms Chained Selects Add-On\",\"version\":\"1.8.0\",\"plugin_uri\":\"https:\\/\\/gravityforms.com\"},\"imagify\\/imagify.php\":{\"name\":\"Imagify\",\"version\":\"2.2.6\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/imagify\\/\"},\"nginx-helper\\/nginx-helper.php\":{\"name\":\"Nginx Helper\",\"version\":\"2.3.5\",\"plugin_uri\":\"https:\\/\\/rtcamp.com\\/nginx-helper\\/\"},\"onesignal-free-web-push-notifications\\/onesignal.php\":{\"name\":\"OneSignal Push Notifications\",\"version\":\"3.2.1\",\"plugin_uri\":\"https:\\/\\/onesignal.com\\/\"},\"query-monitor\\/query-monitor.php\":{\"name\":\"Query Monitor\",\"version\":\"3.19.0\",\"plugin_uri\":\"https:\\/\\/querymonitor.com\\/\"},\"redis-cache\\/redis-cache.php\":{\"name\":\"Redis Object Cache\",\"version\":\"2.6.5\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/redis-cache\\/\"},\"regenerate-thumbnails\\/regenerate-thumbnails.php\":{\"name\":\"Regenerate Thumbnails\",\"version\":\"3.1.6\",\"plugin_uri\":\"https:\\/\\/alex.blog\\/wordpress-plugins\\/regenerate-thumbnails\\/\"},\"wordpress-main\\/renderform.php\":{\"name\":\"RenderForm.io\",\"version\":\"1.0.1\",\"plugin_uri\":\"https:\\/\\/renderform.io\"},\"reveal-ids-for-wp-admin-25\\/reveal-ids-for-wp-admin-25.php\":{\"name\":\"Reveal IDs\",\"version\":\"1.6.1\",\"plugin_uri\":\"https:\\/\\/www.schloebe.de\\/wordpress\\/reveal-ids-for-wp-admin-25-plugin\\/\"},\"wp-seopress\\/seopress.php\":{\"name\":\"SEOPress\",\"version\":\"9.0.1\",\"plugin_uri\":\"https:\\/\\/www.seopress.org\\/\"},\"wp-seopress-pro\\/seopress-pro.php\":{\"name\":\"SEOPress PRO\",\"version\":\"9.0.1\",\"plugin_uri\":\"https:\\/\\/www.seopress.org\\/wordpress-seo-plugins\\/pro\\/\"},\"snapshot-backups\\/snapshot-backups.php\":{\"name\":\"Snapshot Pro\",\"version\":\"4.35.1\",\"plugin_uri\":\"https:\\/\\/wpmudev.com\\/project\\/snapshot\\/\"},\"wp-crontrol\\/wp-crontrol.php\":{\"name\":\"WP Crontrol\",\"version\":\"1.19.2\",\"plugin_uri\":\"https:\\/\\/wp-crontrol.com\"},\"wpmudev-updates\\/update-notifications.php\":{\"name\":\"WPMU DEV Dashboard\",\"version\":\"4.11.29\",\"plugin_uri\":\"https:\\/\\/wpmudev.com\\/project\\/wpmu-dev-dashboard\\/\"},\"zoho-flow\\/zoho-flow.php\":{\"name\":\"Zoho Flow\",\"version\":\"2.14.1\",\"plugin_uri\":\"https:\\/\\/www.zohoflow.com\\/?utm_source=wordpress&utm_campaign=plugin-uri&utm_medium=link\"}},\"ui_field_groups\":\"0\",\"php_field_groups\":\"0\",\"json_field_groups\":\"0\",\"rest_field_groups\":\"0\",\"all_location_rules\":[],\"field_groups_with_single_block_rule\":\"0\",\"field_groups_with_multiple_block_rules\":\"0\",\"field_groups_with_blocks_and_other_rules\":\"0\",\"number_of_fields_by_type\":[],\"number_of_third_party_fields_by_type\":[],\"post_types_enabled\":true,\"ui_post_types\":\"10\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"11\",\"json_taxonomies\":\"0\",\"ui_options_pages_enabled\":true,\"ui_options_pages\":\"0\",\"json_options_pages\":\"0\",\"php_options_pages\":\"0\",\"rest_api_format\":\"light\",\"registered_acf_blocks\":\"0\",\"blocks_per_api_version\":[],\"blocks_per_acf_block_version\":[],\"blocks_using_post_meta\":\"0\",\"preload_blocks\":true,\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":false,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":1,\"event_first_activated\":1747676447,\"event_first_created_post_type\":1747740179,\"last_updated\":1760989827}","off"),
("300","acf_version","6.6.1","auto"),
("315","cpac_options_acf-field-group__default","a:9:{s:2:\"cb\";s:25:\"<input type=\"checkbox\" />\";s:5:\"title\";s:5:\"Title\";s:15:\"acf-description\";s:11:\"Description\";s:8:\"ridwpaid\";s:74:\"<abbr style=\"cursor:help;\" title=\"Enhanced by Reveal IDs Plugin\">ID</abbr>\";s:9:\"acf-count\";s:6:\"Fields\";s:12:\"acf-location\";s:8:\"Location\";s:9:\"acfe-load\";s:4:\"Load\";s:17:\"acfe-autosync-php\";s:3:\"PHP\";s:18:\"acfe-autosync-json\";s:4:\"Json\";}","off"),
("316","ac_sorting_acf-field-group_default","a:5:{s:5:\"title\";a:4:{i:0;s:5:\"title\";i:1;b:0;i:2;s:5:\"Title\";i:3;s:23:\"Table ordered by Title.\";}s:6:\"parent\";a:2:{i:0;s:6:\"parent\";i:1;b:0;}s:8:\"comments\";a:4:{i:0;s:13:\"comment_count\";i:1;b:0;i:2;s:8:\"Comments\";i:3;s:26:\"Table ordered by Comments.\";}s:4:\"date\";a:5:{i:0;s:4:\"date\";i:1;b:1;i:2;s:4:\"Date\";i:3;s:22:\"Table ordered by Date.\";i:4;s:4:\"desc\";}s:8:\"ridwpaid\";s:2:\"ID\";}","off"),
("317","zoho_flow_next_suggestion_date_advanced-custom-fields_1","O:8:\"DateTime\":3:{s:4:\"date\";s:26:\"2026-05-19 17:42:28.800767\";s:13:\"timezone_type\";i:3;s:8:\"timezone\";s:3:\"UTC\";}","auto"),
("320","acf_pro_license","YToyOntzOjM6ImtleSI7czo3MjoiTldKalpUTTVaamRsT1dRek5HTTJNRFprWXpnMFpEWmpZVE5rTm1Zd09USmhNemxpTXpWa1l6Wm1aalkxWm1abU9ERm1PV0UzIjtzOjM6InVybCI7czozOToiaHR0cHM6Ly9kaXZpNS5idWlsdGJ5cGVhcmxjaXR5bWVkaWEuY29tIjt9","auto"),
("334","acfe","a:3:{s:7:\"version\";s:7:\"0.9.1.1\";s:7:\"modules\";a:4:{s:11:\"block_types\";a:0:{}s:13:\"options_pages\";a:0:{}s:10:\"post_types\";a:0:{}s:10:\"taxonomies\";a:0:{}}s:7:\"license\";s:48:\"a2V5PTYzZDM2MTM0ZWE4MDU1M2ZiOWRlM2U3NTAzMmNjYTNl\";}","auto"),
("343","acf_pro_license_status","a:11:{s:6:\"status\";s:6:\"active\";s:7:\"created\";i:1679494370;s:6:\"expiry\";i:1779212007;s:4:\"name\";s:10:\"Freelancer\";s:8:\"lifetime\";b:0;s:8:\"refunded\";b:0;s:17:\"view_licenses_url\";s:62:\"https://www.advancedcustomfields.com/my-account/view-licenses/\";s:23:\"manage_subscription_url\";s:73:\"https://www.advancedcustomfields.com/my-account/view-subscription/382206/\";s:9:\"error_msg\";s:0:\"\";s:10:\"next_check\";i:1761083630;s:16:\"legacy_multisite\";b:1;}","on"),
("346","acfe_plugin_updates","a:2:{s:7:\"timeout\";i:1761089849;s:5:\"value\";s:79962:\"{\"new_version\":\"0.9.1.1\",\"stable_version\":\"0.9.1.1\",\"name\":\"ACF Extended Pro\",\"slug\":\"acf-extended\",\"url\":\"https:\\/\\/www.acf-extended.com\\/?download=acf-extended-pro&#038;changelog=1\",\"last_updated\":\"2025-08-13 11:27:22\",\"homepage\":\"https:\\/\\/www.acf-extended.com\",\"package\":\"https:\\/\\/www.acf-extended.com\\/edd-sl\\/package_download\\/MTc2MTE3MjY0OTphMlY1UFRZelpETTJNVE0wWldFNE1EVTFNMlppT1dSbE0yVTNOVEF6TW1OallUTmw6OTQ5OjA5MmY2ZWE3ZGQ4NjllOGJmMTE3ODg3MDAwY2MwODA5Omh0dHBzQC8vZGl2aTUuYnVpbHRieXBlYXJsY2l0eW1lZGlhLmNvbTow\",\"download_link\":\"https:\\/\\/www.acf-extended.com\\/edd-sl\\/package_download\\/MTc2MTE3MjY0OTphMlY1UFRZelpETTJNVE0wWldFNE1EVTFNMlppT1dSbE0yVTNOVEF6TW1OallUTmw6OTQ5OjA5MmY2ZWE3ZGQ4NjllOGJmMTE3ODg3MDAwY2MwODA5Omh0dHBzQC8vZGl2aTUuYnVpbHRieXBlYXJsY2l0eW1lZGlhLmNvbTow\",\"sections\":{\"description\":\"<p>&#x1f680; All-in-one enhancement suite that improves WordPress &amp; Advanced Custom Fields. This plugin aims to provide a powerful administration framework with a wide range of improvements &amp; optimizations.<\\/p>\\n<p><strong>This plugin requires at least ACF Pro 5.8.<\\/strong>\\nIf you don\'t already own <a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\">ACF Pro<\\/a>, you should consider it. It\'s one of the most powerful WordPress plugin available.<\\/p>\\n<h3>&#x2b50; Highlight<\\/h3>\\n<ul>\\n<li>14+ New ACF Fields<\\/li>\\n<li>10+ ACF Fields Enhanced<\\/li>\\n<li>4+ New Field Groups Locations<\\/li>\\n<li>Self\\/Multi\\/Bidirectional Fields<\\/li>\\n<li>Advanced Fields Validation<\\/li>\\n<li>Flexible Content as Page Builder<\\/li>\\n<li>Optimize metadata with Performance Mode<\\/li>\\n<li>Advanced Front-End Forms Manager<\\/li>\\n<li>ACF Options Pages \\/ Block Types Manager<\\/li>\\n<li>ACF &amp; WordPress Meta Overview<\\/li>\\n<li>WordPress Post Types \\/ Taxonomies Manager<\\/li>\\n<li>WordPress Options Manager<\\/li>\\n<li>WordPress Admin Enhancements<\\/li>\\n<li>WPML &amp; Polylang Multilingual support<\\/li>\\n<li>... And many more features<h3>&#x1f48e; Pro Highlight<\\/h3><\\/li>\\n<li>20+ New ACF Fields<\\/li>\\n<li>10+ ACF Fields Enhanced<\\/li>\\n<li>20+ New Locations<\\/li>\\n<li>Payment Field with Stripe &amp; PayPal Express<\\/li>\\n<li>Flexible Content Grid System<\\/li>\\n<li>Flexible Content Layouts Locations Rules<\\/li>\\n<li>Templates Manager<\\/li>\\n<li>Builtin Classic Editor<\\/li>\\n<li>Settings UI<\\/li>\\n<li>Screen Layouts<\\/li>\\n<li>Force Json Sync<\\/li>\\n<li>Field Visibility Settings<\\/li>\\n<li>Global Field Conditional Rules<\\/li>\\n<li>... And many more features<h3>&#x1f91f; Philosophy<\\/h3><\\/li>\\n<li>Seamless integration<\\/li>\\n<li>No extra menu, ads or notices<\\/li>\\n<li>Built by developers, for developers<h3>&#x1f6e0;&#xfe0f; Links<\\/h3><\\/li>\\n<li><a href=\\\"https:\\/\\/www.acf-extended.com\\\">Website<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\\">Documentation<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.acf-extended.com\\/guides\\\">Guides<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.acf-extended.com\\/roadmap\\\">Roadmap<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/github.com\\/acf-extended\\/ACF-Extended\\\">GitHub<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/twitter.com\\/ACFExtended\\\">Twitter<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/twitter.com\\/hwkfr\\\">Twitter<\\/a> (Personal)<\\/li>\\n<li><a href=\\\"https:\\/\\/slack.acf-extended.com\\\">Slack Community<\\/a><h3>&#x1f9f0; Tools<\\/h3><\\/li>\\n<li><a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-extended\\/#faq\\\">FAQ<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\\">Support<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\\">Feature Request<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\/reviews\\/#new-post\\\">Reviews<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/ko-fi.com\\/acfextended\\\">Donation<\\/a><h3>&#x1f4c1; Field Groups<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/advanced-settings\\\">Advanced Settings<\\/a><\\/strong>\\nEnable advanced settings for all fields within the Field Group.<\\/li>\\n<\\/ul>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/autosync\\\">Auto Sync PHP<\\/a><\\/strong>\\nAutomatically synchronize field groups with local PHP files upon field group updates. This feature will create, include and update a local PHP file for each field group.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/autosync\\\">Auto Sync Json<\\/a><\\/strong>\\nControl which field groups you want to synchronize with local Json files. Display warnings if the Json file has been manually deleted.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/categories\\\">Categories<\\/a><\\/strong>\\nSpice up your field groups with a custom taxonomy and filter field groups by terms.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/custom-key\\\">Custom Key<\\/a><\\/strong>\\nSet custom field group key. Example: <code>group_custom_name<\\/code>.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/custom-meta\\\">Custom Meta<\\/a><\\/strong>\\nAdd custom metas (key\\/value) in the field group administration.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/display-title\\\">Display Title<\\/a><\\/strong>\\nDisplay an alternative field group title in post edition screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/field-group-ui\\\">Field Group UI<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nEnable enhancements to the Field Group UI for a better user experience.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/force-sync\\\">Force Sync<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nAlways keep Json files synchronized with the Field Groups in the database.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/hide-on-screen\\\">Hide on Screen<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nHide Gutenberg Block Editor and 10+ more items to hide in the field group settings.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/instruction-placement\\\">Instructions Placement<\\/a><\\/strong>\\nNew instruction placements let you display field description &quot;above the fields&quot; or in a &quot;tooltip&quot;.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/advanced-post\\\">Location: Advanced Post<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nA collection of multiple new Field Groups locations allowing developers to target posts with specific conditions (Post author, date, slug, path etc...).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/advanced-menu-item\\\">Location: Advanced Menu Item<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nTarget specific &quot;Menu Item Depth&quot; or &quot;Menu Item Type&quot; from the Field Groups Locations rules.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/advanced-taxonomy\\\">Location: Advanced Taxonomy Term<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nA collection of multiple new Field Groups locations allowing developers to target taxonomy and terms with specific conditions (Term name, parent, slug etc...).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/all-post-types\\\">Location: All post types<\\/a><\\/strong>\\nDisplay field groups on all post types edition screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/attachment-list\\\">Location: Attachment List<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field group on attachment admin list screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/dashboard\\\">Location: Dashboard Widgets<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field groups and update ACF Fields from the WP Dashboard.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/field-value\\\">Location: Field Value<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a field group based on the field value of an another field group.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/post-type-archive\\\">Location: Post type Archive<\\/a><\\/strong>\\nAdd an Archive Option Page under the Post Type admin menu. Display and save any field groups within it.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/post-type-list\\\">Location: Post type List<\\/a><\\/strong>\\nDisplay field group on post types admin list screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/taxonomy-list\\\">Location: Taxonomy List<\\/a><\\/strong>\\nDisplay field group on taxonomies admin list screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/user-list\\\">Location: User List<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field group on user admin list screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/woocommerce\\\">Location: Woocommerce<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field groups on Woocommerce pages.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/wp-settings\\\">Location: WP Settings<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field groups on WP Settings pages: General, Writing, Reading, Discussion, Media and Permalinks.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/\\\">Local Field Groups<\\/a><\\/strong>\\nDisplay local field groups that are loaded by ACF, but not available in the ACF field group administration. Example: Field groups that are registered in the <code>functions.php<\\/code> file, but not in the ACF UI.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/note\\\">Note<\\/a><\\/strong>\\nAdd a personal note in the field group administration. Only visible to administrators.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/permissions\\\">Permissions<\\/a><\\/strong>\\nAdd permission layer to field groups. Choose which roles can view &amp; edit field groups in the post edition screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/raw-data\\\">Raw Data<\\/a><\\/strong>\\nDisplay raw field group data in a modal to check your configuration &amp; settings.<h3>&#x2699;&#xfe0f; Fields Settings<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-advanced-settings\\\">Advanced Settings<\\/a><\\/strong>\\nA more sophisticated field settings based on specified location (administration\\/front-end). Example: Field is required only in front-end.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/advanced-validation\\\">Advanced Validation<\\/a><\\/strong>\\nA more sophisticated validation conditions (AND\\/OR) with custom error messages based on specified location (administration\\/front-end).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/bidirectional-fields\\\">Self\\/Multi\\/Bidirectional fields<\\/a><\\/strong>\\nAn advanced bidirectional setting (also called post-to-post) is available for the following fields: Relationship, Post object, User &amp; Taxonomy terms. Fields will work bidirectionally and automatically update each others. Works in groups &amp; clones.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-visibility\\\">Field Visibility<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nGet quick access to &quot;Field Visibility&quot;, &quot;Label Visibility&quot;, &quot;Instructions Visibility&quot; and &quot;Required Setting&quot; for the following screens: &quot;Everywhere&quot;, &quot;Front-end&quot; and &quot;Administration&quot;.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/global-condition\\\">Global Condition<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nEnable Global Conditional Logic for a specific field, which can then be used in an another Field Group as condition, both as Field Group Condition and Field Condition.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-instruction-placement\\\">Instruction Placement<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nOverride a specific field instruction placement to any position: Below labels, below fields, above fields or tooltip.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/instruction-read-more\\\">Instruction Read More<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nAllow to expand instructions text with a &quot;Read More&quot; link. This feature is useful for lengthy instructions text.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/min-max\\\">Min\\/Max<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nMinimum &amp; maximum items is a global field setting that let you define a specific number of items that can or should be added by the user.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-permissions\\\">Permissions<\\/a><\\/strong>\\nAdd permission layer to fields. Choose which roles can view &amp; edit fields in the post edition screen. (can be combined with field groups permissions).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-raw-data\\\">Raw data<\\/a><\\/strong>\\nDisplay raw field data in a modal to check your configuration &amp; settings.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/required-message\\\">Required Message<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nThis setting allow developers to define a custom error message within the field settings for a more intuitive user experience.<h3>&#x1f3f7;&#xfe0f; Fields<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/advanced-link\\\">Advanced Link<\\/a><\\/strong>\\nDisplay a modern Link Selection in a modal. Posts, Post Types Archives &amp; terms selection can be filtered in the field administration.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/block-editor\\\">Block Editor<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an isolated Block Editor field on admin screen (with Classic Editor enabled) or on the front-end.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/block-types\\\">Block Types<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Block Types selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/button\\\">Button<\\/a><\\/strong>\\nDisplay a custom submit or button. Built-in ajax call setting. Usage example available in the field administration.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/checkbox\\\">Checkbox<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nDefine grouped choices values using <code>## Title<\\/code> markup in the field\'s choices.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/clone\\\">Clone<\\/a><\\/strong>\\nAllow users to edit clone fields in a modal. Choose the edit button text, display close button and the modal size.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/code-editor\\\">Code Editor<\\/a><\\/strong>\\nEdit code using the native WP Core Codemirror library. Default languages: Text\\/HTML, Javascript, CSS, PHP mixed\\/plain.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/color-picker\\\">Color Picker<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nA collection of advanced settings for the ACF Color Picker. The field can now be displayed as a palette, custom colors can be predefined and RGBA mode is supported.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/columns\\\">Columns<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nOrganize and re-arrange your fields using columns and line-breaks. The field acts like the ACF Accordion\\/Tab field and allow you to create virtually grouped fields which will be displayed inside columns.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/countries\\\">Countries<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Country selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/currencies\\\">Currencies<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Currency selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/datepicker\\\">Date\\/Timepicker<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nDisplay a modern UI of the ACF Datepicker field. CSS and icons have been enhanced to fit WordPress admin UI and colors.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/date-range-picker\\\">Date Range Picker<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Date Range Picker. The field support a wide range of customization, such as: Placeholder, Default dates, Range Restriction, Date restriction, No weekends etc.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/dynamic-render\\\">Dynamic Render<\\/a><\\/strong>\\nDisplay custom HTML\\/PHP content using a simple named hook.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/field-groups-selector\\\">Field Groups<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Field Groups selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/field-types\\\">Field Types<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Field Types selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/fields-selector\\\">Fields<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Fields selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/file\\\">File<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nChoose the uploader type, enable multi file upload and dropzone.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/flexible-content\\\">Flexible Content<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nDisplayed an enhanced version of the native Flexible Content field. Dozens of new settings and settings were added, allowing developers to create the most advanced page builder and fully control the field\'s behavior.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/forms\\\">Forms<\\/a><\\/strong>\\nSelect any dynamic form (format: checkbox, radio or select).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/google-map\\\">Google Map<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nA collection of new settings added to the ACF Google Map Field that allow developers to have more control over the field behavior.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/recaptcha\\\">Google reCaptcha<\\/a><\\/strong>\\nDisplay a reCaptcha field (compatible v2 &amp; v3).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/group\\\">Group<\\/a><\\/strong>\\nAllow users to edit group fields in a modal Choose the edit button text, display close button and the modal size<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/hidden-input\\\">Hidden Input<\\/a><\\/strong>\\nDisplay a hidden input with custom name\\/value<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/image\\\">Image<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nChoose the uploader type, customize the upload folder and set the image as post featured thumbnail<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/image-selector\\\">Image Selector<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an Image Selector field.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/image-sizes\\\">Image Sizes<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an Image Sizes selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/languages\\\">Languages<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Language selector as radio, checkbox or select field type, compatible with WPML &amp; Polylang.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/menu-locations\\\">Menu Locations<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Menu Locations selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/menus\\\">Menus<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Menu selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/options-pages\\\">Options Pages<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Options Pages selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/payment\\\">Payment<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Payment Field that supports with Stripe &amp; PayPal Express gateways, working on both front-end and back-end.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/payment-cart\\\">Payment Cart<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an optional Payment Cart to easily setup an e-commerce solution.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/payment-selector\\\">Payment Selector<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an optional Payment Selector which let the user switch the payment gateway.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/phone-number\\\">Phone Number<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a fully customizable international Phone Number field.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/post-field\\\">Post Field<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nThe Post Field is a new field that allow developers to move native WordPress fields such as Post Title, Date, Status, Visibility, Permalink etc.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/post-formats\\\">Post Formats<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Post Format selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\\">Post Object<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nAllow user to enter custom value which will be saved as a new post, or enable the inline post creation\\/edit.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/post-statuses\\\">Post Status<\\/a><\\/strong>\\nSelect any post status (format: checkbox, radio or select)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/post-types\\\">Post Types<\\/a><\\/strong>\\nSelect any post type (format: checkbox, radio or select)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/radio\\\">Radio<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nDefine grouped choices values using <code>## Title<\\/code> markup in the field\'s choices.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/relationship\\\">Relationship<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nThe Relationship field includes new settings allowing users to create and edit post on-the-fly from the post edit screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/repeater\\\">Repeater<\\/a><\\/strong>\\nAdd stylised to \'Add Row\' button, lock rows and remove repeater\'s actions.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/select\\\">Select<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nChange the default &quot;Select&quot; placeholder text and Search Input placeholder and allow user to enter custom values.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/slug\\\">Slug<\\/a><\\/strong>\\nA slug text input (ie: <code>my-text-input<\\/code>).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/tab\\\">Tab<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisable the last opened tab user preference. Which means that when the user will refresh the page, it will always load the first tab.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/taxonomies\\\">Taxonomies<\\/a><\\/strong>\\nSelect any taxonomy (format: checkbox, radio or select)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/taxonomy-terms\\\">Taxonomy Terms<\\/a><\\/strong>\\nSelect any terms of any taxonomies, allow specific terms, level or childrens (format: checkbox or select). Terms can be loaded &amp; saved for the current post (just like the native ACF Taxonomy field)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/templates-selector\\\">Templates<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Extended Templates selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/textarea\\\">Textarea<\\/a><\\/strong>\\nSwitch font family to monospace and allow tab indent.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/true-false\\\">True\\/False<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nFive new styles have been added to the native True\\/False field.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/user-roles\\\">User Roles<\\/a><\\/strong>\\nSelect any user role (format: checkbox, radio or select)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/wysiwyg-editor\\\">WYSIWYG Editor<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nNew settings allowing developers to have more control over the field behavior.<h3>&#x1f6e0;&#xfe0f; Modules<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-block-types\\\">Block Types UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Dynamic Block Types module allows you to register and manage ACF Block Types from your WordPress admin, in ACF &gt; Block Types menu. Pro version allows to sync Json\\/PHP files.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/classic-editor\\\">Classic Editor<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nACF Extended is bundled with a custom merged version of the Classic Editor &amp; Disable Gutenberg plugins.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/developer-mode\\\">Developer Mode<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Developer Mode allow you to view all Posts, Terms, Users &amp; Options custom metadata in a readable format. This feature is very useful to check what is actually saved in any WordPress Object.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-forms\\\">Forms<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nManage Advanced ACF Forms from the WordPress administration. This module is an enhanced version of the native ACF Form feature. While all native settings can be used, Dynamic Forms adds many new settings and introduce &quot;Actions&quot; for a complete control over the form behavior.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-options-pages\\\">Options Pages UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Dynamic Options Pages module allows you to register and manage ACF Options Pages from your WordPress admin, in ACF &gt; Options Pages menu. Pro version allows to sync Json\\/PHP files.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/performance-mode\\\">Performance Mode<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nA unique module that allows developers to optimize database load when dealing with hundreds or thousands of metadata with two different methods: Ultra &amp; Hybrid Engines.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-post-types\\\">Post Types UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Dynamic Post Types module allows you to register and manage custom post types from your WordPress admin, in Tools &gt; Post Types menu. Pro version allows to sync Json\\/PHP files.<\\/p>\\n<p>All native post types settings can be set within the UI. ACF Extended also adds more advanced settings allowing to manage posts per page, order etc\\u2026<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/rewrite-rules\\\">Rewrite Rules<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nGet an overview of all WordPress permalinks structures and rules. Test URLs, export rules and flush permalinks from the UI.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/scripts\\\">Scripts UI<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nRun custom scripts on thousands of posts. Including builtin &quot;Orphan Meta Cleaner&quot;, &quot;Script Launcher&quot; and &quot;Performance Converter&quot; scripts.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/settings-ui\\\">Settings UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Settings UI allows developers to get an overview of all ACF and ACF Extended settings values from the ACF &gt; Settings menu.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-taxonomies\\\">Taxonomies UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Dynamic Taxonomies module allows you to register and manage custom taxonomies from your WordPress admin, in Tools &gt; Taxonomies menu. Pro version allows to sync Json\\/PHP files.<\\/p>\\n<p>All native taxonomies settings can be set within the UI. ACF Extended also adds more advanced settings allowing to manage posts per page, order etc\\u2026<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/templates\\\">Templates<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nManage default ACF values in an advanced way and sync templates with Json\\/PHP files.<h3>&#x1f5a5;&#xfe0f; WordPress<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/ajax-author-box\\\">Ajax Author Box<\\/a><\\/strong>\\nThe native WP Author Metabox has been replaced with an Ajax version allowing to manage thousands of users without slowing down the post administration. The new Author box also include an inline search input.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/enhanced-ui\\\">Enhanced UI<\\/a><\\/strong>\\nThe Taxonomy, User profile &amp; Settings views have been enhanced for a more consistent administration experience, using CSS\\/JS only.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/polylang\\\">Polylang<\\/a><\\/strong>\\nACF Extended adds a new layer of compatibility for Polylang. ACF Options Pages and all ACF Extended Modules (Dynamic Post Type, Taxonomy, Options Pages, Block Type) are compatible.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/screen-layouts\\\">Screen Layouts<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nPost Edit screens have been enhanced allowing up to 3 columns layout and multiple variations.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/wpml\\\">WPML<\\/a><\\/strong>\\nACF Extended adds a new layer of compatibility for WPML. ACF Options Pages and all ACF Extended Modules (Dynamic Post Type, Taxonomy, Options Pages, Block Type) are compatible.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/options\\\">WP Options<\\/a><\\/strong>\\nManage WordPress Options from the Settings &gt; Options page. Options value (strings, serialized &amp; Json) will be displayed in a readable form. Values can be edited or deleted.<h3>&#x2764;&#xfe0f; Early Supporters<\\/h3><\\/p>\\n<ul>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/AsmussenBrandon\\\">Brandon A.<\\/a> for his support &amp; tests<\\/li>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/DamChtlv\\\">Damien C.<\\/a> for his support &amp; tests<\\/li>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/Val_Pellegrin\\\">Valentin P.<\\/a> for his support &amp; tests<\\/li>\\n<li>Thanks to Damian P. for his support &amp; tests<\\/li>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/jsaarenk\\\">Jaakko S.<\\/a> for his support &amp; tests<\\/li>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/altendorfme\\\">Renan A.<\\/a> for his support &amp; tests<h3>&#x1f970; Donors<\\/h3><\\/li>\\n<li>Thanks to RavenSays<\\/li>\\n<li>Thanks to Dave A.<\\/li>\\n<li>Thanks to Rob H.<\\/li>\\n<li>Thanks to Valentin P.<\\/li>\\n<li>Thanks to Alan A.<\\/li>\\n<li>Thanks to Damian C.<\\/li>\\n<li>Thanks to Andrew<\\/li>\\n<li>Thanks to Kimantis<\\/li>\\n<li>Thanks to Anonymous<\\/li>\\n<li>Thanks to Chris<\\/li>\\n<li>Thanks to Dennis D.<\\/li>\\n<li>Thanks to Cody R.<\\/li>\\n<li>Thanks to Jamie<\\/li>\\n<li>Thanks to Dave A.<\\/li>\\n<li>Thanks to Paul M.<\\/li>\\n<li>Thanks to David B.<\\/li>\\n<li>Thanks to Swingjac<\\/li>\\n<li>Thanks to Erik<\\/li>\\n<li>Thanks to Giancarlo P.<\\/li>\\n<li>Thanks to Geuer M.<\\/li>\\n<\\/ul>\",\"installation\":\"<h4> Wordpress Install <\\/h4>\\n<ol>\\n<li>Install Advanced Custom Fields: Pro<\\/li>\\n<li>Upload the plugin files to the <code>\\/wp-content\\/plugins\\/acf-extended\\/<\\/code> directory, or install the plugin through the WordPress plugins screen directly.<\\/li>\\n<li>Activate the plugin through the \'Plugins\' screen in WordPress.<\\/li>\\n<li>Everything is ready!<\\/li>\\n<\\/ol>\",\"changelog\":\"<h4> 0.9.1.1 <\\/h4>\\n<p><strong>ACF Extended Pro 0.9.1.1:<\\/strong><\\/p>\\n<ul>\\n<li>Field Group: Fixed error in the Field Group UI with ACF 6.5+<\\/li>\\n<li>Field: Payment - Stripe gateway now use the wrapper text color as placeholder color<\\/li>\\n<li>Field: Post Object - Fixed &quot;Inline Post Edit&quot; feature with ACF 6.5+<\\/li>\\n<\\/ul>\\n<p><strong>ACF Extended Basic 0.9.1.1:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Flexible Content - Added compatibility with ACF 6.5+<\\/li>\\n<li>Field: Flexible Content - Legacy render style (ACF 6.4) is enforced to maintain compatibility<\\/li>\\n<li>Field: Flexible Content - New ACF 6.5 render style will be implemented in a future patch<\\/li>\\n<li>Field: Flexible Content - Fixed &quot;Dynamic Preview&quot; when displaying values with <code>acfe_form()<\\/code><\\/li>\\n<li>Field: Slug - Fixed PHP 8 warning during field validation<\\/li>\\n<li>Fields: Instructions Tooltip - Enhanced text sanitization to allow custom HTML<\\/li>\\n<li>Module: Form - Reset <code>$_FILES<\\/code> as <code>array()<\\/code> to respect PHP standards<\\/li>\\n<li>Module: Options Pages - moved to &quot;Tools&quot; WP admin menu to avoid confusion with ACF Options Pages<\\/li>\\n<li>Module: Performance - Fixed &quot;Save as Individual Meta&quot; regression on post creation<\\/li>\\n<li>Module: Performance - Fixed &quot;Save as Individual Meta&quot; revision restoration on an empty post<\\/li>\\n<li>Global: Fixed PHP 8 warning during initial setup<\\/li>\\n<li>Global: ACFE Modal - Small CSS tweaks<\\/li>\\n<li>Global: Added compatibility with ACF 6.5+<\\/li>\\n<\\/ul>\\n<h4> 0.9.1 <\\/h4>\\n<p><strong>ACF Extended Pro 0.9.1:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Flexible Content - Added &quot;Dynamic Preview Iframe&quot; feature<\\/li>\\n<li>Field: Flexible Content - Added &quot;Dynamic Preview Responsive&quot; feature<\\/li>\\n<li>Field: Flexible Content - &quot;Dynamic Preview Iframe&quot; render previews in isolated iframes<\\/li>\\n<li>Field: Flexible Content - &quot;Dynamic Preview Responsive&quot; allows to switch container preview size<\\/li>\\n<li>Field: Address - Cleaned unused argument<\\/li>\\n<li>Field: Google Map - Added <code>acfe_render_google_map()<\\/code> compatibility with sub fields<\\/li>\\n<li>Field: Google Map - Enhanced <code>acfe_render_google_map()<\\/code> compatibility with Dynamic Preview<\\/li>\\n<li>Field: Radio - Fixed &quot;Custom Choice&quot; render<\\/li>\\n<li>Field: WYSIWYG - Enhanced <code>source_code<\\/code> modal reset stylesheet<\\/li>\\n<li>Field Group Location: Renamed &quot;Dashboard&quot; to &quot;WP Dashboard&quot; for consistency<\\/li>\\n<li>Module: Forms - Ajax submission now redraw form on submission<\\/li>\\n<\\/ul>\\n<p><strong>ACF Extended Basic 0.9.1:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Advanced Link - Enhanced malformed values handling<\\/li>\\n<li>Field: Flexible Content - Added <code>acfe\\/flexible\\/toggle_hide<\\/code> filter to control row visibility<\\/li>\\n<li>Field: reCaptcha - Enhanced error handling when using incorrect API key<\\/li>\\n<li>Field: Taxonomy Terms - Fixed ajax nonce verification when field is cloned<\\/li>\\n<li>Module: Forms - Enhanced File\\/Image\\/Gallery &quot;Uploaded To&quot; logic using related Form Action<\\/li>\\n<\\/ul>\\n<h4> 0.9.0.9 <\\/h4>\\n<p><strong>ACF Extended Pro 0.9.0.9:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Address - Added new Address Field<\\/li>\\n<li>Field: Address - Allows to enter\\/search an address with autocomplete (Google Places API)<\\/li>\\n<li>Field: Color Picker - Added &quot;Return Format: Slug&quot; setting<\\/li>\\n<li>Field: Color Picker - Added &quot;Slug&quot; &amp; &quot;RGBA Array&quot; into the &quot;Color Array&quot; return format<\\/li>\\n<li>Field: Color Picker - Added compatibility with CSS variables for &quot;Palette&quot; display<\\/li>\\n<li>Field: Color Picker - Added <code>editor-gradient-presets<\\/code> theme support<\\/li>\\n<li>Field: Date Range Picker - Enhanced compatibility with custom hooks<\\/li>\\n<li>Field: Date Range Picker - Allowed to clear to input manually when &quot;Allow null&quot; is enabled<\\/li>\\n<li>Field: Date Range Picker - Added &quot;x&quot; icon to clear the input when &quot;Allow null&quot; is enabled<\\/li>\\n<li>Field: Date Range Picker - Added &quot;Prepend&quot; &amp; &quot;Append&quot; settings<\\/li>\\n<li>Field: Google Map - Added <code>acfe_render_google_map()<\\/code> helper to display a map on front-end<\\/li>\\n<li>Field: Google Map - Fixed ACF UI settings sync when interacting with the Map Preview<\\/li>\\n<\\/ul>\\n<p><strong>ACF Extended Basic 0.9.0.9:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Flexible Content - Fixed <code>get_row()<\\/code> &amp; <code>get_row_layout()<\\/code> usage in WP Admin preview<\\/li>\\n<li>Field: Taxonomy Terms - Fixed ajax nonce compatibility with ACF 6.3.10<\\/li>\\n<li>Field Group: Small UI\\/CSS tweaks<\\/li>\\n<\\/ul>\\n<h4> Version History <\\/h4>\\n<p>Full Changelog: <a href=\\\"https:\\/\\/www.acf-extended.com\\/changelog\\\">https:\\/\\/www.acf-extended.com\\/changelog<\\/a><\\/p>\",\"faq\":\"<h4>Where can I find the documentation?<\\/h4>\\n<p>You\'ll find the documentation of every features on the <a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\\">official ACF Extended website<\\/a>.<\\/p>\\n<h4>Where can I submit a bug report?<\\/h4>\\n<p>You can file a report on the <a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\/\\\">Plugin Support Forum<\\/a> or on the <a href=\\\"https:\\/\\/github.com\\/acf-extended\\/ACF-Extended\\\">Github Page<\\/a> if you prefer.<\\/p>\\n<h4>Where can I submit a feature request?<\\/h4>\\n<p>You can submit a feature request on the <a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\/\\\">Plugin Support Forum<\\/a>. Feature requests are all listed on the <a href=\\\"https:\\/\\/trello.com\\/b\\/QEgpU7CL\\/acf-extended\\\">Official Trello Board<\\/a>.<\\/p>\\n<h4>What is planned for the next update?<\\/h4>\\n<p>The content of the upcoming patch and work in progress features are all listed on the <a href=\\\"https:\\/\\/www.acf-extended.com\\/roadmap\\\">Official Roadmap<\\/a> (or the Trello Board).<\\/p>\\n\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/acf-extended\\/assets\\/banner-1544x500.png\",\"low\":\"https:\\/\\/ps.w.org\\/acf-extended\\/assets\\/banner-772x250.png\"},\"icons\":{\"1x\":\"https:\\/\\/www.acf-extended.com\\/wp-content\\/uploads\\/edd\\/acf-extended-256x256-1-128x128.png\",\"2x\":\"https:\\/\\/www.acf-extended.com\\/wp-content\\/uploads\\/edd\\/acf-extended-256x256-1.png\"},\"tags\":[\"acf\",\"custom fields\",\"meta\",\"admin\",\"fields\"],\"requires\":\"4.9\",\"tested\":\"6.8\",\"requires_php\":\"5.6\",\"contributors\":{\"hwk-fr\":{\"display_name\":\"hwk-fr\",\"profile\":\"\\/\\/profiles.wordpress.org\\/hwk-fr\",\"avatar\":\"https:\\/\\/wordpress.org\\/grav-redirect.php?user=hwk-fr\"}},\"stable_tag\":\"0.9.1.1\",\"donate_link\":\"https:\\/\\/www.acf-extended.com\",\"short_description\":\"All-in-one enhancement suite that improves WordPress &amp; Advanced Custom Fields.\",\"license\":\"GPLv2 or later\",\"screenshots\":{\"1\":\"Flexible Content Preview\",\"2\":\"Flexible Content Modal\",\"3\":\"New Fields\",\"4\":\"Post Type List Location\",\"5\":\"Self\\/Multi\\/Bidirectional Fields\",\"6\":\"Developer Mode\",\"7\":\"Dynamic Post Types\",\"8\":\"Enhanced WordPress UI\"},\"faq\":[\"<h4>Where can I find the documentation?<\\/h4>\\n<p>You\'ll find the documentation of every features on the <a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\\">official ACF Extended website<\\/a>.<\\/p>\\n<h4>Where can I submit a bug report?<\\/h4>\\n<p>You can file a report on the <a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\/\\\">Plugin Support Forum<\\/a> or on the <a href=\\\"https:\\/\\/github.com\\/acf-extended\\/ACF-Extended\\\">Github Page<\\/a> if you prefer.<\\/p>\\n<h4>Where can I submit a feature request?<\\/h4>\\n<p>You can submit a feature request on the <a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\/\\\">Plugin Support Forum<\\/a>. Feature requests are all listed on the <a href=\\\"https:\\/\\/trello.com\\/b\\/QEgpU7CL\\/acf-extended\\\">Official Trello Board<\\/a>.<\\/p>\\n<h4>What is planned for the next update?<\\/h4>\\n<p>The content of the upcoming patch and work in progress features are all listed on the <a href=\\\"https:\\/\\/www.acf-extended.com\\/roadmap\\\">Official Roadmap<\\/a> (or the Trello Board).<\\/p>\\n\"],\"warnings\":[],\"description\":[\"<p>&#x1f680; All-in-one enhancement suite that improves WordPress &amp; Advanced Custom Fields. This plugin aims to provide a powerful administration framework with a wide range of improvements &amp; optimizations.<\\/p>\\n<p><strong>This plugin requires at least ACF Pro 5.8.<\\/strong>\\nIf you don\'t already own <a href=\\\"https:\\/\\/www.advancedcustomfields.com\\/pro\\/\\\">ACF Pro<\\/a>, you should consider it. It\'s one of the most powerful WordPress plugin available.<\\/p>\\n<h3>&#x2b50; Highlight<\\/h3>\\n<ul>\\n<li>14+ New ACF Fields<\\/li>\\n<li>10+ ACF Fields Enhanced<\\/li>\\n<li>4+ New Field Groups Locations<\\/li>\\n<li>Self\\/Multi\\/Bidirectional Fields<\\/li>\\n<li>Advanced Fields Validation<\\/li>\\n<li>Flexible Content as Page Builder<\\/li>\\n<li>Optimize metadata with Performance Mode<\\/li>\\n<li>Advanced Front-End Forms Manager<\\/li>\\n<li>ACF Options Pages \\/ Block Types Manager<\\/li>\\n<li>ACF &amp; WordPress Meta Overview<\\/li>\\n<li>WordPress Post Types \\/ Taxonomies Manager<\\/li>\\n<li>WordPress Options Manager<\\/li>\\n<li>WordPress Admin Enhancements<\\/li>\\n<li>WPML &amp; Polylang Multilingual support<\\/li>\\n<li>... And many more features<h3>&#x1f48e; Pro Highlight<\\/h3><\\/li>\\n<li>20+ New ACF Fields<\\/li>\\n<li>10+ ACF Fields Enhanced<\\/li>\\n<li>20+ New Locations<\\/li>\\n<li>Payment Field with Stripe &amp; PayPal Express<\\/li>\\n<li>Flexible Content Grid System<\\/li>\\n<li>Flexible Content Layouts Locations Rules<\\/li>\\n<li>Templates Manager<\\/li>\\n<li>Builtin Classic Editor<\\/li>\\n<li>Settings UI<\\/li>\\n<li>Screen Layouts<\\/li>\\n<li>Force Json Sync<\\/li>\\n<li>Field Visibility Settings<\\/li>\\n<li>Global Field Conditional Rules<\\/li>\\n<li>... And many more features<h3>&#x1f91f; Philosophy<\\/h3><\\/li>\\n<li>Seamless integration<\\/li>\\n<li>No extra menu, ads or notices<\\/li>\\n<li>Built by developers, for developers<h3>&#x1f6e0;&#xfe0f; Links<\\/h3><\\/li>\\n<li><a href=\\\"https:\\/\\/www.acf-extended.com\\\">Website<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\\">Documentation<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.acf-extended.com\\/guides\\\">Guides<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/www.acf-extended.com\\/roadmap\\\">Roadmap<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/github.com\\/acf-extended\\/ACF-Extended\\\">GitHub<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/twitter.com\\/ACFExtended\\\">Twitter<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/twitter.com\\/hwkfr\\\">Twitter<\\/a> (Personal)<\\/li>\\n<li><a href=\\\"https:\\/\\/slack.acf-extended.com\\\">Slack Community<\\/a><h3>&#x1f9f0; Tools<\\/h3><\\/li>\\n<li><a href=\\\"https:\\/\\/wordpress.org\\/plugins\\/acf-extended\\/#faq\\\">FAQ<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\\">Support<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\\">Feature Request<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/wordpress.org\\/support\\/plugin\\/acf-extended\\/reviews\\/#new-post\\\">Reviews<\\/a><\\/li>\\n<li><a href=\\\"https:\\/\\/ko-fi.com\\/acfextended\\\">Donation<\\/a><h3>&#x1f4c1; Field Groups<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/advanced-settings\\\">Advanced Settings<\\/a><\\/strong>\\nEnable advanced settings for all fields within the Field Group.<\\/li>\\n<\\/ul>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/autosync\\\">Auto Sync PHP<\\/a><\\/strong>\\nAutomatically synchronize field groups with local PHP files upon field group updates. This feature will create, include and update a local PHP file for each field group.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/autosync\\\">Auto Sync Json<\\/a><\\/strong>\\nControl which field groups you want to synchronize with local Json files. Display warnings if the Json file has been manually deleted.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/categories\\\">Categories<\\/a><\\/strong>\\nSpice up your field groups with a custom taxonomy and filter field groups by terms.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/custom-key\\\">Custom Key<\\/a><\\/strong>\\nSet custom field group key. Example: <code>group_custom_name<\\/code>.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/custom-meta\\\">Custom Meta<\\/a><\\/strong>\\nAdd custom metas (key\\/value) in the field group administration.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/display-title\\\">Display Title<\\/a><\\/strong>\\nDisplay an alternative field group title in post edition screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/field-group-ui\\\">Field Group UI<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nEnable enhancements to the Field Group UI for a better user experience.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/force-sync\\\">Force Sync<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nAlways keep Json files synchronized with the Field Groups in the database.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/hide-on-screen\\\">Hide on Screen<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nHide Gutenberg Block Editor and 10+ more items to hide in the field group settings.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/instruction-placement\\\">Instructions Placement<\\/a><\\/strong>\\nNew instruction placements let you display field description &quot;above the fields&quot; or in a &quot;tooltip&quot;.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/advanced-post\\\">Location: Advanced Post<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nA collection of multiple new Field Groups locations allowing developers to target posts with specific conditions (Post author, date, slug, path etc...).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/advanced-menu-item\\\">Location: Advanced Menu Item<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nTarget specific &quot;Menu Item Depth&quot; or &quot;Menu Item Type&quot; from the Field Groups Locations rules.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/advanced-taxonomy\\\">Location: Advanced Taxonomy Term<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nA collection of multiple new Field Groups locations allowing developers to target taxonomy and terms with specific conditions (Term name, parent, slug etc...).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/all-post-types\\\">Location: All post types<\\/a><\\/strong>\\nDisplay field groups on all post types edition screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/attachment-list\\\">Location: Attachment List<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field group on attachment admin list screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/dashboard\\\">Location: Dashboard Widgets<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field groups and update ACF Fields from the WP Dashboard.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/field-value\\\">Location: Field Value<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a field group based on the field value of an another field group.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/post-type-archive\\\">Location: Post type Archive<\\/a><\\/strong>\\nAdd an Archive Option Page under the Post Type admin menu. Display and save any field groups within it.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/post-type-list\\\">Location: Post type List<\\/a><\\/strong>\\nDisplay field group on post types admin list screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/taxonomy-list\\\">Location: Taxonomy List<\\/a><\\/strong>\\nDisplay field group on taxonomies admin list screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/user-list\\\">Location: User List<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field group on user admin list screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/woocommerce\\\">Location: Woocommerce<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field groups on Woocommerce pages.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/locations\\/wp-settings\\\">Location: WP Settings<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay field groups on WP Settings pages: General, Writing, Reading, Discussion, Media and Permalinks.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/\\\">Local Field Groups<\\/a><\\/strong>\\nDisplay local field groups that are loaded by ACF, but not available in the ACF field group administration. Example: Field groups that are registered in the <code>functions.php<\\/code> file, but not in the ACF UI.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/note\\\">Note<\\/a><\\/strong>\\nAdd a personal note in the field group administration. Only visible to administrators.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/permissions\\\">Permissions<\\/a><\\/strong>\\nAdd permission layer to field groups. Choose which roles can view &amp; edit field groups in the post edition screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-groups\\/raw-data\\\">Raw Data<\\/a><\\/strong>\\nDisplay raw field group data in a modal to check your configuration &amp; settings.<h3>&#x2699;&#xfe0f; Fields Settings<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-advanced-settings\\\">Advanced Settings<\\/a><\\/strong>\\nA more sophisticated field settings based on specified location (administration\\/front-end). Example: Field is required only in front-end.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/advanced-validation\\\">Advanced Validation<\\/a><\\/strong>\\nA more sophisticated validation conditions (AND\\/OR) with custom error messages based on specified location (administration\\/front-end).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/bidirectional-fields\\\">Self\\/Multi\\/Bidirectional fields<\\/a><\\/strong>\\nAn advanced bidirectional setting (also called post-to-post) is available for the following fields: Relationship, Post object, User &amp; Taxonomy terms. Fields will work bidirectionally and automatically update each others. Works in groups &amp; clones.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-visibility\\\">Field Visibility<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nGet quick access to &quot;Field Visibility&quot;, &quot;Label Visibility&quot;, &quot;Instructions Visibility&quot; and &quot;Required Setting&quot; for the following screens: &quot;Everywhere&quot;, &quot;Front-end&quot; and &quot;Administration&quot;.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/global-condition\\\">Global Condition<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nEnable Global Conditional Logic for a specific field, which can then be used in an another Field Group as condition, both as Field Group Condition and Field Condition.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-instruction-placement\\\">Instruction Placement<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nOverride a specific field instruction placement to any position: Below labels, below fields, above fields or tooltip.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/instruction-read-more\\\">Instruction Read More<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nAllow to expand instructions text with a &quot;Read More&quot; link. This feature is useful for lengthy instructions text.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/min-max\\\">Min\\/Max<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nMinimum &amp; maximum items is a global field setting that let you define a specific number of items that can or should be added by the user.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-permissions\\\">Permissions<\\/a><\\/strong>\\nAdd permission layer to fields. Choose which roles can view &amp; edit fields in the post edition screen. (can be combined with field groups permissions).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/field-raw-data\\\">Raw data<\\/a><\\/strong>\\nDisplay raw field data in a modal to check your configuration &amp; settings.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/field-settings\\/required-message\\\">Required Message<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nThis setting allow developers to define a custom error message within the field settings for a more intuitive user experience.<h3>&#x1f3f7;&#xfe0f; Fields<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/advanced-link\\\">Advanced Link<\\/a><\\/strong>\\nDisplay a modern Link Selection in a modal. Posts, Post Types Archives &amp; terms selection can be filtered in the field administration.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/block-editor\\\">Block Editor<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an isolated Block Editor field on admin screen (with Classic Editor enabled) or on the front-end.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/block-types\\\">Block Types<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Block Types selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/button\\\">Button<\\/a><\\/strong>\\nDisplay a custom submit or button. Built-in ajax call setting. Usage example available in the field administration.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/checkbox\\\">Checkbox<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nDefine grouped choices values using <code>## Title<\\/code> markup in the field\'s choices.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/clone\\\">Clone<\\/a><\\/strong>\\nAllow users to edit clone fields in a modal. Choose the edit button text, display close button and the modal size.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/code-editor\\\">Code Editor<\\/a><\\/strong>\\nEdit code using the native WP Core Codemirror library. Default languages: Text\\/HTML, Javascript, CSS, PHP mixed\\/plain.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/color-picker\\\">Color Picker<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nA collection of advanced settings for the ACF Color Picker. The field can now be displayed as a palette, custom colors can be predefined and RGBA mode is supported.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/columns\\\">Columns<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nOrganize and re-arrange your fields using columns and line-breaks. The field acts like the ACF Accordion\\/Tab field and allow you to create virtually grouped fields which will be displayed inside columns.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/countries\\\">Countries<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Country selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/currencies\\\">Currencies<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Currency selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/datepicker\\\">Date\\/Timepicker<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nDisplay a modern UI of the ACF Datepicker field. CSS and icons have been enhanced to fit WordPress admin UI and colors.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/date-range-picker\\\">Date Range Picker<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Date Range Picker. The field support a wide range of customization, such as: Placeholder, Default dates, Range Restriction, Date restriction, No weekends etc.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/dynamic-render\\\">Dynamic Render<\\/a><\\/strong>\\nDisplay custom HTML\\/PHP content using a simple named hook.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/field-groups-selector\\\">Field Groups<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Field Groups selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/field-types\\\">Field Types<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Field Types selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/fields-selector\\\">Fields<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Fields selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/file\\\">File<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nChoose the uploader type, enable multi file upload and dropzone.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/flexible-content\\\">Flexible Content<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nDisplayed an enhanced version of the native Flexible Content field. Dozens of new settings and settings were added, allowing developers to create the most advanced page builder and fully control the field\'s behavior.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/forms\\\">Forms<\\/a><\\/strong>\\nSelect any dynamic form (format: checkbox, radio or select).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/google-map\\\">Google Map<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nA collection of new settings added to the ACF Google Map Field that allow developers to have more control over the field behavior.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/recaptcha\\\">Google reCaptcha<\\/a><\\/strong>\\nDisplay a reCaptcha field (compatible v2 &amp; v3).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/group\\\">Group<\\/a><\\/strong>\\nAllow users to edit group fields in a modal Choose the edit button text, display close button and the modal size<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/hidden-input\\\">Hidden Input<\\/a><\\/strong>\\nDisplay a hidden input with custom name\\/value<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/image\\\">Image<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nChoose the uploader type, customize the upload folder and set the image as post featured thumbnail<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/image-selector\\\">Image Selector<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an Image Selector field.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/image-sizes\\\">Image Sizes<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an Image Sizes selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/languages\\\">Languages<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Language selector as radio, checkbox or select field type, compatible with WPML &amp; Polylang.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/menu-locations\\\">Menu Locations<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Menu Locations selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/menus\\\">Menus<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Menu selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/options-pages\\\">Options Pages<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Options Pages selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/payment\\\">Payment<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Payment Field that supports with Stripe &amp; PayPal Express gateways, working on both front-end and back-end.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/payment-cart\\\">Payment Cart<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an optional Payment Cart to easily setup an e-commerce solution.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/payment-selector\\\">Payment Selector<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an optional Payment Selector which let the user switch the payment gateway.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/phone-number\\\">Phone Number<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a fully customizable international Phone Number field.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/post-field\\\">Post Field<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nThe Post Field is a new field that allow developers to move native WordPress fields such as Post Title, Date, Status, Visibility, Permalink etc.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/post-formats\\\">Post Formats<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay a Post Format selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\\">Post Object<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nAllow user to enter custom value which will be saved as a new post, or enable the inline post creation\\/edit.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/post-statuses\\\">Post Status<\\/a><\\/strong>\\nSelect any post status (format: checkbox, radio or select)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/post-types\\\">Post Types<\\/a><\\/strong>\\nSelect any post type (format: checkbox, radio or select)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/radio\\\">Radio<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nDefine grouped choices values using <code>## Title<\\/code> markup in the field\'s choices.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/relationship\\\">Relationship<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nThe Relationship field includes new settings allowing users to create and edit post on-the-fly from the post edit screen.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/repeater\\\">Repeater<\\/a><\\/strong>\\nAdd stylised to \'Add Row\' button, lock rows and remove repeater\'s actions.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/select\\\">Select<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nChange the default &quot;Select&quot; placeholder text and Search Input placeholder and allow user to enter custom values.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/slug\\\">Slug<\\/a><\\/strong>\\nA slug text input (ie: <code>my-text-input<\\/code>).<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/tab\\\">Tab<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisable the last opened tab user preference. Which means that when the user will refresh the page, it will always load the first tab.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/taxonomies\\\">Taxonomies<\\/a><\\/strong>\\nSelect any taxonomy (format: checkbox, radio or select)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/taxonomy-terms\\\">Taxonomy Terms<\\/a><\\/strong>\\nSelect any terms of any taxonomies, allow specific terms, level or childrens (format: checkbox or select). Terms can be loaded &amp; saved for the current post (just like the native ACF Taxonomy field)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/templates-selector\\\">Templates<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nDisplay an ACF Extended Templates selector as radio, checkbox or select field type.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/textarea\\\">Textarea<\\/a><\\/strong>\\nSwitch font family to monospace and allow tab indent.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/true-false\\\">True\\/False<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nFive new styles have been added to the native True\\/False field.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/user-roles\\\">User Roles<\\/a><\\/strong>\\nSelect any user role (format: checkbox, radio or select)<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/fields\\/wysiwyg-editor\\\">WYSIWYG Editor<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nNew settings allowing developers to have more control over the field behavior.<h3>&#x1f6e0;&#xfe0f; Modules<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-block-types\\\">Block Types UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Dynamic Block Types module allows you to register and manage ACF Block Types from your WordPress admin, in ACF &gt; Block Types menu. Pro version allows to sync Json\\/PHP files.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/classic-editor\\\">Classic Editor<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nACF Extended is bundled with a custom merged version of the Classic Editor &amp; Disable Gutenberg plugins.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/developer-mode\\\">Developer Mode<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Developer Mode allow you to view all Posts, Terms, Users &amp; Options custom metadata in a readable format. This feature is very useful to check what is actually saved in any WordPress Object.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-forms\\\">Forms<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nManage Advanced ACF Forms from the WordPress administration. This module is an enhanced version of the native ACF Form feature. While all native settings can be used, Dynamic Forms adds many new settings and introduce &quot;Actions&quot; for a complete control over the form behavior.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-options-pages\\\">Options Pages UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Dynamic Options Pages module allows you to register and manage ACF Options Pages from your WordPress admin, in ACF &gt; Options Pages menu. Pro version allows to sync Json\\/PHP files.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/performance-mode\\\">Performance Mode<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nA unique module that allows developers to optimize database load when dealing with hundreds or thousands of metadata with two different methods: Ultra &amp; Hybrid Engines.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-post-types\\\">Post Types UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Dynamic Post Types module allows you to register and manage custom post types from your WordPress admin, in Tools &gt; Post Types menu. Pro version allows to sync Json\\/PHP files.<\\/p>\\n<p>All native post types settings can be set within the UI. ACF Extended also adds more advanced settings allowing to manage posts per page, order etc\\u2026<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/rewrite-rules\\\">Rewrite Rules<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nGet an overview of all WordPress permalinks structures and rules. Test URLs, export rules and flush permalinks from the UI.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/scripts\\\">Scripts UI<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nRun custom scripts on thousands of posts. Including builtin &quot;Orphan Meta Cleaner&quot;, &quot;Script Launcher&quot; and &quot;Performance Converter&quot; scripts.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/settings-ui\\\">Settings UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Settings UI allows developers to get an overview of all ACF and ACF Extended settings values from the ACF &gt; Settings menu.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/dynamic-taxonomies\\\">Taxonomies UI<\\/a><\\/strong> <strong>(FREE \\/ PRO)<\\/strong>\\nThe Dynamic Taxonomies module allows you to register and manage custom taxonomies from your WordPress admin, in Tools &gt; Taxonomies menu. Pro version allows to sync Json\\/PHP files.<\\/p>\\n<p>All native taxonomies settings can be set within the UI. ACF Extended also adds more advanced settings allowing to manage posts per page, order etc\\u2026<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/modules\\/templates\\\">Templates<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nManage default ACF values in an advanced way and sync templates with Json\\/PHP files.<h3>&#x1f5a5;&#xfe0f; WordPress<\\/h3>\\n<strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/ajax-author-box\\\">Ajax Author Box<\\/a><\\/strong>\\nThe native WP Author Metabox has been replaced with an Ajax version allowing to manage thousands of users without slowing down the post administration. The new Author box also include an inline search input.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/enhanced-ui\\\">Enhanced UI<\\/a><\\/strong>\\nThe Taxonomy, User profile &amp; Settings views have been enhanced for a more consistent administration experience, using CSS\\/JS only.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/polylang\\\">Polylang<\\/a><\\/strong>\\nACF Extended adds a new layer of compatibility for Polylang. ACF Options Pages and all ACF Extended Modules (Dynamic Post Type, Taxonomy, Options Pages, Block Type) are compatible.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/screen-layouts\\\">Screen Layouts<\\/a><\\/strong> <strong>(PRO)<\\/strong>\\nPost Edit screens have been enhanced allowing up to 3 columns layout and multiple variations.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/wpml\\\">WPML<\\/a><\\/strong>\\nACF Extended adds a new layer of compatibility for WPML. ACF Options Pages and all ACF Extended Modules (Dynamic Post Type, Taxonomy, Options Pages, Block Type) are compatible.<\\/p>\\n<p><strong><a href=\\\"https:\\/\\/www.acf-extended.com\\/features\\/wordpress\\/options\\\">WP Options<\\/a><\\/strong>\\nManage WordPress Options from the Settings &gt; Options page. Options value (strings, serialized &amp; Json) will be displayed in a readable form. Values can be edited or deleted.<h3>&#x2764;&#xfe0f; Early Supporters<\\/h3><\\/p>\\n<ul>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/AsmussenBrandon\\\">Brandon A.<\\/a> for his support &amp; tests<\\/li>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/DamChtlv\\\">Damien C.<\\/a> for his support &amp; tests<\\/li>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/Val_Pellegrin\\\">Valentin P.<\\/a> for his support &amp; tests<\\/li>\\n<li>Thanks to Damian P. for his support &amp; tests<\\/li>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/jsaarenk\\\">Jaakko S.<\\/a> for his support &amp; tests<\\/li>\\n<li>Thanks to <a href=\\\"https:\\/\\/twitter.com\\/altendorfme\\\">Renan A.<\\/a> for his support &amp; tests<h3>&#x1f970; Donors<\\/h3><\\/li>\\n<li>Thanks to RavenSays<\\/li>\\n<li>Thanks to Dave A.<\\/li>\\n<li>Thanks to Rob H.<\\/li>\\n<li>Thanks to Valentin P.<\\/li>\\n<li>Thanks to Alan A.<\\/li>\\n<li>Thanks to Damian C.<\\/li>\\n<li>Thanks to Andrew<\\/li>\\n<li>Thanks to Kimantis<\\/li>\\n<li>Thanks to Anonymous<\\/li>\\n<li>Thanks to Chris<\\/li>\\n<li>Thanks to Dennis D.<\\/li>\\n<li>Thanks to Cody R.<\\/li>\\n<li>Thanks to Jamie<\\/li>\\n<li>Thanks to Dave A.<\\/li>\\n<li>Thanks to Paul M.<\\/li>\\n<li>Thanks to David B.<\\/li>\\n<li>Thanks to Swingjac<\\/li>\\n<li>Thanks to Erik<\\/li>\\n<li>Thanks to Giancarlo P.<\\/li>\\n<li>Thanks to Geuer M.<\\/li>\\n<\\/ul>\"],\"installation\":[\"<h4> Wordpress Install <\\/h4>\\n<ol>\\n<li>Install Advanced Custom Fields: Pro<\\/li>\\n<li>Upload the plugin files to the <code>\\/wp-content\\/plugins\\/acf-extended\\/<\\/code> directory, or install the plugin through the WordPress plugins screen directly.<\\/li>\\n<li>Activate the plugin through the \'Plugins\' screen in WordPress.<\\/li>\\n<li>Everything is ready!<\\/li>\\n<\\/ol>\"],\"changelog\":[\"<h4> 0.9.1.1 <\\/h4>\\n<p><strong>ACF Extended Pro 0.9.1.1:<\\/strong><\\/p>\\n<ul>\\n<li>Field Group: Fixed error in the Field Group UI with ACF 6.5+<\\/li>\\n<li>Field: Payment - Stripe gateway now use the wrapper text color as placeholder color<\\/li>\\n<li>Field: Post Object - Fixed &quot;Inline Post Edit&quot; feature with ACF 6.5+<\\/li>\\n<\\/ul>\\n<p><strong>ACF Extended Basic 0.9.1.1:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Flexible Content - Added compatibility with ACF 6.5+<\\/li>\\n<li>Field: Flexible Content - Legacy render style (ACF 6.4) is enforced to maintain compatibility<\\/li>\\n<li>Field: Flexible Content - New ACF 6.5 render style will be implemented in a future patch<\\/li>\\n<li>Field: Flexible Content - Fixed &quot;Dynamic Preview&quot; when displaying values with <code>acfe_form()<\\/code><\\/li>\\n<li>Field: Slug - Fixed PHP 8 warning during field validation<\\/li>\\n<li>Fields: Instructions Tooltip - Enhanced text sanitization to allow custom HTML<\\/li>\\n<li>Module: Form - Reset <code>$_FILES<\\/code> as <code>array()<\\/code> to respect PHP standards<\\/li>\\n<li>Module: Options Pages - moved to &quot;Tools&quot; WP admin menu to avoid confusion with ACF Options Pages<\\/li>\\n<li>Module: Performance - Fixed &quot;Save as Individual Meta&quot; regression on post creation<\\/li>\\n<li>Module: Performance - Fixed &quot;Save as Individual Meta&quot; revision restoration on an empty post<\\/li>\\n<li>Global: Fixed PHP 8 warning during initial setup<\\/li>\\n<li>Global: ACFE Modal - Small CSS tweaks<\\/li>\\n<li>Global: Added compatibility with ACF 6.5+<\\/li>\\n<\\/ul>\\n<h4> 0.9.1 <\\/h4>\\n<p><strong>ACF Extended Pro 0.9.1:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Flexible Content - Added &quot;Dynamic Preview Iframe&quot; feature<\\/li>\\n<li>Field: Flexible Content - Added &quot;Dynamic Preview Responsive&quot; feature<\\/li>\\n<li>Field: Flexible Content - &quot;Dynamic Preview Iframe&quot; render previews in isolated iframes<\\/li>\\n<li>Field: Flexible Content - &quot;Dynamic Preview Responsive&quot; allows to switch container preview size<\\/li>\\n<li>Field: Address - Cleaned unused argument<\\/li>\\n<li>Field: Google Map - Added <code>acfe_render_google_map()<\\/code> compatibility with sub fields<\\/li>\\n<li>Field: Google Map - Enhanced <code>acfe_render_google_map()<\\/code> compatibility with Dynamic Preview<\\/li>\\n<li>Field: Radio - Fixed &quot;Custom Choice&quot; render<\\/li>\\n<li>Field: WYSIWYG - Enhanced <code>source_code<\\/code> modal reset stylesheet<\\/li>\\n<li>Field Group Location: Renamed &quot;Dashboard&quot; to &quot;WP Dashboard&quot; for consistency<\\/li>\\n<li>Module: Forms - Ajax submission now redraw form on submission<\\/li>\\n<\\/ul>\\n<p><strong>ACF Extended Basic 0.9.1:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Advanced Link - Enhanced malformed values handling<\\/li>\\n<li>Field: Flexible Content - Added <code>acfe\\/flexible\\/toggle_hide<\\/code> filter to control row visibility<\\/li>\\n<li>Field: reCaptcha - Enhanced error handling when using incorrect API key<\\/li>\\n<li>Field: Taxonomy Terms - Fixed ajax nonce verification when field is cloned<\\/li>\\n<li>Module: Forms - Enhanced File\\/Image\\/Gallery &quot;Uploaded To&quot; logic using related Form Action<\\/li>\\n<\\/ul>\\n<h4> 0.9.0.9 <\\/h4>\\n<p><strong>ACF Extended Pro 0.9.0.9:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Address - Added new Address Field<\\/li>\\n<li>Field: Address - Allows to enter\\/search an address with autocomplete (Google Places API)<\\/li>\\n<li>Field: Color Picker - Added &quot;Return Format: Slug&quot; setting<\\/li>\\n<li>Field: Color Picker - Added &quot;Slug&quot; &amp; &quot;RGBA Array&quot; into the &quot;Color Array&quot; return format<\\/li>\\n<li>Field: Color Picker - Added compatibility with CSS variables for &quot;Palette&quot; display<\\/li>\\n<li>Field: Color Picker - Added <code>editor-gradient-presets<\\/code> theme support<\\/li>\\n<li>Field: Date Range Picker - Enhanced compatibility with custom hooks<\\/li>\\n<li>Field: Date Range Picker - Allowed to clear to input manually when &quot;Allow null&quot; is enabled<\\/li>\\n<li>Field: Date Range Picker - Added &quot;x&quot; icon to clear the input when &quot;Allow null&quot; is enabled<\\/li>\\n<li>Field: Date Range Picker - Added &quot;Prepend&quot; &amp; &quot;Append&quot; settings<\\/li>\\n<li>Field: Google Map - Added <code>acfe_render_google_map()<\\/code> helper to display a map on front-end<\\/li>\\n<li>Field: Google Map - Fixed ACF UI settings sync when interacting with the Map Preview<\\/li>\\n<\\/ul>\\n<p><strong>ACF Extended Basic 0.9.0.9:<\\/strong><\\/p>\\n<ul>\\n<li>Field: Flexible Content - Fixed <code>get_row()<\\/code> &amp; <code>get_row_layout()<\\/code> usage in WP Admin preview<\\/li>\\n<li>Field: Taxonomy Terms - Fixed ajax nonce compatibility with ACF 6.3.10<\\/li>\\n<li>Field Group: Small UI\\/CSS tweaks<\\/li>\\n<\\/ul>\\n<h4> Version History <\\/h4>\\n<p>Full Changelog: <a href=\\\"https:\\/\\/www.acf-extended.com\\/changelog\\\">https:\\/\\/www.acf-extended.com\\/changelog<\\/a><\\/p>\"],\"plugin\":\"acf-extended-pro\\/acf-extended.php\",\"id\":\"acf-extended-pro\\/acf-extended.php\"}\";}","off");

INSERT INTO `pcmdivi5options` VALUES 
("348","acfcdt_options","a:8:{s:9:\"immutable\";a:2:{s:8:\"json_dir\";s:100:\"/home/builtbypearlcity/divi5.builtbypearlcitymedia.com/wp-content/uploads/acf-custom-database-tables\";s:19:\"table_map_cache_dir\";s:107:\"/home/builtbypearlcity/divi5.builtbypearlcitymedia.com/wp-content/uploads/acf-custom-database-tables/.cache\";}s:29:\"store_acf_values_in_core_meta\";b:1;s:27:\"store_acf_keys_in_core_meta\";b:1;s:27:\"enable_join_tables_globally\";b:0;s:26:\"enable_sub_tables_globally\";b:0;s:29:\"enable_repeater_field_support\";b:0;s:34:\"enable_wp_all_import_plugin_compat\";b:0;s:16:\"activate_modules\";a:4:{s:17:\"integer_type_cast\";b:1;s:15:\"serialized_data\";b:0;s:25:\"after_table_schema_update\";b:0;s:21:\"intercept_run_control\";b:1;}}","on"),
("349","acfcdt-rebuild-map-system-upgrade-version","1628121600","auto"),
("356","acfcdt_license","1aef7441462c900b60ae03671aa902ed","auto"),
("359","acfcdt_license_status","valid","auto"),
("362","edd_sl_53ef1f12f654c767d057ea6f75adead4","a:2:{s:7:\"timeout\";i:1761089848;s:5:\"value\";s:12925:\"{\"new_version\":\"1.1.4\",\"stable_version\":\"1.1.4\",\"name\":\"ACF Custom Database Tables\",\"slug\":\"acf-custom-database-tables\",\"url\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-custom-database-tables\\/?changelog=1\",\"last_updated\":\"2023-12-20 00:59:51\",\"homepage\":\"https:\\/\\/hookturn.io\\/downloads\\/acf-custom-database-tables\\/\",\"package\":\"https:\\/\\/hookturn.io\\/edd-sl\\/package_download\\/MTc2MTIwNTA0ODoxYWVmNzQ0MTQ2MmM5MDBiNjBhZTAzNjcxYWE5MDJlZDo4ODA2OjRmN2Q5Y2UyMGFmYmRhNzI2NGE0OGY1ZmQzNTJiODA1Omh0dHBzQC8vZGl2aTUuYnVpbHRieXBlYXJsY2l0eW1lZGlhLmNvbTow\",\"download_link\":\"https:\\/\\/hookturn.io\\/edd-sl\\/package_download\\/MTc2MTIwNTA0ODoxYWVmNzQ0MTQ2MmM5MDBiNjBhZTAzNjcxYWE5MDJlZDo4ODA2OjRmN2Q5Y2UyMGFmYmRhNzI2NGE0OGY1ZmQzNTJiODA1Omh0dHBzQC8vZGl2aTUuYnVpbHRieXBlYXJsY2l0eW1lZGlhLmNvbTow\",\"sections\":{\"description\":\"\",\"changelog\":\"<p><strong>1.1.4<\\/strong><\\/p>\\n<p><em>Added<\\/em><\\/p>\\n<ul>\\n<li>Added REST API foundations to facilitate UI-driven tools.<\\/li>\\n<\\/ul>\\n<p><em>Fixed<\\/em><\\/p>\\n<ul>\\n<li>Compatibility fixes for ACF 6.1.0.<\\/li>\\n<li>Fixed incorrect display of post type in JSON update notice \\u2013 was previously showing `post` instead of the actual post type.<\\/li>\\n<\\/ul>\\n<p><strong>1.1.3<\\/strong><\\/p>\\n<p><em>Fixed<\\/em><\\/p>\\n<ul>\\n<li>Compatibility fixes for ACF 6.0.0.<\\/li>\\n<\\/ul>\\n<p><strong>1.1.2<\\/strong><\\/p>\\n<p><em>Changed<\\/em><\\/p>\\n<ul>\\n<li>Changed the intercept to get field values so that paginated repeaters work when core meta data storage is bypassed.<\\/li>\\n<\\/ul>\\n<p><strong>1.1.1<\\/strong><\\/p>\\n<p>A small interim release to improve compatibility with the latest versions of WordPress and PHP.<\\/p>\\n<p><em>Fixed<\\/em><\\/p>\\n<ul>\\n<li>Fixed deprecated return type issue in PHP 8.1.<\\/li>\\n<li>Fixed deprecation notices related to use of `readonly()` in WP 5.9 or greater.<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<p><em>Added<\\/em><\\/p>\\n<ul>\\n<li>Added plugin settings panel in WordPress admin.<\\/li>\\n<li>Added repeater field support. Repeater data can now be saved as encoded data to a single column or to a sub table. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/working-with-repeater-fields\\/\\\">Working with repeater fields<\\/a>.<\\/li>\\n<li>Added optional module for controlling a field\'s column data type. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/controlling-column-data-types\\/\\\">Controlling column data types<\\/a>.<\\/li>\\n<li>Added optional module for running custom handlers after each table schema is applied to the database. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/running-custom-actions-after-a-table-is-updated-or-created\\/\\\">Running custom actions after a table is updated or created<\\/a>.<\\/li>\\n<li>Added action hooks for disabling\\/enabling data intercepts to and\\/or from custom database tables. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/disabling-storage-or-retrieval-to-and-from-custom-database-tables\\/\\\">Disabling storage\\/retrieval to\\/from custom database tables<\\/a>.<\\/li>\\n<li>Added tools tab and a tool for rebuilding the table map system either in its entirety or by choosing specific field groups. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/rebuilding-the-map-system\\/\\\">Rebuilding the map system<\\/a>.<\\/li>\\n<li>Added an opt-in \'hotfix\' for WP All Import which forces critical hooks and filters to run during import. This improves compatibility with ACF Custom Database Tables. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/wp-all-import-compatibility\\/\\\">WP All Import compatibility<\\/a>.<\\/li>\\n<li>Added filters for controlling encode\\/decode behaviour for field values. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/overriding-default-field-value-encode-and-decode-behaviours\\/\\\">Overriding default field value encode and decode behaviours<\\/a>.<\\/li>\\n<li>Added filters for preventing deletion of custom table data. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/preventing-deletion-of-custom-table-data\\/\\\">Preventing deletion of custom table data<\\/a>.<\\/li>\\n<\\/ul>\\n<p><em>Changed<\\/em><\\/p>\\n<ul>\\n<li>Changed DB access handlers to prevent issues occurring on some Redis configurations.<\\/li>\\n<li>Enhanced automated test suite for much greater coverage and protection against regression.<\\/li>\\n<\\/ul>\\n<p><em>Fixed<\\/em><\\/p>\\n<ul>\\n<li>Fixed a bug where bypassed field names from one post type could affect core storage of another when updating both in the same process.<\\/li>\\n<li>Fixed an issue where default values on deprecated args cause notices in PHP 8.<\\/li>\\n<li>Fixed bug that allowed post revisions to interfere with removal of custom table data when deleting posts.<\\/li>\\n<\\/ul>\\n<p><em>Removed<\\/em><\\/p>\\n<ul>\\n<li>Removed core ACF `acf\\/update_value` duplicate filter. This is now replaced by `acfcdt\\/filter_value_before_update` filter.<\\/li>\\n<li>Removed core ACF `acf\\/load_value` duplicate filters and the `acfcdt\\/settings\\/allow_acf_load_value_filters` setting and filter.<\\/li>\\n<\\/ul>\\n<p><strong>1.0.5<\\/strong><\\/p>\\n<ul>\\n<li>FIX: Adjusted for ACF changes that prevented the creation of table definitions on field group save<\\/li>\\n<\\/ul>\\n<p><strong>1.0.4<\\/strong><\\/p>\\n<ul>\\n<li>FIX: Fixed an issue with path normalization for Windows-based servers<\\/li>\\n<li>FIX: Fixed a bug causing fatal errors when ACF JSON files were imported using ACF\'s \'Import Field Groups\' meta box<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>FIX:\\u00a0an issue where selecting the same post type across multiple <em>OR<\\/em> conditions on a field group\'s location rules deactivated the table meta box<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>FIX: an issue where leading zeros were being removed on save<\\/li>\\n<li>FIX: changed required capability for plugin settings page to match other ACF sub pages<\\/li>\\n<li>ADDED: filters that allow custom de\\/encoding of data being stored in custom tables<\\/li>\\n<li>ADDED: optional module for serializing stored data instead of JSON encoding. Disabled by default.<\\/li>\\n<li>ADDED: optional module for casting string based integers as integers before encoding. This is enabled by default and is the original functionality just moved to a module.<\\/li>\\n<\\/ul>\\n<p><strong>1.0.1<\\/strong><\\/p>\\n<ul>\\n<li>FIX: Fixed an issue that was causing errors on multisite network dashboard on plugin activation.<\\/li>\\n<li>FIX: Fixed an issue where table definition JSON files were causing \'table does not exist\' notices before triggering the database migration process.<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n\"},\"banners\":{\"high\":\"\",\"low\":\"\"},\"icons\":\"a:2:{s:2:\\\"1x\\\";s:79:\\\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/2023\\/05\\/acfcdt-product-image-128x128.jpg\\\";s:2:\\\"2x\\\";s:79:\\\"https:\\/\\/hookturn.io\\/wp-content\\/uploads\\/2023\\/05\\/acfcdt-product-image-256x256.jpg\\\";}\",\"description\":[\"\"],\"changelog\":[\"<p><strong>1.1.4<\\/strong><\\/p>\\n<p><em>Added<\\/em><\\/p>\\n<ul>\\n<li>Added REST API foundations to facilitate UI-driven tools.<\\/li>\\n<\\/ul>\\n<p><em>Fixed<\\/em><\\/p>\\n<ul>\\n<li>Compatibility fixes for ACF 6.1.0.<\\/li>\\n<li>Fixed incorrect display of post type in JSON update notice \\u2013 was previously showing `post` instead of the actual post type.<\\/li>\\n<\\/ul>\\n<p><strong>1.1.3<\\/strong><\\/p>\\n<p><em>Fixed<\\/em><\\/p>\\n<ul>\\n<li>Compatibility fixes for ACF 6.0.0.<\\/li>\\n<\\/ul>\\n<p><strong>1.1.2<\\/strong><\\/p>\\n<p><em>Changed<\\/em><\\/p>\\n<ul>\\n<li>Changed the intercept to get field values so that paginated repeaters work when core meta data storage is bypassed.<\\/li>\\n<\\/ul>\\n<p><strong>1.1.1<\\/strong><\\/p>\\n<p>A small interim release to improve compatibility with the latest versions of WordPress and PHP.<\\/p>\\n<p><em>Fixed<\\/em><\\/p>\\n<ul>\\n<li>Fixed deprecated return type issue in PHP 8.1.<\\/li>\\n<li>Fixed deprecation notices related to use of `readonly()` in WP 5.9 or greater.<\\/li>\\n<\\/ul>\\n<p><strong>1.1.0<\\/strong><\\/p>\\n<p><em>Added<\\/em><\\/p>\\n<ul>\\n<li>Added plugin settings panel in WordPress admin.<\\/li>\\n<li>Added repeater field support. Repeater data can now be saved as encoded data to a single column or to a sub table. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/working-with-repeater-fields\\/\\\">Working with repeater fields<\\/a>.<\\/li>\\n<li>Added optional module for controlling a field\'s column data type. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/controlling-column-data-types\\/\\\">Controlling column data types<\\/a>.<\\/li>\\n<li>Added optional module for running custom handlers after each table schema is applied to the database. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/running-custom-actions-after-a-table-is-updated-or-created\\/\\\">Running custom actions after a table is updated or created<\\/a>.<\\/li>\\n<li>Added action hooks for disabling\\/enabling data intercepts to and\\/or from custom database tables. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/disabling-storage-or-retrieval-to-and-from-custom-database-tables\\/\\\">Disabling storage\\/retrieval to\\/from custom database tables<\\/a>.<\\/li>\\n<li>Added tools tab and a tool for rebuilding the table map system either in its entirety or by choosing specific field groups. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/rebuilding-the-map-system\\/\\\">Rebuilding the map system<\\/a>.<\\/li>\\n<li>Added an opt-in \'hotfix\' for WP All Import which forces critical hooks and filters to run during import. This improves compatibility with ACF Custom Database Tables. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/wp-all-import-compatibility\\/\\\">WP All Import compatibility<\\/a>.<\\/li>\\n<li>Added filters for controlling encode\\/decode behaviour for field values. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/overriding-default-field-value-encode-and-decode-behaviours\\/\\\">Overriding default field value encode and decode behaviours<\\/a>.<\\/li>\\n<li>Added filters for preventing deletion of custom table data. See <a href=\\\"https:\\/\\/hookturn.io\\/docs\\/acf-custom-database-tables\\/1.1\\/preventing-deletion-of-custom-table-data\\/\\\">Preventing deletion of custom table data<\\/a>.<\\/li>\\n<\\/ul>\\n<p><em>Changed<\\/em><\\/p>\\n<ul>\\n<li>Changed DB access handlers to prevent issues occurring on some Redis configurations.<\\/li>\\n<li>Enhanced automated test suite for much greater coverage and protection against regression.<\\/li>\\n<\\/ul>\\n<p><em>Fixed<\\/em><\\/p>\\n<ul>\\n<li>Fixed a bug where bypassed field names from one post type could affect core storage of another when updating both in the same process.<\\/li>\\n<li>Fixed an issue where default values on deprecated args cause notices in PHP 8.<\\/li>\\n<li>Fixed bug that allowed post revisions to interfere with removal of custom table data when deleting posts.<\\/li>\\n<\\/ul>\\n<p><em>Removed<\\/em><\\/p>\\n<ul>\\n<li>Removed core ACF `acf\\/update_value` duplicate filter. This is now replaced by `acfcdt\\/filter_value_before_update` filter.<\\/li>\\n<li>Removed core ACF `acf\\/load_value` duplicate filters and the `acfcdt\\/settings\\/allow_acf_load_value_filters` setting and filter.<\\/li>\\n<\\/ul>\\n<p><strong>1.0.5<\\/strong><\\/p>\\n<ul>\\n<li>FIX: Adjusted for ACF changes that prevented the creation of table definitions on field group save<\\/li>\\n<\\/ul>\\n<p><strong>1.0.4<\\/strong><\\/p>\\n<ul>\\n<li>FIX: Fixed an issue with path normalization for Windows-based servers<\\/li>\\n<li>FIX: Fixed a bug causing fatal errors when ACF JSON files were imported using ACF\'s \'Import Field Groups\' meta box<\\/li>\\n<\\/ul>\\n<p><strong>1.0.3<\\/strong><\\/p>\\n<ul>\\n<li>FIX:\\u00a0an issue where selecting the same post type across multiple <em>OR<\\/em> conditions on a field group\'s location rules deactivated the table meta box<\\/li>\\n<\\/ul>\\n<p><strong>1.0.2<\\/strong><\\/p>\\n<ul>\\n<li>FIX: an issue where leading zeros were being removed on save<\\/li>\\n<li>FIX: changed required capability for plugin settings page to match other ACF sub pages<\\/li>\\n<li>ADDED: filters that allow custom de\\/encoding of data being stored in custom tables<\\/li>\\n<li>ADDED: optional module for serializing stored data instead of JSON encoding. Disabled by default.<\\/li>\\n<li>ADDED: optional module for casting string based integers as integers before encoding. This is enabled by default and is the original functionality just moved to a module.<\\/li>\\n<\\/ul>\\n<p><strong>1.0.1<\\/strong><\\/p>\\n<ul>\\n<li>FIX: Fixed an issue that was causing errors on multisite network dashboard on plugin activation.<\\/li>\\n<li>FIX: Fixed an issue where table definition JSON files were causing \'table does not exist\' notices before triggering the database migration process.<\\/li>\\n<\\/ul>\\n<p>&nbsp;<\\/p>\\n\"]}\";}","off"),
("369","atai_db_version","1.1.1","auto"),
("370","atai_public","yes","auto"),
("377","atai_woo_marketplace","no","auto"),
("378","atai_api_key","ad7025a8c09d0b7143974bdb71d85815","auto"),
("379","atai_model_name","","auto"),
("380","atai_ecomm","no","auto"),
("383","atai_update_title","yes","auto"),
("384","atai_update_caption","yes","auto"),
("385","atai_update_description","yes","auto"),
("386","atai_gpt_prompt","Refine the following alt text to meet WCAG accessibility standards. Ensure clarity, concise wording, and image relevance: {{AltText}}","auto"),
("395","ws_menu_editor","a:30:{s:22:\"hide_advanced_settings\";b:1;s:16:\"show_extra_icons\";b:0;s:11:\"custom_menu\";N;s:19:\"custom_network_menu\";N;s:18:\"first_install_time\";i:1747677407;s:21:\"display_survey_notice\";b:1;s:17:\"plugin_db_version\";i:140;s:24:\"security_logging_enabled\";b:0;s:17:\"menu_config_scope\";s:6:\"global\";s:13:\"plugin_access\";s:14:\"manage_options\";s:15:\"allowed_user_id\";N;s:28:\"plugins_page_allowed_user_id\";N;s:27:\"show_deprecated_hide_button\";b:1;s:37:\"dashboard_hiding_confirmation_enabled\";b:1;s:21:\"submenu_icons_enabled\";s:9:\"if_custom\";s:22:\"force_custom_dashicons\";b:1;s:16:\"ui_colour_scheme\";s:7:\"classic\";s:13:\"visible_users\";a:0:{}s:23:\"show_plugin_menu_notice\";b:0;s:20:\"unused_item_position\";s:8:\"relative\";s:23:\"unused_item_permissions\";s:9:\"unchanged\";s:15:\"error_verbosity\";i:2;s:25:\"optimize_custom_menu_size\";b:1;s:20:\"compress_custom_menu\";b:0;s:28:\"delete_orphan_actor_settings\";b:1;s:20:\"wpml_support_enabled\";b:1;s:24:\"bbpress_override_enabled\";b:0;s:20:\"deep_nesting_enabled\";N;s:24:\"was_nesting_ever_changed\";b:0;s:16:\"is_active_module\";a:1:{s:19:\"highlight-new-menus\";b:0;}}","auto"),
("410","atai_error_logs","- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=16&#038;action=edit\" target=\"_blank\">Image #16</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=17&#038;action=edit\" target=\"_blank\">Image #17</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=18&#038;action=edit\" target=\"_blank\">Image #18</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=19&#038;action=edit\" target=\"_blank\">Image #19</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=20&#038;action=edit\" target=\"_blank\">Image #20</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=21&#038;action=edit\" target=\"_blank\">Image #21</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=22&#038;action=edit\" target=\"_blank\">Image #22</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=23&#038;action=edit\" target=\"_blank\">Image #23</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=24&#038;action=edit\" target=\"_blank\">Image #24</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=25&#038;action=edit\" target=\"_blank\">Image #25</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=26&#038;action=edit\" target=\"_blank\">Image #26</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=27&#038;action=edit\" target=\"_blank\">Image #27</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=28&#038;action=edit\" target=\"_blank\">Image #28</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=29&#038;action=edit\" target=\"_blank\">Image #29</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=30&#038;action=edit\" target=\"_blank\">Image #30</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=31&#038;action=edit\" target=\"_blank\">Image #31</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=32&#038;action=edit\" target=\"_blank\">Image #32</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=33&#038;action=edit\" target=\"_blank\">Image #33</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=34&#038;action=edit\" target=\"_blank\">Image #34</a>: Unsupported extension. (zip)<br>- <a href=\"https://divi5.builtbypearlcitymedia.com/wp-admin/post.php?post=38&#038;action=edit\" target=\"_blank\">Image #38</a>: Unsupported extension. (zip)<br>","auto"),
("423","gf_db_version","2.9.20","off"),
("424","rg_form_version","2.9.20","off"),
("425","gform_enable_background_updates","1","auto"),
("426","auto_update_plugins","a:1:{i:0;s:29:\"gravityforms/gravityforms.php\";}","off"),
("427","rg_gforms_default_theme","orbital","off"),
("428","rg_form_original_version","2.9.1.2","off"),
("429","_site_transient_t15s-registry-gforms","O:8:\"stdClass\":2:{s:8:\"projects\";a:59:{s:26:\"gravityformsactivecampaign\";a:1:{s:12:\"translations\";a:26:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T14:15:16+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:17+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T07:57:07+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:15:47+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:32+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:31:49+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:41+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:05+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-10-09T08:22:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:30+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-24T15:09:35+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-05T14:57:46+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T14:59:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T06:44:05+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:11+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T15:58:58+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:07+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T13:27:41+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T17:58:14+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T19:24:04+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T12:47:21+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T21:18:28+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T22:29:04+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformsactivecampaign/gravityformsactivecampaign-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsaweber\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T14:35:08+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T08:03:28+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T11:19:40+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:50+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:50+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T07:37:20+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T15:24:00+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2023-08-16T11:26:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-24T15:14:51+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:09:53+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-04-01T06:34:42+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:56:34+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-18T18:10:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-04-02T13:44:34+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-29T17:52:10+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-20T19:27:52+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-19T12:51:04+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-27T15:08:02+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.2.1\";s:7:\"updated\";s:25:\"2025-03-30T22:22:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsaweber/gravityformsaweber-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformsagilecrm\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T14:37:01+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T08:01:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T11:18:14+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:32+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:09+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:11+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T08:36:16+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T10:24:04+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:53+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-06T16:56:35+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-24T15:13:08+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T15:05:10+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-04-01T06:35:45+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T15:45:37+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:20+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-04-02T13:43:17+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-29T17:54:16+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-20T19:26:30+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-19T12:49:31+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-30T21:23:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2025-03-30T22:24:10+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsagilecrm/gravityformsagilecrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:24:\"gravityformsauthorizenet\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2024-03-20T12:51:36+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-12-28T11:16:35+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2024-09-12T11:38:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-29T15:48:18+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-19T11:05:17+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-19T11:04:01+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-03-02T20:29:58+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-10-21T11:50:09+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:37+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:39+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:45+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-03-14T17:38:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2021-09-13T20:54:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-12-17T15:01:32+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-12-17T15:53:58+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:49+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T16:57:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-01-06T08:01:53+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2020-11-05T09:28:49+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:6:\"2.11.1\";s:7:\"updated\";s:25:\"2023-11-09T01:30:51+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsauthorizenet/gravityformsauthorizenet-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsbatchbook\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2024-03-20T12:53:19+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2022-06-27T09:51:40+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:14:25+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:20+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:36+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:39+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:29:48+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:24+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:41+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-01-22T16:00:21+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:48+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-03-14T17:40:37+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:41+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:47+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:30:05+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T11:30:11+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T16:58:32+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-10-21T18:08:50+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T08:02:59+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-09T01:26:27+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsbatchbook/gravityformsbatchbook-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsbreeze\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T14:38:33+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T08:03:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T11:20:05+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T07:33:49+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T09:21:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T16:59:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-24T15:15:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T15:11:29+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-01T06:33:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T16:04:19+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:39+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-02T13:45:16+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-29T17:49:19+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-20T19:28:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T12:53:20+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-27T15:05:01+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-30T22:19:44+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsbreeze/gravityformsbreeze-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:27:\"gravityformscampaignmonitor\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T14:38:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2024-11-09T11:58:24+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T08:04:30+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T11:20:27+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:00:49+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T07:37:42+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T09:21:49+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2020-10-27T15:32:58+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-24T15:16:23+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T15:12:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-04-01T06:33:17+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T16:04:53+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-04-02T13:45:29+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-29T18:51:09+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-20T16:43:56+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-19T13:16:17+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-27T15:04:34+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.1.1\";s:7:\"updated\";s:25:\"2025-03-30T22:52:50+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformscampaignmonitor/gravityformscampaignmonitor-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformscampfire\";a:1:{s:12:\"translations\";a:24:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2024-03-20T12:55:41+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:21+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:39+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:01:41+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:51+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:30+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:34+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2022-06-27T09:53:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:01:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-02-18T11:26:09+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-01-22T16:22:19+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:47+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-14T17:44:01+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:59+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:55+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:58+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:44:01+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2019-12-10T11:43:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-01-06T17:02:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2020-02-13T09:15:04+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.2.2\";s:7:\"updated\";s:25:\"2023-11-09T01:41:12+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformscampfire/gravityformscampfire-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformscapsulecrm\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T14:41:03+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:26+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T08:05:52+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:21:13+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:33+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2022-06-27T08:52:42+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2022-06-27T08:52:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:07+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T10:25:08+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T09:22:00+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-01-06T17:03:14+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-24T15:18:53+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:20:01+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-01T06:33:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T16:07:43+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:40:30+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T13:46:44+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T18:53:38+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T19:29:19+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T13:18:09+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T21:28:54+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T22:52:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformscapsulecrm/gravityformscapsulecrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:26:\"gravityformschainedselects\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2024-03-26T11:38:44+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-04-14T18:06:58+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-11-20T07:22:44+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-01-06T17:04:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:57:33+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:39:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:39:05+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:56:33+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:40:25+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T14:50:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2021-09-13T21:00:54+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T15:03:03+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-12-17T15:55:04+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-11-04T16:40:51+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-01-06T17:04:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-21T17:43:40+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2020-10-27T15:55:51+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.1\";s:7:\"updated\";s:25:\"2023-11-10T01:29:52+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformschainedselects/gravityformschainedselects-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformscleverreach\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T14:41:52+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T08:06:48+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:21:40+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:54:38+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:54:39+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:05:28+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:38:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:22:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:05:34+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-24T15:20:44+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T15:25:49+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T06:43:20+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:06:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T18:40:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T13:47:12+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-29T18:54:26+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-20T19:29:40+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T13:19:11+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T21:26:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T22:50:24+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformscleverreach/gravityformscleverreach-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformscoupons\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T14:42:29+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-23T19:14:14+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T08:07:30+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T11:27:01+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-03-02T20:27:34+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T07:38:40+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-19T09:23:19+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-01-06T17:06:49+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-26T15:44:36+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T15:26:41+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-04-02T06:34:19+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2023-11-03T10:13:14+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T16:05:15+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:36+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2024-09-08T00:13:14+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-29T19:00:30+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-20T16:43:37+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-22T07:24:43+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-27T15:06:38+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.5.1\";s:7:\"updated\";s:25:\"2025-03-30T22:45:00+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformscoupons/gravityformscoupons-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsdropbox\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T16:09:14+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2024-09-02T08:18:20+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T14:46:04+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T11:28:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:56:15+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:07:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T10:35:31+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-19T09:23:32+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2022-06-27T08:56:26+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-26T15:45:53+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T15:34:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-04-02T06:33:50+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2023-11-03T10:13:15+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T16:02:05+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-18T18:40:58+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-04-02T15:53:32+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-29T19:16:51+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-20T20:05:17+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-22T07:26:02+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-30T21:31:44+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.3.1\";s:7:\"updated\";s:25:\"2025-03-30T22:44:36+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsdropbox/gravityformsdropbox-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsemma\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T16:12:50+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:14+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:01:29+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:29:52+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:50+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:51+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:54+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:56+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T09:23:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T14:10:58+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-26T15:49:47+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:49:44+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T06:32:04+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:14+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:50:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:41:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T15:29:12+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T19:14:52+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T20:16:33+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-22T07:29:16+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T06:27:41+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T22:41:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsemma/gravityformsemma-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformsfreshbooks\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2024-03-20T13:24:54+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:49+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:29+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-02-20T14:36:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2020-10-21T11:51:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:52+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:11+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:13+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:19+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-03-14T17:49:01+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2021-09-14T09:32:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2020-12-17T15:53:03+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:39+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:09:59+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2021-02-08T11:26:17+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-01-06T17:10:44+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"2.8\";s:7:\"updated\";s:25:\"2023-11-29T02:21:29+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsfreshbooks/gravityformsfreshbooks-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformsgetresponse\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T16:13:42+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T15:03:09+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:30:45+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:58:09+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:58:11+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:13+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:40:50+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:24:14+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2023-01-06T17:11:18+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-26T15:50:57+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:08:44+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T07:37:54+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:02:48+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-18T18:45:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-04-02T15:55:20+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-29T19:12:36+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-20T20:06:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-22T07:29:56+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T21:24:10+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.9.0\";s:7:\"updated\";s:25:\"2025-03-30T22:39:14+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgetresponse/gravityformsgetresponse-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformshelpscout\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2024-03-20T13:26:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-24T07:42:04+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-11T17:38:30+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2022-06-27T09:58:40+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2022-06-27T09:58:42+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:19+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-25T16:20:17+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:08+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2020-11-05T09:45:35+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:27+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:32+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-03-14T17:50:31+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-28T21:10:33+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:48+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-25T23:03:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-10-20T06:44:18+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:12:15+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2021-11-04T18:39:39+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-01-06T17:13:00+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.0.1\";s:7:\"updated\";s:25:\"2023-11-29T02:37:34+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformshelpscout/gravityformshelpscout-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformshighrise\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2024-03-20T13:28:49+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2022-06-27T09:59:10+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:14:26+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:12+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:45+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:21+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:25+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:27+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2020-07-17T13:47:39+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:18+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:33+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:35+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-03-14T17:51:12+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:52+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:54+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:52+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2019-12-10T12:56:56+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:13:23+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2021-08-02T17:30:03+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-01-06T17:14:05+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.3\";s:7:\"updated\";s:25:\"2023-11-19T23:28:15+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformshighrise/gravityformshighrise-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformshipchat\";a:1:{s:12:\"translations\";a:25:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2024-03-20T13:29:15+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:44+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2022-06-27T10:00:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:50+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:25+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:00+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:04+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:11+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-03-02T20:33:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-10-21T13:28:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:57+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:58:55+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-02-21T12:24:57+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-01-25T07:46:44+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:18+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-03-14T17:51:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:23+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-01-06T17:14:57+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-01-06T17:14:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:32+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2019-12-10T12:59:06+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2021-08-02T17:31:33+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2020-02-13T09:22:17+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.2\";s:7:\"updated\";s:25:\"2023-11-19T23:25:08+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshipchat/gravityformshipchat-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsmadmimi\";a:1:{s:12:\"translations\";a:34:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-20T13:31:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:17+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:27+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:32+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:22+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:07+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:20+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:06+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2020-10-21T11:52:31+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:26+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-09-25T12:09:30+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:110:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:27+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:49+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:52+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:13+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:30+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-03-14T17:52:56+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:15+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-10-02T10:46:06+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:11+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2020-12-17T15:55:55+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:47+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sr\";a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:14:16+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-03T10:11:53+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:15:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2021-08-02T17:35:32+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:16:24+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-11-09T01:39:35+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmadmimi/gravityformsmadmimi-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsmailchimp\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2024-03-20T13:32:12+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-24T12:41:33+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:15+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2022-06-27T08:43:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-03-02T20:28:02+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-25T16:35:54+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:39+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:57+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-17T13:48:34+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:05+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-02-04T16:58:16+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-03T10:13:13+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-28T21:13:27+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:19+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2021-10-25T23:02:38+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:25+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:16:47+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:29+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-01-06T17:17:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.7.2\";s:7:\"updated\";s:25:\"2023-11-25T20:33:22+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsmailchimp/gravityformsmailchimp-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:26:\"gravityformspartialentries\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-23T11:07:56+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-04-14T17:10:56+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-02-20T14:31:15+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-09T11:58:41+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-26T19:03:02+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:21+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-09T11:31:43+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-10-21T13:19:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:17:46+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-09-25T12:09:31+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-10-17T13:38:00+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:03+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:05+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2024-11-08T17:21:07+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:12+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-12-17T14:50:15+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2021-09-14T09:48:18+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:24+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-12-17T15:55:24+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:18:31+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-01-06T17:17:54+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2021-08-02T17:40:09+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2020-11-05T09:27:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:115:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.8\";s:7:\"updated\";s:25:\"2023-11-25T20:27:12+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspartialentries/gravityformspartialentries-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:29:\"gravityformspaypalpaymentspro\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2024-03-20T13:33:43+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-12-28T11:16:35+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-11-26T19:04:21+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:08:48+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2022-06-23T19:13:42+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-03-02T20:27:35+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-03-24T14:22:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:07:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:09:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:10+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:08:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-03-14T17:54:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-09-14T09:52:47+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:29+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-12-17T14:13:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:10:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2020-11-05T13:09:09+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2021-09-29T18:02:03+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-01-06T17:19:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:121:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"2.7\";s:7:\"updated\";s:25:\"2023-11-25T20:24:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:118:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpaymentspro/gravityformspaypalpaymentspro-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformspaypal\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2024-03-20T15:01:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:51+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-23T19:13:23+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-27T10:05:05+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-03-02T20:27:35+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2020-10-21T11:52:44+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:19:55+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:13+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:15+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-03-14T17:54:51+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2021-09-14T09:52:14+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2020-12-17T15:54:54+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:40+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:03+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2021-09-29T18:06:04+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-01-06T17:20:46+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"3.5\";s:7:\"updated\";s:25:\"2023-12-01T23:37:46+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformspaypal/gravityformspaypal-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformspaypalpro\";a:1:{s:12:\"translations\";a:30:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2024-03-23T14:15:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-04-15T14:48:04+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-28T11:11:03+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-28T11:16:36+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-02T20:50:54+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:59:29+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:46+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:30+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:02+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:55:18+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:52+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-03-24T11:58:48+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:56:58+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-30T13:48:05+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:112:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-09-25T12:58:34+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-10-17T13:40:59+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-04-29T16:41:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-01-27T16:56:20+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-02T20:50:29+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-03-14T17:55:20+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2019-12-10T13:19:22+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-09-14T09:53:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:53:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:54:40+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:57:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-05-13T16:56:26+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2021-11-04T18:47:08+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2020-04-29T16:42:28+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.4\";s:7:\"updated\";s:25:\"2023-12-01T23:55:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformspaypalpro/gravityformspaypalpro-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformspolls\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-03-20T15:15:58+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-11-27T04:51:47+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:15:31+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:10+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:12+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2022-06-27T09:09:20+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-03-02T20:51:24+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-10-21T13:43:25+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:13:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:24+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:17:13+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:32+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-03-14T17:55:58+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2021-09-14T09:55:19+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-12-17T14:20:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-12-17T14:19:33+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-11-05T15:18:45+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-01-06T17:22:14+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2021-11-04T18:52:05+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2020-06-29T08:29:29+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2023-12-02T00:08:37+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformspolls/gravityformspolls-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformspostmark\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-24T12:00:03+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-27T04:54:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-24T11:44:53+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T09:11:37+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-25T21:03:26+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-31T19:40:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-03-29T18:54:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-22T09:30:48+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-26T12:48:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-04T08:26:03+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-09-14T09:55:49+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-31T04:01:04+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-04-11T21:20:33+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-20T16:53:54+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-01T17:59:01+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-06-05T06:35:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2021-05-26T23:45:38+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-25T20:16:29+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformspostmark/gravityformspostmark-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsquiz\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-07T08:40:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T12:15:00+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-06T18:20:38+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:14+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:15+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:15+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:12+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T15:15:27+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-19T07:49:40+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-07-10T08:01:13+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-26T10:46:55+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T20:51:56+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-10-02T06:51:05+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-10T10:06:05+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-06T19:10:38+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-11T23:20:43+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-15T19:21:44+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-24T12:53:46+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-22T19:36:46+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-17T09:14:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.3.1\";s:7:\"updated\";s:25:\"2024-09-15T19:21:20+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsquiz/gravityformsquiz-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformssignature\";a:1:{s:12:\"translations\";a:25:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T16:17:23+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-02-20T14:32:41+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-06-27T10:11:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-24T08:43:38+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T11:44:44+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2024-11-09T11:33:00+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2021-08-12T08:00:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-03-02T20:55:38+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T07:42:56+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-19T09:28:09+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2023-03-02T20:55:40+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-26T16:52:40+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2024-09-02T08:48:32+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:56:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-04-02T07:03:50+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T16:06:03+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-18T19:08:56+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-04-02T16:07:30+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-29T18:33:52+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-20T16:45:25+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-22T07:55:39+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-30T12:11:45+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.9.0\";s:7:\"updated\";s:25:\"2025-03-30T23:01:49+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformssignature/gravityformssignature-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformsslack\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T16:18:46+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-04-14T18:11:09+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-24T08:44:34+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:45:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:26:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T07:48:34+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:27:59+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:26:48+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-26T16:52:08+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:57:49+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T07:03:12+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:08:17+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T22:09:43+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T15:58:47+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T18:35:17+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T16:49:20+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-22T07:56:35+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T21:31:04+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-31T00:49:49+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsslack/gravityformsslack-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsstripe\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:57+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:01+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:01+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:02+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:00+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:57+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:14:01+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:59+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:58+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.9.2\";s:7:\"updated\";s:25:\"2025-06-05T08:13:58+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsstripe/gravityformsstripe-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformssurvey\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T15:11:13+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-04-14T18:14:00+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-09-02T08:43:26+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-23T19:14:15+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T05:58:48+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-15T15:32:19+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2022-06-23T19:13:41+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-03-02T20:57:55+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-19T08:50:27+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-28T10:17:54+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-09-25T12:51:08+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2023-10-17T13:14:03+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2020-11-06T13:17:26+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-01T11:10:01+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-11-08T17:20:20+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-19T16:32:17+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-01T05:03:07+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-18T10:41:56+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-21T23:00:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-31T22:09:46+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T22:24:23+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-25T10:52:40+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-04-02T20:12:15+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T18:41:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.2.2\";s:7:\"updated\";s:25:\"2024-03-20T22:24:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssurvey/gravityformssurvey-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformstrello\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T16:47:20+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2024-09-02T08:18:24+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T13:28:46+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T11:53:16+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:45+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:29:56+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T15:26:43+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-19T09:27:15+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2023-01-06T17:30:03+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-26T16:54:51+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T17:00:57+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T06:56:40+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T16:04:33+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:14+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-04-02T16:08:09+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-29T18:29:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-20T20:39:11+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-22T08:10:53+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-27T15:04:50+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.0\";s:7:\"updated\";s:25:\"2025-03-30T23:00:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstrello/gravityformstrello-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformstwilio\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T16:46:45+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T13:28:16+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T11:53:28+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-05T16:46:39+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2022-06-27T09:02:55+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:31:07+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T15:26:24+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-19T09:27:02+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2023-01-06T17:31:12+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-27T09:14:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T17:01:55+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-04-02T06:56:24+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T16:03:43+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-18T22:10:21+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-04-02T16:07:47+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-29T18:29:10+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-20T20:39:39+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-22T08:11:15+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-27T15:05:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.1.1\";s:7:\"updated\";s:25:\"2025-03-30T23:00:32+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformstwilio/gravityformstwilio-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:28:\"gravityformsuserregistration\";a:1:{s:12:\"translations\";a:23:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T16:46:08+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2024-09-02T08:18:21+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-01-06T17:32:56+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-24T08:49:32+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T11:54:15+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2022-06-27T10:16:33+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2022-06-27T10:16:36+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-01-06T17:32:11+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2023-03-02T20:28:46+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-10-07T07:40:48+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2024-03-29T13:44:16+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2021-03-29T19:18:41+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-27T09:23:57+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-19T19:34:41+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-04-02T06:56:06+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-18T15:47:00+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-18T22:32:36+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-04-02T16:03:40+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-29T18:28:28+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-20T21:04:43+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-22T08:12:58+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-30T21:30:15+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:119:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"5.3.3\";s:7:\"updated\";s:25:\"2025-03-30T23:00:05+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:116:\"https://packages.translationspress.com/rocketgenius/gravityformsuserregistration/gravityformsuserregistration-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformszapier\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T16:50:44+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T13:22:40+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:55:18+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:29+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:32+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:18:39+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:19:39+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T09:26:32+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:33:24+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-27T09:12:38+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-19T19:38:52+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-04-02T06:53:00+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:27:45+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:46+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-04-02T15:19:59+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-29T18:24:13+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-20T20:59:29+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-22T08:15:36+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-30T21:16:01+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"4.5.0\";s:7:\"updated\";s:25:\"2025-03-30T22:56:56+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformszapier/gravityformszapier-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformszohocrm\";a:1:{s:12:\"translations\";a:20:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T16:54:27+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T13:18:24+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T11:56:01+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-27T09:02:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:55:23+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:34:25+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:16:09+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T09:26:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:34:31+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-27T09:09:58+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T19:41:21+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T06:52:06+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:23:21+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:50+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T16:06:20+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-29T18:20:53+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-20T19:57:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-22T20:46:20+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-30T21:27:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-30T22:55:02+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformszohocrm/gravityformszohocrm-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformsicontact\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T18:08:34+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:03+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:10:50+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T11:33:12+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:08+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:09+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:14+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T08:17:20+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-19T15:27:13+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-05T13:49:17+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-26T15:57:01+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T16:22:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T07:37:34+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T15:35:16+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-18T18:37:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-04-02T13:55:43+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-29T19:22:07+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-20T20:31:53+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-22T07:43:57+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-30T06:22:23+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.8.0\";s:7:\"updated\";s:25:\"2025-03-31T01:10:39+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformsicontact/gravityformsicontact-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:24:\"gravityformsemailoctopus\";a:1:{s:12:\"translations\";a:21:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T18:11:07+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T14:47:14+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T11:29:03+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:55:23+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:36:53+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T07:40:08+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-19T09:23:47+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2020-06-23T13:15:54+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-26T15:46:55+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:37:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-04-02T06:32:30+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:17+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:49:45+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-18T18:41:01+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-04-02T15:22:11+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-29T19:01:57+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-20T20:06:00+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-22T07:27:27+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-30T21:16:40+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:111:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2025-03-30T22:42:48+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:108:\"https://packages.translationspress.com/rocketgenius/gravityformsemailoctopus/gravityformsemailoctopus-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsmailgun\";a:1:{s:12:\"translations\";a:24:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-07T08:52:25+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:11:02+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T10:02:12+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-13T09:22:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T08:15:20+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:14:06+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T08:34:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2022-06-27T10:01:47+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-12-28T11:13:16+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-03-02T20:46:07+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-06T12:42:42+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T11:37:35+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2023-01-06T17:38:07+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-04T17:13:38+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-15T07:35:12+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-24T06:29:14+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-06T09:42:12+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-23T16:10:35+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-19T21:36:35+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-09T14:20:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-15T21:52:07+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-22T17:42:52+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-17T22:15:18+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.0\";s:7:\"updated\";s:25:\"2024-05-09T14:20:57+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsmailgun/gravityformsmailgun-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformssendgrid\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-24T14:25:24+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-02-20T14:31:16+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-23T19:14:16+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-26T19:07:24+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:05:56+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-29T15:47:02+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-27T09:11:37+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-03-15T13:30:44+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2022-06-23T19:13:43+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-03-02T20:27:36+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-10-21T13:18:39+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:06:48+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-01-26T16:08:21+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:110:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-07-04T20:05:08+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-06-28T10:45:00+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:12:16+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-05-23T18:18:20+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:07:21+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-03T10:13:12+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2021-09-14T09:57:06+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-12-17T14:33:12+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-12-17T14:32:57+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:06:16+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-04T22:55:46+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-11-06T09:05:23+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2020-05-15T07:53:36+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.0\";s:7:\"updated\";s:25:\"2023-11-09T01:37:59+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformssendgrid/gravityformssendgrid-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformssquare\";a:1:{s:12:\"translations\";a:19:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T18:16:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T13:35:08+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:46:46+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:13:12+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2022-06-27T09:13:16+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:23:16+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-19T09:27:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:16:17+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-27T09:21:10+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T16:59:25+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-04-02T07:01:53+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:48:44+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-18T22:33:22+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-04-02T15:50:24+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-29T19:04:48+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-20T20:38:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-22T07:58:10+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-30T21:22:34+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.5.0\";s:7:\"updated\";s:25:\"2025-03-31T00:48:40+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformssquare/gravityformssquare-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformshubspot\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2024-03-20T15:34:55+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-11-24T12:35:05+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2024-09-12T12:00:41+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2022-06-27T09:00:32+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-11-09T10:59:10+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-20T14:30:42+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-01-06T17:41:22+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-05T15:02:53+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-15T15:57:06+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-18T06:09:23+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-11-28T21:19:11+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-22T18:52:51+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-05T17:03:26+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-10T17:12:37+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-16T22:26:43+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-06-30T06:42:49+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-05-11T14:43:07+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.2.1\";s:7:\"updated\";s:25:\"2023-11-29T02:47:06+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformshubspot/gravityformshubspot-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformsppcp\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-20T09:43:02+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-24T08:39:31+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-19T11:42:24+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-19T08:05:07+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-19T15:27:49+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2024-09-02T08:18:52+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-27T09:33:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-18T16:49:14+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-04-02T07:11:31+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-18T15:55:09+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-18T22:09:33+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-04-02T15:41:01+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-29T19:12:01+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-20T20:49:21+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-22T07:53:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-30T21:19:19+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"3.9.1\";s:7:\"updated\";s:25:\"2025-03-31T00:55:53+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformsppcp/gravityformsppcp-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:18:\"gravityformsmollie\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-20T09:54:21+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-24T08:31:12+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-19T11:37:44+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2022-06-27T10:02:53+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-19T11:25:58+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-19T15:27:31+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2020-11-01T09:59:43+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-26T16:05:40+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-18T16:40:16+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-04-02T07:26:23+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-18T15:38:26+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-18T22:09:21+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-04-02T14:07:13+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-29T19:29:35+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-20T20:45:27+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-22T07:49:31+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-30T06:25:21+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:99:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:7:\"1.7.0.1\";s:7:\"updated\";s:25:\"2025-03-31T01:02:22+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityformsmollie/gravityformsmollie-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityforms2checkout\";a:1:{s:12:\"translations\";a:22:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-20T10:16:35+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-05T13:57:22+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T07:54:21+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T11:14:58+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-23T19:13:29+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2022-06-23T19:15:48+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-02-19T14:45:46+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2023-03-02T20:27:36+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:03:54+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:17+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2021-02-02T19:49:22+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-24T15:08:16+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T14:56:03+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T06:46:34+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T15:44:09+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:01+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-04-02T13:25:30+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-29T18:06:04+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-20T19:20:42+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-19T12:45:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-30T21:13:17+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.4.0\";s:7:\"updated\";s:25:\"2025-03-31T00:53:30+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityforms2checkout/gravityforms2checkout-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:32:\"gravityformsadvancedpostcreation\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-20T10:20:12+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:11+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2023-01-06T17:46:19+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-19T07:59:59+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-19T11:17:39+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-11-09T11:31:18+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:13+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:14+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:17+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:12:01+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-19T09:20:42+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-05T15:04:19+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-24T15:11:42+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-09-02T08:46:48+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-18T15:02:17+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-04-01T06:36:29+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-18T16:00:21+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-18T18:39:12+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-04-02T13:40:55+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-11-09T11:39:19+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-29T17:55:50+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sr\";a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-11-09T11:50:56+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-11-08T16:08:06+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-20T19:25:36+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-19T12:52:48+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-30T21:32:16+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:127:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2025-03-30T22:26:15+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:124:\"https://packages.translationspress.com/rocketgenius/gravityformsadvancedpostcreation/gravityformsadvancedpostcreation-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:20:\"gravityformswebhooks\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-20T10:21:50+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2024-09-02T08:43:58+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T13:23:06+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T11:54:33+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T15:20:05+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T09:26:39+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2023-01-06T17:46:51+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-27T09:13:30+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-19T19:35:52+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-02T06:53:13+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T16:04:03+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-18T22:10:34+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-04-02T16:07:59+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-29T18:25:08+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-20T20:40:00+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-22T08:13:16+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-27T15:05:11+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:103:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.7.0\";s:7:\"updated\";s:25:\"2025-03-30T22:57:21+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:100:\"https://packages.translationspress.com/rocketgenius/gravityformswebhooks/gravityformswebhooks-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:16:\"gravityformspipe\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-20T10:25:04+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-24T08:41:11+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-19T11:43:50+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-19T07:54:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-19T09:25:47+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2020-11-01T10:02:06+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-26T16:53:58+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-18T16:53:29+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-04-02T07:06:11+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-18T15:57:52+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-18T19:08:44+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-04-02T15:45:06+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-29T18:32:41+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-20T20:36:52+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-22T07:54:52+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-30T21:26:13+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:95:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.4.1\";s:7:\"updated\";s:25:\"2025-03-30T23:03:42+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:92:\"https://packages.translationspress.com/rocketgenius/gravityformspipe/gravityformspipe-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:27:\"gravityformsconstantcontact\";a:1:{s:12:\"translations\";a:27:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2024-05-07T08:20:57+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:11:18+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2024-09-02T08:18:23+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:14:28+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-16T07:57:41+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2024-09-12T11:46:56+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2022-06-27T08:55:20+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2022-06-27T08:55:23+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:00:49+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:12:06+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2020-10-21T11:36:30+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:48:43+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:11:27+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:00+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2020-10-25T15:55:38+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:12:17+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:07+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-03-14T17:46:28+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-03T10:13:13+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:20+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:22+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:24+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2020-10-29T05:29:40+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:48:51+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2020-10-23T18:56:46+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-01-06T17:49:39+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:117:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:3:\"1.5\";s:7:\"updated\";s:25:\"2023-11-09T01:53:49+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:114:\"https://packages.translationspress.com/rocketgenius/gravityformsconstantcontact/gravityformsconstantcontact-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:12:\"gravityforms\";a:1:{s:12:\"translations\";a:32:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T14:40:20+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"bg\";a:7:{s:8:\"language\";s:5:\"bg_BG\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-05T10:47:56+00:00\";s:12:\"english_name\";s:9:\"Bulgarian\";s:11:\"native_name\";s:18:\"Български\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-bg_BG.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"bg\";i:1;s:3:\"bul\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T21:14:24+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-08-14T12:30:56+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:5:\"zh-hk\";a:7:{s:8:\"language\";s:5:\"zh_HK\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-05T10:49:15+00:00\";s:12:\"english_name\";s:19:\"Chinese (Hong Kong)\";s:11:\"native_name\";s:16:\"香港中文版	\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-zh_HK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T15:13:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-17T11:09:32+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T21:28:30+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-15T14:33:52+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-15T06:20:10+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T15:25:52+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:5:\"fr-ca\";a:7:{s:8:\"language\";s:5:\"fr_CA\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-08-14T12:31:00+00:00\";s:12:\"english_name\";s:15:\"French (Canada)\";s:11:\"native_name\";s:19:\"Français du Canada\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-fr_CA.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fr\";i:1;s:3:\"fra\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-17T15:20:06+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-17T12:57:21+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:9:\"de/formal\";a:7:{s:8:\"language\";s:12:\"de_DE_formal\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T15:28:05+00:00\";s:12:\"english_name\";s:15:\"German (Formal)\";s:11:\"native_name\";s:13:\"Deutsch (Sie)\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-de_DE_formal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:14:\"de-ch/informal\";a:7:{s:8:\"language\";s:14:\"de_CH_informal\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2023-09-25T13:01:31+00:00\";s:12:\"english_name\";s:30:\"German (Switzerland, Informal)\";s:11:\"native_name\";s:21:\"Deutsch (Schweiz, Du)\";s:7:\"package\";s:96:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-de_CH_informal.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:5:\"de-ch\";a:7:{s:8:\"language\";s:5:\"de_CH\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-05T10:48:01+00:00\";s:12:\"english_name\";s:20:\"German (Switzerland)\";s:11:\"native_name\";s:17:\"Deutsch (Schweiz)\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-de_CH.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T21:03:01+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T15:12:41+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"hu\";a:7:{s:8:\"language\";s:5:\"hu_HU\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T20:41:14+00:00\";s:12:\"english_name\";s:9:\"Hungarian\";s:11:\"native_name\";s:6:\"Magyar\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-hu_HU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hu\";i:1;s:3:\"hun\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T19:47:39+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T15:17:02+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"nb\";a:7:{s:8:\"language\";s:5:\"nb_NO\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-05T10:48:59+00:00\";s:12:\"english_name\";s:19:\"Norwegian (Bokmål)\";s:11:\"native_name\";s:13:\"Norsk bokmål\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-nb_NO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nb\";i:1;s:3:\"nob\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T16:49:31+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-21T01:39:45+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-17T16:49:39+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T15:49:23+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sk\";a:7:{s:8:\"language\";s:5:\"sk_SK\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-03-18T08:14:12+00:00\";s:12:\"english_name\";s:6:\"Slovak\";s:11:\"native_name\";s:11:\"Slovenčina\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-sk_SK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sk\";i:1;s:3:\"slk\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-20T17:34:37+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-18T06:37:54+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T11:48:03+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:87:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:8:\"2.9.19.3\";s:7:\"updated\";s:25:\"2025-10-16T21:36:45+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:84:\"https://packages.translationspress.com/rocketgenius/gravityforms/gravityforms-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:21:\"gravityformsrecaptcha\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-20T13:53:42+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-24T08:42:51+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-19T11:44:18+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-19T07:42:11+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-19T09:26:04+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2021-06-02T13:26:50+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-24T15:22:17+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-18T16:55:31+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-04-02T07:04:32+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-18T16:03:07+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-18T19:08:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-04-02T15:57:11+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-29T18:36:18+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-20T16:45:05+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-22T07:55:19+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-30T21:25:15+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:105:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.0.2\";s:7:\"updated\";s:25:\"2025-03-30T23:02:23+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:102:\"https://packages.translationspress.com/rocketgenius/gravityformsrecaptcha/gravityformsrecaptcha-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformsmoderation\";a:1:{s:12:\"translations\";a:16:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-20T13:59:13+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-24T08:22:59+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-19T11:35:03+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-19T11:04:22+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-19T09:24:58+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-27T09:27:24+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-18T16:27:34+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-04-02T07:33:23+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-18T15:53:22+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-18T19:18:57+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-04-02T15:32:17+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-29T19:24:32+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-20T20:34:28+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-22T20:50:18+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-30T21:17:58+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.3.0\";s:7:\"updated\";s:25:\"2025-03-31T01:04:54+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsmoderation/gravityformsmoderation-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:23:\"gravityformsgeolocation\";a:1:{s:12:\"translations\";a:16:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-02-23T15:42:07+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-20T05:48:38+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-15T15:46:27+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-18T14:03:02+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-28T10:20:33+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-04-01T11:12:52+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-19T16:31:40+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-04-01T06:09:41+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-18T10:45:34+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-21T23:02:09+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-31T00:08:17+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-22T15:55:11+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-25T10:54:05+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-04-02T20:07:13+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-18T20:50:19+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:109:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.5.0\";s:7:\"updated\";s:25:\"2024-03-22T15:55:38+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:106:\"https://packages.translationspress.com/rocketgenius/gravityformsgeolocation/gravityformsgeolocation-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:31:\"gravityformsconversationalforms\";a:1:{s:12:\"translations\";a:18:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-09T10:30:04+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:122:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-09T08:14:49+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-06T18:14:22+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-05-03T08:43:40+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:122:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-23T12:50:51+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-19T07:05:45+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-05-03T08:43:45+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-26T10:39:25+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-17T20:46:11+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-10-03T06:51:46+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:122:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-10T11:39:42+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-17T16:16:24+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-08T00:11:41+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-15T21:52:57+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-24T12:54:32+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-22T19:39:55+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-17T09:13:03+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:125:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.6.3\";s:7:\"updated\";s:25:\"2024-09-15T21:52:23+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:122:\"https://packages.translationspress.com/rocketgenius/gravityformsconversationalforms/gravityformsconversationalforms-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:22:\"gravityformsconvertkit\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-20T15:22:27+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-19T08:12:59+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-19T11:26:33+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-19T07:33:00+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-19T15:26:57+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-05T14:03:37+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-26T15:43:54+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:58:29+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-04-02T06:42:58+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-18T15:32:27+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-18T18:18:49+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-04-02T14:41:29+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-29T19:00:05+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-20T20:26:46+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-22T07:21:27+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-30T06:26:31+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:107:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.2.1\";s:7:\"updated\";s:25:\"2025-03-30T22:50:03+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:104:\"https://packages.translationspress.com/rocketgenius/gravityformsconvertkit/gravityformsconvertkit-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:11:\"gravitysmtp\";a:1:{s:12:\"translations\";a:16:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:21+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:82:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:28+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:26+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:27+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:28+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:24+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:26+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:25+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:82:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:23+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:26+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:26+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:25+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:27+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:24+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:25+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:85:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"2.0.0\";s:7:\"updated\";s:25:\"2025-06-05T09:12:21+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:82:\"https://packages.translationspress.com/rocketgenius/gravitysmtp/gravitysmtp-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:19:\"gravityformsakismet\";a:1:{s:12:\"translations\";a:30:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-09T08:57:30+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"ca\";a:7:{s:8:\"language\";s:2:\"ca\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T16:10:43+00:00\";s:12:\"english_name\";s:7:\"Catalan\";s:11:\"native_name\";s:7:\"Català\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ca.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ca\";i:1;s:3:\"cat\";}}s:5:\"zh-cn\";a:7:{s:8:\"language\";s:5:\"zh_CN\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T15:43:04+00:00\";s:12:\"english_name\";s:15:\"Chinese (China)\";s:11:\"native_name\";s:12:\"简体中文\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-zh_CN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"zh\";i:1;s:3:\"zho\";}}s:2:\"cs\";a:7:{s:8:\"language\";s:5:\"cs_CZ\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T16:14:50+00:00\";s:12:\"english_name\";s:5:\"Czech\";s:11:\"native_name\";s:9:\"Čeština\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-cs_CZ.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"cs\";i:1;s:3:\"ces\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-13T09:10:58+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T18:50:14+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"nl-be\";a:7:{s:8:\"language\";s:5:\"nl_BE\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:41:44+00:00\";s:12:\"english_name\";s:15:\"Dutch (Belgium)\";s:11:\"native_name\";s:20:\"Nederlands (België)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-nl_BE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-au\";a:7:{s:8:\"language\";s:5:\"en_AU\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:44:15+00:00\";s:12:\"english_name\";s:19:\"English (Australia)\";s:11:\"native_name\";s:19:\"English (Australia)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-en_AU.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:45:19+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fi\";a:7:{s:8:\"language\";s:2:\"fi\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:41:21+00:00\";s:12:\"english_name\";s:7:\"Finnish\";s:11:\"native_name\";s:5:\"Suomi\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-fi.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fi\";i:1;s:3:\"fin\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-13T09:32:38+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-21T08:45:26+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"el\";a:7:{s:8:\"language\";s:2:\"el\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T16:14:11+00:00\";s:12:\"english_name\";s:5:\"Greek\";s:11:\"native_name\";s:16:\"Ελληνικά\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-el.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"el\";i:1;s:3:\"ell\";}}s:2:\"he\";a:7:{s:8:\"language\";s:5:\"he_IL\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:41:28+00:00\";s:12:\"english_name\";s:6:\"Hebrew\";s:11:\"native_name\";s:16:\"עִבְרִית\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-he_IL.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"he\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-08T12:27:32+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"id\";a:7:{s:8:\"language\";s:5:\"id_ID\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T10:41:34+00:00\";s:12:\"english_name\";s:10:\"Indonesian\";s:11:\"native_name\";s:16:\"Bahasa Indonesia\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-id_ID.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"id\";i:1;s:3:\"ind\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-15T07:17:28+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-24T04:38:07+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"fa\";a:7:{s:8:\"language\";s:5:\"fa_IR\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T16:08:07+00:00\";s:12:\"english_name\";s:7:\"Persian\";s:11:\"native_name\";s:10:\"فارسی\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-fa_IR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"fa\";i:1;s:3:\"fas\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-08T10:26:05+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-23T15:53:18+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-21T10:01:11+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ro\";a:7:{s:8:\"language\";s:5:\"ro_RO\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T15:42:58+00:00\";s:12:\"english_name\";s:8:\"Romanian\";s:11:\"native_name\";s:8:\"Română\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ro_RO.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ro\";i:1;s:3:\"ron\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-09T14:18:02+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"sr\";a:7:{s:8:\"language\";s:5:\"sr_RS\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T15:42:59+00:00\";s:12:\"english_name\";s:7:\"Serbian\";s:11:\"native_name\";s:23:\"Српски језик\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-sr_RS.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sr\";i:1;s:3:\"srp\";}}s:5:\"es-mx\";a:7:{s:8:\"language\";s:5:\"es_MX\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-07T15:42:48+00:00\";s:12:\"english_name\";s:16:\"Spanish (Mexico)\";s:11:\"native_name\";s:19:\"Español de México\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-es_MX.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-15T21:54:18+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-22T17:38:12+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-17T22:12:34+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:101:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.1.0\";s:7:\"updated\";s:25:\"2024-05-09T14:30:18+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:98:\"https://packages.translationspress.com/rocketgenius/gravityformsakismet/gravityformsakismet-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}s:17:\"gravityformsbrevo\";a:1:{s:12:\"translations\";a:17:{s:2:\"ar\";a:7:{s:8:\"language\";s:2:\"ar\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-20T08:53:39+00:00\";s:12:\"english_name\";s:6:\"Arabic\";s:11:\"native_name\";s:14:\"العربية\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-ar.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ar\";i:1;s:3:\"ara\";}}s:2:\"da\";a:7:{s:8:\"language\";s:5:\"da_DK\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-27T08:43:30+00:00\";s:12:\"english_name\";s:6:\"Danish\";s:11:\"native_name\";s:5:\"Dansk\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-da_DK.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"da\";i:1;s:3:\"dan\";}}s:2:\"nl\";a:7:{s:8:\"language\";s:5:\"nl_NL\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-19T11:09:26+00:00\";s:12:\"english_name\";s:5:\"Dutch\";s:11:\"native_name\";s:10:\"Nederlands\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-nl_NL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"nl\";i:1;s:3:\"nld\";}}s:5:\"en-gb\";a:7:{s:8:\"language\";s:5:\"en_GB\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-27T08:45:18+00:00\";s:12:\"english_name\";s:12:\"English (UK)\";s:11:\"native_name\";s:12:\"English (UK)\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-en_GB.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"en\";i:1;s:3:\"eng\";i:2;s:3:\"eng\";}}s:2:\"fr\";a:7:{s:8:\"language\";s:5:\"fr_FR\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-18T13:06:27+00:00\";s:12:\"english_name\";s:15:\"French (France)\";s:11:\"native_name\";s:9:\"Français\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-fr_FR.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"fr\";}}s:2:\"de\";a:7:{s:8:\"language\";s:5:\"de_DE\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-19T09:18:34+00:00\";s:12:\"english_name\";s:6:\"German\";s:11:\"native_name\";s:7:\"Deutsch\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-de_DE.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"de\";}}s:2:\"hi\";a:7:{s:8:\"language\";s:5:\"hi_IN\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-24T09:49:27+00:00\";s:12:\"english_name\";s:5:\"Hindi\";s:11:\"native_name\";s:18:\"हिन्दी\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-hi_IN.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"hi\";i:1;s:3:\"hin\";}}s:2:\"it\";a:7:{s:8:\"language\";s:5:\"it_IT\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-27T08:43:44+00:00\";s:12:\"english_name\";s:7:\"Italian\";s:11:\"native_name\";s:8:\"Italiano\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-it_IT.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"it\";i:1;s:3:\"ita\";}}s:2:\"ja\";a:7:{s:8:\"language\";s:2:\"ja\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-04-01T06:30:47+00:00\";s:12:\"english_name\";s:8:\"Japanese\";s:11:\"native_name\";s:9:\"日本語\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-ja.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"ja\";}}s:2:\"pl\";a:7:{s:8:\"language\";s:5:\"pl_PL\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-18T14:50:35+00:00\";s:12:\"english_name\";s:6:\"Polish\";s:11:\"native_name\";s:6:\"Polski\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-pl_PL.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pl\";i:1;s:3:\"pol\";}}s:5:\"pt-br\";a:7:{s:8:\"language\";s:5:\"pt_BR\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-18T19:08:05+00:00\";s:12:\"english_name\";s:19:\"Portuguese (Brazil)\";s:11:\"native_name\";s:20:\"Português do Brasil\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-pt_BR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"pt\";i:1;s:3:\"por\";}}s:2:\"pt\";a:7:{s:8:\"language\";s:5:\"pt_PT\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-23T08:49:53+00:00\";s:12:\"english_name\";s:21:\"Portuguese (Portugal)\";s:11:\"native_name\";s:10:\"Português\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-pt_PT.zip\";s:3:\"iso\";a:1:{i:0;s:2:\"pt\";}}s:2:\"ru\";a:7:{s:8:\"language\";s:5:\"ru_RU\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-23T08:50:10+00:00\";s:12:\"english_name\";s:7:\"Russian\";s:11:\"native_name\";s:14:\"Русский\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-ru_RU.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"ru\";i:1;s:3:\"rus\";}}s:2:\"es\";a:7:{s:8:\"language\";s:5:\"es_ES\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-04-02T09:03:11+00:00\";s:12:\"english_name\";s:15:\"Spanish (Spain)\";s:11:\"native_name\";s:8:\"Español\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-es_ES.zip\";s:3:\"iso\";a:3:{i:0;s:2:\"es\";i:1;s:3:\"spa\";i:2;s:3:\"spa\";}}s:2:\"sv\";a:7:{s:8:\"language\";s:5:\"sv_SE\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-19T13:13:56+00:00\";s:12:\"english_name\";s:7:\"Swedish\";s:11:\"native_name\";s:7:\"Svenska\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-sv_SE.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"sv\";i:1;s:3:\"swe\";}}s:2:\"tr\";a:7:{s:8:\"language\";s:5:\"tr_TR\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-27T15:03:10+00:00\";s:12:\"english_name\";s:7:\"Turkish\";s:11:\"native_name\";s:8:\"Türkçe\";s:7:\"package\";s:97:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-tr_TR.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"tr\";i:1;s:3:\"tur\";}}s:2:\"uk\";a:7:{s:8:\"language\";s:2:\"uk\";s:7:\"version\";s:5:\"1.0.0\";s:7:\"updated\";s:25:\"2025-03-23T08:50:23+00:00\";s:12:\"english_name\";s:9:\"Ukrainian\";s:11:\"native_name\";s:20:\"Українська\";s:7:\"package\";s:94:\"https://packages.translationspress.com/rocketgenius/gravityformsbrevo/gravityformsbrevo-uk.zip\";s:3:\"iso\";a:2:{i:0;s:2:\"uk\";i:1;s:3:\"ukr\";}}}}}s:13:\"_last_checked\";i:1761039617;}","off");

INSERT INTO `pcmdivi5options` VALUES 
("435","gravityformsaddon_gravityformswebapi_version","1.0","auto"),
("436","widget_gform_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("438","gform_version_info","a:12:{s:12:\"is_valid_key\";b:1;s:6:\"reason\";s:0:\"\";s:7:\"version\";s:6:\"2.9.20\";s:3:\"url\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.20.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=q8aKIKx%2B1XinRp5rYuS2CtGngEs%3D\";s:15:\"expiration_time\";i:1778847044;s:9:\"offerings\";a:70:{s:12:\"gravityforms\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:6:\"2.9.20\";s:14:\"version_latest\";s:8:\"2.9.20.1\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.20.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=q8aKIKx%2B1XinRp5rYuS2CtGngEs%3D\";s:10:\"url_latest\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.20.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=IyHHE7asnL2QdpwzRfB3VRoLQKI%3D\";}s:21:\"gravityforms2checkout\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:5:\"2.4.0\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/2checkout/gravityforms2checkout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=uwaVC5MkyjnBAJ2Agfbw7ind%2BqM%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/2checkout/gravityforms2checkout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=uwaVC5MkyjnBAJ2Agfbw7ind%2BqM%3D\";}s:26:\"gravityformsactivecampaign\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:5:\"2.2.0\";s:3:\"url\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/activecampaign/gravityformsactivecampaign_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=Lh30ar9Kw31Qg4WgZUNuO2JEaPQ%3D\";s:10:\"url_latest\";s:212:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/activecampaign/gravityformsactivecampaign_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=Lh30ar9Kw31Qg4WgZUNuO2JEaPQ%3D\";}s:32:\"gravityformsadvancedpostcreation\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:3:\"url\";s:230:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/advancedpostcreation/gravityformsadvancedpostcreation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=vr%2FsBFvECm%2F5%2FEJdXql2p18cUgc%3D\";s:10:\"url_latest\";s:230:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/advancedpostcreation/gravityformsadvancedpostcreation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=vr%2FsBFvECm%2F5%2FEJdXql2p18cUgc%3D\";}s:20:\"gravityformsagilecrm\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.0\";s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/agilecrm/gravityformsagilecrm_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=0TUJ5%2B9e2lBtaV2eTfZaCPEoB98%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/agilecrm/gravityformsagilecrm_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=0TUJ5%2B9e2lBtaV2eTfZaCPEoB98%3D\";}s:19:\"gravityformsakismet\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.0\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/akismet/gravityformsakismet_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=%2FAa9kgfvvjYoyPEGEVUpiC9J6cY%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/akismet/gravityformsakismet_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=%2FAa9kgfvvjYoyPEGEVUpiC9J6cY%3D\";}s:24:\"gravityformsauthorizenet\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:4:\"2.11\";s:14:\"version_latest\";s:4:\"2.11\";s:3:\"url\";s:209:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/authorizenet/gravityformsauthorizenet_2.11.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=362xq4XgbO7nERGeAJbxJv8q8%2BA%3D\";s:10:\"url_latest\";s:209:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/authorizenet/gravityformsauthorizenet_2.11.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=362xq4XgbO7nERGeAJbxJv8q8%2BA%3D\";}s:18:\"gravityformsaweber\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.2.0\";s:14:\"version_latest\";s:5:\"4.2.0\";s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/aweber/gravityformsaweber_4.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=5WWzc0JSdK%2BJvgX1SeCE0KAXjDM%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/aweber/gravityformsaweber_4.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=5WWzc0JSdK%2BJvgX1SeCE0KAXjDM%3D\";}s:21:\"gravityformsbatchbook\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/batchbook/gravityformsbatchbook_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=BxnRrit%2FVNaRkVrIH%2FHU4kbx3uE%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/batchbook/gravityformsbatchbook_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=BxnRrit%2FVNaRkVrIH%2FHU4kbx3uE%3D\";}s:18:\"gravityformsbreeze\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.7.0\";s:14:\"version_latest\";s:5:\"1.7.0\";s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/breeze/gravityformsbreeze_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=DrMcggQMKKgyPUKOsYl%2FtgFuVRg%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/breeze/gravityformsbreeze_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=DrMcggQMKKgyPUKOsYl%2FtgFuVRg%3D\";}s:17:\"gravityformsbrevo\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.0.0\";s:14:\"version_latest\";s:5:\"1.0.0\";s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/brevo/gravityformsbrevo_1.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=HEfvhoeaoCT0saNDRNYyzIEl7uE%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/brevo/gravityformsbrevo_1.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=HEfvhoeaoCT0saNDRNYyzIEl7uE%3D\";}s:27:\"gravityformscampaignmonitor\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.1.0\";s:14:\"version_latest\";s:5:\"4.1.0\";s:3:\"url\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campaignmonitor/gravityformscampaignmonitor_4.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=bGsJBNsKBWorIrFAVfXReuDEIug%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campaignmonitor/gravityformscampaignmonitor_4.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=bGsJBNsKBWorIrFAVfXReuDEIug%3D\";}s:20:\"gravityformscampfire\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.1\";s:14:\"version_latest\";s:5:\"1.2.2\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campfire/gravityformscampfire_1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=4gsSVYmIAOOnw9fSm3%2BUGXHQfBc%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/campfire/gravityformscampfire_1.2.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=58lkd6UMN%2BC2VTgoyrJDPZWHV3s%3D\";}s:22:\"gravityformscapsulecrm\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/capsulecrm/gravityformscapsulecrm_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=ExlTNUs%2FedgK%2BsPcsEvYBY29cGM%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/capsulecrm/gravityformscapsulecrm_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=ExlTNUs%2FedgK%2BsPcsEvYBY29cGM%3D\";}s:26:\"gravityformschainedselects\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:3:\"url\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/chainedselects/gravityformschainedselects_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=I0ll%2FzN42Qw0ZqTdZl9PpRNxFKY%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/chainedselects/gravityformschainedselects_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=I0ll%2FzN42Qw0ZqTdZl9PpRNxFKY%3D\";}s:23:\"gravityformscleverreach\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.9.0\";s:14:\"version_latest\";s:5:\"1.9.0\";s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cleverreach/gravityformscleverreach_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=wivaeigV1CSZi9sIAJnypHDronY%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cleverreach/gravityformscleverreach_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=wivaeigV1CSZi9sIAJnypHDronY%3D\";}s:15:\"gravityformscli\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:3:\"1.7\";s:3:\"url\";s:0:\"\";s:10:\"url_latest\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/cli/gravityformscli_1.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=lCpejVk3JGhH5CXrpwwWDpvpTXo%3D\";}s:27:\"gravityformsconstantcontact\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:3:\"url\";s:218:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/constantcontact/gravityformsconstantcontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=Wx0%2BI9gVJaxmdIo0Z%2FyZBEHwLKY%3D\";s:10:\"url_latest\";s:218:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/constantcontact/gravityformsconstantcontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=Wx0%2BI9gVJaxmdIo0Z%2FyZBEHwLKY%3D\";}s:31:\"gravityformsconversationalforms\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.3\";s:3:\"url\";s:224:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/conversationalforms/gravityformsconversationalforms_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=OtyXkmPwH%2Fl5x3qkoR8dUxA2kno%3D\";s:10:\"url_latest\";s:222:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/conversationalforms/gravityformsconversationalforms_1.6.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=tvlv4QufJzYvegxEdaMqky6mv8s%3D\";}s:22:\"gravityformsconvertkit\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.2.0\";s:14:\"version_latest\";s:5:\"1.2.0\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/convertkit/gravityformsconvertkit_1.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=L8jK81sRHddZ1AKWf5LI9zpIMqQ%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/convertkit/gravityformsconvertkit_1.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=L8jK81sRHddZ1AKWf5LI9zpIMqQ%3D\";}s:19:\"gravityformscoupons\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.5.0\";s:14:\"version_latest\";s:5:\"3.5.0\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/coupons/gravityformscoupons_3.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=TxfWbaLo%2ByG4Q07Fk43IdXCaJb0%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/coupons/gravityformscoupons_3.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=TxfWbaLo%2ByG4Q07Fk43IdXCaJb0%3D\";}s:17:\"gravityformsdebug\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:10:\"1.0.beta12\";s:3:\"url\";s:0:\"\";s:10:\"url_latest\";s:201:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/debug/gravityformsdebug_1.0.beta12.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=uGLcmeCerNlQ%2BNbgSVdQHkNMO88%3D\";}s:19:\"gravityformsdropbox\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.3.0\";s:14:\"version_latest\";s:5:\"3.3.0\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/dropbox/gravityformsdropbox_3.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=P%2FX%2Fnt7Rm%2Fiwjgy4Pw6O0YGVHfw%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/dropbox/gravityformsdropbox_3.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=P%2FX%2Fnt7Rm%2Fiwjgy4Pw6O0YGVHfw%3D\";}s:24:\"gravityformsemailoctopus\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emailoctopus/gravityformsemailoctopus_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=yKSZkiOWJGczRbqZDPQg7x6mr7A%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emailoctopus/gravityformsemailoctopus_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=yKSZkiOWJGczRbqZDPQg7x6mr7A%3D\";}s:16:\"gravityformsemma\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emma/gravityformsemma_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=T%2FDBDFUP0Dsp9GdW1LyoPWgYAjw%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/emma/gravityformsemma_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=T%2FDBDFUP0Dsp9GdW1LyoPWgYAjw%3D\";}s:22:\"gravityformsfreshbooks\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.8\";s:14:\"version_latest\";s:3:\"2.8\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/freshbooks/gravityformsfreshbooks_2.8.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=i1uo2eWGFi52%2BBe3xuB3yNJs5iM%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/freshbooks/gravityformsfreshbooks_2.8.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=i1uo2eWGFi52%2BBe3xuB3yNJs5iM%3D\";}s:23:\"gravityformsgeolocation\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/geolocation/gravityformsgeolocation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=N7TYy4dRJfAJJ%2FMPZLwPKeSUzAM%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/geolocation/gravityformsgeolocation_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=N7TYy4dRJfAJJ%2FMPZLwPKeSUzAM%3D\";}s:23:\"gravityformsgetresponse\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.9.0\";s:14:\"version_latest\";s:5:\"1.9.0\";s:3:\"url\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/getresponse/gravityformsgetresponse_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=LIJp0rbBfhWoSdQXTgTTgYXLALQ%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/getresponse/gravityformsgetresponse_1.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=LIJp0rbBfhWoSdQXTgTTgYXLALQ%3D\";}s:27:\"gravityformsgoogleanalytics\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:5:\"2.4.0\";s:3:\"url\";s:220:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/googleanalytics/gravityformsgoogleanalytics_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=IE0zD4TICJhqN%2B%2BrWDV6BAg%2B8Y0%3D\";s:10:\"url_latest\";s:220:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/googleanalytics/gravityformsgoogleanalytics_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=IE0zD4TICJhqN%2B%2BrWDV6BAg%2B8Y0%3D\";}s:21:\"gravityformsgutenberg\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"1.0-rc-1.4\";s:14:\"version_latest\";s:10:\"1.0-rc-1.5\";s:3:\"url\";s:209:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/gutenberg/gravityformsgutenberg_1.0-rc-1.4.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=7owTE6ObcVMvMzFpb0SaJI%2BN3Uc%3D\";s:10:\"url_latest\";s:209:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/gutenberg/gravityformsgutenberg_1.0-rc-1.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=fb5AjzYJuXRBobP7au5jx%2Bg0FhE%3D\";}s:21:\"gravityformshelpscout\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:5:\"2.4.0\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/helpscout/gravityformshelpscout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=3It1ftVBxzQ5sT3%2BuqbOUNpbfWM%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/helpscout/gravityformshelpscout_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=3It1ftVBxzQ5sT3%2BuqbOUNpbfWM%3D\";}s:20:\"gravityformshighrise\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:3:\"1.3\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/highrise/gravityformshighrise_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=sHI3rSwQq6rs%2Bj96yAgEH9yM5wM%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/highrise/gravityformshighrise_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=sHI3rSwQq6rs%2Bj96yAgEH9yM5wM%3D\";}s:19:\"gravityformshipchat\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"1.2\";s:14:\"version_latest\";s:3:\"1.2\";}s:19:\"gravityformshubspot\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.3.0\";s:14:\"version_latest\";s:5:\"2.3.1\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/hubspot/gravityformshubspot_2.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=4P0iHwLfC%2Fh0TnNCNcQgJ1w5CpI%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/hubspot/gravityformshubspot_2.3.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=pmw0BzYsnHL5coathSB69C19%2BDo%3D\";}s:20:\"gravityformsicontact\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/icontact/gravityformsicontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=CMlvCCeJrYrh9ZnpKzpKLOaslko%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/icontact/gravityformsicontact_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=CMlvCCeJrYrh9ZnpKzpKLOaslko%3D\";}s:19:\"gravityformslogging\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"1.3\";s:14:\"version_latest\";s:5:\"1.3.1\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/logging/gravityformslogging_1.3.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=pCs%2B1xTjzH554fi%2FnB4pGQERYDI%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/logging/gravityformslogging_1.3.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=8k9WT%2FpIg7QMxehiWYYJdFcg3XM%3D\";}s:19:\"gravityformsmadmimi\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.5.0\";s:14:\"version_latest\";s:5:\"1.5.0\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/madmimi/gravityformsmadmimi_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=HvVVLhSVqKf1iHY%2BgHjRWoGVol4%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/madmimi/gravityformsmadmimi_1.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=HvVVLhSVqKf1iHY%2BgHjRWoGVol4%3D\";}s:21:\"gravityformsmailchimp\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.7.0\";s:14:\"version_latest\";s:5:\"5.7.1\";s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailchimp/gravityformsmailchimp_5.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=lOD0YkCnPCWbcR1EXr9QwD1b1Mw%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailchimp/gravityformsmailchimp_5.7.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=5QXl1YKOOOuUYeIoqTJYG0rKr2o%3D\";}s:22:\"gravityformsmailerlite\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.1\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailerlite/gravityformsmailerlite_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=740khjM6kJ5kvOTov1wGJIPvPHE%3D\";s:10:\"url_latest\";s:206:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailerlite/gravityformsmailerlite_1.1.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=3G85VjRdUJSPV%2FD28pjlyTIEcLY%3D\";}s:19:\"gravityformsmailgun\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailgun/gravityformsmailgun_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=S5awQ0ksvigLeklfVkHk2MfI97g%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mailgun/gravityformsmailgun_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=S5awQ0ksvigLeklfVkHk2MfI97g%3D\";}s:22:\"gravityformsmoderation\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.3.0\";s:14:\"version_latest\";s:5:\"1.3.0\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/moderation/gravityformsmoderation_1.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=4s4eKRC4hl4cfiVxKc85Xhu6tAk%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/moderation/gravityformsmoderation_1.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=4s4eKRC4hl4cfiVxKc85Xhu6tAk%3D\";}s:18:\"gravityformsmollie\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mollie/gravityformsmollie_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=WojZiHDkiUhvZcpqvYUFL%2BN5hFU%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/mollie/gravityformsmollie_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=WojZiHDkiUhvZcpqvYUFL%2BN5hFU%3D\";}s:26:\"gravityformspartialentries\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.0\";s:14:\"version_latest\";s:5:\"1.8.0\";s:3:\"url\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/partialentries/gravityformspartialentries_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=iQbg6tK1yU4WwhjsSr%2FestwDpPI%3D\";s:10:\"url_latest\";s:214:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/partialentries/gravityformspartialentries_1.8.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=iQbg6tK1yU4WwhjsSr%2FestwDpPI%3D\";}s:18:\"gravityformspaypal\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"3.5\";s:14:\"version_latest\";s:3:\"3.5\";s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypal/gravityformspaypal_3.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=%2Fv6Z5VDW3Gbx3LRXaaaOEKNpmmY%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypal/gravityformspaypal_3.5.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=%2Fv6Z5VDW3Gbx3LRXaaaOEKNpmmY%3D\";}s:33:\"gravityformspaypalexpresscheckout\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:0:\"\";s:14:\"version_latest\";s:0:\"\";}s:29:\"gravityformspaypalpaymentspro\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:3:\"2.7\";s:14:\"version_latest\";s:3:\"2.7\";s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpaymentspro/gravityformspaypalpaymentspro_2.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=n6Y2lxFiCRUrSUyJs4wBlphDHFg%3D\";s:10:\"url_latest\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpaymentspro/gravityformspaypalpaymentspro_2.7.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=n6Y2lxFiCRUrSUyJs4wBlphDHFg%3D\";}s:21:\"gravityformspaypalpro\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.8.1\";s:14:\"version_latest\";s:5:\"1.8.4\";s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpro/gravityformspaypalpro_1.8.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=O83PHqwumwVCGizGNUKzN3KPQ78%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/paypalpro/gravityformspaypalpro_1.8.4.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=4vsrjB9nabmq2RrFCvFBoLCTkb0%3D\";}s:20:\"gravityformspicatcha\";a:3:{s:12:\"is_available\";b:0;s:7:\"version\";s:3:\"2.0\";s:14:\"version_latest\";s:3:\"2.0\";}s:16:\"gravityformspipe\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:3:\"url\";s:192:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/pipe/gravityformspipe_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=8WGztBeWpBRYQVwtT7dLTIA94W4%3D\";s:10:\"url_latest\";s:192:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/pipe/gravityformspipe_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=8WGztBeWpBRYQVwtT7dLTIA94W4%3D\";}s:17:\"gravityformspolls\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.3.0\";s:14:\"version_latest\";s:5:\"4.3.1\";s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/polls/gravityformspolls_4.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=bi0jta%2FqI9lkYU0I8%2FY6NxRQeBQ%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/polls/gravityformspolls_4.3.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=DydKtw89t%2FchWaI4UCbjStab5nA%3D\";}s:20:\"gravityformspostmark\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:3:\"url\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/postmark/gravityformspostmark_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=VitziyxBhum1wPFF3JOjv8RSP9s%3D\";s:10:\"url_latest\";s:200:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/postmark/gravityformspostmark_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=VitziyxBhum1wPFF3JOjv8RSP9s%3D\";}s:16:\"gravityformsppcp\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.9.0\";s:14:\"version_latest\";s:5:\"3.9.0\";s:3:\"url\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/ppcp/gravityformsppcp_3.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=ruZV%2B8IMMS5z9mqEqe4SXWEhcV4%3D\";s:10:\"url_latest\";s:194:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/ppcp/gravityformsppcp_3.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=ruZV%2B8IMMS5z9mqEqe4SXWEhcV4%3D\";}s:16:\"gravityformsquiz\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.3.0\";s:14:\"version_latest\";s:5:\"4.3.0\";s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/quiz/gravityformsquiz_4.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=jxgZ5sRrRhW%2BSlJKN2MUmw%2Bl9Yk%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/quiz/gravityformsquiz_4.3.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=jxgZ5sRrRhW%2BSlJKN2MUmw%2Bl9Yk%3D\";}s:21:\"gravityformsrecaptcha\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.0.0\";s:14:\"version_latest\";s:5:\"2.0.2\";s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/recaptcha/gravityformsrecaptcha_2.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=gVZFr3STZo1xOi9yPlD6ogobPzE%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/recaptcha/gravityformsrecaptcha_2.0.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=7DDxQnWr%2BqJzWSX0CTYKz5VnHxk%3D\";}s:19:\"gravityformsrestapi\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:10:\"2.0-beta-2\";s:14:\"version_latest\";s:10:\"2.0-beta-2\";s:3:\"url\";s:205:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/restapi/gravityformsrestapi_2.0-beta-2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=wymmjDSUJv%2FlJ9leOoDdFKkUxoA%3D\";s:10:\"url_latest\";s:205:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/restapi/gravityformsrestapi_2.0-beta-2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=wymmjDSUJv%2FlJ9leOoDdFKkUxoA%3D\";}s:22:\"gravityformssalesforce\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.1.0\";s:14:\"version_latest\";s:5:\"1.1.0\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/salesforce/gravityformssalesforce_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=Okju1HeRt2JthhmVlYcfuvYwLjc%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/salesforce/gravityformssalesforce_1.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=Okju1HeRt2JthhmVlYcfuvYwLjc%3D\";}s:20:\"gravityformssendgrid\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.6.0\";s:14:\"version_latest\";s:5:\"1.6.0\";s:3:\"url\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/sendgrid/gravityformssendgrid_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=jLicbiOqR8IT2mU%2FE3w45D34K%2FA%3D\";s:10:\"url_latest\";s:204:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/sendgrid/gravityformssendgrid_1.6.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=jLicbiOqR8IT2mU%2FE3w45D34K%2FA%3D\";}s:21:\"gravityformssignature\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.9.0\";s:14:\"version_latest\";s:5:\"4.9.0\";s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/signature/gravityformssignature_4.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=ubkZ57x671CqC0F00Dv6b2uE9yU%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/signature/gravityformssignature_4.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=ubkZ57x671CqC0F00Dv6b2uE9yU%3D\";}s:17:\"gravityformsslack\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:5:\"2.2.0\";s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/slack/gravityformsslack_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=pthGjkMEXWl4pVYD%2Br7OTTrqpHs%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/slack/gravityformsslack_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=pthGjkMEXWl4pVYD%2Br7OTTrqpHs%3D\";}s:18:\"gravityformssquare\";a:6:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.5.0\";s:14:\"version_latest\";s:5:\"2.5.0\";s:20:\"minimum_requirements\";a:0:{}s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/square/gravityformssquare_2.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=AKh7cospaQhQ3QoNSPhi9tKY9%2FA%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/square/gravityformssquare_2.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=AKh7cospaQhQ3QoNSPhi9tKY9%2FA%3D\";}s:18:\"gravityformsstripe\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.9.0\";s:14:\"version_latest\";s:5:\"5.9.2\";s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/stripe/gravityformsstripe_5.9.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=ORw45lLSF3X8KXgBR7F3ci4T230%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/stripe/gravityformsstripe_5.9.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=zgkVi2TBGGwlc5gKd9c9TRGW7AU%3D\";}s:18:\"gravityformssurvey\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.2.1\";s:14:\"version_latest\";s:5:\"4.2.2\";s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/survey/gravityformssurvey_4.2.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=8ZWtVMfyZt6eBFfWt5ecqBZh%2BWA%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/survey/gravityformssurvey_4.2.2.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=bTlWfJjX2zQB0ItDC2Ksf3IANaE%3D\";}s:18:\"gravityformstrello\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.2.0\";s:14:\"version_latest\";s:5:\"2.2.0\";s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/trello/gravityformstrello_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=kJlYb8Wna1ChmBtw50dUjC2CHik%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/trello/gravityformstrello_2.2.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=kJlYb8Wna1ChmBtw50dUjC2CHik%3D\";}s:21:\"gravityformsturnstile\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.4.0\";s:14:\"version_latest\";s:5:\"1.4.0\";s:3:\"url\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/turnstile/gravityformsturnstile_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=boWt7fjKbr%2Fols6x8Qcd%2FWw%2Fip4%3D\";s:10:\"url_latest\";s:208:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/turnstile/gravityformsturnstile_1.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=boWt7fjKbr%2Fols6x8Qcd%2FWw%2Fip4%3D\";}s:18:\"gravityformstwilio\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"3.1.0\";s:14:\"version_latest\";s:5:\"3.1.0\";s:3:\"url\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/twilio/gravityformstwilio_3.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=uMYXjOnNRjd1KBj8byURdWqF%2B1E%3D\";s:10:\"url_latest\";s:198:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/twilio/gravityformstwilio_3.1.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=uMYXjOnNRjd1KBj8byURdWqF%2B1E%3D\";}s:28:\"gravityformsuserregistration\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"5.4.0\";s:14:\"version_latest\";s:5:\"5.4.1\";s:3:\"url\";s:216:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/userregistration/gravityformsuserregistration_5.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=tfOdqtC3NRlulLwXfhr2VSV0xYg%3D\";s:10:\"url_latest\";s:220:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/userregistration/gravityformsuserregistration_5.4.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=XAe%2ByVgxWqMqOd%2BKEt5WHT2nwUo%3D\";}s:20:\"gravityformswebhooks\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"1.7.0\";s:14:\"version_latest\";s:5:\"1.7.0\";s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/webhooks/gravityformswebhooks_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=qBFZSdsyJqrHzQ3D%2Bs2z4Y6ORME%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/webhooks/gravityformswebhooks_1.7.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=qBFZSdsyJqrHzQ3D%2Bs2z4Y6ORME%3D\";}s:18:\"gravityformszapier\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"4.5.0\";s:14:\"version_latest\";s:5:\"4.5.0\";s:3:\"url\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zapier/gravityformszapier_4.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=5rfU2v2BBF1EVmjhGjtUG4RdCLs%3D\";s:10:\"url_latest\";s:196:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zapier/gravityformszapier_4.5.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=5rfU2v2BBF1EVmjhGjtUG4RdCLs%3D\";}s:19:\"gravityformszohocrm\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.4.0\";s:14:\"version_latest\";s:5:\"2.4.0\";s:3:\"url\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zohocrm/gravityformszohocrm_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=7XOLZq5fM%2Byr%2FfuSbqU8zLmSYAI%3D\";s:10:\"url_latest\";s:202:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/addons/zohocrm/gravityformszohocrm_2.4.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=7XOLZq5fM%2Byr%2FfuSbqU8zLmSYAI%3D\";}s:11:\"gravitysmtp\";a:5:{s:12:\"is_available\";b:1;s:7:\"version\";s:5:\"2.0.0\";s:14:\"version_latest\";s:5:\"2.0.0\";s:3:\"url\";s:185:\"https://s3.dualstack.us-east-1.amazonaws.com/gravitysmtp/releases/gravitysmtp_2.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=CpwYNqHxutnGFifkiMu5iLWoh%2Fo%3D\";s:10:\"url_latest\";s:185:\"https://s3.dualstack.us-east-1.amazonaws.com/gravitysmtp/releases/gravitysmtp_2.0.0.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=CpwYNqHxutnGFifkiMu5iLWoh%2Fo%3D\";}}s:9:\"is_active\";s:1:\"1\";s:12:\"product_code\";s:7:\"GFELITE\";s:12:\"date_created\";s:19:\"2020-04-15 12:11:04\";s:14:\"version_latest\";s:8:\"2.9.20.1\";s:10:\"url_latest\";s:188:\"https://s3.dualstack.us-east-1.amazonaws.com/gravityforms/releases/gravityforms_2.9.20.1.zip?AWSAccessKeyId=AKIA5U3GBHC5Q2TM5N7H&Expires=1761230276&Signature=IyHHE7asnL2QdpwzRfB3VRoLQKI%3D\";s:9:\"timestamp\";i:1761057476;}","off"),
("446","gf_last_telemetry_run","1760551522","auto"),
("447","gf_telemetry_data","a:2:{s:8:\"snapshot\";O:64:\"Gravity_Forms\\Gravity_Forms\\Telemetry\\GF_Telemetry_Snapshot_Data\":3:{s:4:\"data\";a:36:{s:3:\"key\";s:32:\"1c0a9ec116639a30955f7a59da9ef0bc\";s:10:\"wp_version\";s:5:\"6.8.2\";s:11:\"php_version\";s:6:\"8.2.29\";s:13:\"mysql_version\";s:7:\"10.6.23\";s:7:\"plugins\";a:44:{i:0;a:4:{s:4:\"name\";s:20:\"AAA Option Optimizer\";s:4:\"slug\";s:20:\"aaa-option-optimizer\";s:7:\"version\";s:5:\"1.5.0\";s:9:\"is_active\";b:0;}i:1;a:4:{s:4:\"name\";s:17:\"Admin Columns Pro\";s:4:\"slug\";s:17:\"admin-columns-pro\";s:7:\"version\";s:6:\"6.4.21\";s:9:\"is_active\";b:1;}i:2;a:4:{s:4:\"name\";s:17:\"Admin Menu Editor\";s:4:\"slug\";s:17:\"admin-menu-editor\";s:7:\"version\";s:4:\"1.14\";s:9:\"is_active\";b:1;}i:3;a:4:{s:4:\"name\";s:22:\"Advanced Custom Fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:7:\"version\";s:5:\"6.4.1\";s:9:\"is_active\";b:0;}i:4;a:4:{s:4:\"name\";s:46:\"Advanced Custom Fields: Custom Database Tables\";s:4:\"slug\";s:26:\"acf-custom-database-tables\";s:7:\"version\";s:5:\"1.1.4\";s:9:\"is_active\";b:1;}i:5;a:4:{s:4:\"name\";s:36:\"Advanced Custom Fields: Extended PRO\";s:4:\"slug\";s:16:\"acf-extended-pro\";s:7:\"version\";s:7:\"0.9.1.1\";s:9:\"is_active\";b:1;}i:6;a:4:{s:4:\"name\";s:26:\"Advanced Custom Fields PRO\";s:4:\"slug\";s:26:\"advanced-custom-fields-pro\";s:7:\"version\";s:7:\"6.5.0.1\";s:9:\"is_active\";b:1;}i:7;a:4:{s:4:\"name\";s:29:\"Advanced Database Cleaner PRO\";s:4:\"slug\";s:29:\"advanced-database-cleaner-pro\";s:7:\"version\";s:5:\"3.2.9\";s:9:\"is_active\";b:0;}i:8;a:4:{s:4:\"name\";s:10:\"AltText.ai\";s:4:\"slug\";s:10:\"alttext-ai\";s:7:\"version\";s:6:\"1.10.5\";s:9:\"is_active\";b:1;}i:9;a:4:{s:4:\"name\";s:10:\"Branda Pro\";s:4:\"slug\";s:17:\"ultimate-branding\";s:7:\"version\";s:6:\"3.4.24\";s:9:\"is_active\";b:1;}i:10;a:4:{s:4:\"name\";s:19:\"Broken Link Checker\";s:4:\"slug\";s:19:\"broken-link-checker\";s:7:\"version\";s:5:\"2.4.6\";s:9:\"is_active\";b:1;}i:11;a:4:{s:4:\"name\";s:10:\"Cloudflare\";s:4:\"slug\";s:10:\"cloudflare\";s:7:\"version\";s:6:\"4.12.8\";s:9:\"is_active\";b:1;}i:12;a:4:{s:4:\"name\";s:12:\"Defender Pro\";s:4:\"slug\";s:11:\"wp-defender\";s:7:\"version\";s:5:\"5.4.1\";s:9:\"is_active\";b:1;}i:13;a:4:{s:4:\"name\";s:14:\"Divi Assistant\";s:4:\"slug\";s:14:\"divi-assistant\";s:7:\"version\";s:5:\"1.1.2\";s:9:\"is_active\";b:1;}i:14;a:4:{s:4:\"name\";s:14:\"Duplicator Pro\";s:4:\"slug\";s:14:\"duplicator-pro\";s:7:\"version\";s:7:\"4.5.5.1\";s:9:\"is_active\";b:1;}i:15;a:4:{s:4:\"name\";s:13:\"Gravity Forms\";s:4:\"slug\";s:12:\"gravityforms\";s:7:\"version\";s:6:\"2.9.19\";s:9:\"is_active\";b:1;}i:16;a:4:{s:4:\"name\";s:43:\"Gravity Forms Advanced Post Creation Add-On\";s:4:\"slug\";s:32:\"gravityformsadvancedpostcreation\";s:7:\"version\";s:5:\"1.5.0\";s:9:\"is_active\";b:1;}i:17;a:4:{s:4:\"name\";s:36:\"Gravity Forms Chained Selects Add-On\";s:4:\"slug\";s:26:\"gravityformschainedselects\";s:7:\"version\";s:5:\"1.8.0\";s:9:\"is_active\";b:1;}i:18;a:4:{s:4:\"name\";s:7:\"Imagify\";s:4:\"slug\";s:7:\"imagify\";s:7:\"version\";s:5:\"2.2.6\";s:9:\"is_active\";b:1;}i:19;a:4:{s:4:\"name\";s:12:\"Nginx Helper\";s:4:\"slug\";s:12:\"nginx-helper\";s:7:\"version\";s:5:\"2.3.5\";s:9:\"is_active\";b:1;}i:20;a:4:{s:4:\"name\";s:28:\"OneSignal Push Notifications\";s:4:\"slug\";s:37:\"onesignal-free-web-push-notifications\";s:7:\"version\";s:5:\"3.2.1\";s:9:\"is_active\";b:1;}i:21;a:4:{s:4:\"name\";s:13:\"Query Monitor\";s:4:\"slug\";s:13:\"query-monitor\";s:7:\"version\";s:6:\"3.19.0\";s:9:\"is_active\";b:1;}i:22;a:4:{s:4:\"name\";s:18:\"Redis Object Cache\";s:4:\"slug\";s:11:\"redis-cache\";s:7:\"version\";s:5:\"2.6.5\";s:9:\"is_active\";b:1;}i:23;a:4:{s:4:\"name\";s:21:\"Regenerate Thumbnails\";s:4:\"slug\";s:21:\"regenerate-thumbnails\";s:7:\"version\";s:5:\"3.1.6\";s:9:\"is_active\";b:1;}i:24;a:4:{s:4:\"name\";s:13:\"RenderForm.io\";s:4:\"slug\";s:14:\"wordpress-main\";s:7:\"version\";s:5:\"1.0.1\";s:9:\"is_active\";b:1;}i:25;a:4:{s:4:\"name\";s:10:\"Reveal IDs\";s:4:\"slug\";s:26:\"reveal-ids-for-wp-admin-25\";s:7:\"version\";s:5:\"1.6.1\";s:9:\"is_active\";b:1;}i:26;a:4:{s:4:\"name\";s:8:\"SEOPress\";s:4:\"slug\";s:11:\"wp-seopress\";s:7:\"version\";s:5:\"9.0.1\";s:9:\"is_active\";b:1;}i:27;a:4:{s:4:\"name\";s:12:\"SEOPress PRO\";s:4:\"slug\";s:15:\"wp-seopress-pro\";s:7:\"version\";s:5:\"9.0.1\";s:9:\"is_active\";b:1;}i:28;a:4:{s:4:\"name\";s:18:\"Site Kit by Google\";s:4:\"slug\";s:15:\"google-site-kit\";s:7:\"version\";s:7:\"1.160.0\";s:9:\"is_active\";b:0;}i:29;a:4:{s:4:\"name\";s:12:\"Snapshot Pro\";s:4:\"slug\";s:16:\"snapshot-backups\";s:7:\"version\";s:6:\"4.35.1\";s:9:\"is_active\";b:1;}i:30;a:4:{s:4:\"name\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:7:\"version\";s:8:\"6.15.0.1\";s:9:\"is_active\";b:0;}i:31;a:4:{s:4:\"name\";s:51:\"The Events Calendar Extension: WP All Import Add-On\";s:4:\"slug\";s:20:\"tec-labs-wpai-add-on\";s:7:\"version\";s:5:\"1.1.0\";s:9:\"is_active\";b:0;}i:32;a:4:{s:4:\"name\";s:25:\"TranslatePress - Business\";s:4:\"slug\";s:23:\"translatepress-business\";s:7:\"version\";s:5:\"1.3.7\";s:9:\"is_active\";b:0;}i:33;a:4:{s:4:\"name\";s:29:\"TranslatePress - Multilingual\";s:4:\"slug\";s:27:\"translatepress-multilingual\";s:7:\"version\";s:6:\"2.10.1\";s:9:\"is_active\";b:0;}i:34;a:4:{s:4:\"name\";s:37:\"WP All Export - ACF Export Add-On Pro\";s:4:\"slug\";s:15:\"wpae-acf-add-on\";s:7:\"version\";s:5:\"1.0.5\";s:9:\"is_active\";b:0;}i:35;a:4:{s:4:\"name\";s:38:\"WP All Export - User Export Add-On Pro\";s:4:\"slug\";s:20:\"wpae-user-add-on-pro\";s:7:\"version\";s:5:\"1.0.7\";s:9:\"is_active\";b:0;}i:36;a:4:{s:4:\"name\";s:17:\"WP All Export Pro\";s:4:\"slug\";s:17:\"wp-all-export-pro\";s:7:\"version\";s:5:\"1.8.3\";s:9:\"is_active\";b:0;}i:37;a:4:{s:4:\"name\";s:26:\"WP All Import - ACF Add-On\";s:4:\"slug\";s:15:\"wpai-acf-add-on\";s:7:\"version\";s:5:\"3.3.8\";s:9:\"is_active\";b:0;}i:38;a:4:{s:4:\"name\";s:38:\"WP All Import - User Import Add-On Pro\";s:4:\"slug\";s:16:\"wpai-user-add-on\";s:7:\"version\";s:5:\"1.1.8\";s:9:\"is_active\";b:0;}i:39;a:4:{s:4:\"name\";s:17:\"WP All Import Pro\";s:4:\"slug\";s:17:\"wp-all-import-pro\";s:7:\"version\";s:5:\"4.8.0\";s:9:\"is_active\";b:0;}i:40;a:4:{s:4:\"name\";s:11:\"WP Crontrol\";s:4:\"slug\";s:11:\"wp-crontrol\";s:7:\"version\";s:6:\"1.19.2\";s:9:\"is_active\";b:1;}i:41;a:4:{s:4:\"name\";s:18:\"WPMU DEV Dashboard\";s:4:\"slug\";s:15:\"wpmudev-updates\";s:7:\"version\";s:7:\"4.11.29\";s:9:\"is_active\";b:1;}i:42;a:4:{s:4:\"name\";s:9:\"WP Rocket\";s:4:\"slug\";s:9:\"wp-rocket\";s:7:\"version\";s:8:\"3.17.3.1\";s:9:\"is_active\";b:0;}i:43;a:4:{s:4:\"name\";s:9:\"Zoho Flow\";s:4:\"slug\";s:9:\"zoho-flow\";s:7:\"version\";s:6:\"2.14.1\";s:9:\"is_active\";b:1;}}s:10:\"theme_name\";s:4:\"Divi\";s:9:\"theme_uri\";s:42:\"http://www.elegantthemes.com/gallery/divi/\";s:13:\"theme_version\";s:23:\"5.0.0-public-alpha.14.1\";s:12:\"theme_author\";s:14:\"Elegant Themes\";s:16:\"theme_author_uri\";s:28:\"http://www.elegantthemes.com\";s:12:\"is_multisite\";b:0;s:11:\"total_forms\";i:0;s:13:\"total_entries\";s:1:\"0\";s:11:\"emails_sent\";i:0;s:9:\"api_calls\";i:0;s:16:\"entry_meta_count\";i:0;s:19:\"entry_details_count\";i:0;s:17:\"entry_notes_count\";i:0;s:4:\"lang\";s:5:\"en_US\";s:2:\"db\";s:7:\"MariaDB\";s:10:\"autoUpdate\";i:1;s:8:\"currency\";s:3:\"USD\";s:14:\"dataCollection\";i:1;s:5:\"email\";s:0:\"\";s:9:\"formTypes\";s:7:\"contact\";s:14:\"formTypesOther\";s:0:\"\";s:11:\"hideLicense\";i:1;s:12:\"organization\";s:21:\"small-medium-business\";s:17:\"organizationOther\";s:0:\"\";s:8:\"services\";s:0:\"\";s:13:\"servicesOther\";s:0:\"\";s:20:\"gform_enable_logging\";b:0;s:23:\"rg_gforms_default_theme\";s:7:\"orbital\";s:25:\"gform_enable_toolbar_menu\";s:1:\"1\";s:23:\"gform_enable_noconflict\";b:0;s:12:\"legacy_forms\";i:0;}s:3:\"key\";s:8:\"snapshot\";s:15:\"data_collection\";s:1:\"1\";}s:6:\"events\";a:0:{}}","off"),
("462","gravityformsaddon_feed-base_version","0.14","auto"),
("463","gravityformsaddon_gravityformsadvancedpostcreation_version","1.5.0","auto"),
("474","gravityformsaddon_gravityformschainedselects_version","1.8.0","auto"),
("485","rg_gforms_currency","USD","auto"),
("486","rg_gforms_dataCollection","1","auto"),
("487","rg_gforms_email","","auto"),
("488","rg_gforms_formTypes","[\"contact\"]","auto"),
("489","rg_gforms_formTypesOther","","auto"),
("490","rg_gforms_hideLicense","1","auto"),
("491","rg_gforms_organization","small-medium-business","auto"),
("492","rg_gforms_organizationOther","","auto"),
("493","rg_gforms_servicesOther","","auto"),
("494","gform_enable_toolbar_menu","1","auto"),
("495","rg_gforms_enable_akismet","1","auto"),
("496","rg_gforms_key","1c0a9ec116639a30955f7a59da9ef0bc","auto"),
("513","action_scheduler_hybrid_store_demarkation","6","auto"),
("514","schema-ActionScheduler_StoreSchema","7.0.1747677845","auto"),
("515","schema-ActionScheduler_LoggerSchema","3.0.1747677845","auto"),
("518","action_scheduler_lock_async-request-runner","68f7f107077fb7.66739175|1761079619","no"),
("528","imagify_settings","a:19:{s:7:\"version\";s:5:\"2.2.6\";s:7:\"api_key\";s:40:\"c5bec5d195f67ce8bd87c8f7d9a51d3930fbcac7\";s:18:\"optimization_level\";i:2;s:8:\"lossless\";i:0;s:13:\"auto_optimize\";i:1;s:6:\"backup\";i:1;s:13:\"resize_larger\";i:1;s:15:\"resize_larger_w\";i:2560;s:15:\"display_nextgen\";i:0;s:22:\"display_nextgen_method\";s:7:\"picture\";s:12:\"display_webp\";i:0;s:19:\"display_webp_method\";s:7:\"picture\";s:7:\"cdn_url\";s:0:\"\";s:16:\"disallowed-sizes\";a:0:{}s:14:\"admin_bar_menu\";i:1;s:13:\"partner_links\";i:1;s:15:\"convert_to_avif\";i:0;s:15:\"convert_to_webp\";i:0;s:19:\"optimization_format\";s:4:\"webp\";}","on"),
("529","imagify_data","a:4:{s:7:\"version\";s:5:\"2.2.6\";s:25:\"total_size_images_library\";d:0;s:29:\"average_size_images_per_month\";d:0;s:22:\"previous_quota_percent\";d:0;}","on"),
("530","imagify_folders_db_version","100","auto"),
("531","imagify_files_db_version","102","auto"),
("544","_site_transient_timeout_imagify_check_licence_1","1779213902","off"),
("545","_site_transient_imagify_check_licence_1","1","off"),
("556","rt_wp_nginx_helper_options","a:27:{s:12:\"enable_purge\";i:0;s:12:\"cache_method\";s:14:\"enable_fastcgi\";s:12:\"purge_method\";s:11:\"get_request\";s:10:\"enable_map\";i:0;s:10:\"enable_log\";i:0;s:9:\"log_level\";s:4:\"INFO\";s:12:\"log_filesize\";s:1:\"5\";s:12:\"enable_stamp\";i:0;s:22:\"purge_homepage_on_edit\";i:1;s:21:\"purge_homepage_on_del\";i:1;s:21:\"purge_archive_on_edit\";i:1;s:20:\"purge_archive_on_del\";i:1;s:28:\"purge_archive_on_new_comment\";i:0;s:32:\"purge_archive_on_deleted_comment\";i:0;s:17:\"purge_page_on_mod\";i:1;s:25:\"purge_page_on_new_comment\";i:1;s:29:\"purge_page_on_deleted_comment\";i:1;s:11:\"purge_feeds\";i:1;s:14:\"redis_username\";s:0:\"\";s:14:\"redis_password\";s:0:\"\";s:9:\"purge_url\";s:0:\"\";s:25:\"redis_enabled_by_constant\";i:0;s:14:\"purge_amp_urls\";i:1;s:32:\"redis_socket_enabled_by_constant\";i:0;s:29:\"redis_acl_enabled_by_constant\";i:0;s:13:\"preload_cache\";i:0;s:18:\"is_cache_preloaded\";i:0;}","off"),
("574","onesignal_plugin_migrated","1","auto"),
("657","seopress_toggle","a:15:{s:13:\"toggle-titles\";s:1:\"1\";s:18:\"toggle-xml-sitemap\";s:1:\"1\";s:13:\"toggle-social\";s:1:\"1\";s:23:\"toggle-google-analytics\";s:1:\"1\";s:23:\"toggle-instant-indexing\";s:1:\"1\";s:15:\"toggle-advanced\";s:1:\"1\";s:18:\"toggle-dublin-core\";s:1:\"1\";s:21:\"toggle-local-business\";s:1:\"1\";s:20:\"toggle-rich-snippets\";s:1:\"1\";s:18:\"toggle-breadcrumbs\";s:1:\"1\";s:13:\"toggle-robots\";s:1:\"1\";s:10:\"toggle-404\";s:1:\"1\";s:10:\"toggle-bot\";s:1:\"1\";s:18:\"toggle-inspect-url\";s:1:\"1\";s:9:\"toggle-ai\";s:1:\"1\";}","auto"),
("658","seopress_titles_option_name","a:15:{s:31:\"seopress_titles_home_site_title\";s:13:\"%%sitetitle%%\";s:30:\"seopress_titles_home_site_desc\";s:11:\"%%tagline%%\";s:19:\"seopress_titles_sep\";s:1:\"-\";s:29:\"seopress_titles_single_titles\";a:3:{s:4:\"post\";a:2:{s:5:\"title\";s:36:\"%%post_title%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:16:\"%%post_excerpt%%\";}s:4:\"page\";a:2:{s:5:\"title\";s:36:\"%%post_title%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:16:\"%%post_excerpt%%\";}s:7:\"project\";a:2:{s:5:\"title\";s:36:\"%%post_title%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:16:\"%%post_excerpt%%\";}}s:26:\"seopress_titles_tax_titles\";a:6:{s:8:\"category\";a:2:{s:5:\"title\";s:64:\"%%_category_title%% %%current_pagination%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:25:\"%%_category_description%%\";}s:8:\"post_tag\";a:3:{s:5:\"title\";s:58:\"%%tag_title%% %%current_pagination%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:19:\"%%tag_description%%\";s:7:\"noindex\";s:1:\"1\";}s:15:\"layout_category\";a:2:{s:5:\"title\";s:59:\"%%term_title%% %%current_pagination%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:20:\"%%term_description%%\";}s:10:\"layout_tag\";a:2:{s:5:\"title\";s:59:\"%%term_title%% %%current_pagination%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:20:\"%%term_description%%\";}s:16:\"project_category\";a:2:{s:5:\"title\";s:59:\"%%term_title%% %%current_pagination%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:20:\"%%term_description%%\";}s:11:\"project_tag\";a:2:{s:5:\"title\";s:59:\"%%term_title%% %%current_pagination%% %%sep%% %%sitetitle%%\";s:11:\"description\";s:20:\"%%term_description%%\";}}s:30:\"seopress_titles_archive_titles\";a:3:{s:4:\"post\";a:1:{s:5:\"title\";s:45:\"%%cpt_plural%% %%current_pagination%% %%sep%%\";}s:4:\"page\";a:1:{s:5:\"title\";s:45:\"%%cpt_plural%% %%current_pagination%% %%sep%%\";}s:7:\"project\";a:1:{s:5:\"title\";s:45:\"%%cpt_plural%% %%current_pagination%% %%sep%%\";}}s:37:\"seopress_titles_archives_author_title\";s:37:\"%%post_author%% %%sep%% %%sitetitle%%\";s:39:\"seopress_titles_archives_author_noindex\";s:1:\"1\";s:35:\"seopress_titles_archives_date_title\";s:38:\"%%archive_date%% %%sep%% %%sitetitle%%\";s:37:\"seopress_titles_archives_date_noindex\";s:1:\"1\";s:37:\"seopress_titles_archives_search_title\";s:41:\"%%search_keywords%% %%sep%% %%sitetitle%%\";s:45:\"seopress_titles_archives_search_title_noindex\";s:1:\"1\";s:34:\"seopress_titles_archives_404_title\";s:42:\"404 - Page not found %%sep%% %%sitetitle%%\";s:25:\"seopress_titles_paged_rel\";s:1:\"1\";s:35:\"seopress_titles_attachments_noindex\";s:1:\"1\";}","auto"),
("659","seopress_xml_sitemap_option_name","a:4:{s:35:\"seopress_xml_sitemap_general_enable\";s:1:\"1\";s:31:\"seopress_xml_sitemap_img_enable\";s:1:\"1\";s:36:\"seopress_xml_sitemap_post_types_list\";a:2:{s:4:\"post\";a:1:{s:7:\"include\";s:1:\"1\";}s:4:\"page\";a:1:{s:7:\"include\";s:1:\"1\";}}s:36:\"seopress_xml_sitemap_taxonomies_list\";a:1:{s:8:\"category\";a:1:{s:7:\"include\";s:1:\"1\";}}}","auto"),
("660","seopress_social_option_name","a:2:{s:27:\"seopress_social_facebook_og\";s:1:\"1\";s:28:\"seopress_social_twitter_card\";s:1:\"1\";}","auto"),
("661","seopress_advanced_option_name","a:9:{s:38:\"seopress_advanced_advanced_attachments\";s:1:\"1\";s:42:\"seopress_advanced_advanced_tax_desc_editor\";s:1:\"1\";s:38:\"seopress_advanced_appearance_title_col\";s:1:\"1\";s:42:\"seopress_advanced_appearance_meta_desc_col\";s:1:\"1\";s:38:\"seopress_advanced_appearance_score_col\";s:1:\"1\";s:40:\"seopress_advanced_appearance_noindex_col\";s:1:\"1\";s:41:\"seopress_advanced_appearance_nofollow_col\";s:1:\"1\";s:54:\"seopress_advanced_appearance_universal_metabox_disable\";s:1:\"1\";s:45:\"seopress_advanced_advanced_image_auto_alt_txt\";s:1:\"1\";}","auto"),
("662","seopress_instant_indexing_option_name","a:2:{s:38:\"seopress_instant_indexing_bing_api_key\";s:44:\"YmZlMjUzOGU0ZGZiNGQyOWEzZWY5N2E5YzI5OWNiODA=\";s:45:\"seopress_instant_indexing_automate_submission\";s:1:\"1\";}","auto"),
("668","widget_seopress_pro_lb_widget","a:1:{s:12:\"_multiwidget\";i:1;}","auto"),
("671","edd_sl_c397ed7a535465d30ffa680d89b6e587","a:2:{s:7:\"timeout\";i:1747689301;s:5:\"value\";s:35135:\"{\"new_version\":\"8.7\",\"stable_version\":\"8.7\",\"name\":\"SEOPress PRO\",\"slug\":\"wp-seopress-pro\",\"url\":\"https:\\/\\/www.seopress.org\\/downloads\\/seopress-pro\\/?changelog=1\",\"last_updated\":\"2025-04-10 14:47:16\",\"homepage\":\"https:\\/\\/www.seopress.org\\/\",\"package\":\"\",\"download_link\":\"\",\"sections\":{\"description\":\"<h3>Best SEO plugin for WordPress fully integrated with all page builders and themes!<\\/h3>\\n<h3>Now with AI ( GPT-4o Mini, GPT-4o, GPT-4, GPT-3.5-Turbo) to automagically generate meta title, description and alternative texts for images!<\\/h3>\\n<p>SEOPress is a powerful WordPress SEO plugin to optimize your SEO, boost your traffic, improve social sharing, build custom HTML and XML Sitemaps, create optimized breadcrumbs, add schemas \\/ Google Structured data types, manage 301 redirections and so much more.<br \\/><\\/p>\\n<p>&#x2714; <strong><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/page-builders-integration\\/\\\">Universal SEO metabox<\\/a>: edit all your SEO from any page builder \\/ theme builder. No more back and forth between your editor and the WordPress administration<\\/strong>\\n&#x2714; <strong>No advertising, no footprints, white label, in backend AND frontend<\\/strong>\\n&#x2714; <strong>Content analysis to help you write content optimized for search engines with unlimited target keywords<\\/strong>\\n&#x2714; <strong><a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Import your post and term metadatas<\\/a> from other SEO plugins or CSV file in 1 click<\\/strong>\\n&#x2714; <strong><a href=\\\"https:\\/\\/translate.wordpress.org\\/projects\\/wp-plugins\\/wp-seopress\\\">Translated into 26 languages (and counting)<\\/a><\\/strong>\\n&#x2714; <strong>Trusted by over 300,000 WordPress websites since 2017<\\/strong><\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress PRO: only $49 \\/ year \\/ 5 sites<\\/strong><\\/a><\\/p>\\n<p>[youtube <a href=\\\"https:\\/\\/www.youtube.com\\/watch?v=4ysKFVr_nu0\\\">https:\\/\\/www.youtube.com\\/watch?v=4ysKFVr_nu0<\\/a>]<\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/\\\">Features<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Migrate<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/wordpress-seo-plugins\\/pro\\/\\\">PRO<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/integrations\\/\\\">Integrations<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/\\\">Support<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seopress-white-label\\/\\\">White Label<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/openai\\/\\\">AI<\\/a><\\/p>\\n<h3>Why SEOPress is the best WordPress SEO plugin?<\\/h3>\\n<ul>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/seopress-productivity\\/\\\"><strong>Save time<\\/strong><\\/a>: you prefer to work with Excel or Google Spreadsheets? No problem, you can import \\/ export your metadata from CSV files with SEOPress PRO in few clicks!<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Save money<\\/strong><\\/a>: SEOPress PRO is available for $49 \\/ year \\/ 5 sites. Go unlimited sites for just $149 \\/ year!<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/\\\"><strong>All in one SEO plugin<\\/strong><\\/a>: comes with all the features you need to optimize the SEO of your WordPress site. No need to install additional extensions to manage redirects, schemas, XML sitemaps... You reduce the risk of conflicts and maintenance costs. You don\'t need a special feature? Deactivate it with one click without losing your configuration. Child\'s play !<\\/li>\\n    <li><strong>Easy AND ready to use<\\/strong>: you doesn\'t need to know SEO or code to use SEOPress. Most of the parameters are automatically set. And thanks to our installation wizard, configuring SEOPress has never been easier. To go further, we provide many <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/\\\">free tutorials<\\/a> and <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/ebooks\\/\\\">ebooks to learn SEO<\\/a> in order to better understand how to position your content on search engines.<\\/li>\\n<\\/ul>\\n<h3>SEOPress Free Features<\\/h3>\\n<ul>\\n    <li><strong>Installation wizard<\\/strong> to quickly setup your site<\\/li>\\n    <li><strong>Content analysis<\\/strong> with unlimited keywords to help you write optimized content for search engines<\\/li>\\n    <li><strong>Mobile \\/ Desktop Google Preview<\\/strong> to see how your post will looks like in Google search results<\\/li>\\n    <li><strong>Facebook &amp; X (ex-Twitter) Social Preview<\\/strong> to see how your post will looks like on social media to increase conversions<\\/li>\\n    <li><strong>Titles<\\/strong> (with <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/manage-titles-meta-descriptions\\/\\\">dynamic variables<\\/a>: custom fields, terms taxonomie...)<\\/li>\\n    <li><strong>Meta descriptions<\\/strong> (with dynamic variables too)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/social-media\\/\\\"><strong>Open Graph and X (ex-Twitter) Cards<\\/strong><\\/a> to improve social media sharing (Facebook, LinkedIn, Instagram, X (ex-Twitter), Pinterest, WhatsApp...)<\\/li>\\n    <li><strong>Google Knowledge Graph<\\/strong><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Analytics<\\/strong> and <strong>Matomo<\\/strong><\\/a> with downloads tracking, custom dimensions, ip anonymization, remarketing, demographics and interest reporting, cross-domain tracking...(<a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seopress-white-label\\/\\\">GDPR compatibility<\\/a>)<\\/li>\\n    <li><strong>Microsoft Clarity integration<\\/strong>: to capture session recordings, get instant heatmaps and powerful Insights for Free. Know how people interact with your site to improve user experience and conversions<\\/li>\\n    <li><strong>Custom Canonical URL<\\/strong><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/manage-meta-robots\\/\\\"><strong>Meta robots<\\/strong><\\/a> (noindex, nofollow, noimageindex, nosnippet)<\\/li>\\n    <li>Build your <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/sitemaps\\/\\\"><strong>custom XML Sitemap<\\/strong><\\/a> to improve search indexing<\\/li>\\n    <li><strong>Image XML Sitemaps<\\/strong> to improve search indexing for Google Images<\\/li>\\n    <li>Build your custom <strong>HTML Sitemap<\\/strong> to enhanced navigation for visitors and improve search indexing<\\/li>\\n    <li>Link your social media accounts to your site<\\/li>\\n    <li><strong>Redirections<\\/strong> in post, pages, custom post types<\\/li>\\n    <li>Remove \\/category\\/ in URLs<\\/li>\\n    <li>Remove \\/product-category\\/ in URLs<\\/li>\\n    <li>Remove ?replytocom to avoid duplicate content<\\/li>\\n    <li>Redirect attachment pages to post parent<\\/li>\\n    <li>Redirect attachment pages to their file URL<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/image-seo\\/\\\"><strong>Image SEO<\\/strong><\\/a>: Automatically set the image title \\/ alt \\/ caption \\/ description<\\/li>\\n    <li>Import \\/ Export settings from site to site.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/google-indexing-api-with-seopress\\/\\\"><strong>Google Indexing API and IndexNow API (Bing \\/ Yandex)<\\/strong><\\/a> to quickly index its content in these search engines<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Import posts and terms metadata<\\/a> from Yoast SEO, All In One SEO, SEO Framework, Rank Math, SEO Ultimate, WP Meta SEO, Premium SEO Pack, Squirrly and many other SEO plugins<\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/wordpress-seo-plugins\\/free\\/features\\/\\\">Check out all SEOPress Free features here<\\/a><\\/p>\\n<h3>SEOPress PRO: to go further with your SEO<\\/h3>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/zxGCY-bJYwE\\\">https:\\/\\/youtu.be\\/zxGCY-bJYwE<\\/a>]<\\/p>\\n<ul>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/openai\\/\\\"><strong>Use Artificial Intelligence (GPT-4o, GPT-4 Turbo \\/ Vision and GPT 3.5 Turbo) to generate SEO metadata and alternative texts for image files. Bulk actions supported.<\\/strong><\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/site-audit\\/\\\"><strong>Site Audit: Detect technical issues that could harm your site\'s SEO directly from your WordPress administration.<\\/strong><\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seo-alerts\\/\\\">Receive SEO alerts to prevent breaking your SEO before it\'s too late<\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/import-metadata-from-a-csv-file-with-seopress-pro\\/\\\"><strong>Import \\/ export metadata<\\/strong><\\/a> (titles, open graph, robots...) from \\/ to CSV file<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/sitemaps\\/\\\"><strong>Video XML Sitemap<\\/strong><\\/a> to improve rankings in video search results. YouTube videos are automatically added.<\\/li>\\n    <li>Internal linking suggestions<\\/li>\\n    <li>Inspect URL with Google Search Console: get details about crawling, indexing, mobile compatibility, schemas and more.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-search-console\\/\\\"><strong>Search Console integration<\\/strong><\\/a>: get insights from your post \\/ page \\/ post type list with clicks, positions, CTR and impressions.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-suggest\\/\\\"><strong>Google Suggestions in Content Analysis<\\/strong><\\/a> to find the top 10 Google suggestions instantly. This is useful if you want to work with the long tail technique.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-structured-data-types\\/\\\"><strong>Google Structured Data types<\\/strong> (schema.org)<\\/a>:\\n        <ol>\\n            <li>article<\\/li>\\n            <li>local business<\\/li>\\n            <li>service<\\/li>\\n            <li>how-to<\\/li>\\n            <li>FAQ<\\/li>\\n            <li>course<\\/li>\\n            <li>recipe<\\/li>\\n            <li>software application<\\/li>\\n            <li>video<\\/li>\\n            <li>event<\\/li>\\n            <li>product<\\/li>\\n            <li>job<\\/li>\\n            <li>simple review<\\/li>\\n            <li>custom schema<\\/li>\\n        <\\/ol>\\n    <\\/li><li><strong>Automatic Schemas<\\/strong> with advanced conditions (AND, OR, Post types, taxonomies)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/breadcrumbs\\/\\\"><strong>Breadcrumbs<\\/strong><\\/a> optimized with Schema.org, A11Y ready.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Analytics Stats in Dashboard<\\/strong><\\/a> to quickly see your metrics without leaving your site<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/local-seo\\/\\\"><strong>Google Local Business<\\/strong><\\/a> to boost your local store<\\/li>\\n    <li><strong>Broken link checker (SEOPress BOT)<\\/strong>: scan all your links in content to find errors (e.g. 404...)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/woocommerce-seo\\/\\\"><strong>WooCommerce<\\/strong><\\/a>: Product Global Identifiers type and Product Global Identifiers fields to WooCommerce metabox for product schema (barcode), disable crawling on cart page, checkout page, customer account pages, add OG Price \\/ OG Currency for better sharing and more<\\/li>\\n    <li><strong>Easy Digital Downloads<\\/strong>: add OG Price \\/ OG Currency, remove EDD meta generator<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/breadcrumbs\\/\\\"><strong>Custom Breadcrumbs<\\/strong><\\/a> for single post types \\/ term taxonomy<\\/li>\\n    <li><strong>Google Page Speed Insights<\\/strong> to analyse your site performances on Mobile \\/ Desktop + your Core Web Vitals<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Enhanced Ecommerce for WooCommerce<\\/strong><\\/a>: measure purchases, singular product view details, additions to and removals from shopping carts<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/htaccess-robots-txt\\/\\\">Edit your <strong>robots.txt<\\/strong><\\/a> file from the admin (multisite \\/ multidomain ready)<\\/li>\\n    <li><strong>Google News Sitemap<\\/strong> to get your posts on Google News<\\/li>\\n    <li><strong>404 Monitoring<\\/strong>: Monitor your 404 errors to improve user experience, performances and increase the crawl budget allocated by Google<\\/li>\\n    <li><strong>Redirect 404 to homepage\\/custom url automatically<\\/strong> with custom status code (301, 302, 307, 410 or 451)<\\/li>\\n    <li>Email notifications on 404<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/301-redirects\\/\\\"><strong>Redirect manager<\\/strong><\\/a>: create unlimited 301, 302, 307, 410 and 451 redirections. Regular expressions supported. Import \\/ export redirections to CSV or htaccess file.<\\/li>\\n    <li>Import redirections using CSV<\\/li>\\n    <li>Import redirections from Redirections plugin (via a JSON file)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/htaccess-robots-txt\\/\\\">Edit your <strong>htaccess file<\\/strong><\\/a> from the admin<\\/li>\\n    <li>Easily customize your <strong>RSS feeds<\\/strong><\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress PRO now!<\\/strong><\\/a><\\/p>\\n<h3>WooCommerce SEO (SEOPress PRO required)<\\/h3>\\nWe support WooCommerce and Easy Digital Downloads for e-commerce sites.\\n<ul>\\n    <li>Price and currency meta tags to improve social sharing<\\/li>\\n    <li>XML sitemaps for products<\\/li>\\n    <li>Support for WooCommerce product images and WooCommerce image galleries for the XML sitemap<\\/li>\\n    <li>Centralized way to set noindex meta robots tags on pages like cart, checkout...<\\/li>\\n    <li>Remove WooCommerce generator meta tag in the source code<\\/li>\\n    <li>Create manual and\\/or automatic \\\"product\\\" schemas in JSON-LD to increase visibility in Google search results<\\/li>\\n    <li>WooCommerce support for our breadcrumbs<\\/li>\\n    <li>Global dynamic tags to insert in your metas titles \\/ descriptions<\\/li>\\n    <li>Product Global Identifiers type and Product Global Identifiers fields to WooCommerce metabox for product schema (barcode)<\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Increase your sales now!<\\/strong><\\/a><\\/p>\\n<h3><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/page-builders-integration\\/\\\">Universal SEO metabox<\\/a>: edit your metadata from any page builder \\/ editor<\\/h3>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/sf0ocG7vQMM\\\">https:\\/\\/youtu.be\\/sf0ocG7vQMM<\\/a>]<\\/p>\\n<h3>Elementor + SEOPress: perfect combo!<\\/h3>\\nWe provide deep integration with Elementor page builder UI, see below:\\n<p>[youtube <a href=\\\"https:\\/\\/www.youtube.com\\/watch?v=oC5QZ0_TH_g\\\">https:\\/\\/www.youtube.com\\/watch?v=oC5QZ0_TH_g<\\/a>]<\\/p>\\n<h3>SEOPress Insights: Off-site SEO plugin to track your rankings and backlinks in WordPress<\\/h3>\\n<ul>\\n    <li><strong>Keyword rank tracker<\\/strong>: 51 Google Search locations available<\\/li>\\n    <li>Track <strong>50 keywords<\\/strong> per site daily<\\/li>\\n    <li>Track your <strong>competitors<\\/strong>: who ranks first on your keywords<\\/li>\\n    <li>Monitor and analyze your <strong>backlinks<\\/strong> weekly<\\/li>\\n    <li><strong>Google trends<\\/strong> to find new and relevant ideas for your content marketing strategy<\\/li>\\n    <li>Your <strong>data accessible for life<\\/strong>: export it to a CSV, PDF or Excel file. Sort, order, filter your data right from your WordPress.<\\/li>\\n    <li>Receive <strong>email and Slack alerts<\\/strong> for your rankings to easily follow them<\\/li>\\n<\\/ul>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/p6v9Jd5lRIU\\\">https:\\/\\/youtu.be\\/p6v9Jd5lRIU<\\/a>]<\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress Insights now!<\\/strong><\\/a><\\/p>\\n<h3>Developers will love SEOPress!<\\/h3>\\n<ul>\\n    <li>Hundreds of hooks are available to extend SEOPress. <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/hooks\\/\\\">Browse them all here<\\/a>!<\\/li>\\n    <li>Plus we have a <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/get-started-with-the-seopress-rest-api\\/\\\">REST API<\\/a> to build static websites.<\\/li>\\n    <li>Finally, <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/seopress-wp-cli\\/\\\"><strong>WP CLI commands<\\/strong><\\/a> are available.<\\/li>\\n<\\/ul>\",\"changelog\":\"<h4> 8.7.0.2 <a href=\\\"https:\\/\\/www.seopress.org\\/newsroom\\/product-news\\/seopress-8-7\\/\\\">Read the blog post update<\\/a> <\\/h4>\\n<ul>\\n<li>INFO WP 6.8 compatibility<\\/li>\\n<li>FIX Label \\\"SEO notifications counter in admin bar\\\"<\\/li>\\n<li>FIX A regression for Automatic Instant Indexing with IndexNow<\\/li>\\n<li>FIX Canonical check exclusion for XML sitemaps<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/changelog\\/\\\">View our complete changelog<\\/a>\\n<a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/how-to-downgrade-seopress-pro-to-a-previous-version\\/\\\">Need to downgrade\\/rollback?<\\/a><\\/p>\",\"installation\":\"<ol>\\n<li>Upload \'wp-seopress\' to the \'\\/wp-content\\/plugins\\/\' directory<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu in WordPress<\\/li>\\n<li>Click on SEOPress and apply settings.<\\/li>\\n<\\/ol>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/get-started-seopress\\/\\\">Requirements \\/ Installation guide<\\/a><\\/p>\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/wp-seopress\\/assets\\/banner-1544x500.png?rev=1\",\"low\":\"https:\\/\\/ps.w.org\\/wp-seopress\\/assets\\/banner-772x250.png?rev=1\"},\"icons\":{\"1x\":\"https:\\/\\/www.seopress.org\\/wp-content\\/uploads\\/edd\\/2024\\/02\\/logo-square-seopress-pro-128x128.png\",\"2x\":\"https:\\/\\/www.seopress.org\\/wp-content\\/uploads\\/edd\\/2024\\/02\\/logo-square-seopress-pro-256x256.png\"},\"msg\":\"No license key has been provided.\",\"stable_tag\":\"8.7.0.2\",\"tested\":\"6.8.1\",\"description\":[\"<h3>Best SEO plugin for WordPress fully integrated with all page builders and themes!<\\/h3>\\n<h3>Now with AI ( GPT-4o Mini, GPT-4o, GPT-4, GPT-3.5-Turbo) to automagically generate meta title, description and alternative texts for images!<\\/h3>\\n<p>SEOPress is a powerful WordPress SEO plugin to optimize your SEO, boost your traffic, improve social sharing, build custom HTML and XML Sitemaps, create optimized breadcrumbs, add schemas \\/ Google Structured data types, manage 301 redirections and so much more.<br \\/><\\/p>\\n<p>&#x2714; <strong><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/page-builders-integration\\/\\\">Universal SEO metabox<\\/a>: edit all your SEO from any page builder \\/ theme builder. No more back and forth between your editor and the WordPress administration<\\/strong>\\n&#x2714; <strong>No advertising, no footprints, white label, in backend AND frontend<\\/strong>\\n&#x2714; <strong>Content analysis to help you write content optimized for search engines with unlimited target keywords<\\/strong>\\n&#x2714; <strong><a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Import your post and term metadatas<\\/a> from other SEO plugins or CSV file in 1 click<\\/strong>\\n&#x2714; <strong><a href=\\\"https:\\/\\/translate.wordpress.org\\/projects\\/wp-plugins\\/wp-seopress\\\">Translated into 26 languages (and counting)<\\/a><\\/strong>\\n&#x2714; <strong>Trusted by over 300,000 WordPress websites since 2017<\\/strong><\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress PRO: only $49 \\/ year \\/ 5 sites<\\/strong><\\/a><\\/p>\\n<p>[youtube <a href=\\\"https:\\/\\/www.youtube.com\\/watch?v=4ysKFVr_nu0\\\">https:\\/\\/www.youtube.com\\/watch?v=4ysKFVr_nu0<\\/a>]<\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/\\\">Features<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Migrate<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/wordpress-seo-plugins\\/pro\\/\\\">PRO<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/integrations\\/\\\">Integrations<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/\\\">Support<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seopress-white-label\\/\\\">White Label<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/openai\\/\\\">AI<\\/a><\\/p>\\n<h3>Why SEOPress is the best WordPress SEO plugin?<\\/h3>\\n<ul>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/seopress-productivity\\/\\\"><strong>Save time<\\/strong><\\/a>: you prefer to work with Excel or Google Spreadsheets? No problem, you can import \\/ export your metadata from CSV files with SEOPress PRO in few clicks!<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Save money<\\/strong><\\/a>: SEOPress PRO is available for $49 \\/ year \\/ 5 sites. Go unlimited sites for just $149 \\/ year!<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/\\\"><strong>All in one SEO plugin<\\/strong><\\/a>: comes with all the features you need to optimize the SEO of your WordPress site. No need to install additional extensions to manage redirects, schemas, XML sitemaps... You reduce the risk of conflicts and maintenance costs. You don\'t need a special feature? Deactivate it with one click without losing your configuration. Child\'s play !<\\/li>\\n    <li><strong>Easy AND ready to use<\\/strong>: you doesn\'t need to know SEO or code to use SEOPress. Most of the parameters are automatically set. And thanks to our installation wizard, configuring SEOPress has never been easier. To go further, we provide many <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/\\\">free tutorials<\\/a> and <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/ebooks\\/\\\">ebooks to learn SEO<\\/a> in order to better understand how to position your content on search engines.<\\/li>\\n<\\/ul>\\n<h3>SEOPress Free Features<\\/h3>\\n<ul>\\n    <li><strong>Installation wizard<\\/strong> to quickly setup your site<\\/li>\\n    <li><strong>Content analysis<\\/strong> with unlimited keywords to help you write optimized content for search engines<\\/li>\\n    <li><strong>Mobile \\/ Desktop Google Preview<\\/strong> to see how your post will looks like in Google search results<\\/li>\\n    <li><strong>Facebook &amp; X (ex-Twitter) Social Preview<\\/strong> to see how your post will looks like on social media to increase conversions<\\/li>\\n    <li><strong>Titles<\\/strong> (with <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/manage-titles-meta-descriptions\\/\\\">dynamic variables<\\/a>: custom fields, terms taxonomie...)<\\/li>\\n    <li><strong>Meta descriptions<\\/strong> (with dynamic variables too)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/social-media\\/\\\"><strong>Open Graph and X (ex-Twitter) Cards<\\/strong><\\/a> to improve social media sharing (Facebook, LinkedIn, Instagram, X (ex-Twitter), Pinterest, WhatsApp...)<\\/li>\\n    <li><strong>Google Knowledge Graph<\\/strong><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Analytics<\\/strong> and <strong>Matomo<\\/strong><\\/a> with downloads tracking, custom dimensions, ip anonymization, remarketing, demographics and interest reporting, cross-domain tracking...(<a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seopress-white-label\\/\\\">GDPR compatibility<\\/a>)<\\/li>\\n    <li><strong>Microsoft Clarity integration<\\/strong>: to capture session recordings, get instant heatmaps and powerful Insights for Free. Know how people interact with your site to improve user experience and conversions<\\/li>\\n    <li><strong>Custom Canonical URL<\\/strong><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/manage-meta-robots\\/\\\"><strong>Meta robots<\\/strong><\\/a> (noindex, nofollow, noimageindex, nosnippet)<\\/li>\\n    <li>Build your <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/sitemaps\\/\\\"><strong>custom XML Sitemap<\\/strong><\\/a> to improve search indexing<\\/li>\\n    <li><strong>Image XML Sitemaps<\\/strong> to improve search indexing for Google Images<\\/li>\\n    <li>Build your custom <strong>HTML Sitemap<\\/strong> to enhanced navigation for visitors and improve search indexing<\\/li>\\n    <li>Link your social media accounts to your site<\\/li>\\n    <li><strong>Redirections<\\/strong> in post, pages, custom post types<\\/li>\\n    <li>Remove \\/category\\/ in URLs<\\/li>\\n    <li>Remove \\/product-category\\/ in URLs<\\/li>\\n    <li>Remove ?replytocom to avoid duplicate content<\\/li>\\n    <li>Redirect attachment pages to post parent<\\/li>\\n    <li>Redirect attachment pages to their file URL<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/image-seo\\/\\\"><strong>Image SEO<\\/strong><\\/a>: Automatically set the image title \\/ alt \\/ caption \\/ description<\\/li>\\n    <li>Import \\/ Export settings from site to site.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/google-indexing-api-with-seopress\\/\\\"><strong>Google Indexing API and IndexNow API (Bing \\/ Yandex)<\\/strong><\\/a> to quickly index its content in these search engines<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Import posts and terms metadata<\\/a> from Yoast SEO, All In One SEO, SEO Framework, Rank Math, SEO Ultimate, WP Meta SEO, Premium SEO Pack, Squirrly and many other SEO plugins<\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/wordpress-seo-plugins\\/free\\/features\\/\\\">Check out all SEOPress Free features here<\\/a><\\/p>\\n<h3>SEOPress PRO: to go further with your SEO<\\/h3>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/zxGCY-bJYwE\\\">https:\\/\\/youtu.be\\/zxGCY-bJYwE<\\/a>]<\\/p>\\n<ul>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/openai\\/\\\"><strong>Use Artificial Intelligence (GPT-4o, GPT-4 Turbo \\/ Vision and GPT 3.5 Turbo) to generate SEO metadata and alternative texts for image files. Bulk actions supported.<\\/strong><\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/site-audit\\/\\\"><strong>Site Audit: Detect technical issues that could harm your site\'s SEO directly from your WordPress administration.<\\/strong><\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seo-alerts\\/\\\">Receive SEO alerts to prevent breaking your SEO before it\'s too late<\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/import-metadata-from-a-csv-file-with-seopress-pro\\/\\\"><strong>Import \\/ export metadata<\\/strong><\\/a> (titles, open graph, robots...) from \\/ to CSV file<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/sitemaps\\/\\\"><strong>Video XML Sitemap<\\/strong><\\/a> to improve rankings in video search results. YouTube videos are automatically added.<\\/li>\\n    <li>Internal linking suggestions<\\/li>\\n    <li>Inspect URL with Google Search Console: get details about crawling, indexing, mobile compatibility, schemas and more.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-search-console\\/\\\"><strong>Search Console integration<\\/strong><\\/a>: get insights from your post \\/ page \\/ post type list with clicks, positions, CTR and impressions.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-suggest\\/\\\"><strong>Google Suggestions in Content Analysis<\\/strong><\\/a> to find the top 10 Google suggestions instantly. This is useful if you want to work with the long tail technique.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-structured-data-types\\/\\\"><strong>Google Structured Data types<\\/strong> (schema.org)<\\/a>:\\n        <ol>\\n            <li>article<\\/li>\\n            <li>local business<\\/li>\\n            <li>service<\\/li>\\n            <li>how-to<\\/li>\\n            <li>FAQ<\\/li>\\n            <li>course<\\/li>\\n            <li>recipe<\\/li>\\n            <li>software application<\\/li>\\n            <li>video<\\/li>\\n            <li>event<\\/li>\\n            <li>product<\\/li>\\n            <li>job<\\/li>\\n            <li>simple review<\\/li>\\n            <li>custom schema<\\/li>\\n        <\\/ol>\\n    <\\/li><li><strong>Automatic Schemas<\\/strong> with advanced conditions (AND, OR, Post types, taxonomies)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/breadcrumbs\\/\\\"><strong>Breadcrumbs<\\/strong><\\/a> optimized with Schema.org, A11Y ready.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Analytics Stats in Dashboard<\\/strong><\\/a> to quickly see your metrics without leaving your site<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/local-seo\\/\\\"><strong>Google Local Business<\\/strong><\\/a> to boost your local store<\\/li>\\n    <li><strong>Broken link checker (SEOPress BOT)<\\/strong>: scan all your links in content to find errors (e.g. 404...)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/woocommerce-seo\\/\\\"><strong>WooCommerce<\\/strong><\\/a>: Product Global Identifiers type and Product Global Identifiers fields to WooCommerce metabox for product schema (barcode), disable crawling on cart page, checkout page, customer account pages, add OG Price \\/ OG Currency for better sharing and more<\\/li>\\n    <li><strong>Easy Digital Downloads<\\/strong>: add OG Price \\/ OG Currency, remove EDD meta generator<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/breadcrumbs\\/\\\"><strong>Custom Breadcrumbs<\\/strong><\\/a> for single post types \\/ term taxonomy<\\/li>\\n    <li><strong>Google Page Speed Insights<\\/strong> to analyse your site performances on Mobile \\/ Desktop + your Core Web Vitals<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Enhanced Ecommerce for WooCommerce<\\/strong><\\/a>: measure purchases, singular product view details, additions to and removals from shopping carts<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/htaccess-robots-txt\\/\\\">Edit your <strong>robots.txt<\\/strong><\\/a> file from the admin (multisite \\/ multidomain ready)<\\/li>\\n    <li><strong>Google News Sitemap<\\/strong> to get your posts on Google News<\\/li>\\n    <li><strong>404 Monitoring<\\/strong>: Monitor your 404 errors to improve user experience, performances and increase the crawl budget allocated by Google<\\/li>\\n    <li><strong>Redirect 404 to homepage\\/custom url automatically<\\/strong> with custom status code (301, 302, 307, 410 or 451)<\\/li>\\n    <li>Email notifications on 404<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/301-redirects\\/\\\"><strong>Redirect manager<\\/strong><\\/a>: create unlimited 301, 302, 307, 410 and 451 redirections. Regular expressions supported. Import \\/ export redirections to CSV or htaccess file.<\\/li>\\n    <li>Import redirections using CSV<\\/li>\\n    <li>Import redirections from Redirections plugin (via a JSON file)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/htaccess-robots-txt\\/\\\">Edit your <strong>htaccess file<\\/strong><\\/a> from the admin<\\/li>\\n    <li>Easily customize your <strong>RSS feeds<\\/strong><\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress PRO now!<\\/strong><\\/a><\\/p>\\n<h3>WooCommerce SEO (SEOPress PRO required)<\\/h3>\\nWe support WooCommerce and Easy Digital Downloads for e-commerce sites.\\n<ul>\\n    <li>Price and currency meta tags to improve social sharing<\\/li>\\n    <li>XML sitemaps for products<\\/li>\\n    <li>Support for WooCommerce product images and WooCommerce image galleries for the XML sitemap<\\/li>\\n    <li>Centralized way to set noindex meta robots tags on pages like cart, checkout...<\\/li>\\n    <li>Remove WooCommerce generator meta tag in the source code<\\/li>\\n    <li>Create manual and\\/or automatic \\\"product\\\" schemas in JSON-LD to increase visibility in Google search results<\\/li>\\n    <li>WooCommerce support for our breadcrumbs<\\/li>\\n    <li>Global dynamic tags to insert in your metas titles \\/ descriptions<\\/li>\\n    <li>Product Global Identifiers type and Product Global Identifiers fields to WooCommerce metabox for product schema (barcode)<\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Increase your sales now!<\\/strong><\\/a><\\/p>\\n<h3><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/page-builders-integration\\/\\\">Universal SEO metabox<\\/a>: edit your metadata from any page builder \\/ editor<\\/h3>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/sf0ocG7vQMM\\\">https:\\/\\/youtu.be\\/sf0ocG7vQMM<\\/a>]<\\/p>\\n<h3>Elementor + SEOPress: perfect combo!<\\/h3>\\nWe provide deep integration with Elementor page builder UI, see below:\\n<p>[youtube <a href=\\\"https:\\/\\/www.youtube.com\\/watch?v=oC5QZ0_TH_g\\\">https:\\/\\/www.youtube.com\\/watch?v=oC5QZ0_TH_g<\\/a>]<\\/p>\\n<h3>SEOPress Insights: Off-site SEO plugin to track your rankings and backlinks in WordPress<\\/h3>\\n<ul>\\n    <li><strong>Keyword rank tracker<\\/strong>: 51 Google Search locations available<\\/li>\\n    <li>Track <strong>50 keywords<\\/strong> per site daily<\\/li>\\n    <li>Track your <strong>competitors<\\/strong>: who ranks first on your keywords<\\/li>\\n    <li>Monitor and analyze your <strong>backlinks<\\/strong> weekly<\\/li>\\n    <li><strong>Google trends<\\/strong> to find new and relevant ideas for your content marketing strategy<\\/li>\\n    <li>Your <strong>data accessible for life<\\/strong>: export it to a CSV, PDF or Excel file. Sort, order, filter your data right from your WordPress.<\\/li>\\n    <li>Receive <strong>email and Slack alerts<\\/strong> for your rankings to easily follow them<\\/li>\\n<\\/ul>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/p6v9Jd5lRIU\\\">https:\\/\\/youtu.be\\/p6v9Jd5lRIU<\\/a>]<\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress Insights now!<\\/strong><\\/a><\\/p>\\n<h3>Developers will love SEOPress!<\\/h3>\\n<ul>\\n    <li>Hundreds of hooks are available to extend SEOPress. <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/hooks\\/\\\">Browse them all here<\\/a>!<\\/li>\\n    <li>Plus we have a <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/get-started-with-the-seopress-rest-api\\/\\\">REST API<\\/a> to build static websites.<\\/li>\\n    <li>Finally, <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/seopress-wp-cli\\/\\\"><strong>WP CLI commands<\\/strong><\\/a> are available.<\\/li>\\n<\\/ul>\"],\"changelog\":[\"<h4> 8.7.0.2 <a href=\\\"https:\\/\\/www.seopress.org\\/newsroom\\/product-news\\/seopress-8-7\\/\\\">Read the blog post update<\\/a> <\\/h4>\\n<ul>\\n<li>INFO WP 6.8 compatibility<\\/li>\\n<li>FIX Label \\\"SEO notifications counter in admin bar\\\"<\\/li>\\n<li>FIX A regression for Automatic Instant Indexing with IndexNow<\\/li>\\n<li>FIX Canonical check exclusion for XML sitemaps<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/changelog\\/\\\">View our complete changelog<\\/a>\\n<a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/how-to-downgrade-seopress-pro-to-a-previous-version\\/\\\">Need to downgrade\\/rollback?<\\/a><\\/p>\"],\"installation\":[\"<ol>\\n<li>Upload \'wp-seopress\' to the \'\\/wp-content\\/plugins\\/\' directory<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu in WordPress<\\/li>\\n<li>Click on SEOPress and apply settings.<\\/li>\\n<\\/ol>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/get-started-seopress\\/\\\">Requirements \\/ Installation guide<\\/a><\\/p>\"],\"plugin\":\"wp-seopress-pro\\/seopress-pro.php\",\"id\":\"wp-seopress-pro\\/seopress-pro.php\",\"requires\":\"\",\"requires_php\":\"\"}\";}","off"),
("673","seopress_versions","a:1:{s:3:\"pro\";s:3:\"9.2\";}","auto"),
("674","seopress_pro_option_name","a:1:{s:27:\"seopress_dublin_core_enable\";s:1:\"1\";}","auto"),
("675","seopress_bot_option_name","a:2:{s:37:\"seopress_bot_scan_settings_post_types\";a:2:{s:4:\"post\";a:1:{s:7:\"include\";s:1:\"1\";}s:4:\"page\";a:1:{s:7:\"include\";s:1:\"1\";}}s:30:\"seopress_bot_scan_settings_404\";s:1:\"1\";}","auto"),
("682","seopress_pro_license_key","8ac51972d2db731464db1e625acd59ec","auto"),
("689","seopress_pro_license_status","valid","auto"),
("691","edd_sl_944377aee770ad3274f3154c6a5762dc","a:2:{s:7:\"timeout\";i:1761083630;s:5:\"value\";s:37271:\"{\"new_version\":\"9.2\",\"stable_version\":\"9.2\",\"name\":\"SEOPress PRO\",\"slug\":\"wp-seopress-pro\",\"url\":\"https:\\/\\/www.seopress.org\\/downloads\\/seopress-pro\\/?changelog=1\",\"last_updated\":\"2025-09-30 08:42:25\",\"homepage\":\"https:\\/\\/www.seopress.org\\/\",\"package\":\"https:\\/\\/www.seopress.org\\/edd-sl\\/package_download\\/MTc2MTE2NjQyOTo4YWM1MTk3MmQyZGI3MzE0NjRkYjFlNjI1YWNkNTllYzoxMTM6MmZiMDZiNDAwZmFhZDA0YTU2YWY2MmNhMmRiNzQxNmI6aHR0cHNALy9kaXZpNS5idWlsdGJ5cGVhcmxjaXR5bWVkaWEuY29tOjA=\",\"download_link\":\"https:\\/\\/www.seopress.org\\/edd-sl\\/package_download\\/MTc2MTE2NjQyOTo4YWM1MTk3MmQyZGI3MzE0NjRkYjFlNjI1YWNkNTllYzoxMTM6MmZiMDZiNDAwZmFhZDA0YTU2YWY2MmNhMmRiNzQxNmI6aHR0cHNALy9kaXZpNS5idWlsdGJ5cGVhcmxjaXR5bWVkaWEuY29tOjA=\",\"sections\":{\"description\":\"<h3>Best SEO plugin for WordPress fully integrated with all page builders and themes!<\\/h3>\\n<h3>Now with AI (GPT-5, GPT-4o Mini, GPT-4o, GPT-4, GPT-3.5-Turbo &amp; DeepSeek AI) to automagically generate meta title, description and alternative texts for images!<\\/h3>\\n<p>SEOPress is a powerful WordPress SEO plugin to optimize your SEO, boost your traffic, improve social sharing, build custom HTML and XML Sitemaps, create optimized breadcrumbs, add schemas \\/ Google Structured data types, manage 301 redirections and so much more.<br \\/><\\/p>\\n<p>&#x2714; <strong><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/page-builders-integration\\/\\\">Universal SEO metabox<\\/a>: edit all your SEO from any page builder \\/ theme builder. No more back and forth between your editor and the WordPress administration<\\/strong>\\n&#x2714; <strong>No advertising, no footprints, white label, in backend AND frontend<\\/strong>\\n&#x2714; <strong>Content analysis to help you write content optimized for search engines with unlimited target keywords<\\/strong>\\n&#x2714; <strong><a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Import your post and term metadatas<\\/a> from other SEO plugins or CSV file in 1 click<\\/strong>\\n&#x2714; <strong><a href=\\\"https:\\/\\/translate.wordpress.org\\/projects\\/wp-plugins\\/wp-seopress\\\">Translated into 27 languages (and counting)<\\/a><\\/strong>\\n&#x2714; <strong>Trusted by over 350,000 WordPress websites since 2017<\\/strong><\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress PRO: only $49 \\/ year \\/ 1 site<\\/strong><\\/a><\\/p>\\n<p>[youtube <a href=\\\"https:\\/\\/www.youtube.com\\/watch?v=4ysKFVr_nu0\\\">https:\\/\\/www.youtube.com\\/watch?v=4ysKFVr_nu0<\\/a>]<\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/\\\">Features<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Migrate<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/wordpress-seo-plugins\\/pro\\/\\\">PRO<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/integrations\\/\\\">Integrations<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/\\\">Support<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seopress-white-label\\/\\\">White Label<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/openai\\/\\\">AI<\\/a><\\/p>\\n<h3>Why SEOPress is the best WordPress SEO plugin?<\\/h3>\\n<ul>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/seopress-productivity\\/\\\"><strong>Save time<\\/strong><\\/a>: you prefer to work with Excel or Google Spreadsheets? No problem, you can import \\/ export your metadata from CSV files with SEOPress PRO in few clicks!<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Save money<\\/strong><\\/a>: SEOPress PRO is available for $49 \\/ year \\/ 1 site. Go unlimited sites for just $149 \\/ year!<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/\\\"><strong>All in one SEO plugin<\\/strong><\\/a>: comes with all the features you need to optimize the SEO of your WordPress site. No need to install additional extensions to manage redirects, schemas, XML sitemaps... You reduce the risk of conflicts and maintenance costs. You don\'t need a special feature? Deactivate it with one click without losing your configuration. Child\'s play !<\\/li>\\n    <li><strong>Easy AND ready to use<\\/strong>: you doesn\'t need to know SEO or code to use SEOPress. Most of the parameters are automatically set. And thanks to our installation wizard, configuring SEOPress has never been easier. To go further, we provide many <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/\\\">free tutorials<\\/a> and <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/ebooks\\/\\\">ebooks to learn SEO<\\/a> in order to better understand how to position your content on search engines.<\\/li>\\n<\\/ul>\\n<h3>SEOPress Free Features<\\/h3>\\n<ul>\\n    <li><strong>Installation wizard<\\/strong> to quickly setup your site<\\/li>\\n    <li><strong>Content analysis<\\/strong> with unlimited keywords to help you write optimized content for search engines<\\/li>\\n    <li><strong>Mobile \\/ Desktop Google Preview<\\/strong> to see how your post will looks like in Google search results<\\/li>\\n    <li><strong>Facebook &amp; X (ex-Twitter) Social Preview<\\/strong> to see how your post will looks like on social media to increase conversions<\\/li>\\n    <li><strong>Titles<\\/strong> (with <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/manage-titles-meta-descriptions\\/\\\">dynamic variables<\\/a>: custom fields, terms taxonomie...)<\\/li>\\n    <li><strong>Meta descriptions<\\/strong> (with dynamic variables too)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/social-media\\/\\\"><strong>Open Graph and X (ex-Twitter) Cards<\\/strong><\\/a> to improve social media sharing (Facebook, LinkedIn, Instagram, X (ex-Twitter), Pinterest, WhatsApp...)<\\/li>\\n    <li><strong>Google Knowledge Graph<\\/strong><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Analytics<\\/strong> and <strong>Matomo<\\/strong><\\/a> with downloads tracking, custom dimensions, ip anonymization, remarketing, demographics and interest reporting, cross-domain tracking...(<a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seopress-white-label\\/\\\">GDPR compatibility<\\/a>)<\\/li>\\n    <li><strong>Microsoft Clarity integration<\\/strong>: to capture session recordings, get instant heatmaps and powerful Insights for Free. Know how people interact with your site to improve user experience and conversions<\\/li>\\n    <li><strong>Custom Canonical URL<\\/strong><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/manage-meta-robots\\/\\\"><strong>Meta robots<\\/strong><\\/a> (noindex, nofollow, noimageindex, nosnippet)<\\/li>\\n    <li>Build your <a href=\\\"https:\\/\\/www.seopress.org\\/features\\/sitemaps\\/\\\"><strong>custom XML Sitemap<\\/strong><\\/a> to improve search indexing<\\/li>\\n    <li><strong>Image XML Sitemaps<\\/strong> to improve search indexing for Google Images<\\/li>\\n    <li>Build your custom <strong>HTML Sitemap<\\/strong> to enhanced navigation for visitors and improve search indexing<\\/li>\\n    <li>Link your social media accounts to your site<\\/li>\\n    <li><strong>Redirections<\\/strong> in post, pages, custom post types<\\/li>\\n    <li>Remove \\/category\\/ in URLs<\\/li>\\n    <li>Remove \\/product-category\\/ in URLs<\\/li>\\n    <li>Remove ?replytocom to avoid duplicate content<\\/li>\\n    <li>Redirect attachment pages to post parent<\\/li>\\n    <li>Redirect attachment pages to their file URL<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/image-seo\\/\\\"><strong>Image SEO<\\/strong><\\/a>: Automatically set the image title \\/ alt \\/ caption \\/ description<\\/li>\\n    <li>Import \\/ Export settings from site to site.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/google-indexing-api-with-seopress\\/\\\"><strong>Google Indexing API and IndexNow API (Bing \\/ Yandex)<\\/strong><\\/a> to quickly index its content in these search engines<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Import posts and terms metadata<\\/a> from Yoast SEO, All In One SEO, SEO Framework, Rank Math, SEO Ultimate, WP Meta SEO, Premium SEO Pack, Squirrly and many other SEO plugins<\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/wordpress-seo-plugins\\/free\\/features\\/\\\">Check out all SEOPress Free features here<\\/a><\\/p>\\n<h3>SEOPress PRO: to go further with your SEO<\\/h3>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/zxGCY-bJYwE\\\">https:\\/\\/youtu.be\\/zxGCY-bJYwE<\\/a>]<\\/p>\\n<ul>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/openai\\/\\\"><strong>Use Artificial Intelligence (GPT-4o, GPT-4 Turbo \\/ Vision and GPT 3.5 Turbo) to generate SEO metadata and alternative texts for image files. Bulk actions supported.<\\/strong><\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/site-audit\\/\\\"><strong>Site Audit: Detect technical issues that could harm your site\'s SEO directly from your WordPress administration.<\\/strong><\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/seo-alerts\\/\\\">Receive SEO alerts to prevent breaking your SEO before it\'s too late<\\/a><\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/import-metadata-from-a-csv-file-with-seopress-pro\\/\\\"><strong>Import \\/ export metadata<\\/strong><\\/a> (titles, open graph, robots...) from \\/ to CSV file<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/sitemaps\\/\\\"><strong>Video XML Sitemap<\\/strong><\\/a> to improve rankings in video search results. YouTube videos are automatically added.<\\/li>\\n    <li>Internal linking suggestions<\\/li>\\n    <li>Inspect URL with Google Search Console: get details about crawling, indexing, mobile compatibility, schemas and more.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-search-console\\/\\\"><strong>Search Console integration<\\/strong><\\/a>: get insights from your post \\/ page \\/ post type list with clicks, positions, CTR and impressions.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-suggest\\/\\\"><strong>Google Suggestions in Content Analysis<\\/strong><\\/a> to find the top 10 Google suggestions instantly. This is useful if you want to work with the long tail technique.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-structured-data-types\\/\\\"><strong>Google Structured Data types<\\/strong> (schema.org)<\\/a>:\\n        <ol>\\n            <li>article<\\/li>\\n            <li>local business<\\/li>\\n            <li>service<\\/li>\\n            <li>how-to<\\/li>\\n            <li>FAQ<\\/li>\\n            <li>course<\\/li>\\n            <li>recipe<\\/li>\\n            <li>software application<\\/li>\\n            <li>video<\\/li>\\n            <li>event<\\/li>\\n            <li>product<\\/li>\\n            <li>job<\\/li>\\n            <li>simple review<\\/li>\\n            <li>custom schema<\\/li>\\n        <\\/ol>\\n    <\\/li><li><strong>Automatic Schemas<\\/strong> with advanced conditions (AND, OR, Post types, taxonomies)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/breadcrumbs\\/\\\"><strong>Breadcrumbs<\\/strong><\\/a> optimized with Schema.org, A11Y ready.<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Analytics Stats in Dashboard<\\/strong><\\/a> to quickly see your metrics without leaving your site<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/local-seo\\/\\\"><strong>Google Local Business<\\/strong><\\/a> to boost your local store<\\/li>\\n    <li><strong>Broken link checker (SEOPress BOT)<\\/strong>: scan all your links in content to find errors (e.g. 404...)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/woocommerce-seo\\/\\\"><strong>WooCommerce<\\/strong><\\/a>: Product Global Identifiers type and Product Global Identifiers fields to WooCommerce metabox for product schema (barcode), disable crawling on cart page, checkout page, customer account pages, add OG Price \\/ OG Currency for better sharing and more<\\/li>\\n    <li><strong>Easy Digital Downloads<\\/strong>: add OG Price \\/ OG Currency, remove EDD meta generator<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/breadcrumbs\\/\\\"><strong>Custom Breadcrumbs<\\/strong><\\/a> for single post types \\/ term taxonomy<\\/li>\\n    <li><strong>Google Page Speed Insights<\\/strong> to analyse your site performances on Mobile \\/ Desktop + your Core Web Vitals<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/google-analytics\\/\\\"><strong>Google Enhanced Ecommerce for WooCommerce<\\/strong><\\/a>: measure purchases, singular product view details, additions to and removals from shopping carts<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/htaccess-robots-txt\\/\\\">Edit your <strong>robots.txt<\\/strong><\\/a> file from the admin (multisite \\/ multidomain ready)<\\/li>\\n    <li><strong>Google News Sitemap<\\/strong> to get your posts on Google News<\\/li>\\n    <li><strong>404 Monitoring<\\/strong>: Monitor your 404 errors to improve user experience, performances and increase the crawl budget allocated by Google<\\/li>\\n    <li><strong>Redirect 404 to homepage\\/custom url automatically<\\/strong> with custom status code (301, 302, 307, 410 or 451)<\\/li>\\n    <li>Email notifications on 404<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/301-redirects\\/\\\"><strong>Redirect manager<\\/strong><\\/a>: create unlimited 301, 302, 307, 410 and 451 redirections. Regular expressions supported. Import \\/ export redirections to CSV or htaccess file.<\\/li>\\n    <li>Import redirections using CSV<\\/li>\\n    <li>Import redirections from Redirections plugin (via a JSON file)<\\/li>\\n    <li><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/htaccess-robots-txt\\/\\\">Edit your <strong>htaccess file<\\/strong><\\/a> from the admin<\\/li>\\n    <li>Easily customize your <strong>RSS feeds<\\/strong><\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress PRO now!<\\/strong><\\/a><\\/p>\\n<h3>WooCommerce SEO (SEOPress PRO required)<\\/h3>\\nWe support WooCommerce and Easy Digital Downloads for e-commerce sites.\\n<ul>\\n    <li>Price and currency meta tags to improve social sharing<\\/li>\\n    <li>XML sitemaps for products<\\/li>\\n    <li>Support for WooCommerce product images and WooCommerce image galleries for the XML sitemap<\\/li>\\n    <li>Centralized way to set noindex meta robots tags on pages like cart, checkout...<\\/li>\\n    <li>Remove WooCommerce generator meta tag in the source code<\\/li>\\n    <li>Create manual and\\/or automatic \\\"product\\\" schemas in JSON-LD to increase visibility in Google search results<\\/li>\\n    <li>WooCommerce support for our breadcrumbs<\\/li>\\n    <li>Global dynamic tags to insert in your metas titles \\/ descriptions<\\/li>\\n    <li>Product Global Identifiers type and Product Global Identifiers fields to WooCommerce metabox for product schema (barcode)<\\/li>\\n    <li>...<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Increase your sales now!<\\/strong><\\/a><\\/p>\\n<h3><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/page-builders-integration\\/\\\">Universal SEO metabox<\\/a>: edit your metadata from any page builder \\/ editor<\\/h3>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/sf0ocG7vQMM\\\">https:\\/\\/youtu.be\\/sf0ocG7vQMM<\\/a>]<\\/p>\\n<h3>Elementor + SEOPress: perfect combo!<\\/h3>\\nWe provide deep integration with Elementor page builder UI, see below:\\n<p>[youtube <a href=\\\"https:\\/\\/www.youtube.com\\/watch?v=oC5QZ0_TH_g\\\">https:\\/\\/www.youtube.com\\/watch?v=oC5QZ0_TH_g<\\/a>]<\\/p>\\n<h3>SEOPress Insights: Off-site SEO plugin to track your rankings and backlinks in WordPress<\\/h3>\\n<ul>\\n    <li><strong>Keyword rank tracker<\\/strong>: 52 Google Search locations available<\\/li>\\n    <li>Track <strong>50 keywords<\\/strong> per site daily<\\/li>\\n    <li>Track your <strong>competitors<\\/strong>: who ranks first on your keywords<\\/li>\\n    <li>Monitor and analyze your <strong>backlinks<\\/strong> weekly<\\/li>\\n    <li><strong>Google trends<\\/strong> to find new and relevant ideas for your content marketing strategy<\\/li>\\n    <li>Your <strong>data accessible for life<\\/strong>: export it to a CSV, PDF or Excel file. Sort, order, filter your data right from your WordPress.<\\/li>\\n    <li>Receive <strong>email and Slack alerts<\\/strong> for your rankings to easily follow them<\\/li>\\n<\\/ul>\\n<p>[youtube <a href=\\\"https:\\/\\/youtu.be\\/p6v9Jd5lRIU\\\">https:\\/\\/youtu.be\\/p6v9Jd5lRIU<\\/a>]<\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress Insights now!<\\/strong><\\/a><\\/p>\\n<h3>Developers will love SEOPress!<\\/h3>\\n<ul>\\n    <li>Hundreds of hooks are available to extend SEOPress. <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/hooks\\/\\\">Browse them all here<\\/a>!<\\/li>\\n    <li>Plus we have a <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/get-started-with-the-seopress-rest-api\\/\\\">REST API<\\/a> to build static websites.<\\/li>\\n    <li>Finally, <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/seopress-wp-cli\\/\\\"><strong>WP CLI commands<\\/strong><\\/a> are available.<\\/li>\\n<\\/ul>\",\"changelog\":\"<h4> 9.2 <a href=\\\"https:\\/\\/www.seopress.org\\/newsroom\\/product-news\\/seopress-9-2\\/\\\">Read the blog post update<\\/a> <\\/h4>\\n<ul>\\n<li>NEW Display format and Time separator for Local Business widget \\/ Block (PRO) &#x1f389;<\\/li>\\n<li>NEW \'seopress_lb_widget_opening_hours_separator\' and \'seopress_lb_block_opening_hours_separator\' hook to filter the opening hours separator (PRO - <a href=\\\"https:\\/\\/www.seopress.org\\/support\\/hooks\\/filter-local-business-opening-hours-separator\\/\\\">https:\\/\\/www.seopress.org\\/support\\/hooks\\/filter-local-business-opening-hours-separator\\/<\\/a>)<\\/li>\\n<li>NEW Migrate SEO metadata from SiteSEO (<a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/import-post-and-terms-metadata-from-siteseo-to-seopress\\/\\\">https:\\/\\/www.seopress.org\\/support\\/guides\\/import-post-and-terms-metadata-from-siteseo-to-seopress\\/<\\/a>)<\\/li>\\n<li>INFO Remove jQuery dependency for User Consent Cookie Bar<\\/li>\\n<li>INFO Strengthened security<\\/li>\\n<li>FIX Target keywords detection with dots<\\/li>\\n<li>FIX GA4 cookie domain error in browser console<\\/li>\\n<li>FIX Deprecated PHP errors when editing a term taxonomy<\\/li>\\n<li>FIX Post language sent to AI with the universal SEO metabox<\\/li>\\n<\\/ul>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/changelog\\/\\\">View our complete changelog<\\/a>\\n<a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/how-to-downgrade-seopress-pro-to-a-previous-version\\/\\\">Need to downgrade\\/rollback?<\\/a><\\/p>\",\"installation\":\"<ol>\\n<li>Upload \'wp-seopress\' to the \'\\/wp-content\\/plugins\\/\' directory<\\/li>\\n<li>Activate the plugin through the \'Plugins\' menu in WordPress<\\/li>\\n<li>Click on SEOPress and apply settings.<\\/li>\\n<\\/ol>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/support\\/guides\\/get-started-seopress\\/\\\">Requirements \\/ Installation guide<\\/a><\\/p>\"},\"banners\":{\"high\":\"https:\\/\\/ps.w.org\\/wp-seopress\\/assets\\/banner-1544x500.png?rev=1\",\"low\":\"https:\\/\\/ps.w.org\\/wp-seopress\\/assets\\/banner-772x250.png?rev=1\"},\"icons\":{\"1x\":\"https:\\/\\/www.seopress.org\\/wp-content\\/uploads\\/edd\\/2024\\/02\\/logo-square-seopress-pro-128x128.png\",\"2x\":\"https:\\/\\/www.seopress.org\\/wp-content\\/uploads\\/edd\\/2024\\/02\\/logo-square-seopress-pro-256x256.png\"},\"stable_tag\":\"9.2\",\"tested\":\"6.8.2\",\"description\":[\"<h3>Best SEO plugin for WordPress fully integrated with all page builders and themes!<\\/h3>\\n<h3>Now with AI (GPT-5, GPT-4o Mini, GPT-4o, GPT-4, GPT-3.5-Turbo &amp; DeepSeek AI) to automagically generate meta title, description and alternative texts for images!<\\/h3>\\n<p>SEOPress is a powerful WordPress SEO plugin to optimize your SEO, boost your traffic, improve social sharing, build custom HTML and XML Sitemaps, create optimized breadcrumbs, add schemas \\/ Google Structured data types, manage 301 redirections and so much more.<br \\/><\\/p>\\n<p>&#x2714; <strong><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/page-builders-integration\\/\\\">Universal SEO metabox<\\/a>: edit all your SEO from any page builder \\/ theme builder. No more back and forth between your editor and the WordPress administration<\\/strong>\\n&#x2714; <strong>No advertising, no footprints, white label, in backend AND frontend<\\/strong>\\n&#x2714; <strong>Content analysis to help you write content optimized for search engines with unlimited target keywords<\\/strong>\\n&#x2714; <strong><a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Import your post and term metadatas<\\/a> from other SEO plugins or CSV file in 1 click<\\/strong>\\n&#x2714; <strong><a href=\\\"https:\\/\\/translate.wordpress.org\\/projects\\/wp-plugins\\/wp-seopress\\\">Translated into 27 languages (and counting)<\\/a><\\/strong>\\n&#x2714; <strong>Trusted by over 350,000 WordPress websites since 2017<\\/strong><\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/pricing\\/\\\"><strong>Buy SEOPress PRO: only $49 \\/ year \\/ 1 site<\\/strong><\\/a><\\/p>\\n<p>[youtube <a href=\\\"https:\\/\\/www.youtube.com\\/watch?v=4ysKFVr_nu0\\\">https:\\/\\/www.youtube.com\\/watch?v=4ysKFVr_nu0<\\/a>]<\\/p>\\n<p><a href=\\\"https:\\/\\/www.seopress.org\\/features\\/\\\">Features<\\/a> | <a href=\\\"https:\\/\\/www.seopress.org\\/solutions\\/migrate-from\\/\\\">Migrate<\\/a> |