<?php

namespace ACFCustomDatabaseTables\Provider;

use ACFCustomDatabaseTables\Vendor\Pimple\Container;
use ACFCustomDatabaseTables\Vendor\Pimple\ServiceProviderInterface;

class RestProvider implements ServiceProviderInterface {

	/** @var string[] */
	private $endpoint_classes = [
		//ExampleEndpoint::class,
	];

	public function register( Container $c ) {
		if ( empty( $this->endpoint_classes ) ) {
			return;
		}

		// Let's just load these classes up directly — no need to bind into the container for now.
		add_action( 'rest_api_init', function () use ( $c ) {
			array_map( function ( $class ) {
				( new $class )->register_routes();
			}, $this->endpoint_classes );
		} );
	}
}