<?php

namespace ACFCustomDatabaseTables\Rest;

use WP_REST_Controller;

abstract class RestBase extends WP_REST_Controller {

	protected $namespace = 'acfcdt/v1';

	/**
	 * A generic permissions check that we can use where something more specific isn't required.
	 *
	 * @return bool
	 */
	public function permissions_check() {
		return current_user_can( 'manage_options' );
	}

	/**
	 * Get the rest base for this endpoint. This will just return the $rest_base prop by default so if there's no need
	 * for patterns using $this->pattern(), the rest base can be defined on the property directly. If, however, the base
	 * needs to be constructed, we can use this method instead.
	 *
	 * @return string
	 */
	protected function rest_base() {
		return $this->rest_base;
	}

	/**
	 * Build a URL pattern fragment for use in $this->rest_base. This is a convenience method with a number of patterns
	 * built in.
	 *
	 * @param string $type
	 * @param string $name
	 *
	 * @return string
	 */
	protected function pattern( $type, $name = '' ) {
		switch ( $type ) {
			case 'id':
			case 'user_id':
			case 'post_id':
			case 'term_id':
				$pattern = $name ? "(?P<$name>\d+)" : '(\d+)';
				break;
			case 'slug':
				$pattern = $name ? "(?P<$name>[a-zA-Z0-9-]+)" : '([a-zA-Z0-9-]+)';
				break;
			case 'uuid':
				$pattern = $name ? "(?P<$name>[\w\-]+)" : '([\w\-]+)';
				break;
			case 'lat':
			case 'lon':
				$pattern = $name ? "(?P<$name>[a-z0-9 .\-]+)" : '([a-z0-9 .\-]+)';
				break;
			default:
				$pattern = $name ? "(?P<$name>[a-zA-Z0-9_-]+)" : '([a-zA-Z0-9_-]+)';
		}

		return $pattern;
	}

}