<?php

namespace ACFCustomDatabaseTables\Utils;

/**
 * Class Request
 * @package ACFCustomDatabaseTables\Utils
 *
 * Utility methods for accessing data on the request.
 */
class Request {

	/**
	 * Get a value from the request. Defaults to using $_REQUEST but
	 *
	 * @param $key
	 * @param null $default
	 * @param string $context
	 *
	 * @return mixed|null
	 */
	public static function get( $key, $default = null, $context = 'request' ) {
		if ( $context === 'post' ) {
			return Arr::get( $_POST, $key, $default );

		} elseif ( $context === 'get' ) {
			return Arr::get( $_GET, $key, $default );
		}

		return Arr::get( $_REQUEST, $key, $default );
	}

	/**
	 * Get a nested value from a request array. Defaults to using $_REQUEST
	 *
	 * @param $key
	 * @param null $default
	 * @param string $context
	 *
	 * @return mixed|null
	 */
	public static function get_deep( $key, $default = null, $context = 'request' ) {
		if ( $context === 'post' ) {
			return Arr::get_deep( $_POST, $key, $default );

		} elseif ( $context === 'get' ) {
			return Arr::get_deep( $_GET, $key, $default );
		}

		return Arr::get_deep( $_REQUEST, $key, $default );
	}
}