<?php
/*
    Plugin Name: Divi Assistant
    Plugin URI: https://www.peeayecreative.com/product/divi-assistant/
    Author: Pee-Aye Creative
    Author URI: https://www.peeayecreative.com/
    Update URI: https://www.peeayecreative.com/
    Version: 1.1.2
    Description: A huge collection of incredibly handy features and tools to make your life easier when working on your Divi website - startup actions, general utilities, interface hacks, custom settings, global styles, learning resources, maintenance tools, code editors, accessibility improvements, alt text fixes, media hacks, local fonts, system report sharing, import/export tools, and so much more!
    Text-Domain: pac-divi-assistant
    Requires at least: 5.x
    Requires PHP: 7.4
    License:  GPL2
    License URI: https://www.gnu.org/licenses/gpl-2.0.html
*/

// No direct access allowed
if( ! defined( 'ABSPATH' ) ) : exit(); endif;

// Define Plugins Constants
if (!defined('PAC_DA_PLUGIN_VERSION')):
    define('PAC_DA_PLUGIN_VERSION', '1.1.2');
endif;
if (!defined('PAC_DA_PLUGIN_PATH')):
    define('PAC_DA_PLUGIN_PATH', trailingslashit( plugin_dir_path( __FILE__ ) ));
endif;
if (!defined('PAC_DA_PLUGIN_URL')):
    define ( 'PAC_DA_PLUGIN_URL', trailingslashit( plugins_url( '/', __FILE__ ) ) );
endif;
if (!defined('PAC_DA_PLUGIN_TEXT_DOMAIN')):
    define('PAC_DA_PLUGIN_TEXT_DOMAIN', 'pac-divi-assistant');
endif;
if (!defined('PAC_DA_PLUGIN_BASENAME')):
    define('PAC_DA_PLUGIN_BASENAME', plugin_basename(__FILE__));
endif;
if (!defined('PAC_DA_PLUGIN_FILE')):
    define('PAC_DA_PLUGIN_FILE', __FILE__);
endif;

function pac_da_get_user_details() {
    $current_user = wp_get_current_user();
    if (!defined('PAC_DA_CURRENT_USERNAME')):
        define('PAC_DA_CURRENT_USERNAME', $current_user->display_name);
    endif;
    if (!defined('PAC_DA_CURRENT_USER_EMAIL')):
        define('PAC_DA_CURRENT_USER_EMAIL', $current_user->user_email);
    endif;
    if (!defined('PAC_DA_USER_PREMISSION')):
        define('PAC_DA_USER_PREMISSION', (bool)array_intersect(['administrator', 'editor'], $current_user->roles));
    endif;
    if (!defined('PAC_DA_IS_USER_ADMIN')):
        define('PAC_DA_IS_USER_ADMIN', (bool)array_intersect(['administrator'], $current_user->roles));
    endif; 
    // Enqueue frontend style
    if(is_user_logged_in()){
        add_action( 'wp_enqueue_scripts', 'da_load_frontend_scripts' );
        function da_load_frontend_scripts() {
            wp_enqueue_style('pac_da_frontend_style', plugins_url('divi-assistant/include/css/divi-assistant-front-style.css'));
            $codeData = json_decode(get_option('pacDaCodeData', '{"css":false,"jquery":false,"php":false}'));
            $enableAddons = json_decode(get_option('pacDaAddons', '{"startUp":true,"maintenance":true,"utility":true,"media":true,"learning":true,"support":true,"fonts":true,"styles":true,"code":true,"frontend":true,"accessibility":true}'));
            $codeSettings = isset($enableAddons->code) ? $enableAddons->code : true;
            if((boolval($codeData->css) || boolval($codeData->jquery) || boolval($codeData->php)) && boolval($codeSettings) === true){
                wp_enqueue_code_editor(['type' => 'text/css']);
                if (!wp_script_is('jshint', 'enqueued')) {
                    wp_enqueue_script('jshint');
                }
                if (!wp_script_is('csslint', 'enqueued')) {
                    wp_enqueue_script('csslint');
                }
                if (!wp_script_is('htmlhint', 'enqueued')) {
                    wp_enqueue_script('htmlhint');
                }
            }
        }
    }
    add_filter('plugin_action_links', 'pac_da_maybe_action_links', 10, 2);
}
add_action( 'init', 'pac_da_get_user_details' );

function pac_da_maybe_action_links($links, $file)
{
    if (PAC_DA_PLUGIN_BASENAME !== $file) {
        return $links;
    }
    $url = admin_url("admin.php?page=divi-assistant");
    $settings_link = sprintf('<a href="%1$s">%2$s</a>', $url, __('Settings', PAC_DA_PLUGIN_TEXT_DOMAIN));
    array_unshift($links, $settings_link);
    return $links;
}

// Add option in database
add_option( 'pacDaWebHosting', 'null', '', 'yes' );

// Loading Necessary Scripts
function pac_da_admin_enqueue_scripts() {
    $current_user = wp_get_current_user();
    $allowAdmin = isset(json_decode(get_option('pacDaAllowAdmin'))->{$current_user->ID}) && json_decode(get_option('pacDaAllowAdmin'))->{$current_user->ID} !== null ? json_decode(get_option('pacDaAllowAdmin'))->{$current_user->ID} : true;
    if(boolval($allowAdmin)){
        require_once PAC_DA_PLUGIN_PATH . 'include/php/pac-da-create-admin-menu.php';
        add_action( 'admin_enqueue_scripts', 'pac_da_load_scripts' );
    }
}
add_action( 'init', 'pac_da_admin_enqueue_scripts' );

function pac_da_load_scripts() {
    wp_enqueue_script( 'pac_bundle_js', PAC_DA_PLUGIN_URL . 'dist/bundle.js', [ 'jquery', 'wp-element' ], wp_rand(), true );
    wp_localize_script( 'pac_bundle_js', 'pacDaAppLocalizer', [
        'apiUrl'        => home_url( '/wp-json' ),
        'nonce'         => wp_create_nonce( 'wp_rest' ),
        'ajaxNonce'     => wp_create_nonce( 'updates' ),
        'ajaxNonceRollback'    => wp_create_nonce( 'et_core_version_rollback' ),
        'plugin_url'      => PAC_DA_PLUGIN_URL,
        'site_url'      => get_site_url(),
    ]);
    // Load CSS file
    wp_enqueue_style('pac-da-admin-style', plugins_url('divi-assistant/include/css/divi-assistant-style.css'));
}

require_once PAC_DA_PLUGIN_PATH . 'include/php/pac-da-functions.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-da-et-hooks.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-snippets.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-general-js.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-general-php.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-general-css.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-quick-links.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-auto-clear-cache.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-custom-widget.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-allow-svg-upload.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-tutorials-api.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-theme-builder-template.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/pac-da-create-settings-routes.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-filter-project-post-type.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/class-wp-maintenance-comingsoon-modes.php';
require_once PAC_DA_PLUGIN_PATH . 'include/php/pac-da-class-shortcode-in-menus.php';

if (is_admin()) {
	require_once PAC_DA_PLUGIN_PATH . 'include/php/pac-da-class-shortcode-in-menus-admin.php';
	Pac_Da_Shortcode_In_Menus_Admin::get_instance();
} else {
	Pac_Da_Shortcode_In_Menus::get_instance();
}

// Add Documentation & Support Header
function plugin_extra_headers_divi_assistant($headers){
	if (!in_array('DocumentationURI', $headers)) {
		$headers[] = 'DocumentationURI';
	}
	return $headers;
}
function plugin_meta_links_divi_assistant($links, $file)
{
    if (PAC_DA_PLUGIN_BASENAME !== $file) {
        return $links;
    }
    $links[] = sprintf('<a href="%s"  target="_blank">'.esc_html__('Documentation & Support', PAC_DA_PLUGIN_TEXT_DOMAIN).'</a>', esc_url('https://www.peeayecreative.com/docs/divi-assistant/'));
    return $links;
}
add_filter('extra_plugin_headers', 'plugin_extra_headers_divi_assistant');
add_filter('plugin_row_meta', 'plugin_meta_links_divi_assistant', 10, 2);


// LICENSE MANAGER CODE BEGINS HERE
if(!defined('WOO_SLT_DA_PATH_DA'))
define('WOO_SLT_DA_PATH_DA',   plugin_dir_path(__FILE__));
if(!defined('WOO_SLT_DA_URL_DA'))
define('WOO_SLT_DA_URL_DA',    plugins_url('', __FILE__));
if(!defined('WOO_SLT_DA_APP_API_URL_DA'))
define('WOO_SLT_DA_APP_API_URL_DA',      'https://www.peeayecreative.com/product/divi-assistant/');

if(!defined('WOO_SLT_DA_VERSION_DA'))
define('WOO_SLT_DA_VERSION_DA', '1.1.2');
if(!defined('WOO_SLT_DA_DB_VERSION_DA'))
define('WOO_SLT_DA_DB_VERSION_DA', '1.1.2'); 

if(!defined('WOO_SLT_DA_PRODUCT_ID_DA'))
define('WOO_SLT_DA_PRODUCT_ID_DA',           'PA-DA');
if(!defined('WOO_SLT_DA_INSTANCE_DA'))
define('WOO_SLT_DA_INSTANCE_DA',             str_replace(array ("https://" , "http://"), "", network_site_url()));


if(!class_exists('WOO_SLT_DA'))
include_once(WOO_SLT_DA_PATH_DA . '/license/class.wooslt.php');
if(!class_exists('WOO_SLT_DA_licence'))
include_once(WOO_SLT_DA_PATH_DA . '/license/class.licence.php');
if(!class_exists('WOO_SLT_DA_options_interface'))
include_once(WOO_SLT_DA_PATH_DA . '/license/class.options.php');
if(!class_exists('WOO_SLT_DA_CodeAutoUpdate'))
include_once(WOO_SLT_DA_PATH_DA . '/license/class.updater.php');

function WOO_SLT_DA_DA_activated() 
    {

    }

function WOO_SLT_DA_DA_deactivated() 
    {

    }

global $WOO_SLT_DA;
$WOO_SLT_DA = new WOO_SLT_DA()

?>