<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_Allow_SVG_Upload')) {
    class PAC_DA_Allow_SVG_Upload
    {

        private static $_instance;

        private string $transient_key; // phpcs:ignore

        private bool $is_permission_granted = false; // phpcs:ignore

        private string $btn_default_label; // phpcs:ignore

        private string $btn_granting_label; // phpcs:ignore

        private string $btn_granted_label; // phpcs:ignore

        /**
         * Get Class Instance
         * @return PAC_DA_Allow_SVG_Upload
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         * Add/Remove Necessary Actions/Filters
         */
        public function init()
        {
            $enableAddons = json_decode(get_option('pacDaAddons', '{"media":true}'));
            $mediaSettings = isset($enableAddons->media) ? $enableAddons->media : true;
            $mediaCards = json_decode(get_option('pacDaMediaCards', '{"svgUploads":false,"svgUploadsValue":"default"}'));
            $svgUploads = isset($mediaCards->svgUploads) ? $mediaCards->svgUploads : false;
            $svgUploadsValue = isset($mediaCards->svgUploadsValue) ? $mediaCards->svgUploadsValue : 'default';
            if(boolval($mediaSettings) === true && boolval($svgUploads) === true && $svgUploadsValue === 'temporarily'){
                $this->btn_default_label = __('Temporarily Allow SVG Upload', 'pac-divi-assistant');
                $this->btn_granting_label = __('Permission Granting Please wait...', 'pac-divi-assistant');
                $this->btn_granted_label = __('Temporary SVG Upload Permission Enabled', 'pac-divi-assistant');
                add_action('init', [$this, 'maybe_init_actions'], 999);
                add_action('post-upload-ui', [$this, 'maybe_render_btn']);
                add_action('wp_ajax_allow_permission', [$this, 'maybe_allow_permission']);
                add_action('wp_ajax_get_permission_status', [$this, 'get_permission_status']);
                add_filter('upload_mimes', [$this, 'maybe_add_mimes']);
                add_filter('wp_check_filetype_and_ext', [$this, 'maybe_fix_mime_type_ext'], 999, 4);
                add_filter('wp_handle_upload_prefilter', [$this, 'maybe_check_permission']);
            }
        }

        /**
         * @return void
         */
        public function maybe_init_actions()
        {
            if (!is_user_logged_in()) {
                return;
            }
            global $pagenow;
            $this->transient_key = 'allow_permission_temp_'.md5(get_current_user_id());
            $this->is_permission_granted = get_transient($this->transient_key);
            // Delete Access
            $excluded_pages = ['async-upload.php', 'admin-ajax.php'];
            if (!wp_doing_ajax() && (!in_array($pagenow, $excluded_pages))) {
                delete_transient($this->transient_key);
            }
            // Delete Access
            $page_was_refreshed = isset($_SERVER['HTTP_CACHE_CONTROL']) && (sanitize_text_field($_SERVER['HTTP_CACHE_CONTROL']) === 'max-age=0' || sanitize_text_field($_SERVER['HTTP_CACHE_CONTROL']) == 'no-cache');
            if ($page_was_refreshed && is_admin()) {
                $this->is_permission_granted = false;
                delete_transient($this->transient_key);
            }
        }

        /**
         * Add Custom Button
         * @return void
         */
        public function maybe_render_btn()
        {
            if (!is_user_logged_in()) {
                return;
            }
            $btn_label = $this->is_permission_granted ? $this->btn_granted_label : $this->btn_default_label;
            $data_attributes = [
                'ajax-url' => admin_url('admin-ajax.php'),
                'nonce' => wp_create_nonce('pac-da-temp-svg'),
                'granting-label' => $this->btn_granting_label,
                'granted-label' => $this->btn_granted_label,
            ];
            ?>
            <style>
                .svg__permission_container .btn__svg {
                    position: relative;
                    z-index: 99999;
                }

                .svg__permission_container .permission__granted {
                    color: #008000 !important;
                    pointer-events: none;
                    border: none !important;
                    background: none !important;
                    box-shadow: none !important;
                    cursor: default;
                    transform: none !important;
                }
            </style>
            <div class="svg__permission_container">
                <button
                        type="button"
                        class="btn__svg button <?php echo $this->is_permission_granted ? 'permission__granted' : ''; ?>"
                    <?php foreach ($data_attributes as $key => $value) { ?>
                        data-<?php echo esc_attr($key); ?>="<?php echo esc_attr($value); ?>"
                    <?php } ?>
                >
                    <?php echo esc_html($btn_label); ?>
                </button>
            </div>
            <script type="text/javascript" id="pac-da-temp-svg">
                (function ($) {
                    'use strict';
                    let $btn = $('.btn__svg');
                    // Allow Temp. SVG Uploading
                    $btn.click(function (e) {
                        e.preventDefault();
                        const $btn = $(e.target)
                        let $this = $(this);
                        let nonce = $this.data('nonce');
                        $.ajax({
                            type: 'post',
                            dataType: 'json',
                            url: $btn.data('ajax-url'),
                            data: {
                                'action': 'allow_permission',
                                '_wpnonce': nonce,
                            },
                            beforeSend: function () {
                                $btn.addClass('permission__granted');
                                $btn.text($btn.data('granting-label'))
                            },
                            success: function (response) {
                                if (!response.success) {
                                    $btn.text(response.data.message)
                                }
                            },
                            complete: function () {
                                $btn.text($btn.data('granted-label'))
                            },
                            error: function (xhr, status, error) {
                            }
                        })
                    });
                    // Some Actions On wp.media
                    if (wp.media) {
                        wp.media.view.Modal.prototype.on('ready', function () {
                            $btn.css('opacity', '0')
                            jQuery.ajax({
                                type: 'GET',
                                url: $btn.data('ajax-url'),
                                data: {action: 'get_permission_status'},
                                beforeSend: function () {},
                                success: function (response) {
                                    if (response.success) {
                                        $btn.addClass('permission__granted');
                                        $btn.text($btn.data('granted-label'))
                                    }
                                },
                                complete: function () {
                                    $btn.css('opacity', '1')
                                },
                                error: function (xhr, status, error) {}
                            });
                            wp.media.view.Modal.prototype.on('open', function () {});
                        });
                    }
                })(jQuery);
            </script>
            <?php
        }

        /**
         * Allow SVG Temp.
         * @return void
         */
        public function maybe_allow_permission()
        {
            if (!is_user_logged_in()) {
                return;
            }
            if (empty($_POST['_wpnonce']) && !wp_verify_nonce(sanitize_text_field($_POST['_wpnonce']), 'pac-da-temp-svg')) {
                return;
            }
            delete_transient($this->transient_key);
            $response = set_transient($this->transient_key, true, HOUR_IN_SECONDS);
            if ($response) {
                wp_send_json_success($response);
            } else {
                wp_send_json_error(['message' => __('The permission is not allowed. Please contact admin.', 'pac-divi-assistant')]);
            }
            wp_die();
        }

        /**
         * Get Permission Status
         * @return void
         */
        public function get_permission_status()
        {
            $response = get_transient($this->transient_key);
            if ($response) {
                wp_send_json_success($response);
            } else {
                wp_send_json_error();
            }
            wp_die();
        }

        /**
         * Allow SVG Mime
         *
         * @param $mimes
         *
         * @return mixed
         */
        public function maybe_add_mimes($mimes)
        {
            if (!is_user_logged_in()) {
                return $mimes;
            }
            $mimes['svg'] = 'image/svg+xml';
            $mimes['svgz'] = 'image/svg+xml';

            return $mimes;
        }

        /**
         * Fixes the issue in WordPress 4.7.1 being unable to correctly identify a type
         *
         * @param $file
         * @param $tmp_file
         * @param $filename
         * @param $mimes
         *
         * @return array|mixed|null
         */
        public function maybe_fix_mime_type_ext($file, $tmp_file, $filename, $mimes)
        {
            if (!is_user_logged_in()) {
                return $file;
            }
            if (isset($file['ext']) && empty($file['ext'])) {
                $file_ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
                if ('svg' === $file_ext) {
                    $file['ext'] = 'svg';
                    $file['type'] = 'image/svg+xml';
                }
                if ('svgz' === $file_ext) {
                    $file['ext'] = 'svgz';
                    $file['type'] = 'image/svg+xml';
                }
            }

            return $file;
        }

        /**
         * @param $file
         *
         * @return mixed
         */
        public function maybe_check_permission($file)
        {
            if (!is_user_logged_in()) {
                return $file;
            }
            if (false === get_transient($this->transient_key) && in_array($file['type'], ['image/svg+xml', 'svg+xml'])) {
                $file['error'] = __('Sorry, SVG files are not allowed for security reasons.', 'pac-divi-assistant');
            }

            return $file;
        }

    }

    (new PAC_DA_Allow_SVG_Upload())->instance()->init();
}