<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_Auto_Clear_Cache')) {
    class PAC_DA_Auto_Clear_Cache
    {

        private static $_instance;

        private $hook;

        private $recurrence;

        /**
         * Get Class Instance
         * @return PAC_DA_Auto_Clear_Cache
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         * Add/Remove Necessary Actions/Filters
         */
        public function init()
        {
            $enableAddons = json_decode(get_option('pacDaAddons', '{"maintenance":true}'));
            $maintenanceSettings = !isset($enableAddons->maintenance) || $enableAddons->maintenance;
            if(boolval($maintenanceSettings)) {
                // Clear Cache With Theme OR Plugin Update
                $data = json_decode(get_option('pacDaMaintenanceCards', '{"autoClearCache":"disable","clearOnExitsVB":false,"clearOnUpdatePlugin":false,"clearOnUpdateTheme":false}'));
                $autoClearCache = isset($data->autoClearCache) ? $data->autoClearCache : "disable";
                $clearOnExitsVB = isset($data->clearOnExitsVB) ? $data->clearOnExitsVB : true;
                $clearOnUpdatePlugin = isset($data->clearOnUpdatePlugin) ? $data->clearOnUpdatePlugin : true;
                $clearOnUpdateTheme = isset($data->clearOnUpdateTheme) ? $data->clearOnUpdateTheme : true;
                if(boolval($clearOnUpdatePlugin) || boolval($clearOnUpdateTheme)){
                    add_action('upgrader_process_complete', [$this, 'maybe_theme_plugin_update'], 999, 2);
                }
                // Clear Cache With Divi Builder Exit
                if(boolval($clearOnExitsVB)){
                    add_action('init', [$this, 'maybe_divi_builder_exit'], 999);
                }
                // Clear Cache With Cron Job
                if($autoClearCache !== "disable"){
                    $this->hook = 'pa_da_clear_divi_static_cache_'.$autoClearCache;
                    $this->recurrence = $autoClearCache; // hourly,twicedaily,daily,weekly,monthly
                    add_action('init', [$this, 'maybe_schedule_auto_clear_cache']);
                    add_action($this->hook, [$this, 'maybe_run_auto_clear_cache']);
                }   
            }
        }

        /**
         * Maybe Theme OR Plugin Update
         *
         * @param $upgrader_object
         * @param $options
         *
         * @return void
         */
        public function maybe_theme_plugin_update($upgrader_object, $options)
        {
            // Update Cache
            $type = isset($options['type']) ? strtolower($options['type']) : null;
            if ((isset($options['action']) && $options['action'] === 'update') && ('theme' === $type || 'plugin' === $type)) {
                $this->clear_divi_static_cache();
            }
        }

        /**
         * Clear Cache When Builder Exists
         * @return void
         */
        public function maybe_divi_builder_exit()
        {
            // Check Nonce
            if (isset($_POST['et_fb_helper_nonce']) && !wp_verify_nonce(sanitize_text_field($_POST['et_fb_helper_nonce']), 'et_fb_update_helper_assets_nonce')) {
                return;
            }
            // Update Cache
            if (isset($_POST['action']) && 'et_fb_update_builder_assets' === sanitize_text_field($_POST['action'])) {
                $this->clear_divi_static_cache();
            }
        }

        /**
         * Add Cron Job
         * @return void
         */
        public function maybe_schedule_auto_clear_cache()
        {
            if (!wp_next_scheduled($this->hook)) {
                wp_schedule_event(time(), $this->recurrence, $this->hook);
            }
        }

        /**
         * Process Cron Job
         * @return void
         */
        public function maybe_run_auto_clear_cache()
        {
            // Update Cache
            $this->clear_divi_static_cache();
        }

        /**
         * Clear Divi Static Cache
         * @return void
         */
        private function clear_divi_static_cache()
        {
            ET_Core_PageResource::remove_static_resources('all', 'all');
        }

    }

    (new PAC_DA_Auto_Clear_Cache())->instance()->init();
}