<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_ET_Hooks')) {
    class PAC_DA_ET_Hooks
    {

        private static $_instance;

        /**
         * Get Class Instance
         *
         * @return PAC_DA_ET_Hooks
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         *
         * Add/Remove Nnecessary Actions/Filters
         */
        public function init()
        {
            $accessibilityHelperData = json_decode(get_option('pacDaAccessibilityHelper', '{"pinchZoom":false}'));
            $pinchZoom = isset($accessibilityHelperData->pinchZoom) ? $accessibilityHelperData->pinchZoom : false;
            $enableAddons = json_decode(get_option('pacDaAddons', '{"accessibility":true}'));
            $accessibilitySettings = isset($enableAddons->accessibility) ? $enableAddons->accessibility : true;
            if (boolval($pinchZoom) && boolval($accessibilitySettings)) {
                add_action('init', [$this, 'maybe_remove_et_viewport_meta']);
                add_action('wp_head', [$this, 'maybe_add_vieport']);
            }
        }

        /**
         * Remove Divi View Port
         *
         * @return void
         */
        public function maybe_remove_et_viewport_meta()
        {
            remove_action('wp_head', 'et_add_viewport_meta');
        }

        /**
         * Add Scaleable View Port
         *
         * @return void
         */
        public function maybe_add_vieport()
        {
            echo '<meta name="viewport" content="width=device-width, initial-scale=1, viewport-fit=cover">';
        }

    }
    (new PAC_DA_ET_Hooks())->instance()->init();
}