<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_Theme_Builder_Template')) {
    class PAC_DA_Theme_Builder_Template
    {
        private static $_instance;

        /**
         * Get Class Instance
         * @return PAC_DA_Theme_Builder_Template
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         * Add/Remove Necessary Actions/Filters
         */
        public function init()
        {
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"tBTDetails":false}'));
            $tBTDetails = isset($utilityCards->tBTDetails) ? $utilityCards->tBTDetails : false;
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            if(boolval($tBTDetails) && boolval($utilitySettings)){
                add_action('admin_bar_menu', [$this, 'maybe_show_template_details'], 999);
            }
        }

        /**
         * Add Admin Bar
         *
         * @param $wp_admin_bar
         *
         * @return void
         */
        public function maybe_show_template_details($wp_admin_bar)
        {
            if (is_admin()) return;
            list($template_title, $header_tpl_title, $body_tpl_title, $footer_tpl_title) = $this->get_template();
            // Menu Nodes
            $wp_admin_bar->add_node([
                'id' => 'theme_builder_template',
                'title' => __('Theme Builder Template', 'pac-divi-assistant'),
            ]);
            $wp_admin_bar->add_node([
                'parent' => 'theme_builder_template',
                'id' => 'theme_builder_template_name',
                'title' => sprintf(__('Template Name: %s', 'pac-divi-assistant'), esc_html($template_title)),
            ]);
            $wp_admin_bar->add_node([
                'parent' => 'theme_builder_template',
                'id' => 'theme_builder_header_template',
                'title' => sprintf(__('&nbsp;&nbsp;&#8226; Header Template: %s', 'pac-divi-assistant'), esc_html($header_tpl_title)),
            ]);
            $wp_admin_bar->add_node([
                'parent' => 'theme_builder_template',
                'id' => 'theme_builder_body_template',
                'title' => sprintf(__('&nbsp;&nbsp;&#8226; Body Template: %s', 'pac-divi-assistant'), esc_html($body_tpl_title)),
            ]);
            $wp_admin_bar->add_node([
                'parent' => 'theme_builder_template',
                'id' => 'theme_builder_footer_template',
                'title' => sprintf(__('&nbsp;&nbsp;&#8226; Footer Template: %s', 'pac-divi-assistant'), esc_html($footer_tpl_title)),
            ]);
        }

        /**
         * Get Template Data
         *
         * @return array
         */
        private function get_template()
        {
            $option_name = strtolower(get_class());
            // Retrieve the current theme builder request
            $request = ET_Theme_Builder_Request::from_current();
            // Extract necessary information from the request
            $id = $request->get_id();
            $type = $request->get_type();
            $sub_type = $request->get_subtype();
            // Get all available theme builder templates and flat template settings options
            $all_templates = et_theme_builder_get_theme_builder_templates(true);
            $settings = et_theme_builder_get_flat_template_settings_options();
            // Get the template based on the request
            $template = $request->get_template($all_templates, $settings);
            // Extract relevant information from the template
            $tpl_id = (int)et_()->array_get($template, 'id', 0);
            $tpl_title = et_()->array_get($template, 'title');
            $is_default_template = et_()->array_get($template, 'default', '0');
            if(empty($tpl_title) || (!$is_default_template && $tpl_title === 'Default Website Template')){
                $tpl_title = get_the_title($tpl_id);
            }
            $header_tpl_id = (int)et_()->array_get($template, 'layouts.header.id', '0');
            $body_tpl_id = (int)et_()->array_get($template, 'layouts.body.id', '0');
            $footer_tpl_id = (int)et_()->array_get($template, 'layouts.footer.id', '0');
            $is_tpl_enabled = get_post_meta($tpl_id, '_et_enabled', true);
            $is_header_tpl_enabled = (int)get_post_meta($tpl_id, '_et_header_layout_enabled', true);
            $is_body_tpl_enabled = (int)get_post_meta($tpl_id, '_et_body_layout_enabled', true);
            $is_footer_tpl_enabled = (int)get_post_meta($tpl_id, '_et_footer_layout_enabled', true);
            // Check if the template is the default one
            if ($is_default_template) {
                // Extract layout IDs for header, body, and footer from the default template
                $global_header_id = et_()->array_get($template, 'layouts.header.id', 0);
                $global_body_id = et_()->array_get($template, 'layouts.body.id', 0);
                $global_footer_id = et_()->array_get($template, 'layouts.footer.id', 0);
                // Create an array of theme builder templates using default layout IDs
                $global_template = [
                    'header_id' => 0 === $global_header_id ? '' : $global_header_id,
                    'body_id' => 0 === $global_body_id ? '' : $global_body_id,
                    'footer_id' => 0 === $global_footer_id ? '' : $global_footer_id
                ];
                // Update the theme builder templates option
                update_option($option_name, $global_template, 'no');
            }
            // Retrieve the theme builder templates from the options
            $global_template = get_option($option_name);
            $header_tpl_title = '';
            $body_tpl_title = '';
            $footer_tpl_title = '';
            if (!$is_tpl_enabled) {
                $tpl_title = __('Disabled', 'pac-divi-assistant');
            }
            // Check Header Template
            if (0 === $header_tpl_id) {
                $header_tpl_title = __('None', 'pac-divi-assistant');
            } elseif (!$is_header_tpl_enabled) {
                $header_tpl_title = __('Hidden', 'pac-divi-assistant');
            } elseif (!empty($global_template['header_id']) && $global_template['header_id'] === $header_tpl_id) {
                $header_tpl_title = __('Global Header', 'pac-divi-assistant');
            } elseif (!empty($global_template['header_id']) && $global_template['header_id'] !== $header_tpl_id) {
                $header_tpl_title = __('Custom Header', 'pac-divi-assistant');
            }
            // Check Body Template
            if (0 === $body_tpl_id) {
                $body_tpl_title = __('None', 'pac-divi-assistant');
            } elseif (!$is_body_tpl_enabled) {
                $body_tpl_title = __('Hidden', 'pac-divi-assistant');
            } elseif (!empty($global_template['body_id']) && $global_template['body_id'] === $body_tpl_id) {
                $body_tpl_title = __('Global Body', 'pac-divi-assistant');
            } elseif (/*!empty($global_template['body_id']) && */ $global_template['body_id'] !== $body_tpl_id) {
                $body_tpl_title = __('Custom Body', 'pac-divi-assistant');
            }
            // Check Footer Template
            if (0 === $footer_tpl_id) {
                $footer_tpl_title = __('None', 'pac-divi-assistant');
            } elseif (!$is_footer_tpl_enabled) {
                $footer_tpl_title = __('Hidden', 'pac-divi-assistant');
            } elseif (!empty($global_template['footer_id']) && $global_template['footer_id'] === $footer_tpl_id) {
                $footer_tpl_title = __('Global Footer', 'pac-divi-assistant');
            } elseif (/*!empty($global_template['footer_id']) &&*/ $global_template['footer_id'] !== $footer_tpl_id) {
                $footer_tpl_title = __('Custom Footer', 'pac-divi-assistant');
            }

            // Return an array containing the template titles
            return [
                $tpl_title,
                $header_tpl_title,
                $body_tpl_title,
                $footer_tpl_title,
            ];

        }
    }

    (new PAC_DA_Theme_Builder_Template())->instance()->init();
}