<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_Custom_Widget')) {
    class PAC_DA_Custom_Widget extends WP_Widget {
        public function __construct() {
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"diviLibWidget":false}'));
            $diviLibWidget = isset($utilityCards->diviLibWidget) ? $utilityCards->diviLibWidget : false;
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            if(boolval($diviLibWidget) && boolval($utilitySettings)){
                parent::__construct(
                    'pac_da_divi_library_widget',
                    __('Divi Layouts', PAC_DA_PLUGIN_TEXT_DOMAIN),
                    array('description' => __('Display a Divi Layout.', PAC_DA_PLUGIN_TEXT_DOMAIN))
                );
                add_action('widgets_init', array($this, 'register_custom_widget'));
            }
        }

        public function register_custom_widget() {
            register_widget($this);
        }

        public function widget($args, $instance) {

            $layout_id = isset($instance['layout_id']) ? $instance['layout_id'] : true;
            if( empty($layout_id) || !is_numeric($layout_id) ) {
                return;
            }

            $layout = get_post( $layout_id );
            if ( empty( $layout ) ) {
                return;
            }

            if ( empty( $layout->post_content ) ) {
                return;
            }

            echo wp_kses_post($args['before_widget']);
            echo wp_kses_post(do_shortcode( $layout->post_content ));
            echo wp_kses_post($args['after_widget']);
        }

        public function form($instance) {
            $selected_layout_id = ! empty( $instance['layout_id'] ) ? sanitize_key( $instance['layout_id'] ) : '';

            $layouts = get_posts( array(
                'post_type'      => 'et_pb_layout',
                'posts_per_page' => '-1',
                'post_status'    => 'publish',
                'meta_query'     => array(  // phpcs:ignore
                    array(
                        'key'     => '_et_pb_predefined_layout',
                        'compare' => 'NOT EXISTS',
                    ),
                    array(
                        'key'   => '_et_pb_built_for_post_type',
                        'value' => 'page',
                    ),
                ),
            ));

            $options = '';
            foreach ( $layouts as $layout ) {
                $options .= sprintf(
                    '<option value="%s" %s>%s</option>',
                    esc_attr( $layout->ID ),
                    selected( $selected_layout_id, $layout->ID, false ),
                    $layout->post_title
                );
            }

            if ( empty( $options ) ) {
                $options = __( 'No layouts found.', PAC_DA_PLUGIN_TEXT_DOMAIN );
            }

            echo '<p>';
            printf(
                '<label for="%s">%s:</label>',
                esc_attr($this->get_field_id( 'layout' )),
                esc_html__( 'Layout', PAC_DA_PLUGIN_TEXT_DOMAIN )
            );

            $allowed_tags = wp_kses_allowed_html('post');
            $allowed_tags['select'] = [
                'name' => true,
                'id' => true,
            ];
            $allowed_tags['option'] = [
                'value' => true,
            ];

            printf(
                '<select id="%s" name="%s" class="widefat">%s</select>',
                esc_attr($this->get_field_id( 'layout_id')),
                esc_attr($this->get_field_name( 'layout_id')),
                wp_kses($options, $allowed_tags)
            );
            echo '</p>';
        }

        public function update($new_instance, $old_instance) {
            $instance = array();
            $instance['layout_id'] = ! empty( $new_instance['layout_id'] ) ? sanitize_key( $new_instance['layout_id'] ) : '';
            return $instance;
        }
    }
    (new PAC_DA_Custom_Widget());
}
