<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_Filter_Project_Post_Type')) {
    class PAC_DA_Filter_Project_Post_Type
    {
        private static $_instance;

        /**
         * Get Class Instance
         * @return PAC_DA_Filter_Project_Post_Type
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         * Add/Remove Necessary Actions/Filters
         */
        public function init()
        {
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"hideProject":false,"renameProject":false}'));
            $hideProject = isset($utilityCards->hideProject) ? $utilityCards->hideProject : false;
            $renameProject = isset($utilityCards->renameProject) ? $utilityCards->renameProject : false;
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            if(!boolval($hideProject) && boolval($renameProject) && boolval($utilitySettings)){
                add_filter('register_post_type_args', [$this, 'maybe_modify_post_args'], 20, 2);
                add_filter('register_taxonomy_args', [$this, 'maybe_modify_taxonomy_args'], 10, 2);
            }
        }

        /**
         * @param $args
         * @param $post_type
         *
         * @return mixed
         */
        public function maybe_modify_post_args($args, $post_type)
        {
            if ($post_type == "project") {
                $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"pluralName":"Projects","singularName":"Project","slug":"projects"}'));
                $args['labels'] = [
                    'name' => $utilityCards->pluralName,
                    'singular_name' => $utilityCards->singularName,
                    'add_new_item' => sprintf('Add New %s', $utilityCards->singularName),
                    'edit_item' => sprintf('Edit %s', $utilityCards->singularName),
                    'new_item' => sprintf('New %s', $utilityCards->singularName),
                    'all_items' => sprintf('All %s', $utilityCards->pluralName),
                    'view_item' => sprintf('View %s', $utilityCards->singularName),
                    'search_items' => sprintf('Search %s', $utilityCards->pluralName),
                ];
                $args['menu_icon'] = $utilityCards->menuIcon;
                $args['rewrite'] = [
                    'slug' => $utilityCards->slug,
                ];
            }

            return $args;
        }

        /**
         * @param $args
         * @param $taxonomy
         *
         * @return mixed
         */
        public function maybe_modify_taxonomy_args($args, $taxonomy)
        {
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"pluralCategory":"Project Categories","singularCategory":"Project Category","slugCategory":"project_category","pluralTag":"Project Tags","singularTag":"Project Tag","slugTag":"project_tag","menuIcon":"dashicons-admin-post"}'));
            // Rename Project Category Labels and Slug
            if ($taxonomy === 'project_category') {
                $args['labels'] = [
                    'name' => sprintf('%s', $utilityCards->pluralCategory),
                    'singular_name' => sprintf('%s', $utilityCards->singularCategory),
                    'search_items' => sprintf('Search %s', $utilityCards->pluralCategory),
                    'all_items' => sprintf('All %s', $utilityCards->pluralCategory),
                    'parent_item' => sprintf('Parent %s', $utilityCards->singularCategory),
                    'parent_item_colon' => sprintf('Parent %s:', $utilityCards->singularCategory),
                    'edit_item' => sprintf('Edit %s', $utilityCards->singularCategory),
                    'update_item' => sprintf('Update %s', $utilityCards->singularCategory),
                    'add_new_item' => sprintf('Add New %s', $utilityCards->singularCategory),
                    'new_item_name' => sprintf('New %s Name', $utilityCards->singularCategory),
                    'menu_name' => sprintf('%s', $utilityCards->pluralCategory),
                    'not_found' => sprintf('You currently don\'t have any %s.', $utilityCards->pluralCategory),
                ];
                $args['rewrite'] = [
                    'slug' => $utilityCards->slugCategory,
                ];
            }
            // Rename Project Tag Labels and Slug
            if ($taxonomy === 'project_tag') {
                $args['labels'] = [
                    'name' => sprintf('%s', $utilityCards->pluralTag),
                    'singular_name' => sprintf('%s', $utilityCards->singularTag),
                    'search_items' => sprintf('Search %s', $utilityCards->pluralTag),
                    'all_items' => sprintf('All %s', $utilityCards->pluralTag),
                    'parent_item' => sprintf('Parent %s', $utilityCards->singularTag),
                    'parent_item_colon' => sprintf('Parent %s:', $utilityCards->singularTag),
                    'edit_item' => sprintf('Edit %s', $utilityCards->singularTag),
                    'update_item' => sprintf('Update %s', $utilityCards->singularTag),
                    'add_new_item' => sprintf('Add New %s', $utilityCards->singularTag),
                    'new_item_name' => sprintf('New %s Name', $utilityCards->singularTag),
                    'menu_name' => sprintf('%s', $utilityCards->pluralTag),
                    'not_found' => sprintf('You currently don\'t have any  %s.', $utilityCards->pluralTag),
                ];
                $args['rewrite'] = [
                    'slug' => $utilityCards->slugTag,
                ];
            }

            return $args;
        }

    }

    (new PAC_DA_Filter_Project_Post_Type())->instance()->init();
}