<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_General_CSS')) {
    class PAC_DA_General_CSS
    {

        private static $_instance;

        /**
         * Get Class Instance
         *
         * @return PAC_DA_General_CSS
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         *
         * Add/Remove Necessary Actions/Filters
         */
        public function init()
        {
            add_action('wp_enqueue_scripts', [$this, 'enqueue'],999);
            add_action('admin_enqueue_scripts', [$this, 'admin_enqueue']);
        }

        /**
         * Enqueue CSS
         *
         * @return void
         */
        public function enqueue()
        {
            $css_content = "";
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"staticCss":false,"localStorage":false,"hardRefresh":false,"quickLinks":false,"duplicateDiviLib":false,"exportDiviLib":false,"openVisualBuilder":false,"escKey":false,"horizontalScroll":false,"cursorHighlight":false,"bgHighlight":"#3399ff","textHighlight":"#ffffff","hideProject":false,"renameProject":false,"pluralName":"Projects","singularName":"Project","slug":"projects","pluralCategory":"Project Categories","singularCategory":"Project Category","slugCategory":"project_category","pluralTag":"Project Tags","singularTag":"Project Tag","slugTag":"project_tag","menuIcon":"dashicons-admin-post","defaultThemes":false,"updateThemes":false,"updatePlugins":false,"themeBuilderCPT":false,"fullScreen":false,"edidorBtn":false,"stickyToolbar":false,"htmlArea":false,"htmlAreaValue":"400","popupHeight":false,"popupHeightValue":"500","iconAreaHeight":false,"iconAreaHeightValue":"300","textPopover":false,"rowWidth":false,"swapSandGbtn":false,"hideExploreBtn":false,"disableAi":false}'));
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true,"frontend":true,"accessibility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            $frontendSettings = isset($enableAddons->frontend) ? $enableAddons->frontend : true;
            $environmentsData = json_decode(get_option('pacDaEnvironmentsData', '{"enable":false,"prodLabel":"Production","prodClr":"#00D263","stagLabel":"Staging","stagClr":"#7846FF","devLabel":"Development","devClr":"#F15A24"}'));
            $stickyToolbar = isset($utilityCards->stickyToolbar) ? $utilityCards->stickyToolbar : false;
            $hideExploreBtn = isset($utilityCards->hideExploreBtn) ? $utilityCards->hideExploreBtn : false;

            $accessibilityHelperData = json_decode(get_option('pacDaAccessibilityHelper', '{"skipNavigation":false,"hideSkipNavigation":false}'));
            $accessibilitySettings = isset($enableAddons->accessibility) ? $enableAddons->accessibility : true;
            $skipNavigation = isset($accessibilityHelperData->skipNavigation) ? $accessibilityHelperData->skipNavigation : true;
            $hideSkipNavigation = isset($accessibilityHelperData->hideSkipNavigation) ? $accessibilityHelperData->hideSkipNavigation : true;

            $disableAi = isset($utilityCards->disableAi) ? $utilityCards->disableAi : false;
            if(boolval($disableAi) && boolval($utilitySettings)) {
                $css_content .= ".et-code-ai-btn {display:none;}";
            }
            
            if (boolval($hideExploreBtn)) {
                $css_content .= ".et-fb-module-upsell-button{display: none !important;}";
            }
            if (boolval($skipNavigation)) {
                $css_content .= ".skip-link.da-screen-reader-text {position: fixed;left: 0;top: var(--admin-bar-top);z-index: 999999999999;background-color: #f1f1f1;box-shadow: 0 0 2px 2px rgba(0, 0, 0, 0.6);color: #0073aa;display: block;font-weight: 600;height: auto;line-height: normal;padding: 15px 23px 14px;}";
            }
            if (boolval($skipNavigation) && boolval($hideSkipNavigation)) {
                $css_content .= ".skip-link.da-screen-reader-text {opacity: 0;}.skip-link.da-screen-reader-text:focus {opacity: 1;}";
            }
            if (boolval($stickyToolbar) && boolval($utilitySettings)) {
                $css_content .= ".mce-panel .mce-stack-layout-item.mce-first{position: sticky!important;top: -60px;}.et-fb-modal--expanded .mce-panel .mce-stack-layout-item.mce-first{top: -24px!important;}";
            }
            $textPopover = isset($utilityCards->textPopover) ? $utilityCards->textPopover : false;
            if (boolval($textPopover) && boolval($utilitySettings)) {
                $css_content .= ".et-db #et-boc .et-fb-popover--inverse.et-fb-popover--arrow {display: none!important;}";
            }
            $popupHeight = isset($utilityCards->popupHeight) ? $utilityCards->popupHeight : false;
            if (boolval($popupHeight) && boolval($utilitySettings)) {
                $css_content .= ".et-fb-field-settings-modal {max-height:" . (int)$utilityCards->popupHeightValue . "px!important;}";
            }
            $iconAreaHeight = isset($utilityCards->iconAreaHeight) ? $utilityCards->iconAreaHeight : false;
            if (boolval($iconAreaHeight) && boolval($utilitySettings)) {
                $css_content .= ".et-db #et-boc .et-l .et-fb-font-icon-list { min-height:" . (int)$utilityCards->iconAreaHeightValue . "px!important;}";
            }
            $cursorHighlight = isset($utilityCards->cursorHighlight) ? $utilityCards->cursorHighlight : false;
            if (boolval($cursorHighlight) && boolval($frontendSettings)) {
                $css_content .= "::selection {color:" . $utilityCards->textHighlight . "!important;background-color:" . $utilityCards->bgHighlight . "!important;}";
                $css_content .= "::-moz-selection {color:" . $utilityCards->textHighlight . "!important;background-color:" . $utilityCards->bgHighlight . "!important;}";
            }
            $horizontalScroll = isset($utilityCards->horizontalScroll) ? $utilityCards->horizontalScroll : false;
            if (boolval($horizontalScroll) && boolval($frontendSettings)) {
                $css_content .= "@media all and (max-width: 980px) {html, body {overflow-x: hidden;} body {position: relative}}";
            }
            $htmlArea = isset($utilityCards->htmlArea) ? $utilityCards->htmlArea : false;
            if (boolval($htmlArea) && boolval($utilitySettings)) {
                $css_content .= ".et-db #et-boc .et-l .et-fb-option--tiny-mce .et-fb-tinymce-html-input { min-height:" . (int)$utilityCards->htmlAreaValue . "px!important;}";
            }
            $rowWidth = isset($utilityCards->rowWidth) ? $utilityCards->rowWidth : false;
            if (boolval($rowWidth) && boolval($utilitySettings)) {
                $css_content .= ".et-db #et-boc .et-l .et-l--post .et_builder_inner_content .et_pb_row {width: 100%;}";
            }
            $swapSandGbtn = isset($utilityCards->swapSandGbtn) ? $utilityCards->swapSandGbtn : false;
            if (boolval($swapSandGbtn) && boolval($utilitySettings) && !empty($_GET['et_fb'])) {
                $css_content .= ".et-fb-settings-color-manager__saved-global-recent-switches {display:flex;align-items:center;}";
                $css_content .= ".et-fb-settings-color-manager__saved-global-recent-switches  > span[data-mode='global'] {order: 1;}";
                $css_content .= ".et-fb-settings-color-manager__saved-global-recent-switches  > span[data-mode='saved'] {order: 2;}";
                $css_content .= ".et-fb-settings-color-manager__saved-global-recent-switches  > span[data-mode='recent'] {order: 3;}";
                $css_content .= ".et-fb-settings-color-manager__saved-global-recent-switches  > span:nth-child(4) {order: 4;}";
            }
            
            $enable = isset($environmentsData->enable) ? $environmentsData->enable : false;
            if (boolval($enable) && boolval($utilitySettings)) {
                $css_content .= ".pac-da-environment.development div:before {background-color:" . pac_da_check_global_color_gcid($environmentsData->devClr) . "!important;}";
                $css_content .= ".pac-da-environment.staging div:before {background-color:" . pac_da_check_global_color_gcid($environmentsData->stagClr) . "!important;}";
                $css_content .= ".pac-da-environment.production div:before {background-color:" . pac_da_check_global_color_gcid($environmentsData->prodClr) . "!important;}";
            }
            $scrollbar = json_decode(get_option('pacDaScrollbar', '{"scrollbar":false,"barWidth":"17px","barBgColor":"#f1f1f1","barRaduis":"3px","barHandleColor":"#c1c1c1","barHandleHColor":"#c1c1c1"}'));
            $scrollbarValue = isset($scrollbar->scrollbar) ? $scrollbar->scrollbar : false;
            if (boolval($frontendSettings) && boolval($scrollbarValue) && empty($_GET['et_fb'])) {
                $css_content .= "::-webkit-scrollbar {width:" . (int)$scrollbar->barWidth . "px!important;}";
                $css_content .= "::-webkit-scrollbar-track {background:" . pac_da_check_global_color_gcid($scrollbar->barBgColor) . "!important;}";
                $css_content .= "::-webkit-scrollbar-thumb {background:" . pac_da_check_global_color_gcid($scrollbar->barHandleColor) . "!important;border-radius:" . (int)$scrollbar->barRaduis . "px!important;}";
                $css_content .= "::-webkit-scrollbar-thumb:hover {background:" . pac_da_check_global_color_gcid($scrollbar->barHandleHColor) . "!important;}";
            }

            $backToTop = json_decode(get_option('pacDaBackToTop', '{"backToTop":false,"devices":"all","btnBgColor":"rgba(0,0,0,0.4)","btnBgHColor":"rgba(0,0,0,0.4)","btnRadius":"5px","right":"0px","bottom":"125px","btnTextColor":"#ffffff","btnTextHColor":"#ffffff","btnContent":"icon","btnIcon":"","btnText":"","btnIconPlacement":"left"}'));
            $backToTopValue = isset($backToTop->backToTop) ? $backToTop->backToTop : false;
            if (boolval($frontendSettings) && boolval($backToTopValue)) {
                if($backToTop->devices === 'desktop_tablet'){
                    $css_content .= "@media only screen and (max-width: 767px) {body .et_pb_scroll_top {display:none !important;}}";
                }elseif($backToTop->devices === 'desktop_phone'){
                    $css_content .= "@media only screen and (max-width: 980px) and (min-width: 768px) {body .et_pb_scroll_top  {display:none !important;}}";
                }elseif($backToTop->devices === 'tablet_phone'){
                    $css_content .= "@media only screen and (min-width: 981px) {body .et_pb_scroll_top  {display:none !important;}}";
                }elseif($backToTop->devices === 'desktop'){
                    $css_content .= "@media only screen and (max-width: 980px) {body .et_pb_scroll_top  {display:none !important;}}";
                }elseif($backToTop->devices === 'tablet'){
                    $css_content .= "@media only screen and (min-width: 981px) {body .et_pb_scroll_top  {display:none !important;}}";
                    $css_content .= "@media only screen and (max-width: 767px) {body .et_pb_scroll_top  {display:none !important;}}";
                }elseif($backToTop->devices === 'mobile'){
                    $css_content .= "@media only screen and (min-width: 768px) {body .et_pb_scroll_top  {display:none !important;}}";
                }
                $css_content .= "body .et_pb_scroll_top {background-color:" . pac_da_check_global_color_gcid($backToTop->btnBgColor) . "!important;color:" . pac_da_check_global_color_gcid($backToTop->btnTextColor) . "!important;right:" . (int)$backToTop->right . "px!important;bottom:" . (int)$backToTop->bottom . "px!important;border-radius:" . $backToTop->btnRadius . " !important;}";
                $css_content .= "body .et_pb_scroll_top:hover {background-color:" . pac_da_check_global_color_gcid($backToTop->btnBgHColor) . "!important;color:" . pac_da_check_global_color_gcid($backToTop->btnTextHColor) . "!important;}";
                if($backToTop->btnContent === 'icon'){
                    $css_content .= "body .et_pb_scroll_top:before {content:\"" . ($backToTop->btnIcon === '' ? '2' : $backToTop->btnIcon) . "\" !important;}";
                }elseif($backToTop->btnContent === 'text'){
                    $css_content .= "body .et_pb_scroll_top:before {display:none !important;}";
                    $css_content .= "body .et_pb_scroll_top:after {content:\"" . ($backToTop->btnText === '' ? 'Back To Top' : $backToTop->btnText) . "\" !important;font-family:Open Sans,Arial,sans-serif !important;line-height:30px !important;font-size:22px !important;position:relative;top:-2px;padding: 0px 7px;}";
                }elseif($backToTop->btnContent === 'icon_text'){
                    if($backToTop->btnIconPlacement === 'left'){
                        $css_content .= "body .et_pb_scroll_top:before {content:\"" . ($backToTop->btnIcon === '' ? '2' : $backToTop->btnIcon) . "\" !important;position:relative;top:3px;}";
                        $css_content .= "body .et_pb_scroll_top:after {content:\"" . ($backToTop->btnText === '' ? 'Back To Top' : $backToTop->btnText) . "\" !important;font-family:Open Sans,Arial,sans-serif !important;line-height:30px !important;font-size:22px !important;position:relative;top:-2px;margin-left:10px !important;}";
                    }elseif($backToTop->btnIconPlacement === 'right'){
                        $css_content .= "body .et_pb_scroll_top:after {content:\"" . ($backToTop->btnIcon === '' ? '2' : $backToTop->btnIcon) . "\" !important;position:relative;top:3px;}";
                        $css_content .= "body .et_pb_scroll_top:before {content:\"" . ($backToTop->btnText === '' ? 'Back To Top' : $backToTop->btnText) . "\" !important;font-family:Open Sans,Arial,sans-serif !important;line-height:30px !important;font-size:22px !important;position:relative;top:-2px;margin-right:10px !important;}";
                    }
                }
            }

            // Hide Adminbar Permaently
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"adminbarEverywhere":false,"adminbarFrontend":false,"adminbarHover":false}'));
            $adminbarHover = isset($utilityCards->adminbarHover) ? $utilityCards->adminbarHover : false;
            if (boolval($adminbarHover) && boolval($utilitySettings)) {
                $adminbarEverywhere = isset($utilityCards->adminbarEverywhere) ? $utilityCards->adminbarEverywhere : false;
                $adminbarFrontend = isset($utilityCards->adminbarFrontend) ? $utilityCards->adminbarFrontend : false;
                if(boolval($adminbarEverywhere)){
                    $css_content .= "#wpadminbar {display:none;z-index:999999}";
                    $css_content .= "#wpadminbar:hover {display:block;}";
                    $css_content .= "#main-header.moveup {top:0!important;}";
                    $css_content .= "html.moveup {margin-top:0!important;}";
                    $css_content .= "html.moveup.et-has-admin-bar.et-fb-preview--desktop {margin-top:0!important;}";
                    $css_content .= "#pac_da_show_adminbar:hover {display:none!important;}";
                    $css_content .= "#pac_da_show_adminbar:hover + #wpadminbar {display:block!important;}";
                    $css_content .= "#pac_da_show_adminbar {position: fixed;z-index: 999990;padding: 2px 10px;box-sizing: border-box;line-height: 28px;font-size: 13px;font-weight: 400;color: #f0f0f1;cursor: pointer;background-color: #1d2327;top:0;left:0;}";
                }elseif(boolval($adminbarFrontend)){
                    if (!empty($_GET['et_fb'])) {
                        $css_content .= "#wpadminbar {display:none;z-index:999999}";
                        $css_content .= "#wpadminbar:hover {display:block;}";
                        $css_content .= "#main-header.moveup {top:0!important;}";
                        $css_content .= "html.moveup {margin-top:0!important;}";
                        $css_content .= "html.moveup.et-has-admin-bar.et-fb-preview--desktop {margin-top:0!important;}";
                        $css_content .= "#pac_da_show_adminbar:hover {display:none!important;}";
                        $css_content .= "#pac_da_show_adminbar:hover + #wpadminbar {display:block!important;}";
                        $css_content .= "#pac_da_show_adminbar {position: fixed;z-index: 999990;padding: 2px 10px;box-sizing: border-box;line-height: 28px;font-size: 16px;font-weight: 500;color: #FFF;cursor: pointer;background-color: red;border-radius: 3px;top:0;left:0;}";
                    }
                }
            }

            // Register Inline CSS
            wp_register_style('pac-da', false, [], '1.0.0');
            wp_enqueue_style('pac-da');
            wp_add_inline_style('pac-da', $css_content);
        }

        public function admin_enqueue()
        {
            $css_content_admin = "";
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"staticCss":false,"localStorage":false,"hardRefresh":false,"quickLinks":false,"adminbarEverywhere":false,"adminbarFrontend":false,"adminbarHover":false,"duplicateDiviLib":false,"exportDiviLib":false,"diviLibWidget":false,"diviLibSC":false,"openVisualBuilder":false,"escKey":false,"hideLayout":false,"disableAi":false,"horizontalScroll":false,"cursorHighlight":false,"bgHighlight":"#3399ff","textHighlight":"#ffffff","hideProject":false,"renameProject":false,"pluralName":"Projects","singularName":"Project","slug":"projects","pluralCategory":"Project Categories","singularCategory":"Project Category","slugCategory":"project_category","pluralTag":"Project Tags","singularTag":"Project Tag","slugTag":"project_tag","menuIcon":"dashicons-admin-post","defaultThemes":false,"updateThemes":false,"updatePlugins":false,"themeBuilderCPT":false,"fullScreen":false,"edidorBtn":false,"stickyToolbar":false,"htmlArea":false,"htmlAreaValue":"400","popupHeight":false,"popupHeightValue":"500","iconAreaHeight":false,"iconAreaHeightValue":"300","textPopover":false,"rowWidth":false}'));
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            $environmentsData = json_decode(get_option('pacDaEnvironmentsData', '{"enable":false,"prodLabel":"Production","prodClr":"#00D263","stagLabel":"Staging","stagClr":"#7846FF","devLabel":"Development","devClr":"#F15A24"}'));
            $codeData = json_decode(get_option('pacDaCodeData', '{"css":false,"jquery":false,"php":false,"enableResize":false,"boxHeight":false,"boxHeightValue":"313px","enableResizeCe":false,"boxHeightCe":false,"boxHeightValueCe":"313px"}'));
            $boxHeight = isset($codeData->boxHeight) ? $codeData->boxHeight : false;
            $boxHeightCe = isset($codeData->boxHeightCe) ? $codeData->boxHeightCe : false;
            $boxHeightValueCe = isset($codeData->boxHeightValueCe) ? $codeData->boxHeightValueCe : '313';
            $enableResize = isset($codeData->enableResize) ? $codeData->enableResize : false;
            $enableResizeCe = isset($codeData->enableResizeCe) ? $codeData->enableResizeCe : false;
            $enableAddons = json_decode(get_option('pacDaAddons', '{"startUp":true,"maintenance":true,"utility":true,"media":true,"learning":true,"support":true,"fonts":true,"styles":true,"code":true,"frontend":true,"accessibility":true}'));
            $codeSettings = isset($enableAddons->code) ? $enableAddons->code : true;
            if (boolval($boxHeight) && boolval($codeSettings)) {
                $css_content_admin .= "#divi_custom_css + .CodeMirror-wrap { min-height:" . (int)$codeData->boxHeightValue . "px;}";
            }
            if (boolval($boxHeightCe) && boolval($codeSettings)) {
                $css_content_admin .= "#divi_integration_head + .CodeMirror-wrap, #divi_integration_body + .CodeMirror-wrap, #divi_integration_single_top + .CodeMirror-wrap, #divi_integration_single_bottom + .CodeMirror-wrap { min-height:" . (int)$boxHeightValueCe . "px;}";
            }
            if (boolval($enableResize) && boolval($codeSettings)) {
                $css_content_admin .= "#divi_custom_css + .CodeMirror-wrap {resize: vertical;}";
            }
            if (boolval($enableResizeCe) && boolval($codeSettings)) {
                $css_content_admin .= "#divi_integration_head + .CodeMirror-wrap, #divi_integration_body + .CodeMirror-wrap, #divi_integration_single_top + .CodeMirror-wrap, #divi_integration_single_bottom + .CodeMirror-wrap {resize: vertical;}";
            }
            $disableAi = isset($utilityCards->disableAi) ? $utilityCards->disableAi : false;
            if(boolval($disableAi) && boolval($utilitySettings)) {
                $css_content_admin .= "#et_pb_administrator_role .et_pb_roles_options_internal:nth-child(1) .et_pb_capability_option:nth-child(4) {display:none;} #et_pb_administrator_role .et_pb_roles_options_internal:nth-child(1) .et_pb_capability_option:nth-child(5) {margin-right:3%;}#et_pb_editor_role .et_pb_roles_options_internal:nth-child(1) .et_pb_capability_option:nth-child(3) {display:none;}#et_pb_editor_role .et_pb_roles_options_internal:nth-child(1) .et_pb_capability_option:nth-child(5) {margin-right:3%;}";
            }

            $edidorBtn = isset($utilityCards->edidorBtn) ? $utilityCards->edidorBtn : false;
            if(boolval($edidorBtn) && boolval($utilitySettings)) {
                if(get_option('et_divi')['et_enable_classic_editor'] === "on"){
                    $css_content_admin .= ".et_pb_toggle_builder_wrapper #et_pb_toggle_builder.et_pb_builder_is_used {display: none !important;} #et_pb_toggle_builder.et_pb_builder_is_used + #et_pb_fb_cta {margin-left: 0 !important;}";
                    $css_content_admin .= ".et-db #et-boc .et-l #et_pb_toggle_builder.et_pb_builder_is_used {display: none;}.et-db #et-boc .et-l #et_pb_fb_cta {margin-left: 0;}";
                } else {
                    $css_content_admin .= ".block-editor__container .editor-post-switch-to-gutenberg.components-button.is-default {display: none !important;} .block-editor__container #et-switch-to-gutenberg, .block-editor__container #et-switch-to-gutenberg.components-button.is-default {display: none !important;}";
                }
            }
            $enable = isset($environmentsData->enable) ? $environmentsData->enable : false;
            if (boolval($enable) && boolval($utilitySettings)) {
                $css_content_admin .= ".pac-da-environment.development div:before {background-color:" . pac_da_check_global_color_gcid($environmentsData->devClr) . "!important;}";
                $css_content_admin .= ".pac-da-environment.staging div:before {background-color:" . pac_da_check_global_color_gcid($environmentsData->stagClr) . "!important;}";
                $css_content_admin .= ".pac-da-environment.production div:before {background-color:" . pac_da_check_global_color_gcid($environmentsData->prodClr) . "!important;}";
            }

            // Register Inline CSS
            wp_register_style('pac-da-admin', false, [], '1.0.0');
            wp_enqueue_style('pac-da-admin');
            wp_add_inline_style('pac-da-admin', $css_content_admin);
        }
    }

    (new PAC_DA_General_CSS())->instance()->init();
}
