<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_General_JS')) {
    class PAC_DA_General_JS
    {

        private static $_instance;

        /**
         * Get Class Instance
         *
         * @return PAC_DA_General_JS
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         *
         * Add/Remove Necessary Actions/Filters
         */
        public function init()
        {
            add_action('wp_enqueue_scripts', [$this, 'enqueue']);
            add_action('wp_enqueue_scripts', [$this, 'enqueue_premade_layouts']);
            add_action('admin_enqueue_scripts', [$this, 'admin_enqueue_premade_layouts']);
            $enableAddons = json_decode(get_option('pacDaAddons', '{"accessibility":true}'));
            $accessibilitySettings = isset($enableAddons->accessibility) ? $enableAddons->accessibility : true;
            if(boolval($accessibilitySettings)){
                add_action('wp_enqueue_scripts', [$this, 'enqueue_accessibility']);
            }
        }

        /**
         * Enqueue CSS
         *
         * @return void
         */
        public function enqueue()
        {
            $output = '';
            ob_start();
            if (boolval(json_decode(get_option('pacDaUtilityCards','{"escKey":false}'))->escKey) && boolval(json_decode(get_option('pacDaAddons','{"utility":true}'))->utility)) { ?>
                jQuery(document).ready(function(){
                    jQuery(document).keyup(function (e) {
                        if (e.keyCode === 27) {
                            let builderKey = document.location.href.indexOf("?et_fb=1&PageSpeed=off");
                            if (jQuery('body').hasClass('logged-in')) {
                                if (builderKey >= 0) {
                                    if(jQuery('li#wp-admin-bar-et-disable-visual-builder>a')[0] !== undefined){
                                        jQuery('li#wp-admin-bar-et-disable-visual-builder>a')[0].click();
                                    }
                                    else{
                                        document.location.href = document.location.href.substring(0,builderKey);
                                    }
                                }
                                else
                                {
                                    if(jQuery('li#wp-admin-bar-et-use-visual-builder>a')[0] !== undefined){
                                        jQuery('li#wp-admin-bar-et-use-visual-builder>a')[0].click();
                                    }else{
                                        document.location.href = document.location.href + '?et_fb=1&PageSpeed=off';
                                    }
                                }
                            }
                        }
                    });
                });
                <?php
            }

            // Hide Image Title
            $mediaCards = json_decode(get_option('pacDaMediaCards', '{"imgTitle":true}'));
            $imgTitle = isset($mediaCards->imgTitle) ? $mediaCards->imgTitle : false;
            if(boolval($imgTitle)) { ?>
                jQuery(document).ready(function($) {
                    $("img").mouseenter(function() {
                        let $pac_da_title = $(this).attr("title");
                        $(this).attr("pac_da_title", $pac_da_title);
                        $(this).attr("title", "");
                    }).mouseleave(function() {
                        let $pac_da_title = $(this).attr("pac_da_title");
                        $(this).attr("title", $pac_da_title);
                        $(this).removeAttr("pac_da_title");
                    });
                });
                <?php
            }

            // Hide Adminbar Permaently
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"adminbarEverywhere":false,"adminbarFrontend":false,"adminbarHover":false}'));
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            $adminbarHover = isset($utilityCards->adminbarHover) ? $utilityCards->adminbarHover : false;
            if (boolval($adminbarHover)  && boolval($utilitySettings)) {
                $adminbarEverywhere = isset($utilityCards->adminbarEverywhere) ? $utilityCards->adminbarEverywhere : false;
                $adminbarFrontend = isset($utilityCards->adminbarFrontend) ? $utilityCards->adminbarFrontend : false;
                if(boolval($adminbarEverywhere)){
                    ?>
                        jQuery(document).ready(function(){
                            if(jQuery('#main-header').length > 0){
                                jQuery('#main-header').addClass('moveup');
                            }else if(jQuery('iframe')[0] !== undefined){
                                var iframe = jQuery('iframe')[0].contentWindow.document;
                                if(jQuery('#main-header', iframe).length > 0){
                                    jQuery('#main-header', iframe).addClass('moveup');
                                }else{
                                    jQuery('html', iframe).addClass('moveup');
                                    jQuery('html', iframe).css('margin-top', '0px');
                                }
                            }else{
                                jQuery('html').addClass('moveup');
                            }
                            var button = jQuery('<div>').text("Show Admin Bar").attr('id', 'pac_da_show_adminbar');
                            jQuery('#wpadminbar').before(button);
                            jQuery('#wpadminbar').hover(function() {
                                jQuery('#pac_da_show_adminbar').hide();
                                if(jQuery('#main-header').length > 0){
                                    jQuery('#main-header').removeClass('moveup');
                                }else if(jQuery('iframe')[0] !== undefined){
                                    var iframe = jQuery('iframe')[0].contentWindow.document;
                                    if(jQuery('#main-header', iframe).length > 0){
                                        jQuery('#main-header', iframe).removeClass('moveup');
                                    }else{
                                        jQuery('html', iframe).removeClass('moveup');
                                    }
                                    
                                }else{
                                    jQuery('html').removeClass('moveup');
                                }
                            }, function() {
                                jQuery('#pac_da_show_adminbar').show();
                                if(jQuery('#main-header').length > 0){
                                    jQuery('#main-header').addClass('moveup');
                                }else if(jQuery('iframe')[0] !== undefined){
                                    var iframe = jQuery('iframe')[0].contentWindow.document;
                                    if(jQuery('#main-header', iframe).length > 0){
                                        jQuery('#main-header', iframe).addClass('moveup');
                                    }else{
                                        jQuery('html', iframe).addClass('moveup');
                                        jQuery('html', iframe).css('margin-top', '0px');
                                    }
                                }else{
                                    jQuery('html').addClass('moveup');
                                }
                            });
                        });
                    <?php
                }elseif(boolval($adminbarFrontend)){
                    if (!empty($_GET['et_fb'])) {
                        ?>
                            jQuery(document).ready(function(){
                                if(jQuery('#main-header').length > 0){
                                    jQuery('#main-header').addClass('moveup');
                                }else if(jQuery('iframe')[0] !== undefined){
                                    var iframe = jQuery('iframe')[0].contentWindow.document;
                                    if(jQuery('#main-header', iframe).length > 0){
                                        jQuery('#main-header', iframe).addClass('moveup');
                                    }else{
                                        jQuery('html', iframe).addClass('moveup');
                                        jQuery('html', iframe).css('margin-top', '0px');
                                    }
                                }else{
                                    jQuery('html').addClass('moveup');
                                }
                                var button = jQuery('<div>').text("Show Admin Bar").attr('id', 'pac_da_show_adminbar');
                                jQuery('#wpadminbar').before(button);
                                jQuery('#wpadminbar').hover(function() {
                                    jQuery('#pac_da_show_adminbar').hide();
                                    if(jQuery('#main-header').length > 0){
                                        jQuery('#main-header').removeClass('moveup');
                                    }else if(jQuery('iframe')[0] !== undefined){
                                        var iframe = jQuery('iframe')[0].contentWindow.document;
                                        if(jQuery('#main-header', iframe).length > 0){
                                            jQuery('#main-header', iframe).removeClass('moveup');
                                        }else{
                                            jQuery('html', iframe).removeClass('moveup');
                                        }
                                        
                                    }else{
                                        jQuery('html').removeClass('moveup');
                                    }
                                }, function() {
                                    jQuery('#pac_da_show_adminbar').show();
                                    if(jQuery('#main-header').length > 0){
                                        jQuery('#main-header').addClass('moveup');
                                    }else if(jQuery('iframe')[0] !== undefined){
                                        var iframe = jQuery('iframe')[0].contentWindow.document;
                                        if(jQuery('#main-header', iframe).length > 0){
                                            jQuery('#main-header', iframe).addClass('moveup');
                                        }else{
                                            jQuery('html', iframe).addClass('moveup');
                                            jQuery('html', iframe).css('margin-top', '0px');
                                        }
                                    }else{
                                        jQuery('html').addClass('moveup');
                                    }
                                });
                            });
                        <?php
                    }
                }
            }
            $enableAddons = json_decode(get_option('pacDaAddons', '{"frontend":true}'));
            $frontendSettings = isset($enableAddons->frontend) ? $enableAddons->frontend : true;
            if(boolval(get_option('pacDaTextReplace', false)) && boolval($frontendSettings)){
                $textReplaceData = json_decode(get_option('pacDaTextReplaceData','[{"selector": "", "customText": ""},{"selector": "", "customText": ""}]'));
                foreach ($textReplaceData as $textReplace) {
                    $textReplace = get_object_vars($textReplace);
                    ?>
                        jQuery(document).ready(function(){
                            jQuery("<?php echo $textReplace['selector'] ?>").html("<?php echo $textReplace['customText'] ?>");
                        });
                    <?php
                }
            }
            $output .= ob_get_contents();
            ob_end_clean();
            wp_register_script('pac-da', '', ['jquery'], '1.0.0', true);
            wp_enqueue_script('pac-da');
            wp_add_inline_script('pac-da', $output);
        }
        public function enqueue_accessibility()
        {
            $accessibilityHelperData = json_decode(get_option('pacDaAccessibilityHelper', '{"focusable":false,"outline":false,"outlineColor":"#E1271A","ariaSupport":false,"iconsAria":false,"Underline":false,"underlineHeading":false,"underlineBtns":false,"underlineMenu":false,"skipNavigation":false,"duplicateMenu":false,"dropdownMenu":false,"improveScreenReader":false,"pinchZoom":false,"Tota11y":false}'));
            $focusable = isset($accessibilityHelperData->focusable) ? $accessibilityHelperData->focusable : false;
            if (boolval($focusable)) {
                wp_enqueue_script("pac-da-accessibility-focusable", PAC_DA_PLUGIN_URL . 'include/php/public/js/focusable-modules.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
            }
            $outline = isset($accessibilityHelperData->outline) ? $accessibilityHelperData->outline : false;
            $outlineColor = isset($accessibilityHelperData->outlineColor) ? $accessibilityHelperData->outlineColor : '#E1271A';
            $outlineColor = pac_da_check_global_color_gcid($outlineColor);
            if (boolval($outline) && empty($_GET['et_fb'])) {
                wp_enqueue_script("pac-da-keyboard-navigation-outline", PAC_DA_PLUGIN_URL . 'include/php/public/js/keyboard-navigation-outline.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
                wp_localize_script( 'pac-da-keyboard-navigation-outline', 'pac_da_objj', [
                    'keyboardOutlineColor'  => $outlineColor,
                ]);
                wp_enqueue_style("pac-da-keyboard-navigation-outline-style", PAC_DA_PLUGIN_URL . 'include/php/public/css/keyboard-navigation-outline.min.css', [], PAC_DA_PLUGIN_VERSION);
            }
            $ariaSupport = isset($accessibilityHelperData->ariaSupport) ? $accessibilityHelperData->ariaSupport : false;
            if (boolval($ariaSupport)) {
                wp_enqueue_script("pac-da-aria-Support", PAC_DA_PLUGIN_URL . 'include/php/public/js/aria-support.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
                wp_enqueue_script("pac-da-aria-Support-mobile", PAC_DA_PLUGIN_URL . 'include/php/public/js/mobile-menu-aria-support.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
            }
            $iconsAria = isset($accessibilityHelperData->iconsAria) ? $accessibilityHelperData->iconsAria : false;
            if (boolval($iconsAria)) {
                wp_enqueue_script("pac-da-aria-hidden-icons", PAC_DA_PLUGIN_URL . 'include/php/public/js/aria-hidden-icons.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
            }
            $Underline = isset($accessibilityHelperData->Underline) ? $accessibilityHelperData->Underline : false;
            if (boolval($Underline)) {
                if (empty($_GET['et_fb'])) {
                    wp_enqueue_style("pac-da-underline-links-style", PAC_DA_PLUGIN_URL . 'include/php/public/css/underline-links.min.css', [], PAC_DA_PLUGIN_VERSION);
                }
            }
            $underlineHeading = isset($accessibilityHelperData->underlineHeading) ? $accessibilityHelperData->underlineHeading : false;
            if (boolval($underlineHeading)) {
                wp_enqueue_style("pac-da-underline-links-exclude-heading-style", PAC_DA_PLUGIN_URL . 'include/php/public/css/underline-links-exclude-heading.min.css', [], PAC_DA_PLUGIN_VERSION);
            }
            $underlineBtns = isset($accessibilityHelperData->underlineBtns) ? $accessibilityHelperData->underlineBtns : false;
            if (boolval($underlineBtns)) {
                wp_enqueue_style("pac-da-underline-links-exclude-btns-style", PAC_DA_PLUGIN_URL . 'include/php/public/css/underline-links-exclude-btns.min.css', [], PAC_DA_PLUGIN_VERSION);
            }
            $underlineMenu = isset($accessibilityHelperData->underlineMenu) ? $accessibilityHelperData->underlineMenu : false;
            if (boolval($underlineMenu)) {
                wp_enqueue_style("pac-da-underline-links-exclude-menu-style", PAC_DA_PLUGIN_URL . 'include/php/public/css/underline-links-exclude-menu.min.css', [], PAC_DA_PLUGIN_VERSION);
            }
            $skipNavigation = isset($accessibilityHelperData->skipNavigation) ? $accessibilityHelperData->skipNavigation : false;
            if (boolval($skipNavigation)) {
                wp_enqueue_script("pac-da-aria-hidden-icons", PAC_DA_PLUGIN_URL . 'include/php/public/js/skip-navigation-link.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
                wp_localize_script( 'pac-da-aria-hidden-icons', 'pac_da_obj', [
                    'skipNavigationLinkText'  => __('Skip To Content', PAC_DA_PLUGIN_TEXT_DOMAIN),
                ]);
            }
            $duplicateMenu = isset($accessibilityHelperData->duplicateMenu) ? $accessibilityHelperData->duplicateMenu : false;
            if (boolval($duplicateMenu)) {
                wp_enqueue_script("pac-da-fix-duplicate-menu-ids", PAC_DA_PLUGIN_URL . 'include/php/public/js/fix-duplicate-menu-ids.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
            }
            $dropdownMenu = isset($accessibilityHelperData->dropdownMenu) ? $accessibilityHelperData->dropdownMenu : false;
            if (boolval($dropdownMenu)) {
                wp_enqueue_script("pac-da-enable-dropdown-menu-keyboard-navigation", PAC_DA_PLUGIN_URL . 'include/php/public/js/dropdown-menu-keyboard-navigation.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
                wp_enqueue_style("pac-da-enable-dropdown-menu-keyboard-navigation-style", PAC_DA_PLUGIN_URL . 'include/php/public/css/dropdown-menu-keyboard-navigation.min.css', [], PAC_DA_PLUGIN_VERSION);
            }
            $improveScreenReader = isset($accessibilityHelperData->improveScreenReader) ? $accessibilityHelperData->improveScreenReader : false;
            if (boolval($improveScreenReader)) {
                wp_enqueue_style("pac-da-improve-screen-reader-classes", PAC_DA_PLUGIN_URL . 'include/php/public/css/screen-reader-text.min.css', [], PAC_DA_PLUGIN_VERSION);
            }
            $Tota11y = isset($accessibilityHelperData->Tota11y) ? $accessibilityHelperData->Tota11y : false;
            if (boolval($Tota11y) && current_user_can('manage_options')) {
                wp_enqueue_script("pac-da-add-tota11y", PAC_DA_PLUGIN_URL . 'include/php/public/js/tota11y.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
            }
        }
        public function enqueue_premade_layouts()
        {
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"hideLayout":false}'));
            $hideLayout = isset($utilityCards->hideLayout) ? $utilityCards->hideLayout : false;
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            if (boolval($hideLayout) && boolval($utilitySettings)) {
                wp_enqueue_script("pac-da-hide-layout-vb", PAC_DA_PLUGIN_URL . 'include/js/hide-layout.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
                wp_enqueue_style("pac-da-hide-layout-vb",  PAC_DA_PLUGIN_URL . 'include/css/hide-layout.min.css', [], PAC_DA_PLUGIN_VERSION);
            }
        }
        public function admin_enqueue_premade_layouts()
        {
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"hideLayout":false}'));
            $hideLayout = isset($utilityCards->hideLayout) ? $utilityCards->hideLayout : false;
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            if (boolval($hideLayout) && boolval($utilitySettings)) {
                global $typenow, $pagenow;
                if ( 'edit.php' != $pagenow && in_array( $typenow, et_builder_get_builder_post_types() ) )
                {
                    global $post;
                    if($post)
                    {
                        wp_enqueue_script("pac-da-hide-layout-admin", PAC_DA_PLUGIN_URL . 'include/js/hide-layout.min.js', ['jquery'], PAC_DA_PLUGIN_VERSION, true);
                        wp_enqueue_style("pac-da-hide-layout-admin",  PAC_DA_PLUGIN_URL . 'include/css/hide-layout.min.css', [], PAC_DA_PLUGIN_VERSION);
                    }
                }
            }
        }
    }
    (new PAC_DA_General_JS())->instance()->init();
}