<?php
/* -------  Check Dependency  ------- */
if (!function_exists('pac_da_check_is_divi_theme')):
    function pac_da_check_is_divi_theme()
    {
        $active_theme = wp_get_theme()->get('Name');
        $parent_theme = wp_get_theme()->get('Template');
        if ( ! function_exists( 'is_plugin_active' ) ){
            require_once( ABSPATH . '/wp-admin/includes/plugin.php' );
        }
        $divi_ghoster = is_plugin_active('divi-ghoster/divi-ghoster.php');
        if ('divi' == strtolower($active_theme) || 'divi' == strtolower($parent_theme) || 'extra' == strtolower($active_theme) || 'extra' == strtolower($parent_theme) || $divi_ghoster) {
            if(empty(get_option('permalink_structure'))){
                update_option( 'permalink_structure', '//%postname%//');
            }
            return true;
        }
        deactivate_plugins(PAC_DA_PLUGIN_BASENAME);
        wp_die('<p>'.sprintf(esc_attr__('The Divi Assistant plugin only works with the Divi Theme. Your current active theme is %2$s %1$s. %3$sThe plugin will be deactivated and you may return to your WordPress dashboard.',
                'Divi'), esc_html($active_theme), '<b>', '</b>').'</p> <a href="'.esc_url(admin_url('index.php')).'">'.esc_attr__('Go Back', 'Divi').'</a>');
    }

    add_action('init', 'pac_da_check_is_divi_theme');
    register_activation_hook(PAC_DA_PLUGIN_BASENAME, 'pac_da_check_is_divi_theme');
endif;


/* -------  Helper Function REST API  ------- */
// Get Allowed font file type
function get_allowed_font_file_types() {
    $allowed_mimes = get_allowed_mime_types();
    
    // Filter the allowed MIME types for font file types
    $allowed_font_types = array_filter($allowed_mimes, function ($mime_type) {
        return strpos($mime_type, 'font') !== false;
    });

    // Get the file extensions for font file types
    $font_extensions = array_keys($allowed_font_types);

    return $font_extensions;
}


/* -------  Change Divi Version  ------- */
add_action('wp_ajax_pac_da_change_divi_version', 'pac_da_change_divi_version');
function pac_da_change_divi_version()
{
    if (isset($_POST['_ajax_nonce']) && wp_verify_nonce(sanitize_text_field($_POST['_ajax_nonce']), 'et_core_version_rollback') && isset($_POST['action']) && 'pac_da_change_divi_version' === sanitize_text_field($_POST['action'])) {
        $error = false;
        $message = '';
        $product_name = isset($_POST['product_name']) ? sanitize_text_field($_POST['product_name']) : '';
        $product_shortname = isset($_POST['product_shortname']) ? sanitize_text_field($_POST['product_shortname']) : '';
        $version = isset($_POST['version']) ? sanitize_text_field($_POST['version']) : '';
        if (empty($product_name) || empty($version)) {
            $error = true;
            $message = esc_html('Product name and version is required.');
        }
        $options = get_option('et_automatic_updates_options');
        $api_username = isset($options['username']) ? sanitize_text_field($options['username']) : '';
        $api_key = isset($options['api_key']) ? sanitize_text_field($options['api_key']) : '';
        if (empty($api_username) || empty($api_key)) {
            $error = true;
            $message = esc_html('You don\'t have username and key.');
        }
        $api = new ET_Core_API_ElegantThemes($api_username, $api_key);
        $is_product_available = $api->is_product_available($product_name, $version);
        if (false === $is_product_available) {
            $error = true;
            $message = esc_html('The product does not exit');
        }
        if (false === $error) {
            $previous_version = et_get_option("{$product_shortname}_previous_installed_version", '');
            $latest_version = et_get_option("{$product_shortname}_latest_installed_version", '');
            require_once(ABSPATH.'wp-admin/includes/class-wp-upgrader.php');
            $package = add_query_arg([
                'api_update' => 1,
                'theme' => $product_name,
                'version' => $version,
                'username' => $api_username,
                'api_key' => $api_key,
            ], 'https://www.elegantthemes.com/api/api_downloads.php');
            $upgrader = new Theme_Upgrader(new ET_Core_LIB_SilentThemeUpgraderSkin());
            add_filter('upgrader_source_selection', [$upgrader, 'check_package']);
            add_filter('upgrader_post_install', [$upgrader, 'check_parent_theme_filter'], 10, 3);
            $upgrader->run([
                'package' => $package,
                'destination' => get_theme_root(),
                'clear_destination' => true,
                'clear_working' => true,
                'hook_extra' => [
                    'type' => 'theme',
                    'action' => 'install'
                ],
            ]);
            remove_action('upgrader_process_complete', 'wp_clean_themes_cache', 9);
            remove_filter('upgrader_source_selection', [$upgrader, 'check_package']);
            remove_filter('upgrader_post_install', [$upgrader, 'check_parent_theme_filter']);
            if ($upgrader->result || !is_wp_error($upgrader->result)) {
                $message = esc_html('The theme is updated successfully!');
                et_update_option("{$product_shortname}_previous_installed_version", sanitize_text_field($latest_version));
                et_update_option("{$product_shortname}_latest_installed_version", sanitize_text_field($previous_version));
            } else {
                $message = $upgrader->result->get_error_message();
            }
        }
        wp_send_json_success($message);
    }
}


/* -------  Add Custom Admin Bar Menu Link  ------- */
$utilityCards = json_decode(get_option('pacDaUtilityCards', '{"staticCss":false,"localStorage":false,"hardRefresh":false,"quickLinks":false,"tBTDetails":false,"removeHowdy":false,"adminbarEverywhere":false,"adminbarFrontend":false,"adminbarHover":false,"duplicateDiviLib":false,"exportDiviLib":false,"diviLibWidget":false,"diviLibSC":false,"openVisualBuilder":false,"disableCommentSettings":false,"duplicatePagePost":false,"escKey":false,"hideLayout":false,"disableAi":false,"hideExploreBtn":false,"horizontalScroll":false,"cursorHighlight":false,"bgHighlight":"#3399ff","textHighlight":"#ffffff","hideProject":false,"renameProject":false,"pluralName":"Projects","singularName":"Project","slug":"projects","pluralCategory":"Project Categories","singularCategory":"Project Category","slugCategory":"project_category","pluralTag":"Project Tags","singularTag":"Project Tag","slugTag":"project_tag","menuIcon":"dashicons-admin-post","defaultThemes":false,"updateThemes":false,"updatePlugins":false,"themeBuilderCPT":false,"fullScreen":false,"edidorBtn":false,"stickyToolbar":false,"htmlArea":false,"htmlAreaValue":"400px","popupHeight":false,"popupHeightValue":"500px","iconAreaHeight":false,"iconAreaHeightValue":"300px","textPopover":false,"rowWidth":false,"swapSandGbtn":false}'));
$mediaCards = json_decode(get_option('pacDaMediaCards', '{"svgUploads":false,"svgUploadsValue":"default","fileSize":false,"fileSizeValue":"512","imgReplace":false}'));
$fontCards = get_option('pacDaFontCards', false);

$enableAddons = json_decode(get_option('pacDaAddons', '{"startUp":true,"maintenance":true,"utility":true,"media":true,"learning":true,"support":true,"fonts":true,"styles":true,"code":true,"frontend":true,"accessibility":true}'));
$utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
$mediaSettings = isset($enableAddons->media) ? $enableAddons->media : true;
$fontsSettings = isset($enableAddons->fonts) ? $enableAddons->fonts : true;
$codeSettings = isset($enableAddons->code) ? $enableAddons->code : true;
$maintenanceSettings = isset($enableAddons->maintenance) ? $enableAddons->maintenance : true;
$stylesSettings = isset($enableAddons->styles) ? $enableAddons->styles : true;


$staticCss = isset($utilityCards->staticCss) ? $utilityCards->staticCss : false;
$localStorage = isset($utilityCards->localStorage) ? $utilityCards->localStorage : false;
$hardRefresh = isset($utilityCards->hardRefresh) ? $utilityCards->hardRefresh : false;

if((boolval($staticCss) === true | boolval($localStorage) === true  | boolval($hardRefresh) === true)  && boolval($utilitySettings)){
    if (!function_exists('pac_misc_csc_maybe_admin_bar_link')):
        function pac_misc_csc_maybe_admin_bar_link($admin_bar)
        {
            $admin_bar->add_menu([
                'id' => 'pac_misc_csc',
                'title' => '<span class="ab-icon"></span><span class="ab-label">Clear Divi Cache</span>',
                'href' => '',
                'meta' => [
                    'title' => '',
                ],
            ]);
        }
        add_action('admin_bar_menu', 'pac_misc_csc_maybe_admin_bar_link', 999);
    endif;
}
if(boolval($staticCss) && boolval($utilitySettings)){
    if (!function_exists('pac_misc_csc_maybe_admin_bar_link_static')):
        function pac_misc_csc_maybe_admin_bar_link_static($admin_bar)
        {
            $admin_bar->add_menu([
                'id' => 'pac_misc_clear_static_css',
                'parent' => 'pac_misc_csc',
                'title' => sprintf('<span data-wpnonce="%1$s">%2$s</span>', wp_create_nonce('pac_misc_clear_static_css'), esc_html('Clear Static CSS File Generation')),
                'href' => 'javascript:void(0)',
            ]);
        }
        add_action('admin_bar_menu', 'pac_misc_csc_maybe_admin_bar_link_static', 999);
    endif;
}
if(boolval($localStorage) && boolval($utilitySettings)){
    if (!function_exists('pac_misc_csc_maybe_admin_bar_link_local')):
        function pac_misc_csc_maybe_admin_bar_link_local($admin_bar)
        {
            $admin_bar->add_menu([
                'id' => 'pac_misc_csc_clear_local_storage',
                'parent' => 'pac_misc_csc',
                'title' => esc_html('Clear Local Storage'),
                'href' => 'javascript:void(0)',
            ]);
        }
    
        add_action('admin_bar_menu', 'pac_misc_csc_maybe_admin_bar_link_local', 999);
    endif;
}
if(boolval($hardRefresh) && boolval($utilitySettings)){
    if (!function_exists('pac_misc_csc_maybe_admin_bar_link_hard_refresh')):
        function pac_misc_csc_maybe_admin_bar_link_hard_refresh($admin_bar)
        {
            $admin_bar->add_menu([
                'id' => 'pac_misc_csc_hard_refresh',
                'parent' => 'pac_misc_csc',
                'title' => esc_html('Hard Refresh'),
                'href' => 'javascript:void(0)',
            ]);
        }
        add_action('admin_bar_menu', 'pac_misc_csc_maybe_admin_bar_link_hard_refresh', 999);
    endif;
}
// Process Ajax Request
if (!function_exists('pac_misc_csc_maybe_admin_scripts')):
    function pac_misc_csc_maybe_admin_scripts()
    {
        if(!current_user_can('administrator')){
            return;
        }
        ?>
        <script>
            jQuery(document).ready(function () {
                var adminAaxURL = '<?php echo esc_url(admin_url('admin-ajax.php')); ?>';
                var isAdmin = '<?php echo esc_attr(is_admin()); ?>';
                // Clear Static CSS
                jQuery("#wp-admin-bar-pac_misc_clear_static_css").click(function (e) {
                    e.preventDefault();
                    jQuery.ajax({
                        type: 'post',
                        dataType: 'json',
                        url: adminAaxURL,
                        data: {
                            'action': 'pac_misc_clear_static_css',
                            '_wpnonce': jQuery(this).find('span').data('wpnonce')
                        },
                        success: function (response) {
                            if (response.success) {
                                let successData = response.data;
                                if (isAdmin) {
                                    let messageHTML = '<div class="notice notice-success pac-misc-message"><p>' + successData + '</p></div>';
                                    if (jQuery('body .wrap h1').length > 0) {
                                        jQuery('body .wrap h1').after(messageHTML);
                                    } else {
                                        jQuery('body #wpbody-content').prepend(messageHTML);
                                    }
                                    setTimeout(function () {
                                        jQuery(".pac-misc-message").remove();
                                    }, 3000);
                                } else {
                                    alert(successData);
                                }
                            }
                        },
                    });
                });
                // Clear Local Storage
                jQuery("#wp-admin-bar-pac_misc_csc_clear_local_storage").click(function (e) {
                    e.preventDefault();
                    let msgText = 'The local storage has been cleared!';
                    window.localStorage.clear();
                    if (isAdmin) {
                        let messageHTML = '<div class="notice notice-success pac-misc-message"><p>' + msgText + '</p></div>';
                        if (jQuery('body .wrap h1').length > 0) {
                            jQuery('body .wrap h1').after(messageHTML);
                        } else {
                            jQuery('body #wpbody-content').prepend(messageHTML);
                        }
                        setTimeout(function () {
                            jQuery(".pac-misc-message").remove();
                        }, 3500);
                    } else {
                        alert(msgText);
                    }
                });
                // Hard refresh
                jQuery("#pac_misc_csc_hard_refresh").click(function (e) {
                    e.preventDefault();
                    location.reload(true);
                });
            });
        </script>
        <?php
    }
    $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"staticCss":false,"localStorage":false,"hardRefresh":false}'));
    $staticCss = isset($utilityCards->staticCss) ? $utilityCards->staticCss : false;
    $localStorage = isset($utilityCards->localStorage) ? $utilityCards->localStorage : false;
    $hardRefresh = isset($utilityCards->hardRefresh) ? $utilityCards->hardRefresh : false;
    $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
    $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
    if(($staticCss || $localStorage || $hardRefresh) && boolval($utilitySettings)){
        add_action('admin_footer', 'pac_misc_csc_maybe_admin_scripts');
        add_action('wp_footer', 'pac_misc_csc_maybe_admin_scripts');
    }
endif;
if (!function_exists('pac_misc_csc_maybe_ajax_request')):
    function pac_misc_csc_maybe_ajax_request()
    {
        if (isset($_POST['_wpnonce']) && wp_verify_nonce(sanitize_text_field($_POST['_wpnonce']), 'pac_misc_clear_static_css') && isset($_POST['action']) && 'pac_misc_clear_static_css' === sanitize_text_field($_POST['action'])) {
            ET_Core_PageResource::remove_static_resources('all', 'all');
            wp_send_json_success(esc_html('The static CSS file generation has been cleared!'), 200);
        }
    }
    add_action('wp_ajax_pac_misc_clear_static_css', 'pac_misc_csc_maybe_ajax_request');
endif;


// Remove Howdy from admin bar name
$removeHowdy = isset($utilityCards->removeHowdy) ? $utilityCards->removeHowdy : false;
if($removeHowdy && boolval($utilitySettings)){
    function pac_da_custom_admin_bar_user_name() {
        global $wp_admin_bar;
        $node_id = 'my-account';
        if ($wp_admin_bar->get_node($node_id)) {
            $current_title = $wp_admin_bar->get_node($node_id)->title;
            $newTitle = explode(", ", $current_title);
            $wp_admin_bar->add_node(array(
                'id' => $node_id,
                'title' => $newTitle[1],
            ));
        }
    }
    add_action('wp_before_admin_bar_render', 'pac_da_custom_admin_bar_user_name');
}

/* -------  Helper Functionality  ------- */
// Disable & Hide Automatic Theme Updates
$updateThemes = isset($utilityCards->updateThemes) ? $utilityCards->updateThemes : false;
$updatePlugins = isset($utilityCards->updatePlugins) ? $utilityCards->updatePlugins : false;
$defaultThemes = isset($utilityCards->defaultThemes) ? $utilityCards->defaultThemes : false;
$hideProject = isset($utilityCards->hideProject) ? $utilityCards->hideProject : false;
$fullScreen = isset($utilityCards->fullScreen) ? $utilityCards->fullScreen : false;
$fileSize = isset($mediaCards->fileSize) ? $mediaCards->fileSize : false;

if(boolval($updateThemes) && boolval($maintenanceSettings)){
    add_filter( 'auto_update_theme', '__return_false' );
    add_filter( 'themes_auto_update_enabled', '__return_false' );
}
// Disable & Hide Automatic Plugin Updates
if(boolval($updatePlugins) && boolval($maintenanceSettings)){
    add_filter( 'auto_update_plugin', '__return_false' );
    add_filter( 'plugins_auto_update_enabled', '__return_false' );
}
// Disable New Default WordPress Themes
if(boolval($defaultThemes) && boolval($maintenanceSettings)){
    define('CORE_UPGRADE_SKIP_NEW_BUNDLED', true);
}
// Hide Projects Post Type
if(boolval($hideProject) && boolval($utilitySettings)){
    function pac_hide_project_posttype_args( $args ) {
        return array_merge( $args, array(
            'public'              => false,
            'exclude_from_search' => false,
            'publicly_queryable'  => false,
            'show_in_nav_menus'   => false,
            'show_ui'             => false
        ));
    }
    add_filter( 'et_project_posttype_args', 'pac_hide_project_posttype_args', 10, 1 );
}
// Disable WordPress Fullscreen Editor
if(boolval($fullScreen) && boolval($utilitySettings)){
    if (is_admin()) {
        function pa_disable_fullscreen_wp_editor() {
        $script = "jQuery( window ).load(function() { const isFullscreenMode = wp.data.select( 'core/edit-post' ).isFeatureActive( 'fullscreenMode' ); if ( isFullscreenMode ) { wp.data.dispatch( 'core/edit-post' ).toggleFeature( 'fullscreenMode' ); } });";
        wp_add_inline_script( 'wp-blocks', $script );
    }
    add_action( 'enqueue_block_editor_assets', 'pa_disable_fullscreen_wp_editor' );
    }
}
// Upload size limit
if(boolval($fileSize) === true && boolval($mediaSettings)){
    // Limit Media size
    function pac_da_site_upload_size_limit( $size ) {
        $mediaCards = json_decode(get_option('pacDaMediaCards', '{"fileSizeValue":"512"}'));
        $fileSizeValue = isset($mediaCards->fileSizeValue) ? $mediaCards->fileSizeValue : '512';
        $size = (int)$fileSizeValue * 1024;
        return $size;
    }
    add_filter( 'upload_size_limit', 'pac_da_site_upload_size_limit', 20 );
}
// Export Divi Library Items
if (!function_exists('pac_da_export_library_link')):
    function pac_da_export_library_link($actions, $post)
    {
        $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"exportDiviLib":false}'));
        $exportDiviLib = isset($utilityCards->exportDiviLib) ? $utilityCards->exportDiviLib : false;
        $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
        $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
        if (current_user_can('edit_posts') && 'et_pb_layout' === $post->post_type && 'trash' !== $post->post_status && boolval($exportDiviLib) && boolval($utilitySettings)) {
            $export_url = wp_nonce_url(add_query_arg(['action' => 'export_library', 'library_id' => $post->ID], home_url()), basename(__FILE__), '_exportlibrary_nonce');
            $actions['export_library'] = sprintf(__("<a href='%s' rel='permalink'>Export</a>", 'pac-da'), esc_url($export_url));
        }
        return $actions;
    }
    add_filter('post_row_actions', 'pac_da_export_library_link', 10, 2);
endif;
function pac_da_get_parent_slug( $parent_id, $taxonomy ) {
    $term_data = get_term( $parent_id, $taxonomy );
    $slug = '' === $term_data->slug ? 0 : $term_data->slug;

    return $slug;
}
function pac_da_get_all_parents( $parent_id, $taxonomy ) {
    $parents_data_array = array();
    $parent = $parent_id;
    if ( 0 !== $parent  ) {
        while( 0 !== $parent ) {
            $parent_term_data = get_term( $parent, $taxonomy );
            $parents_data_array[$parent_term_data->slug] = array(
                'name' => $parent_term_data->name,
                'description' => $parent_term_data->description,
                'parent' => 0 !== $parent_term_data->parent ? pac_da_get_parent_slug( $parent_term_data->parent, $taxonomy ) : 0,
            );

            $parent = $parent_term_data->parent;
        }
    }
    return array_reverse( $parents_data_array );
}
function pac_da_export_posts_query($post_id) {
    $get_post = get_post($post_id);
    $taxonomies = get_object_taxonomies(get_post_type($get_post));
    $post = [];

    unset(
        $get_post->post_author,
        $get_post->guid
    );

    $post[$get_post->ID] = $get_post;

    // Include post meta.
    $post_meta = (array) get_post_meta( $get_post->ID );
    if ( isset( $post_meta['_edit_lock'] ) ) {
        unset(
            $post_meta['_edit_lock'],
            $post_meta['_edit_last']
        );
    }
    $post[$get_post->ID]->post_meta = $post_meta;

    // Include terms.
    $get_terms = (array) wp_get_object_terms( $get_post->ID, $taxonomies );
    $terms = [];

    // Order terms to make sure children are after the parents.
    while ( $term = array_shift( $get_terms ) ) {
        if ( 0 === $term->parent || isset( $terms[$term->parent] ) ) {
            $terms[$term->term_id] = $term;
        } else {
            // if parent category is also exporting then add the term to the end of the list and process it later
            // otherwise add a term as usual
            if (pac_da_is_parent_term_included( $get_terms, $term->parent ) ) {
                $get_terms[] = $term;
            } else {
                $terms[$term->term_id] = $term;
            }
        }
    }

    $post[$get_post->ID]->terms = array();

    foreach ( $terms as $term ) {
        $parents_data = [];
        if ( $term->parent ) {
            $parent_slug = isset( $terms[$term->parent] ) ? $terms[$term->parent]->slug : pac_da_get_parent_slug( $term->parent, $term->taxonomy );
            $parents_data = pac_da_get_all_parents( $term->parent, $term->taxonomy );
        } else {
            $parent_slug = 0;
        }
        $post[$get_post->ID]->terms[$term->term_id] = array(
            'name'        => $term->name,
            'slug'        => $term->slug,
            'taxonomy'    => $term->taxonomy,
            'parent'      => $parent_slug,
            'all_parents' => $parents_data,
            'description' => $term->description
        );
    }
    return $post;
}
if (!function_exists('pac_da_export_library')):
    function pac_da_export_library(){
        
        if (!is_user_logged_in()) {
            return;
        }
        if (isset($_GET['_exportlibrary_nonce']) && !wp_verify_nonce(sanitize_text_field($_GET['_exportlibrary_nonce']), basename(__FILE__))) {
            wp_die(esc_html__('The library export link is expired.'), 403);
        }
        if (!isset($_GET['action']) || 'export_library' !== sanitize_text_field($_GET['action'])) {
            return;
        }
        if (!isset($_GET['library_id']) || '' === sanitize_text_field($_GET['library_id'])) {
            return;
        }
        

        $post_id = sanitize_text_field($_GET['library_id']);
        $post = pac_da_export_posts_query($post_id);
        $portability = et_core_portability_load( 'et_theme_builder' );
        $thumbnails = $portability->get_theme_builder_library_thumbnail_images( $post );
        $images = $portability->get_theme_builder_library_images( $post );


        $used_global_presets = array();
        $options             = array(
            'apply_global_presets' => true,
        );

        $shortcode_object = et_fb_process_shortcode( $post[$post_id]->post_content );

        // We have to always process global presets to get the global colors correctly.
        $global_presets_from_post = $portability->get_theme_builder_library_used_global_presets( $shortcode_object, $used_global_presets );
        $used_global_presets      = array_merge(
            $global_presets_from_post,
            $used_global_presets
        );

        $global_presets       = '';
		$global_colors        = '';
        $apply_global_presets = isset( $_POST['apply_global_presets'] ) ? wp_validate_boolean( sanitize_text_field($_POST['apply_global_presets'])) : false;
        $used_global_colors = $portability->get_theme_builder_library_used_global_colors( $shortcode_object);
        if ( $apply_global_presets ) {
            $shortcode_object   = et_fb_process_to_shortcode( $shortcode_object, $options, '', false );
            $post->post_content = $shortcode_object;
        }
        if ( ! empty ( $used_global_presets ) ) {
            $global_presets = (object) $used_global_presets;
        }
        if ( ! empty( $used_global_colors ) ) {
            $global_colors = $portability->_get_global_colors_data( $used_global_colors );
        }

        $timestamp = $portability->get_timestamp();
        $data = array(
			'context'       => 'et_builder_layouts',
			'data'          => $post,
			'presets'       => $global_presets,
			'global_colors' => $global_colors,
			'images'        => $images,
			'thumbnails'    => $thumbnails,
		);
        if ($data) {
            $export_filename = sanitize_title($post[$post_id]->post_title) . '.json';
            $export_content = wp_json_encode($data, JSON_PRETTY_PRINT);
            header('Content-Type: application/json');
            header('Content-Disposition: attachment; filename="' . $export_filename . '"');
            echo wp_kses_post($export_content);
            exit;
        }
        wp_safe_redirect(add_query_arg(['post_type' => 'et_pb_layout'], admin_url('edit.php')));
        exit;
    }
    add_action('init', 'pac_da_export_library');
endif;
// Allow SVG OR Font File
global $da_allowed_mimes;
$svgUploads = isset($mediaCards->svgUploads) ? $mediaCards->svgUploads : false;
$svgUploadsValue = isset($mediaCards->svgUploadsValue) ? $mediaCards->svgUploadsValue : 'default';

$da_allowed_mimes_svg  = boolval($svgUploads) === true && boolval($mediaSettings) === true && $svgUploadsValue === 'default' ? ['svg' => 'image/svg+xml','svgz' => 'image/svg+xml'] : [];
$da_allowed_mimes_font = boolval($fontCards) === true && boolval($fontsSettings) === true ? ['ttf' => 'application/x-font-ttf','otf' => 'application/x-font-otf','woff' => 'application/x-font-woff','woff2' => 'application/x-font-woff2'] : [];
$da_allowed_mimes = array_merge($da_allowed_mimes_svg, $da_allowed_mimes_font);
// Allow Custom Mime
if (!function_exists('pac_da_upload_mimes')):
    function pac_da_upload_mimes($mimes)
    {
        global $da_allowed_mimes;
        foreach ($da_allowed_mimes as $key => $val) {
            $mimes[$key] = $val;
        }
        return $mimes;
    }
endif;
// Allow Divi To Upload Fonts Format
if (!function_exists('pac_da_filter_divi_supportedt_font_formats') & boolval($fontCards) === true):
    function pac_da_filter_divi_supportedt_font_formats()
    {
        return ['otf', 'woff', 'woff2', 'ttf'];
    }
    add_filter('et_pb_supported_font_formats', 'pac_da_filter_divi_supportedt_font_formats', 999);
endif;
if (!function_exists('pac_da_fix_mime_type_ext')):
    function pac_da_fix_mime_type_ext($file, $tmp_file, $filename, $mimes)
    {
        // Get File Ext.
        if (isset($file['ext']) && empty($file['ext'])) {
            $file_ext = strtolower(pathinfo($filename, PATHINFO_EXTENSION));
            // Set File Ext.
            global $da_allowed_mimes;
            foreach ($da_allowed_mimes as $key => $val) {
                if ($key === $file_ext) {
                    $file['ext'] = $key;
                    $file['type'] = $val;
                }
            }
        }
        return $file;
    }
endif;
add_action( 'init', function() {
    if(current_user_can('administrator')){
        add_filter('upload_mimes', 'pac_da_upload_mimes');
        add_filter('wp_check_filetype_and_ext', 'pac_da_fix_mime_type_ext', 75, 4);
    }
});
// Duplicate Divi Library Items
if (!function_exists('pac_da_clone_library_link')):
    function pac_da_clone_library_link($actions, $post)
    {
        $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"duplicateDiviLib":false}'));
        $duplicateDiviLib = isset($utilityCards->duplicateDiviLib) ? $utilityCards->duplicateDiviLib : false;
        $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
        $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
        if (current_user_can('edit_posts') && 'et_pb_layout' === $post->post_type && 'trash' !== $post->post_status && boolval($duplicateDiviLib) && boolval($utilitySettings)) {
            $url = wp_nonce_url(add_query_arg(['action' => 'clone_library', 'library_id' => $post->ID], home_url()), basename(__FILE__), '_clonelibrary_nonce');
            $actions['duplicate_library'] = sprintf(__("<a href='%s' rel='permalink'>Duplicate</a>", 'pac-da'), esc_url($url));
        }
        return $actions;
    }

    add_filter('post_row_actions', 'pac_da_clone_library_link', 10, 2);
endif;
// Cloned Library
if (!function_exists('pac_da_clone_library')):
    function pac_da_clone_library()
    {
        // Check is User Logged In
        if (!is_user_logged_in()) {
            return;
        }
        // Check Nonce
        if (isset($_GET['_clonelibrary_nonce']) && !wp_verify_nonce(sanitize_text_field($_GET['_clonelibrary_nonce']), basename(__FILE__))) {
            wp_die(esc_html__('The library clone link is expired.'), 403);
        }
        // Check Action
        if (!isset($_GET['action']) || 'clone_library' !== sanitize_text_field($_GET['action'])) {
            return;
        }
        // Check Library ID
        if (!isset($_GET['library_id']) || '' === sanitize_text_field($_GET['library_id'])) {
            return;
        }
        
        $post_id = sanitize_text_field($_GET['library_id']);
        $post = get_post($post_id);
        if ($post) {
            // Clone Library Post
            $inserted_post_id = wp_insert_post([
                'post_title' => sprintf("$post->post_title - %s", 'Duplicate'),
                'post_type' => $post->post_type,
                'post_status' => 'draft',
                'post_content' => $post->post_content,
                'post_excerpt' => $post->post_excerpt,
                'post_name' => $post->post_name,
                'comment_status' => $post->comment_status,
                'ping_status' => $post->ping_status,
                'post_author' => get_current_user_id(),
                'post_parent' => $post->post_parent,
                'post_password' => $post->post_password,
                'to_ping' => $post->to_ping,
                'menu_order' => $post->menu_order
            ]);
            if (!is_wp_error($inserted_post_id)) {
                // Copy Library Terms
                $taxonomies = get_object_taxonomies(get_post_type($post));
                if ($taxonomies) {
                    foreach ($taxonomies as $taxonomy) {
                        $post_terms = wp_get_object_terms($post_id, $taxonomy, ['fields' => 'slugs']);
                        wp_set_object_terms($inserted_post_id, $post_terms, $taxonomy);
                    }
                }
                // Clone Library Feaured Image
                $thumbnail_id = get_post_meta($post_id, '_thumbnail_id', true);
                if ('' !== $thumbnail_id) {
                    set_post_thumbnail($inserted_post_id, $thumbnail_id);
                }
            }
            
        }
        wp_safe_redirect(add_query_arg(['post_type' => 'et_pb_layout'], admin_url('edit.php')));
        exit;
    }
    add_action('init', 'pac_da_clone_library');
endif;
// Enable Visual Builder
if (!function_exists('pac_da_load_new_post') && boolval($utilitySettings)):
    function pac_da_load_new_post()
    {
        pac_da_auto_insert_draft_post();
    }
    add_action('load-post-new.php', 'pac_da_load_new_post');
endif;
if (!function_exists('pac_da_auto_insert_draft_post')):
    function pac_da_auto_insert_draft_post()
    {
        add_action('wp_insert_post', 'pac_da_covert_editor_to_vb', 10, 2);
    }
endif;
if (!function_exists('pac_da_covert_editor_to_vb')):
    function pac_da_covert_editor_to_vb($post_id, $post)
    {
        remove_action('wp_insert_post', 'pac_da_covert_editor_to_vb');
        if (!isset($post->post_type)) {
            return;
        }
        $current_post_type = $post->post_type;
        $autoload_vb_poststypes = [];
        $option_value = json_decode(get_option('pacDaAllPostTypes'), true);

        if (is_array($option_value)) {
            foreach ($option_value as $key => $value) {
                if ($value === true) {
                    $autoload_vb_poststypes[] = $key;
                }
            }
        }
        if (in_array($current_post_type, et_builder_get_enabled_builder_post_types()) && in_array($current_post_type, $autoload_vb_poststypes)) {
            wp_update_post(['ID' => $post_id, 'post_status' => 'draft', 'post_title' => '', 'post_content' => '[et_pb_section][/et_pb_section]']);
            update_post_meta($post_id, '_et_pb_use_builder', 'on');
            wp_safe_redirect(add_query_arg(['post' => $post->ID, 'action' => 'edit'], admin_url('post.php')));
            exit;
        }
    }
endif;
// Add a Open Visual Builder button
add_filter('post_row_actions','pac_da_divi_enabler_action_row', 10, 2);
add_filter('page_row_actions','pac_da_divi_enabler_action_row', 10, 2);
function pac_da_divi_enabler_action_row($actions, $post){
    $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"openVisualBuilder":false}'));
    $openVisualBuilder = isset($utilityCards->openVisualBuilder) ? $utilityCards->openVisualBuilder : false;
    $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
    $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
    if (function_exists('et_pb_is_pagebuilder_used') && et_pb_is_pagebuilder_used($post->ID) && boolval($openVisualBuilder) && boolval($utilitySettings)){
        if($post->post_status == 'publish'){
            $actions['edit_in_visual_builder'] = '<a href="'.get_permalink($post->ID).'?et_fb=1">Open Visual Builder</a>';
        } elseif ($post->post_status == 'draft') {
            $actions['edit_in_visual_builder'] = '<a href="'.get_permalink($post->ID).'&et_fb=1">Open Visual Builder</a>';
        }
    }
    return $actions;
}


/* -------  Add Tag To Admin Bar To Show Environment  ------- */
function add_custom_menu_in_admin_bar() {
    global $wp_admin_bar;
    $environmentsData = json_decode(get_option('pacDaEnvironmentsData'));
    $environment = isset($environmentsData->environment) ? $environmentsData->environment : 'default';
    $environment = $environment === 'default' ? wp_get_environment_type() : $environment;
    switch ($environment) {
        case 'local':
            $args = array(
                'id'    => 'pac-da-environment-local',
                'title' => 'Local',
                'parent'=> 'top-secondary',
                'meta' => ['class' => 'pac-da-environment local']
            );
            break;
        case 'development':
            $args = array(
                'id'    => 'pac-da-environment-development',
                'title' => $environmentsData->devLabel !== '' ? $environmentsData->devLabel : 'Development',
                'parent'=> 'top-secondary',
                'meta' => ['class' => 'pac-da-environment development']
            );
            break;
        case 'staging':
            $args = array(
                'id'    => 'pac-da-environment-staging',
                'title' => $environmentsData->stagLabel !== '' ? $environmentsData->stagLabel : 'Staging',
                'parent'=> 'top-secondary',
                'meta' => ['class' => 'pac-da-environment staging']
            );
            break;
        case 'production':
            $args = array(
                'id'    => 'pac-da-environment-production',
                'title' => $environmentsData->prodLabel !== '' ? $environmentsData->prodLabel : 'Production',
                'parent'=> 'top-secondary',
                'meta' => ['class' => 'pac-da-environment production']
            );
            break;
        default:
            break;
    }
    $wp_admin_bar->add_menu( $args );
}
$environmentsData = json_decode(get_option('pacDaEnvironmentsData', '{"enable":false,"prodLabel":"Production","prodClr":"#00D263","stagLabel":"Staging","stagClr":"#7846FF","devLabel":"Development","devClr":"#F15A24"}'));
$enable = isset($environmentsData->enable) ? $environmentsData->enable : false;
if(boolval($enable) && boolval($utilitySettings)){
    add_action('wp_before_admin_bar_render', 'add_custom_menu_in_admin_bar');
}


/* -------  Apply Global Styles  ------- */
if (!function_exists('pac_da_global_styles') && boolval($stylesSettings)):
    function pac_da_global_styles()
    {
        if (!in_array('et-fb', get_body_class())) {
            ?> <style id='pac-da-global-styles-css'> <?php
            $stylesH1 = json_decode(get_option('paDaStylesH1'));
            if (isset($stylesH1) && boolval($stylesH1->H1) === true) {
                ?> @media(min-width:981px){
                    .et_pb_module h1 {
                        <?php echo $stylesH1->H1DpFF !== 'Initial' ? et_builder_get_font_family($stylesH1->H1DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH1->H1DpFW) ?>;
                        font-style: <?php echo esc_attr($stylesH1->H1DpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH1->H1DpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH1->H1DpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH1->H1DpFS->underline === true ? 'underline' : ($stylesH1->H1DpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH1->H1DpFS->underline === true | $stylesH1->H1DpFS->line_through === true) ? $stylesH1->H1DpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH1->H1DpFS->underline === true | $stylesH1->H1DpFS->line_through === true) ? $stylesH1->H1DpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH1->H1DpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH1->H1DpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH1->H1DpLS) ?>;
                        line-height: <?php echo esc_attr($stylesH1->H1DpLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h1 {
                        <?php echo $stylesH1->H1DpFF !== 'Initial' ? et_builder_get_font_family($stylesH1->H1DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH1->H1DpFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH1->H1DpColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH1->H1DpTS) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    .et_pb_module h1 {
                        <?php echo $stylesH1->H1TbFF !== 'Initial' ? et_builder_get_font_family($stylesH1->H1TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH1->H1TbFW) ?>;
                        font-style: <?php echo esc_attr($stylesH1->H1TbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH1->H1TbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH1->H1TbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH1->H1TbFS->underline === true ? 'underline' : ($stylesH1->H1TbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH1->H1TbFS->underline === true | $stylesH1->H1TbFS->line_through === true) ? $stylesH1->H1TbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH1->H1TbFS->underline === true | $stylesH1->H1TbFS->line_through === true) ? $stylesH1->H1TbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH1->H1TbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH1->H1TbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH1->H1TbLS) ?>;
                        line-height: <?php echo esc_attr($stylesH1->H1TbLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h1 {
                        <?php echo $stylesH1->H1TbFF !== 'Initial' ? et_builder_get_font_family($stylesH1->H1TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH1->H1TbFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH1->H1TbColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH1->H1TbTS) ?>;
                    }
                }
                @media(max-width:767px){
                    .et_pb_module h1 {
                        <?php echo $stylesH1->H1PhFF !== 'Initial' ? et_builder_get_font_family($stylesH1->H1PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH1->H1PhFW) ?>;
                        font-style: <?php echo esc_attr($stylesH1->H1PhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH1->H1PhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH1->H1PhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH1->H1PhFS->underline === true ? 'underline' : ($stylesH1->H1PhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH1->H1PhFS->underline === true | $stylesH1->H1PhFS->line_through === true) ? $stylesH1->H1PhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH1->H1PhFS->underline === true | $stylesH1->H1PhFS->line_through === true) ? $stylesH1->H1PhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH1->H1PhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH1->H1PhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH1->H1PhLS) ?>;
                        line-height: <?php echo esc_attr($stylesH1->H1PhLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h1 {
                        <?php echo $stylesH1->H1PhFF !== 'Initial' ? et_builder_get_font_family($stylesH1->H1PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH1->H1PhFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH1->H1PhColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH1->H1PhTS) ?>;
                    }
                }
                <?php
            }
            $stylesH2 = json_decode(get_option('paDaStylesH2'));
            if (isset($stylesH2) && boolval($stylesH2->H2) === true) {
                ?> @media(min-width:981px){
                    .et_pb_module h2 {
                        <?php echo $stylesH2->H2DpFF !== 'Initial' ? et_builder_get_font_family($stylesH2->H2DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH2->H2DpFW) ?>;
                        font-style: <?php echo esc_attr($stylesH2->H2DpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH2->H2DpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH2->H2DpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH2->H2DpFS->underline === true ? 'underline' : ($stylesH2->H2DpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH2->H2DpFS->underline === true | $stylesH2->H2DpFS->line_through === true) ? $stylesH2->H2DpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH2->H2DpFS->underline === true | $stylesH2->H2DpFS->line_through === true) ? $stylesH2->H2DpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH2->H2DpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH2->H2DpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH2->H2DpLS) ?>;
                        line-height: <?php echo esc_attr($stylesH2->H2DpLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h2 {
                        <?php echo $stylesH2->H2DpFF !== 'Initial' ? et_builder_get_font_family($stylesH2->H2DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH2->H2DpFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH2->H2DpColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH2->H2DpTS) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    .et_pb_module h2 {
                        <?php echo $stylesH2->H2TbFF !== 'Initial' ? et_builder_get_font_family($stylesH2->H2TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH2->H2TbFW) ?>;
                        font-style: <?php echo esc_attr($stylesH2->H2TbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH2->H2TbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH2->H2TbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH2->H2TbFS->underline === true ? 'underline' : ($stylesH2->H2TbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH2->H2TbFS->underline === true | $stylesH2->H2TbFS->line_through === true) ? $stylesH2->H2TbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH2->H2TbFS->underline === true | $stylesH2->H2TbFS->line_through === true) ? $stylesH2->H2TbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH2->H2TbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH2->H2TbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH2->H2TbLS) ?>;
                        line-height: <?php echo esc_attr($stylesH2->H2TbLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h2 {
                        <?php echo $stylesH2->H2TbFF !== 'Initial' ? et_builder_get_font_family($stylesH2->H2TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH2->H2TbFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH2->H2TbColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH2->H2TbTS) ?>;
                    }
                }
                @media(max-width:767px){
                    .et_pb_module h2 {
                        <?php echo $stylesH2->H2PhFF !== 'Initial' ? et_builder_get_font_family($stylesH2->H2PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH2->H2PhFW) ?>;
                        font-style: <?php echo esc_attr($stylesH2->H2PhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH2->H2PhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH2->H2PhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH2->H2PhFS->underline === true ? 'underline' : ($stylesH2->H2PhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH2->H2PhFS->underline === true | $stylesH2->H2PhFS->line_through === true) ? $stylesH2->H2PhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH2->H2PhFS->underline === true | $stylesH2->H2PhFS->line_through === true) ? $stylesH2->H2PhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH2->H2PhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH2->H2PhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH2->H2PhLS) ?>;
                        line-height: <?php echo esc_attr($stylesH2->H2PhLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h2 {
                        <?php echo $stylesH2->H2PhFF !== 'Initial' ? et_builder_get_font_family($stylesH2->H2PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH2->H2PhFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH2->H2PhColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH2->H2PhTS) ?>;
                    }
                }
                <?php
            }
            $stylesH3 = json_decode(get_option('paDaStylesH3'));
            if (isset($stylesH3) && boolval($stylesH3->H3) === true) {
                ?> @media(min-width:981px){
                    .et_pb_module h3 {
                        <?php echo $stylesH3->H3DpFF !== 'Initial' ? et_builder_get_font_family($stylesH3->H3DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH3->H3DpFW) ?>;
                        font-style: <?php echo esc_attr($stylesH3->H3DpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH3->H3DpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH3->H3DpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH3->H3DpFS->underline === true ? 'underline' : ($stylesH3->H3DpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH3->H3DpFS->underline === true | $stylesH3->H3DpFS->line_through === true) ? $stylesH3->H3DpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH3->H3DpFS->underline === true | $stylesH3->H3DpFS->line_through === true) ? $stylesH3->H3DpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH3->H3DpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH3->H3DpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH3->H3DpLS) ?>;
                        line-height: <?php echo esc_attr($stylesH3->H3DpLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h3 {
                        <?php echo $stylesH3->H3DpFF !== 'Initial' ? et_builder_get_font_family($stylesH3->H3DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH3->H3DpFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH3->H3DpColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH3->H3DpTS) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    .et_pb_module h3 {
                        <?php echo $stylesH3->H3TbFF !== 'Initial' ? et_builder_get_font_family($stylesH3->H3TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH3->H3TbFW) ?>;
                        font-style: <?php echo esc_attr($stylesH3->H3TbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH3->H3TbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH3->H3TbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH3->H3TbFS->underline === true ? 'underline' : ($stylesH3->H3TbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH3->H3TbFS->underline === true | $stylesH3->H3TbFS->line_through === true) ? $stylesH3->H3TbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH3->H3TbFS->underline === true | $stylesH3->H3TbFS->line_through === true) ? $stylesH3->H3TbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH3->H3TbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH3->H3TbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH3->H3TbLS) ?>;
                        line-height: <?php echo esc_attr($stylesH3->H3TbLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h3 {
                        <?php echo $stylesH3->H3TbFF !== 'Initial' ? et_builder_get_font_family($stylesH3->H3TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH3->H3TbFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH3->H3TbColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH3->H3TbTS) ?>;
                    }
                }
                @media(max-width:767px){
                    .et_pb_module h3 {
                        <?php echo $stylesH3->H3PhFF !== 'Initial' ? et_builder_get_font_family($stylesH3->H3PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH3->H3PhFW) ?>;
                        font-style: <?php echo esc_attr($stylesH3->H3PhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH3->H3PhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH3->H3PhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH3->H3PhFS->underline === true ? 'underline' : ($stylesH3->H3PhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH3->H3PhFS->underline === true | $stylesH3->H3PhFS->line_through === true) ? $stylesH3->H3PhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH3->H3PhFS->underline === true | $stylesH3->H3PhFS->line_through === true) ? $stylesH3->H3PhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH3->H3PhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH3->H3PhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH3->H3PhLS) ?>;
                        line-height: <?php echo esc_attr($stylesH3->H3PhLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h3 {
                        <?php echo $stylesH3->H3PhFF !== 'Initial' ? et_builder_get_font_family($stylesH3->H3PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH3->H3PhFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH3->H3PhColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH3->H3PhTS) ?>;
                    }
                }
                <?php
            }
            $stylesH4 = json_decode(get_option('paDaStylesH4'));
            if (isset($stylesH4) && boolval($stylesH4->H4) === true) {
                ?> @media(min-width:981px){
                    .et_pb_module h4 {
                        <?php echo $stylesH4->H4DpFF !== 'Initial' ? et_builder_get_font_family($stylesH4->H4DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH4->H4DpFW) ?>;
                        font-style: <?php echo esc_attr($stylesH4->H4DpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH4->H4DpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH4->H4DpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH4->H4DpFS->underline === true ? 'underline' : ($stylesH4->H4DpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH4->H4DpFS->underline === true | $stylesH4->H4DpFS->line_through === true) ? $stylesH4->H4DpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH4->H4DpFS->underline === true | $stylesH4->H4DpFS->line_through === true) ? $stylesH4->H4DpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH4->H4DpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH4->H4DpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH4->H4DpLS) ?>;
                        line-height: <?php echo esc_attr($stylesH4->H4DpLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h4 {
                        <?php echo $stylesH4->H4DpFF !== 'Initial' ? et_builder_get_font_family($stylesH4->H4DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH4->H4DpFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH4->H4DpColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH4->H4DpTS) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    .et_pb_module h4 {
                        <?php echo $stylesH4->H4TbFF !== 'Initial' ? et_builder_get_font_family($stylesH4->H4TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH4->H4TbFW) ?>;
                        font-style: <?php echo esc_attr($stylesH4->H4TbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH4->H4TbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH4->H4TbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH4->H4TbFS->underline === true ? 'underline' : ($stylesH4->H4TbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH4->H4TbFS->underline === true | $stylesH4->H4TbFS->line_through === true) ? $stylesH4->H4TbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH4->H4TbFS->underline === true | $stylesH4->H4TbFS->line_through === true) ? $stylesH4->H4TbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH4->H4TbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH4->H4TbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH4->H4TbLS) ?>;
                        line-height: <?php echo esc_attr($stylesH4->H4TbLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h4 {
                        <?php echo $stylesH4->H4TbFF !== 'Initial' ? et_builder_get_font_family($stylesH4->H4TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH4->H4TbFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH4->H4TbColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH4->H4TbTS) ?>;
                    }
                }
                @media(max-width:767px){
                    .et_pb_module h4 {
                        <?php echo $stylesH4->H4PhFF !== 'Initial' ? et_builder_get_font_family($stylesH4->H4PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH4->H4PhFW) ?>;
                        font-style: <?php echo esc_attr($stylesH4->H4PhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH4->H4PhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH4->H4PhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH4->H4PhFS->underline === true ? 'underline' : ($stylesH4->H4PhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH4->H4PhFS->underline === true | $stylesH4->H4PhFS->line_through === true) ? $stylesH4->H4PhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH4->H4PhFS->underline === true | $stylesH4->H4PhFS->line_through === true) ? $stylesH4->H4PhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH4->H4PhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH4->H4PhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH4->H4PhLS) ?>;
                        line-height: <?php echo esc_attr($stylesH4->H4PhLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h4 {
                        <?php echo $stylesH4->H4PhFF !== 'Initial' ? et_builder_get_font_family($stylesH4->H4PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH4->H4PhFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH4->H4PhColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH4->H4PhTS) ?>;
                    }
                }
                <?php
            }
            $stylesH5 = json_decode(get_option('paDaStylesH5'));
            if (isset($stylesH5) && boolval($stylesH5->H5) === true) {
                ?> @media(min-width:981px){
                    .et_pb_module h5 {
                        <?php echo $stylesH5->H5DpFF !== 'Initial' ? et_builder_get_font_family($stylesH5->H5DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH5->H5DpFW) ?>;
                        font-style: <?php echo esc_attr($stylesH5->H5DpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH5->H5DpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH5->H5DpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH5->H5DpFS->underline === true ? 'underline' : ($stylesH5->H5DpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH5->H5DpFS->underline === true | $stylesH5->H5DpFS->line_through === true) ? $stylesH5->H5DpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH5->H5DpFS->underline === true | $stylesH5->H5DpFS->line_through === true) ? $stylesH5->H5DpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH5->H5DpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH5->H5DpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH5->H5DpLS) ?>;
                        line-height: <?php echo esc_attr($stylesH5->H5DpLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h5 {
                        <?php echo $stylesH5->H5DpFF !== 'Initial' ? et_builder_get_font_family($stylesH5->H5DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH5->H5DpFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH5->H5DpColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH5->H5DpTS) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    .et_pb_module h5 {
                        <?php echo $stylesH5->H5TbFF !== 'Initial' ? et_builder_get_font_family($stylesH5->H5TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH5->H5TbFW) ?>;
                        font-style: <?php echo esc_attr($stylesH5->H5TbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH5->H5TbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH5->H5TbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH5->H5TbFS->underline === true ? 'underline' : ($stylesH5->H5TbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH5->H5TbFS->underline === true | $stylesH5->H5TbFS->line_through === true) ? $stylesH5->H5TbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH5->H5TbFS->underline === true | $stylesH5->H5TbFS->line_through === true) ? $stylesH5->H5TbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH5->H5TbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH5->H5TbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH5->H5TbLS) ?>;
                        line-height: <?php echo esc_attr($stylesH5->H5TbLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h5 {
                        <?php echo $stylesH5->H5TbFF !== 'Initial' ? et_builder_get_font_family($stylesH5->H5TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH5->H5TbFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH5->H5TbColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH5->H5TbTS) ?>;
                    }
                }
                @media(max-width:767px){
                    .et_pb_module h5 {
                        <?php echo $stylesH5->H5PhFF !== 'Initial' ? et_builder_get_font_family($stylesH5->H5PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH5->H5PhFW) ?>;
                        font-style: <?php echo esc_attr($stylesH5->H5PhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH5->H5PhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH5->H5PhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH5->H5PhFS->underline === true ? 'underline' : ($stylesH5->H5PhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH5->H5PhFS->underline === true | $stylesH5->H5PhFS->line_through === true) ? $stylesH5->H5PhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH5->H5PhFS->underline === true | $stylesH5->H5PhFS->line_through === true) ? $stylesH5->H5PhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH5->H5PhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH5->H5PhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH5->H5PhLS) ?>;
                        line-height: <?php echo esc_attr($stylesH5->H5PhLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h5 {
                        <?php echo $stylesH5->H5PhFF !== 'Initial' ? et_builder_get_font_family($stylesH5->H5PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH5->H5PhFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH5->H5PhColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH5->H5PhTS) ?>;
                    }
                }
                <?php
            }
            $stylesH6 = json_decode(get_option('paDaStylesH6'));
            if (isset($stylesH6) && boolval($stylesH6->H6) === true) {
                ?> @media(min-width:981px){
                    .et_pb_module h6 {
                        <?php echo $stylesH6->H6DpFF !== 'Initial' ? et_builder_get_font_family($stylesH6->H6DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH6->H6DpFW) ?>;
                        font-style: <?php echo esc_attr($stylesH6->H6DpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH6->H6DpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH6->H6DpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH6->H6DpFS->underline === true ? 'underline' : ($stylesH6->H6DpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH6->H6DpFS->underline === true | $stylesH6->H6DpFS->line_through === true) ? $stylesH6->H6DpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH6->H6DpFS->underline === true | $stylesH6->H6DpFS->line_through === true) ? $stylesH6->H6DpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH6->H6DpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH6->H6DpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH6->H6DpLS) ?>;
                        line-height: <?php echo esc_attr($stylesH6->H6DpLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h6 {
                        <?php echo $stylesH6->H6DpFF !== 'Initial' ? et_builder_get_font_family($stylesH6->H6DpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH6->H6DpFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH6->H6DpColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH6->H6DpTS) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    .et_pb_module h6 {
                        <?php echo $stylesH6->H6TbFF !== 'Initial' ? et_builder_get_font_family($stylesH6->H6TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH6->H6TbFW) ?>;
                        font-style: <?php echo esc_attr($stylesH6->H6TbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH6->H6TbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH6->H6TbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH6->H6TbFS->underline === true ? 'underline' : ($stylesH6->H6TbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH6->H6TbFS->underline === true | $stylesH6->H6TbFS->line_through === true) ? $stylesH6->H6TbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH6->H6TbFS->underline === true | $stylesH6->H6TbFS->line_through === true) ? $stylesH6->H6TbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH6->H6TbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH6->H6TbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH6->H6TbLS) ?>;
                        line-height: <?php echo esc_attr($stylesH6->H6TbLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h6 {
                        <?php echo $stylesH6->H6TbFF !== 'Initial' ? et_builder_get_font_family($stylesH6->H6TbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH6->H6TbFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH6->H6TbColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH6->H6TbTS) ?>;
                    }
                }
                @media(max-width:767px){
                    .et_pb_module h6 {
                        <?php echo $stylesH6->H6PhFF !== 'Initial' ? et_builder_get_font_family($stylesH6->H6PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH6->H6PhFW) ?>;
                        font-style: <?php echo esc_attr($stylesH6->H6PhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesH6->H6PhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesH6->H6PhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesH6->H6PhFS->underline === true ? 'underline' : ($stylesH6->H6PhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesH6->H6PhFS->underline === true | $stylesH6->H6PhFS->line_through === true) ? $stylesH6->H6PhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesH6->H6PhFS->underline === true | $stylesH6->H6PhFS->line_through === true) ? $stylesH6->H6PhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH6->H6PhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesH6->H6PhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesH6->H6PhLS) ?>;
                        line-height: <?php echo esc_attr($stylesH6->H6PhLH) ?>;
                    }
                    .et_pb_slider .et_pb_slide_description h6 {
                        <?php echo $stylesH6->H6PhFF !== 'Initial' ? et_builder_get_font_family($stylesH6->H6PhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesH6->H6PhFW) ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesH6->H6PhColor)) ?> !important;
                        font-size: <?php echo esc_attr($stylesH6->H6PhTS) ?>;
                    }
                }
                <?php
            }
            $stylesBT = json_decode(get_option('paDaStylesBT'));
            if (isset($stylesBT) && boolval($stylesBT->BT) === true) {
                ?> @media(min-width:981px){
                    .et_pb_module:not(.et_pb_image, .et_pb_text, .et_pb_slider, .pac-da-styles-helper-exclude), .et_pb_text, .et_pb_slider .et_pb_slide_content {
                        <?php echo $stylesBT->BTDpFF !== 'Initial' ? et_builder_get_font_family($stylesBT->BTDpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesBT->BTDpFW) ?>;
                        font-style: <?php echo esc_attr($stylesBT->BTDpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesBT->BTDpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesBT->BTDpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesBT->BTDpFS->underline === true ? 'underline' : ($stylesBT->BTDpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesBT->BTDpFS->underline === true | $stylesBT->BTDpFS->line_through === true) ? $stylesBT->BTDpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesBT->BTDpFS->underline === true | $stylesBT->BTDpFS->line_through === true) ? $stylesBT->BTDpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesBT->BTDpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesBT->BTDpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesBT->BTDpLS) ?>;
                        line-height: <?php echo esc_attr($stylesBT->BTDpLH) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    .et_pb_module:not(.et_pb_image, .et_pb_text, .et_pb_slider, .pac-da-styles-helper-exclude), .et_pb_text, .et_pb_slider .et_pb_slide_content {
                        <?php echo $stylesBT->BTTbFF !== 'Initial' ? et_builder_get_font_family($stylesBT->BTTbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesBT->BTTbFW) ?>;
                        font-style: <?php echo esc_attr($stylesBT->BTTbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesBT->BTTbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesBT->BTTbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesBT->BTTbFS->underline === true ? 'underline' : ($stylesBT->BTTbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesBT->BTTbFS->underline === true | $stylesBT->BTTbFS->line_through === true) ? $stylesBT->BTTbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesBT->BTTbFS->underline === true | $stylesBT->BTTbFS->line_through === true) ? $stylesBT->BTTbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesBT->BTTbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesBT->BTTbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesBT->BTTbLS) ?>;
                        line-height: <?php echo esc_attr($stylesBT->BTTbLH) ?>;
                    }
                }
                @media(max-width:767px){
                    .et_pb_module:not(.et_pb_image, .et_pb_text, .et_pb_slider, .pac-da-styles-helper-exclude), .et_pb_text, .et_pb_slider .et_pb_slide_content {
                        <?php echo $stylesBT->BTPhFF !== 'Initial' ? et_builder_get_font_family($stylesBT->BTPhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesBT->BTPhFW) ?>;
                        font-style: <?php echo esc_attr($stylesBT->BTPhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesBT->BTPhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesBT->BTPhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesBT->BTPhFS->underline === true ? 'underline' : ($stylesBT->BTPhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesBT->BTPhFS->underline === true | $stylesBT->BTPhFS->line_through === true) ? $stylesBT->BTPhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesBT->BTPhFS->underline === true | $stylesBT->BTPhFS->line_through === true) ? $stylesBT->BTPhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesBT->BTPhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesBT->BTPhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesBT->BTPhLS) ?>;
                        line-height: <?php echo esc_attr($stylesBT->BTPhLH) ?>;
                    }
                }
                <?php
            }
            $stylesLT = json_decode(get_option('paDaStylesLT'));
            if (isset($stylesLT) && boolval($stylesLT->LT) === true) {
                ?> @media(min-width:981px){
                    .et_pb_module div:not(.pac_dtm_title_subtitle) > a, .et_pb_module p > a, .et_pb_module li:not([class^='et_pb_tab_']) > a {
                        <?php echo $stylesLT->LTDpFF !== 'Initial' ? et_builder_get_font_family($stylesLT->LTDpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesLT->LTDpFW) ?>;
                        font-style: <?php echo esc_attr($stylesLT->LTDpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesLT->LTDpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesLT->LTDpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesLT->LTDpFS->underline === true ? 'underline' : ($stylesLT->LTDpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesLT->LTDpFS->underline === true | $stylesLT->LTDpFS->line_through === true) ? $stylesLT->LTDpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesLT->LTDpFS->underline === true | $stylesLT->LTDpFS->line_through === true) ? $stylesLT->LTDpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesLT->LTDpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesLT->LTDpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesLT->LTDpLS) ?>;
                        line-height: <?php echo esc_attr($stylesLT->LTDpLH) ?>;
                    }
                    .et_pb_module div:not(.pac_dtm_title_subtitle) > a:hover, .et_pb_module p > a:hover, .et_pb_module li:not([class^='et_pb_tab_']) > a:hover {
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid(isset($stylesLT->LTDpHColor) ? $stylesLT->LTDpHColor : '#2ea3f2')) ?>!important;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    .et_pb_module div:not(.pac_dtm_title_subtitle) > a, .et_pb_module p > a, .et_pb_module li:not([class^='et_pb_tab_']) > a {
                        <?php echo $stylesLT->LTTbFF !== 'Initial' ? et_builder_get_font_family($stylesLT->LTTbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesLT->LTTbFW) ?>;
                        font-style: <?php echo esc_attr($stylesLT->LTTbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesLT->LTTbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesLT->LTTbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesLT->LTTbFS->underline === true ? 'underline' : ($stylesLT->LTTbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesLT->LTTbFS->underline === true | $stylesLT->LTTbFS->line_through === true) ? $stylesLT->LTTbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesLT->LTTbFS->underline === true | $stylesLT->LTTbFS->line_through === true) ? $stylesLT->LTTbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesLT->LTTbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesLT->LTTbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesLT->LTTbLS) ?>;
                        line-height: <?php echo esc_attr($stylesLT->LTTbLH) ?>;
                    }
                    .et_pb_module div:not(.pac_dtm_title_subtitle) > a:hover, .et_pb_module p > a:hover, .et_pb_module li:not([class^='et_pb_tab_']) > a:hover {
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid(isset($stylesLT->LTTbHColor) ? $stylesLT->LTTbHColor : '#2ea3f2')) ?>!important;
                    }
                }
                @media(max-width:767px){
                    .et_pb_module div:not(.pac_dtm_title_subtitle) > a, .et_pb_module p > a, .et_pb_module li:not([class^='et_pb_tab_']) > a {
                        <?php echo $stylesLT->LTPhFF !== 'Initial' ? et_builder_get_font_family($stylesLT->LTPhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesLT->LTPhFW) ?>;
                        font-style: <?php echo esc_attr($stylesLT->LTPhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesLT->LTPhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesLT->LTPhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesLT->LTPhFS->underline === true ? 'underline' : ($stylesLT->LTPhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesLT->LTPhFS->underline === true | $stylesLT->LTPhFS->line_through === true) ? $stylesLT->LTPhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesLT->LTPhFS->underline === true | $stylesLT->LTPhFS->line_through === true) ? $stylesLT->LTPhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesLT->LTPhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesLT->LTPhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesLT->LTPhLS) ?>;
                        line-height: <?php echo esc_attr($stylesLT->LTPhLH) ?>;
                    }
                    .et_pb_module div:not(.pac_dtm_title_subtitle) > a:hover, .et_pb_module p > a:hover, .et_pb_module li:not([class^='et_pb_tab_']) > a:hover {
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid(isset($stylesLT->LTPhHColor) ? $stylesLT->LTPhHColor : '#2ea3f2')) ?>!important;
                    }
                }
                <?php
            }
            $stylesUL = json_decode(get_option('paDaStylesUL'));
            if (isset($stylesUL) && boolval($stylesUL->UL) === true) {
                ?> @media(min-width:981px){
                    body .et_pb_module ul {
                        list-style-type: <?php echo esc_attr($stylesUL->ULDpT) ?>;
                        padding-left: <?php echo esc_attr($stylesUL->ULDpI) ?>;
                    }
                    .et_pb_module ul {
                        list-style-position: <?php echo esc_attr($stylesUL->ULDpP) ?>;
                    }
                    .et_pb_module ul li {
                        <?php echo $stylesUL->ULDpFF !== 'Initial' ? et_builder_get_font_family($stylesUL->ULDpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesUL->ULDpFW) ?>;
                        font-style: <?php echo esc_attr($stylesUL->ULDpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesUL->ULDpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesUL->ULDpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesUL->ULDpFS->underline === true ? 'underline' : ($stylesUL->ULDpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesUL->ULDpFS->underline === true | $stylesUL->ULDpFS->line_through === true) ? $stylesUL->ULDpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesUL->ULDpFS->underline === true | $stylesUL->ULDpFS->line_through === true) ? $stylesUL->ULDpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesUL->ULDpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesUL->ULDpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesUL->ULDpLS) ?>;
                        line-height: <?php echo esc_attr($stylesUL->ULDpLH) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    body .et_pb_module ul {
                        list-style-type: <?php echo esc_attr($stylesUL->ULTbT) ?>;
                        padding-left: <?php echo esc_attr($stylesUL->ULTbI) ?>;
                    }
                    .et_pb_module ul {
                        list-style-position: <?php echo esc_attr($stylesUL->ULTbP) ?>;
                    }
                    .et_pb_module ul li {
                        <?php echo $stylesUL->ULTbFF !== 'Initial' ? et_builder_get_font_family($stylesUL->ULTbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesUL->ULTbFW) ?>;
                        font-style: <?php echo esc_attr($stylesUL->ULTbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesUL->ULTbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesUL->ULTbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesUL->ULTbFS->underline === true ? 'underline' : ($stylesUL->ULTbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesUL->ULTbFS->underline === true | $stylesUL->ULTbFS->line_through === true) ? $stylesUL->ULTbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesUL->ULTbFS->underline === true | $stylesUL->ULTbFS->line_through === true) ? $stylesUL->ULTbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesUL->ULTbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesUL->ULTbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesUL->ULTbLS) ?>;
                        line-height: <?php echo esc_attr($stylesUL->ULTbLH) ?>;
                    }
                }
                @media(max-width:767px){
                    body .et_pb_module ul {
                        list-style-type: <?php echo esc_attr($stylesUL->ULPhT) ?>;
                        padding-left: <?php echo esc_attr($stylesUL->ULPhI) ?>;
                    }
                    .et_pb_module ul {
                        list-style-position: <?php echo esc_attr($stylesUL->ULPhP) ?>;
                    }
                    .et_pb_module ul li {
                        <?php echo $stylesUL->ULPhFF !== 'Initial' ? et_builder_get_font_family($stylesUL->ULPhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesUL->ULPhFW) ?>;
                        font-style: <?php echo esc_attr($stylesUL->ULPhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesUL->ULPhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesUL->ULPhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesUL->ULPhFS->underline === true ? 'underline' : ($stylesUL->ULPhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesUL->ULPhFS->underline === true | $stylesUL->ULPhFS->line_through === true) ? $stylesUL->ULPhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesUL->ULPhFS->underline === true | $stylesUL->ULPhFS->line_through === true) ? $stylesUL->ULPhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesUL->ULPhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesUL->ULPhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesUL->ULPhLS) ?>;
                        line-height: <?php echo esc_attr($stylesUL->ULPhLH) ?>;
                    }
                }
                <?php
            }
            $stylesOL = json_decode(get_option('paDaStylesOL'));
            if (isset($stylesOL) && boolval($stylesOL->OL) === true) {
                ?> @media(min-width:981px){
                    body .et_pb_module ol {
                        list-style-type: <?php echo esc_attr($stylesOL->OLDpT) ?>;
                        padding-left: <?php echo esc_attr($stylesOL->OLDpI) ?>;
                    }
                    .et_pb_module ol {
                        list-style-position: <?php echo esc_attr($stylesOL->OLDpP) ?>;
                    }
                    .et_pb_module ol li {
                        <?php echo $stylesOL->OLDpFF !== 'Initial' ? et_builder_get_font_family($stylesOL->OLDpFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesOL->OLDpFW) ?>;
                        font-style: <?php echo esc_attr($stylesOL->OLDpFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesOL->OLDpFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesOL->OLDpFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesOL->OLDpFS->underline === true ? 'underline' : ($stylesOL->OLDpFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesOL->OLDpFS->underline === true | $stylesOL->OLDpFS->line_through === true) ? $stylesOL->OLDpUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesOL->OLDpFS->underline === true | $stylesOL->OLDpFS->line_through === true) ? $stylesOL->OLDpUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesOL->OLDpColor)) ?>;
                        font-size: <?php echo esc_attr($stylesOL->OLDpTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesOL->OLDpLS) ?>;
                        line-height: <?php echo esc_attr($stylesOL->OLDpLH) ?>;
                    }
                }
                @media(min-width:768px) and (max-width:980px){
                    body .et_pb_module ol {
                        list-style-type: <?php echo esc_attr($stylesOL->OLTbT) ?>;
                        padding-left: <?php echo esc_attr($stylesOL->OLTbI) ?>;
                    }
                    .et_pb_module ol {
                        list-style-position: <?php echo esc_attr($stylesOL->OLTbP) ?>;
                    }
                    .et_pb_module ol li {
                        <?php echo $stylesOL->OLTbFF !== 'Initial' ? et_builder_get_font_family($stylesOL->OLTbFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesOL->OLTbFW) ?>;
                        font-style: <?php echo esc_attr($stylesOL->OLTbFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesOL->OLTbFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesOL->OLTbFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesOL->OLTbFS->underline === true ? 'underline' : ($stylesOL->OLTbFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesOL->OLTbFS->underline === true | $stylesOL->OLTbFS->line_through === true) ? $stylesOL->OLTbUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesOL->OLTbFS->underline === true | $stylesOL->OLTbFS->line_through === true) ? $stylesOL->OLTbUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesOL->OLTbColor)) ?>;
                        font-size: <?php echo esc_attr($stylesOL->OLTbTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesOL->OLTbLS) ?>;
                        line-height: <?php echo esc_attr($stylesOL->OLTbLH) ?>;
                    }
                }
                @media(max-width:767px){
                    body .et_pb_module ol {
                        list-style-type: <?php echo esc_attr($stylesOL->OLPhT) ?>;
                        padding-left: <?php echo esc_attr($stylesOL->OLPhI) ?>;
                    }
                    .et_pb_module ol {
                        list-style-position: <?php echo esc_attr($stylesOL->OLPhP) ?>;
                    }
                    .et_pb_module ol li {
                        <?php echo $stylesOL->OLPhFF !== 'Initial' ? et_builder_get_font_family($stylesOL->OLPhFF) : '' // phpcs:ignore ?>
                        font-weight: <?php echo esc_attr($stylesOL->OLPhFW) ?>;
                        font-style: <?php echo esc_attr($stylesOL->OLPhFS->italic === true ? 'italic' : 'normal') ?>;
                        text-transform: <?php echo esc_attr($stylesOL->OLPhFS->uppercase === true ? 'uppercase' : 'inherit') ?>;
                        font-variant: <?php echo esc_attr($stylesOL->OLPhFS->capitalize === true ? 'small-caps' : 'normal') ?>;
                        text-decoration-line: <?php echo esc_attr($stylesOL->OLPhFS->underline === true ? 'underline' : ($stylesOL->OLPhFS->line_through === true ? 'line-through' : 'none')) ?>;
                        text-decoration-color: <?php echo esc_attr(pac_da_check_global_color_gcid(($stylesOL->OLPhFS->underline === true | $stylesOL->OLPhFS->line_through === true) ? $stylesOL->OLPhUColor : 'inherit')) ?>;
                        text-decoration-style: <?php echo esc_attr(($stylesOL->OLPhFS->underline === true | $stylesOL->OLPhFS->line_through === true) ? $stylesOL->OLPhUStyle : 'solid') ?>;
                        color: <?php echo esc_attr(pac_da_check_global_color_gcid($stylesOL->OLPhColor)) ?>;
                        font-size: <?php echo esc_attr($stylesOL->OLPhTS) ?>;
                        letter-spacing: <?php echo esc_attr($stylesOL->OLPhLS) ?>;
                        line-height: <?php echo esc_attr($stylesOL->OLPhLH) ?>;
                    }
                }
                <?php
            }
            ?> </style> <?php
        }
    }
    add_action('wp_footer', 'pac_da_global_styles', 0);
endif;
function pacDaRmDpFw($input) {
    $firstChar = substr($input, 0, 1);
    $input = substr($input, 1); 
    $array = explode(",", $input); 
    $uniqueArray = array_unique($array); 
    $result = implode(",", $uniqueArray); 
    $result = $firstChar . $result;
    return $result;
}
function pac_da_generate_font_link($fontFamilies,$fontWeights, $subset = 'latin,latin-ext', $display = 'swap') {
    $fontLink = 'https://fonts.googleapis.com/css?family=';

    foreach ($fontFamilies as $fontFamily) {
        if($fontFamily !== 'Initial'){
            $fontLink .= str_replace(' ', '+', $fontFamily) . pacDaRmDpFw($fontWeights[$fontFamily]) .'|';
        }
    }
    $fontLink = rtrim($fontLink, '|');
    $fontLink .= '&amp;subset=latin,latin-ext&amp;display=swap';

    return $fontLink;
}
function daCheckFontWeight($value) {
    if ($value === 400) {
        return 'regular';
    } else {
        return $value;
    }
}
// Include google font family
if (!function_exists('pac_da_enqueue_google_font_styles') && boolval($stylesSettings)):
    function pac_da_enqueue_google_font_styles()
    {
        if (!in_array('et-fb', get_body_class())) {
            $FF = [];
            $FW = [];
            $stylesH1 = json_decode(get_option('paDaStylesH1', '{"H1":false,"H1DpFF":"Initial","H1DpFW":"400","H1DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1DpUColor":"#333","H1DpUStyle":"solid","H1DpColor":"#333","H1DpTS":"30px","H1DpLS":"0px","H1DpLH":"1em","H1TbFF":"Initial","H1TbFW":"400","H1TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1TbUColor":"#333","H1TbUStyle":"solid","H1TbColor":"#333","H1TbTS":"30px","H1TbLS":"0px","H1TbLH":"1em","H1PhFF":"Initial","H1PhFW":"400","H1PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1PhUColor":"#333","H1PhUStyle":"solid","H1PhColor":"#333","H1PhTS":"30px","H1PhLS":"0px","H1PhLH":"1em"}'));
            if (true === (bool)$stylesH1->H1) {
                $FF[] = $stylesH1->H1DpFF;
                $FF[] = $stylesH1->H1TbFF;
                $FF[] = $stylesH1->H1PhFF;
                $FW[$stylesH1->H1DpFF] = isset($FW[$stylesH1->H1DpFF]) ? $FW[$stylesH1->H1DpFF].','.daCheckFontWeight($stylesH1->H1DpFW).($stylesH1->H1DpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH1->H1DpFW).($stylesH1->H1DpFS->italic === true ? 'italic' : '');
                $FW[$stylesH1->H1TbFF] = isset($FW[$stylesH1->H1TbFF]) ? $FW[$stylesH1->H1TbFF].','.daCheckFontWeight($stylesH1->H1TbFW).($stylesH1->H1TbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH1->H1TbFW).($stylesH1->H1TbFS->italic === true ? 'italic' : '');
                $FW[$stylesH1->H1PhFF] = isset($FW[$stylesH1->H1PhFF]) ? $FW[$stylesH1->H1PhFF].','.daCheckFontWeight($stylesH1->H1PhFW).($stylesH1->H1PhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH1->H1PhFW).($stylesH1->H1PhFS->italic === true ? 'italic' : '');
            }
            $stylesH2 = json_decode(get_option('paDaStylesH2', '{"H2":false,"H2DpFF":"Initial","H2DpFW":"400","H2DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2DpUColor":"#333","H2DpUStyle":"solid","H2DpColor":"#333","H2DpTS":"26px","H2DpLS":"0px","H2DpLH":"1em","H2TbFF":"Initial","H2TbFW":"400","H2TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2TbUColor":"#333","H2TbUStyle":"solid","H2TbColor":"#333","H2TbTS":"26px","H2TbLS":"0px","H2TbLH":"1em","H2PhFF":"Initial","H2PhFW":"400","H2PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2PhUColor":"#333","H2PhUStyle":"solid","H2PhColor":"#333","H2PhTS":"26px","H2PhLS":"0px","H2PhLH":"1em"}'));
            if (true === (bool)$stylesH2->H2) {
                $FF[] = $stylesH2->H2DpFF;
                $FF[] = $stylesH2->H2TbFF;
                $FF[] = $stylesH2->H2PhFF;
                $FW[$stylesH2->H2DpFF] = isset($FW[$stylesH2->H2DpFF]) ? $FW[$stylesH2->H2DpFF].','.daCheckFontWeight($stylesH2->H2DpFW).($stylesH2->H2DpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH2->H2DpFW).($stylesH2->H2DpFS->italic === true ? 'italic' : '');
                $FW[$stylesH2->H2TbFF] = isset($FW[$stylesH2->H2TbFF]) ? $FW[$stylesH2->H2TbFF].','.daCheckFontWeight($stylesH2->H2TbFW).($stylesH2->H2TbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH2->H2TbFW).($stylesH2->H2TbFS->italic === true ? 'italic' : '');
                $FW[$stylesH2->H2PhFF] = isset($FW[$stylesH2->H2PhFF]) ? $FW[$stylesH2->H2PhFF].','.daCheckFontWeight($stylesH2->H2PhFW).($stylesH2->H2PhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH2->H2PhFW).($stylesH2->H2PhFS->italic === true ? 'italic' : '');
            }
            $stylesH3 = json_decode(get_option('paDaStylesH3', '{"H3":false,"H3DpFF":"Initial","H3DpFW":"400","H3DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3DpUColor":"#333","H3DpUStyle":"solid","H3DpColor":"#333","H3DpTS":"22px","H3DpLS":"0px","H3DpLH":"1em","H3TbFF":"Initial","H3TbFW":"400","H3TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3TbUColor":"#333","H3TbUStyle":"solid","H3TbColor":"#333","H3TbTS":"22px","H3TbLS":"0px","H3TbLH":"1em","H3PhFF":"Initial","H3PhFW":"400","H3PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3PhUColor":"#333","H3PhUStyle":"solid","H3PhColor":"#333","H3PhTS":"22px","H3PhLS":"0px","H3PhLH":"1em"}'));
            if (true === (bool)$stylesH3->H3) {
                $FF[] = $stylesH3->H3DpFF;
                $FF[] = $stylesH3->H3TbFF;
                $FF[] = $stylesH3->H3PhFF;
                $FW[$stylesH3->H3DpFF] = isset($FW[$stylesH3->H3DpFF]) ? $FW[$stylesH3->H3DpFF].','.daCheckFontWeight($stylesH3->H3DpFW).($stylesH3->H3DpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH3->H3DpFW).($stylesH3->H3DpFS->italic === true ? 'italic' : '');
                $FW[$stylesH3->H3TbFF] = isset($FW[$stylesH3->H3TbFF]) ? $FW[$stylesH3->H3TbFF].','.daCheckFontWeight($stylesH3->H3TbFW).($stylesH3->H3TbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH3->H3TbFW).($stylesH3->H3TbFS->italic === true ? 'italic' : '');
                $FW[$stylesH3->H3PhFF] = isset($FW[$stylesH3->H3PhFF]) ? $FW[$stylesH3->H3PhFF].','.daCheckFontWeight($stylesH3->H3PhFW).($stylesH3->H3PhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH3->H3PhFW).($stylesH3->H3PhFS->italic === true ? 'italic' : '');
            }
            $stylesH4 = json_decode(get_option('paDaStylesH4', '{"H4":false,"H4DpFF":"Initial","H4DpFW":"400","H4DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4DpUColor":"#333","H4DpUStyle":"solid","H4DpColor":"#333","H4DpTS":"18px","H4DpLS":"0px","H4DpLH":"1em","H4TbFF":"Initial","H4TbFW":"400","H4TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4TbUColor":"#333","H4TbUStyle":"solid","H4TbColor":"#333","H4TbTS":"18px","H4TbLS":"0px","H4TbLH":"1em","H4PhFF":"Initial","H4PhFW":"400","H4PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4PhUColor":"#333","H4PhUStyle":"solid","H4PhColor":"#333","H4PhTS":"18px","H4PhLS":"0px","H4PhLH":"1em"}'));
            if (true === (bool)$stylesH4->H4) {
                $FF[] = $stylesH4->H4DpFF;
                $FF[] = $stylesH4->H4TbFF;
                $FF[] = $stylesH4->H4PhFF;
                $FW[$stylesH4->H4DpFF] = isset($FW[$stylesH4->H4DpFF]) ? $FW[$stylesH4->H4DpFF].','.daCheckFontWeight($stylesH4->H4DpFW).($stylesH4->H4DpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH4->H4DpFW).($stylesH4->H4DpFS->italic === true ? 'italic' : '');
                $FW[$stylesH4->H4TbFF] = isset($FW[$stylesH4->H4TbFF]) ? $FW[$stylesH4->H4TbFF].','.daCheckFontWeight($stylesH4->H4TbFW).($stylesH4->H4TbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH4->H4TbFW).($stylesH4->H4TbFS->italic === true ? 'italic' : '');
                $FW[$stylesH4->H4PhFF] = isset($FW[$stylesH4->H4PhFF]) ? $FW[$stylesH4->H4PhFF].','.daCheckFontWeight($stylesH4->H4PhFW).($stylesH4->H4PhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH4->H4PhFW).($stylesH4->H4PhFS->italic === true ? 'italic' : '');
            }
            $stylesH5 = json_decode(get_option('paDaStylesH5', '{"H5":false,"H5DpFF":"Initial","H5DpFW":"400","H5DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5DpUColor":"#333","H5DpUStyle":"solid","H5DpColor":"#333","H5DpTS":"16px","H5DpLS":"0px","H5DpLH":"1em","H5TbFF":"Initial","H5TbFW":"400","H5TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5TbUColor":"#333","H5TbUStyle":"solid","H5TbColor":"#333","H5TbTS":"16px","H5TbLS":"0px","H5TbLH":"1em","H5PhFF":"Initial","H5PhFW":"400","H5PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5PhUColor":"#333","H5PhUStyle":"solid","H5PhColor":"#333","H5PhTS":"16px","H5PhLS":"0px","H5PhLH":"1em"}'));
            if (true === (bool)$stylesH5->H5) {
                $FF[] = $stylesH5->H5DpFF;
                $FF[] = $stylesH5->H5TbFF;
                $FF[] = $stylesH5->H5PhFF;
                $FW[$stylesH5->H5DpFF] = isset($FW[$stylesH5->H5DpFF]) ? $FW[$stylesH5->H5DpFF].','.daCheckFontWeight($stylesH5->H5DpFW).($stylesH5->H5DpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH5->H5DpFW).($stylesH5->H5DpFS->italic === true ? 'italic' : '');
                $FW[$stylesH5->H5TbFF] = isset($FW[$stylesH5->H5TbFF]) ? $FW[$stylesH5->H5TbFF].','.daCheckFontWeight($stylesH5->H5TbFW).($stylesH5->H5TbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH5->H5TbFW).($stylesH5->H5TbFS->italic === true ? 'italic' : '');
                $FW[$stylesH5->H5PhFF] = isset($FW[$stylesH5->H5PhFF]) ? $FW[$stylesH5->H5PhFF].','.daCheckFontWeight($stylesH5->H5PhFW).($stylesH5->H5PhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH5->H5PhFW).($stylesH5->H5PhFS->italic === true ? 'italic' : '');
            }
            $stylesH6 = json_decode(get_option('paDaStylesH6', '{"H6":false,"H6DpFF":"Initial","H6DpFW":"400","H6DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6DpUColor":"#333","H6DpUStyle":"solid","H6DpColor":"#333","H6DpTS":"14px","H6DpLS":"0px","H6DpLH":"1em","H6TbFF":"Initial","H6TbFW":"400","H6TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6TbUColor":"#333","H6TbUStyle":"solid","H6TbColor":"#333","H6TbTS":"14px","H6TbLS":"0px","H6TbLH":"1em","H6PhFF":"Initial","H6PhFW":"400","H6PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6PhUColor":"#333","H6PhUStyle":"solid","H6PhColor":"#333","H6PhTS":"14px","H6PhLS":"0px","H6PhLH":"1em"}'));
            if (true === (bool)$stylesH6->H6) {
                $FF[] = $stylesH6->H6DpFF;
                $FF[] = $stylesH6->H6TbFF;
                $FF[] = $stylesH6->H6PhFF;
                $FW[$stylesH6->H6DpFF] = isset($FW[$stylesH6->H6DpFF]) ? $FW[$stylesH6->H6DpFF].','.daCheckFontWeight($stylesH6->H6DpFW).($stylesH6->H6DpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH6->H6DpFW).($stylesH6->H6DpFS->italic === true ? 'italic' : '');
                $FW[$stylesH6->H6TbFF] = isset($FW[$stylesH6->H6TbFF]) ? $FW[$stylesH6->H6TbFF].','.daCheckFontWeight($stylesH6->H6TbFW).($stylesH6->H6TbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH6->H6TbFW).($stylesH6->H6TbFS->italic === true ? 'italic' : '');
                $FW[$stylesH6->H6PhFF] = isset($FW[$stylesH6->H6PhFF]) ? $FW[$stylesH6->H6PhFF].','.daCheckFontWeight($stylesH6->H6PhFW).($stylesH6->H6PhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesH6->H6PhFW).($stylesH6->H6PhFS->italic === true ? 'italic' : '');

            }
            $stylesBT = json_decode(get_option('paDaStylesBT', '{"BT":false, "BTDpFF":"Initial","BTDpFW":"400","BTDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTDpUColor":"#666","BTDpUStyle":"solid","BTDpColor":"#666","BTDpTS":"14px","BTDpLS":"0px","BTDpLH":"1em","BTTbFF":"Initial","BTTbFW":"400","BTTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTTbUColor":"#666","BTTbUStyle":"solid","BTTbColor":"#666","BTTbTS":"14px","BTTbLS":"0px","BTTbLH":"1em","BTPhFF":"Initial","BTPhFW":"400","BTPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTPhUColor":"#666","BTPhUStyle":"solid","BTPhColor":"#666","BTPhTS":"14px","BTPhLS":"0px","BTPhLH":"1em"}'));
            if (true === (bool)$stylesBT->BT) {
                $FF[] = $stylesBT->BTDpFF;
                $FF[] = $stylesBT->BTTbFF;
                $FF[] = $stylesBT->BTPhFF;
                $FW[$stylesBT->BTDpFF] = isset($FW[$stylesBT->BTDpFF]) ? $FW[$stylesBT->BTDpFF].','.daCheckFontWeight($stylesBT->BTDpFW).($stylesBT->BTDpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesBT->BTDpFW).($stylesBT->BTDpFS->italic === true ? 'italic' : '');
                $FW[$stylesBT->BTTbFF] = isset($FW[$stylesBT->BTTbFF]) ? $FW[$stylesBT->BTTbFF].','.daCheckFontWeight($stylesBT->BTTbFW).($stylesBT->BTTbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesBT->BTTbFW).($stylesBT->BTTbFS->italic === true ? 'italic' : '');
                $FW[$stylesBT->BTPhFF] = isset($FW[$stylesBT->BTPhFF]) ? $FW[$stylesBT->BTPhFF].','.daCheckFontWeight($stylesBT->BTPhFW).($stylesBT->BTPhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesBT->BTPhFW).($stylesBT->BTPhFS->italic === true ? 'italic' : '');

            }
            $stylesLT = json_decode(get_option('paDaStylesLT', '{"LT":false, "LTDpFF":"Initial","LTDpFW":"400","LTDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTDpUColor":"#2ea3f2","LTDpUStyle":"solid","LTDpColor":"#2ea3f2","LTDpTS":"14px","LTDpLS":"0px","LTDpLH":"1em","LTTbFF":"Initial","LTTbFW":"400","LTTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTTbUColor":"#2ea3f2","LTTbUStyle":"solid","LTTbColor":"#2ea3f2","LTTbTS":"14px","LTTbLS":"0px","LTTbLH":"1em","LTPhFF":"Initial","LTPhFW":"400","LTPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTPhUColor":"#2ea3f2","LTPhUStyle":"solid","LTPhColor":"#2ea3f2","LTPhTS":"14px","LTPhLS":"0px","LTPhLH":"1em"}'));
            if (true === (bool)$stylesLT->LT) {
                $FF[] = $stylesLT->LTDpFF;
                $FF[] = $stylesLT->LTTbFF;
                $FF[] = $stylesLT->LTPhFF;
                $FW[$stylesLT->LTDpFF] = isset($FW[$stylesLT->LTDpFF]) ? $FW[$stylesLT->LTDpFF].','.daCheckFontWeight($stylesLT->LTDpFW).($stylesLT->LTDpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesLT->LTDpFW).($stylesLT->LTDpFS->italic === true ? 'italic' : '');
                $FW[$stylesLT->LTTbFF] = isset($FW[$stylesLT->LTTbFF]) ? $FW[$stylesLT->LTTbFF].','.daCheckFontWeight($stylesLT->LTTbFW).($stylesLT->LTTbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesLT->LTTbFW).($stylesLT->LTTbFS->italic === true ? 'italic' : '');
                $FW[$stylesLT->LTPhFF] = isset($FW[$stylesLT->LTPhFF]) ? $FW[$stylesLT->LTPhFF].','.daCheckFontWeight($stylesLT->LTPhFW).($stylesLT->LTPhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesLT->LTPhFW).($stylesLT->LTPhFS->italic === true ? 'italic' : '');
            }
            $stylesUL = json_decode(get_option('paDaStylesUL', '{"UL":false, "ULDpFF":"Initial","ULDpFW":"400","ULDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULDpUColor":"#666","ULDpUStyle":"solid","ULDpColor":"#666","ULDpTS":"14px","ULDpLS":"0px","ULDpLH":"1em","ULDpT":"disc","ULDpP":"outside","ULDpI":"0px","ULTbFF":"Initial","ULTbFW":"400","ULTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULTbUColor":"#666","ULTbUStyle":"solid","ULTbColor":"#666","ULTbTS":"14px","ULTbLS":"0px","ULTbLH":"1em","ULTbT":"disc","ULTbP":"outside","ULTbI":"0px","ULPhFF":"Initial","ULPhFW":"400","ULPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULPhUColor":"#666","ULPhUStyle":"solid","ULPhColor":"#666","ULPhTS":"14px","ULPhLS":"0px","ULPhLH":"1em","ULPhT":"disc","ULPhP":"outside","ULPhI":"0px"}'));
            if (true === (bool)$stylesUL->UL) {
                $FF[] = $stylesUL->ULDpFF;
                $FF[] = $stylesUL->ULTbFF;
                $FF[] = $stylesUL->ULPhFF;
                $FW[$stylesUL->ULDpFF] = isset($FW[$stylesUL->ULDpFF]) ? $FW[$stylesUL->ULDpFF].','.daCheckFontWeight($stylesUL->ULDpFW).($stylesUL->ULDpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesUL->ULDpFW).($stylesUL->ULDpFS->italic === true ? 'italic' : '');
                $FW[$stylesUL->ULTbFF] = isset($FW[$stylesUL->ULTbFF]) ? $FW[$stylesUL->ULTbFF].','.daCheckFontWeight($stylesUL->ULTbFW).($stylesUL->ULTbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesUL->ULTbFW).($stylesUL->ULTbFS->italic === true ? 'italic' : '');
                $FW[$stylesUL->ULPhFF] = isset($FW[$stylesUL->ULPhFF]) ? $FW[$stylesUL->ULPhFF].','.daCheckFontWeight($stylesUL->ULPhFW).($stylesUL->ULPhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesUL->ULPhFW).($stylesUL->ULPhFS->italic === true ? 'italic' : '');
            }
            $stylesOL = json_decode(get_option('paDaStylesOL', '{"OL":false, "OLDpFF":"Initial","OLDpFW":"400","OLDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLDpUColor":"#666","OLDpUStyle":"solid","OLDpColor":"#666","OLDpTS":"14px","OLDpLS":"0px","OLDpLH":"1em","OLDpT":"decimal","OLDpP":"outside","OLDpI":"0px","OLTbFF":"Initial","OLTbFW":"400","OLTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLTbUColor":"#666","OLTbUStyle":"solid","OLTbColor":"#666","OLTbTS":"14px","OLTbLS":"0px","OLTbLH":"1em","OLTbT":"decimal","OLTbP":"outside","OLTbI":"0px","OLPhFF":"Initial","OLPhFW":"400","OLPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLPhUColor":"#666","OLPhUStyle":"solid","OLPhColor":"#666","OLPhTS":"14px","OLPhLS":"0px","OLPhLH":"1em","OLPhT":"decimal","OLPhP":"outside","OLPhI":"0px"}'));
            if (true === (bool)$stylesOL->OL) {
                $FF[] = $stylesOL->OLDpFF;
                $FF[] = $stylesOL->OLTbFF;
                $FF[] = $stylesOL->OLPhFF;
                $FW[$stylesOL->OLDpFF] = isset($FW[$stylesOL->OLDpFF]) ? $FW[$stylesOL->OLDpFF].','.daCheckFontWeight($stylesOL->OLDpFW).($stylesOL->OLDpFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesOL->OLDpFW).($stylesOL->OLDpFS->italic === true ? 'italic' : '');
                $FW[$stylesOL->OLTbFF] = isset($FW[$stylesOL->OLTbFF]) ? $FW[$stylesOL->OLTbFF].','.daCheckFontWeight($stylesOL->OLTbFW).($stylesOL->OLTbFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesOL->OLTbFW).($stylesOL->OLTbFS->italic === true ? 'italic' : '');
                $FW[$stylesOL->OLPhFF] = isset($FW[$stylesOL->OLPhFF]) ? $FW[$stylesOL->OLPhFF].','.daCheckFontWeight($stylesOL->OLPhFW).($stylesOL->OLPhFS->italic === true ? 'italic' : '') : ':'.daCheckFontWeight($stylesOL->OLPhFW).($stylesOL->OLPhFS->italic === true ? 'italic' : '');
            }

            if(count($FF) > 0 & et_core_use_google_fonts()){
                $FF = array_unique($FF);
                if (($key = array_search('Initial', $FF)) !== false) {
                    unset($FF[$key]);
                }
                $FF = array_values($FF);
                if(count($FF) > 0){
                    $fontLink = pac_da_generate_font_link($FF,$FW);
                    wp_enqueue_style( 'pac-da-google-fonts-styles', $fontLink);
                }
            }
        }
    }
    add_action('wp_enqueue_scripts', 'pac_da_enqueue_google_font_styles');
endif;


/* -------  Enqueue Local Fonts  ------- */
function add_custom_font_styles() {
    $pac_da_own_font  = empty(get_option('et_uploaded_fonts')) ? null : get_option('et_uploaded_fonts');
    if($pac_da_own_font !== null){
        $pacDaOwnFont = et_builder_enqueue_user_fonts(et_builder_get_custom_fonts());
        $style = <<<EOT
        <style id="pac-da-own-global-font">
            $pacDaOwnFont
        </style>
EOT;
        $allowed_tags = array(
            'style' => array(
                'id' => true,
            ),
            'font-face' => array(
                'font-family' => true,
                'font-display' => true,
                'src' => true,
            ),
        );
        echo wp_kses($style, $allowed_tags);
    }
}
add_action('wp_head', 'add_custom_font_styles');


/* -------  Show Theme Option CSS in Visual builder  ------- */
function pac_da_theme_option_css() {
    $codeData = json_decode(get_option('pacDaCodeData', '{"css":false,"jquery":false,"php":false,"boxHeight":false,"boxHeightValue":"600"}'));
    $enableAddons = json_decode(get_option('pacDaAddons', '{"startUp":true,"maintenance":true,"utility":true,"media":true,"learning":true,"support":true,"fonts":true,"styles":true,"code":true,"frontend":true,"accessibility":true}'));
    $codeSettings = isset($enableAddons->code) ? $enableAddons->code : true;
    $post = get_post(get_the_ID());
    if ( is_object( $post ) && property_exists( $post, 'post_type' ) ) {
        $post_type = $post->post_type;
        if ( is_user_logged_in() && ($post_type === 'page' || $post_type === 'post' || $post_type === 'et_body_layout' || $post_type === 'et_header_layout' || $post_type === 'et_footer_layout') && (boolval($codeData->css) || boolval($codeData->jquery) || boolval($codeData->php)) && boolval($codeSettings)) {
            $REQUEST_URI = isset($_SERVER['REQUEST_URI']) ? sanitize_text_field($_SERVER['REQUEST_URI']) : '';
            if (strpos($REQUEST_URI, '?et_fb=1&PageSpeed=off') !== false || strpos($REQUEST_URI, '?page=et_theme_builder') !== false) {
                wp_enqueue_style( 'epanel-style', get_template_directory_uri() . '/epanel/css/panel.css', array(), et_get_theme_version() );
                $themeOptionsCSS = get_option('et_divi', false);
                $phpCode = get_option('pacDaCustomSnippetPhp', '');
                if($themeOptionsCSS !== false){
                    echo '<div id="pac_da_theme_options_css" class="pac_da_theme_options_css" style="display:none;"><div class="head"><span class="title">Custom Code</span><svg xmlns="http://www.w3.org/2000/svg" id="Layer_2" viewBox="0 0 11.99 11.98"><g><path class="cls-1" d="m7.58,5.99L11.66,1.91c.42-.46.38-1.17-.08-1.59-.43-.39-1.08-.39-1.51,0l-4.08,4.08L1.91.32C1.47-.11.76-.11.32.34c-.43.44-.43,1.14,0,1.57l4.08,4.08L.32,10.07c-.43.44-.43,1.15.02,1.59.44.43,1.14.43,1.57,0l4.08-4.08,4.08,4.08c.44.43,1.15.43,1.59-.02.43-.44.43-1.14,0-1.57l-4.08-4.08h0Z"/></g></svg></div><div class="pac_da_tabs">';
                    echo boolval($codeData->css) ? '<div id="pac_da_css_tab" class="active">CSS</div>' : '';
                    echo !boolval($codeData->jquery) ? '' : (boolval($codeData->css) ? '<div id="pac_da_jquery_tab">JQuery</div>' : '<div id="pac_da_jquery_tab" class="active">JQuery</div>');
                    echo !boolval($codeData->php) ? '' : (boolval($codeData->css) | boolval($codeData->jquery) ? '<div id="pac_da_php_tab">PHP</div>' : '<div id="pac_da_php_tab" class="active">PHP</div>');
                    echo '</div><div class="pac_da_codearea">';
                    echo boolval($codeData->css) ? '<textarea id="themeOptionsTextarea" class="body">' . esc_textarea($themeOptionsCSS['divi_custom_css']) . '</textarea>' : '';
                    echo boolval($codeData->jquery) ? '<textarea id="themeOptionsJquery" class="body">' . esc_textarea($themeOptionsCSS['divi_integration_head']) . '</textarea>' : '';
                    echo boolval($codeData->php) ? '<textarea id="customPhpCode" class="body">' . esc_textarea($phpCode) . '</textarea>' : '';
                    echo '</div><img id="pacDaSavethemeCSSLoader" style="display: none;" src="' . esc_url(PAC_DA_PLUGIN_URL) . '/include/img/loader.gif' . '" alt="saving"><div id="pacDathemeCSSSaved" style="display: none;"></div><div id="pacDaSavethemeCSS">Save</div></div>';
                    ?>
                    <script>
                        jQuery(document).ready(function ($) {
                            var iframe = $("#et-fb-app-frame");
                            if(iframe !== null && iframe.length){
                                var targetDiv = $(".et-fb-page-settings-bar__toggle-button");
                                var sourceDiv = iframe.contents().find("#pac_da_theme_options_css");
                                if (targetDiv.length && sourceDiv.length) {
                                    sourceDiv.insertAfter(targetDiv);
                                }
                            }
                            setTimeout(() => {
                                if($('#pac_da_theme_options_css').length > 0){
                                    var configCSS  = $.extend( {}, window.wp.codeEditor.defaultSettings.codemirror, {
                                        theme: 'et'
                                    });
                                    var configHTML = $.extend( {}, configCSS, {
                                        mode: 'htmlmixed'
                                    });
                                    var configPHP = $.extend({}, configCSS, {
                                        mode: {
                                            name: 'php',
                                            startOpen: true
                                        }
                                    });
                                    var elmnt = document.getElementById("pac_da_theme_options_css");
                                    elmnt.setAttribute('style', 'display:block !important');
                                    if($('#customPhpCode').length > 0 && $('#customPhpCode + .CodeMirror').length === 0){
                                        var instancePhp = window.wp.codeEditor.initialize($('#customPhpCode'), {codemirror: configPHP});
                                        if($('#themeOptionsJquery').length > 0 | $('#themeOptionsTextarea').length > 0){
                                            jQuery("#customPhpCode + .CodeMirror").hide();
                                        }
                                    }
                                    if($('#themeOptionsJquery').length > 0 && $('#themeOptionsJquery + .CodeMirror').length === 0){
                                        var instanceJQ = window.wp.codeEditor.initialize($('#themeOptionsJquery'), {codemirror: configHTML});
                                        if($('#themeOptionsTextarea').length > 0){
                                            jQuery("#themeOptionsJquery + .CodeMirror").hide();
                                        }
                                    }
                                    if($('#themeOptionsTextarea').length > 0  && $('#themeOptionsTextarea + .CodeMirror').length === 0){
                                        var instance = window.wp.codeEditor.initialize($('#themeOptionsTextarea'), {codemirror: configCSS});
                                    }
                                    elmnt.style.display = "none";
                                    jQuery("#pacDaSavethemeCSS").click(function() {
                                        if(instance !== undefined){
                                            instance.codemirror.save();
                                        }
                                        if(instanceJQ !== undefined){
                                            instanceJQ.codemirror.save();
                                        }
                                        if(instancePhp !== undefined){
                                            instancePhp.codemirror.save();
                                        }
                                    });
                                    if(jQuery("#pac_da_php_tab").length > 0){
                                        jQuery("#pac_da_php_tab").click(function() {
                                            jQuery("#pac_da_css_tab").removeClass("active");
                                            jQuery("#pac_da_jquery_tab").removeClass("active");
                                            jQuery(this).addClass("active");
                                            jQuery("#themeOptionsTextarea + .CodeMirror").hide();
                                            jQuery("#themeOptionsJquery + .CodeMirror").hide();
                                            jQuery("#customPhpCode + .CodeMirror").show();
                                        });
                                    }
                                    if(jQuery("#pac_da_jquery_tab").length > 0){
                                        jQuery("#pac_da_jquery_tab").click(function() {
                                            jQuery("#pac_da_css_tab").removeClass("active");
                                            jQuery("#pac_da_php_tab").removeClass("active");
                                            jQuery(this).addClass("active");
                                            jQuery("#themeOptionsTextarea + .CodeMirror").hide();
                                            jQuery("#customPhpCode + .CodeMirror").hide();
                                            jQuery("#themeOptionsJquery + .CodeMirror").show();
                                        });
                                    }
                                    if(jQuery("#pac_da_css_tab").length > 0){
                                        jQuery("#pac_da_css_tab").click(function() {
                                            jQuery("#pac_da_jquery_tab").removeClass("active");
                                            jQuery("#pac_da_php_tab").removeClass("active");
                                            jQuery(this).addClass("active");
                                            jQuery("#customPhpCode + .CodeMirror").hide();
                                            jQuery("#themeOptionsJquery + .CodeMirror").hide();
                                            jQuery("#themeOptionsTextarea + .CodeMirror").show();
                                        });
                                    }
                                    jQuery("#pac_da_theme_options_css > .head > svg").click(function() {
                                        jQuery("#pac_da_theme_options_css").css('display', 'none');
                                    });
                                }
                            }, 2000);
                            jQuery(".pac_da_theme_options_css").draggable({
                                handle: ".head"
                            });
                            jQuery("#pacDaSavethemeCSS").click(function() {
                                jQuery("#pacDaSavethemeCSSLoader").show();
                                setTimeout(() => {
                                    var cssCode = jQuery("#themeOptionsTextarea").length > 0 ? jQuery("#themeOptionsTextarea").val() : "";
                                    var jqueryCode = jQuery("#themeOptionsJquery").length > 0 ? jQuery("#themeOptionsJquery").val() : "";
                                    var phpCode = jQuery("#customPhpCode").length > 0 ? jQuery("#customPhpCode").val() : "";
                                    jQuery.ajax({
                                        type: "POST",
                                        url: "<?php echo esc_url(admin_url('admin-ajax.php')) ?>",
                                        data: {
                                            action: "update_theme_options_css",
                                            cssCode: cssCode,
                                            jqueryCode: jqueryCode,
                                            phpCode: phpCode,
                                            _ajax_nonce: "<?php echo esc_attr(wp_create_nonce('update_theme_options_code_nonce')) ?>"
                                        },
                                        success: function(response) {
                                            jQuery("#pacDaSavethemeCSSLoader").hide();
                                            jQuery("#pacDathemeCSSSaved").show();
                                            setTimeout(function(){
                                                jQuery("#pacDathemeCSSSaved").hide();
                                            },1500);
                                        }
                                    });
                                }, 2500);
                            });
                            function insertButton() {
                                var customButtonHTML = '<div id="pac_da_theme_option_css_button" class="et_fb_ignore_iframe"><div class="pac_da_settings_bar"><button type="button" data-tip="Custom Code" class="et_fb_ignore_iframe et-fb-button et-fb-button--elevate et-fb-button--primary et-fb-button--round et-fb-button--Tooltip" style="width: 40px; height: 40px;"><span class="pac_da_modal_toggle_button_icon" style="display: block; fill: rgb(255, 255, 255); width: 0px; height: 0px; margin-top: -10px; margin-left: -1px;"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_2" viewBox="0 0 20 20.79" style="height: 20px;width: 20px;fill: #fff !important;"><g id="Layer_1-2"><g><g><path class="cls-1" d="M19.11,15.05c.67-1.55,.97-3.26,.87-4.95-.02-.39-.36-.69-.75-.67s-.69,.36-.67,.75c.09,1.47-.17,2.95-.76,4.3-.12,.28-.05,.58,.15,.78,.06,.06,.14,.11,.22,.15,.37,.15,.78-.01,.94-.37h0Z"/><path class="cls-1" d="M6.22,.23c-.26-.29-.71-.31-1.01-.05-1.41,1.28-2.47,2.91-3.05,4.74-.1,.34,.04,.69,.35,.85,.04,.02,.07,.03,.12,.05,.37,.12,.77-.09,.89-.46,.51-1.58,1.42-3.01,2.65-4.12,.29-.27,.32-.72,.05-1.01h0Z"/></g><path class="cls-1" d="M6.21,20.15c-1.62-.52-3.16-1.01-4.33-4.35L.11,10.72h0c-.11-.29-.14-.6-.08-.91,.06-.3,.2-.58,.41-.81,.24-.23,.54-.38,.86-.45,.32-.07,.66-.04,.97,.07,.46,.18,.87,.47,1.21,.83,.34,.36,.59,.8,.74,1.27l.55,1.21,1.65-7.44c.1-.44,.37-.82,.75-1.06,.4-.25,.88-.33,1.34-.22,.05,0,.1,.02,.15,.04,.34,.11,.64,.31,.86,.59,.14-.33,.38-.61,.69-.79,.45-.25,.98-.3,1.47-.15,.45,.13,.83,.44,1.05,.86,.22,.41,.27,.9,.13,1.35h0c.42-.2,.9-.24,1.35-.09,.44,.14,.81,.44,1.02,.85,.22,.41,.26,.88,.13,1.32h0l-.5,1.47c.2-.01,.4,.02,.59,.08,.41,.13,.75,.41,.94,.78,.2,.38,.24,.81,.12,1.22h0s-1.01,3.03-2.12,5.93c-.26,.9-.73,1.72-1.37,2.4-.64,.68-1.43,1.2-2.3,1.52-1.18,.33-2.43,.28-3.59-.12l-.91-.3ZM15.49,10.4c.04-.14,.02-.29-.05-.41-.07-.12-.19-.22-.32-.25-.13-.05-.28-.04-.41,.02s-.23,.17-.28,.31v.02l-.95,2.55c-.05,.13-.15,.24-.27,.3-.13,.06-.27,.07-.4,.02-.13-.05-.24-.14-.3-.27-.06-.13-.07-.27-.02-.4h0l1.86-5.43c.05-.17,.03-.35-.06-.51-.09-.15-.23-.27-.4-.32-.17-.06-.35-.05-.51,.03-.16,.08-.28,.21-.34,.38h0v.02l-1.71,4.77c-.05,.13-.14,.23-.26,.3-.12,.06-.26,.07-.39,.03-.13-.04-.24-.13-.31-.25-.07-.12-.09-.26-.05-.39l1.53-6.06c.06-.17,.06-.37-.01-.53-.07-.17-.21-.3-.38-.37h-.03c-.21-.08-.45-.06-.65,.04-.15,.1-.26,.25-.29,.43h0l-1.67,6.19c-.04,.13-.12,.25-.24,.32-.12,.07-.26,.09-.4,.06-.13-.03-.25-.11-.33-.23-.07-.12-.1-.26-.07-.39h0l1.07-5.29h0c.03-.18,0-.35-.09-.49-.09-.14-.22-.25-.39-.3l-.06-.02c-.18-.04-.37-.01-.53,.09-.14,.09-.24,.23-.28,.39h0l-2,8.99c-.03,.11-.08,.21-.17,.28-.08,.07-.19,.12-.3,.13-.11,.01-.22-.01-.32-.07-.1-.06-.17-.14-.22-.24h0l-1.22-2.67v-.03c-.21-.66-.68-1.2-1.3-1.48-.12-.05-.26-.07-.39-.05-.13,.02-.26,.08-.36,.16-.07,.08-.12,.19-.13,.3s0,.22,.05,.32l1.78,5.07c1,2.84,2.17,3.22,3.65,3.69l.91,.29c3.48,1.11,5.15-1.11,5.94-3.17,1.08-2.83,2.06-5.75,2.1-5.87h0Z"/></g></g></svg></span></button></div></div>';
                                jQuery(".et-fb-page-settings-bar__toggle-button").after(customButtonHTML);
                                jQuery("#pac_da_theme_option_css_button").click(function() {
                                    var elmnt = document.getElementById("pac_da_theme_options_css");
                                    if(elmnt.style.display === "block"){
                                        elmnt.style.display = "none";
                                    }
                                    else{
                                        elmnt.style.display = '';
                                        var currentStyle = elmnt.getAttribute('style') || '';
                                        elmnt.setAttribute('style', currentStyle + 'display:block !important');
                                    }
                                });
                            }
                            setTimeout(() => {
                                if (jQuery(".et-fb-page-settings-bar__toggle-button").length) {
                                    insertButton();
                                } else {
                                    var observer = new MutationObserver(function(mutations) {
                                        mutations.forEach(function(mutation) {
                                            if (jQuery(mutation.target).hasClass("et-fb-page-settings-bar__toggle-button")) {
                                                observer.disconnect();
                                                insertButton();
                                            }
                                        });
                                    });
                                    if (window.location.href.indexOf('et_header_layout') !== -1 || window.location.href.indexOf('et_body_layout') !== -1 || window.location.href.indexOf('et_footer_layout') !== -1) {
                                        var parentDocument = jQuery(window.parent.document);
                                        var toggleButton = parentDocument.find('.et-fb-page-settings-bar__toggle-button');
                                        var customButtonHTML = '<div id="pac_da_theme_option_css_button" class="et_fb_ignore_iframe"><div class="pac_da_settings_bar"><button type="button" data-tip="Custom Code" class="et_fb_ignore_iframe et-fb-button et-fb-button--elevate et-fb-button--primary et-fb-button--round et-fb-button--Tooltip" style="width: 40px; height: 40px;"><span class="pac_da_modal_toggle_button_icon" style="display: block; fill: rgb(255, 255, 255); width: 0px; height: 0px; margin-top: -10px; margin-left: -1px;"><svg xmlns="http://www.w3.org/2000/svg" id="Layer_2" viewBox="0 0 20 20.79" style="height: 20px;width: 20px;fill: #fff !important;"><g id="Layer_1-2"><g><g><path class="cls-1" d="M19.11,15.05c.67-1.55,.97-3.26,.87-4.95-.02-.39-.36-.69-.75-.67s-.69,.36-.67,.75c.09,1.47-.17,2.95-.76,4.3-.12,.28-.05,.58,.15,.78,.06,.06,.14,.11,.22,.15,.37,.15,.78-.01,.94-.37h0Z"/><path class="cls-1" d="M6.22,.23c-.26-.29-.71-.31-1.01-.05-1.41,1.28-2.47,2.91-3.05,4.74-.1,.34,.04,.69,.35,.85,.04,.02,.07,.03,.12,.05,.37,.12,.77-.09,.89-.46,.51-1.58,1.42-3.01,2.65-4.12,.29-.27,.32-.72,.05-1.01h0Z"/></g><path class="cls-1" d="M6.21,20.15c-1.62-.52-3.16-1.01-4.33-4.35L.11,10.72h0c-.11-.29-.14-.6-.08-.91,.06-.3,.2-.58,.41-.81,.24-.23,.54-.38,.86-.45,.32-.07,.66-.04,.97,.07,.46,.18,.87,.47,1.21,.83,.34,.36,.59,.8,.74,1.27l.55,1.21,1.65-7.44c.1-.44,.37-.82,.75-1.06,.4-.25,.88-.33,1.34-.22,.05,0,.1,.02,.15,.04,.34,.11,.64,.31,.86,.59,.14-.33,.38-.61,.69-.79,.45-.25,.98-.3,1.47-.15,.45,.13,.83,.44,1.05,.86,.22,.41,.27,.9,.13,1.35h0c.42-.2,.9-.24,1.35-.09,.44,.14,.81,.44,1.02,.85,.22,.41,.26,.88,.13,1.32h0l-.5,1.47c.2-.01,.4,.02,.59,.08,.41,.13,.75,.41,.94,.78,.2,.38,.24,.81,.12,1.22h0s-1.01,3.03-2.12,5.93c-.26,.9-.73,1.72-1.37,2.4-.64,.68-1.43,1.2-2.3,1.52-1.18,.33-2.43,.28-3.59-.12l-.91-.3ZM15.49,10.4c.04-.14,.02-.29-.05-.41-.07-.12-.19-.22-.32-.25-.13-.05-.28-.04-.41,.02s-.23,.17-.28,.31v.02l-.95,2.55c-.05,.13-.15,.24-.27,.3-.13,.06-.27,.07-.4,.02-.13-.05-.24-.14-.3-.27-.06-.13-.07-.27-.02-.4h0l1.86-5.43c.05-.17,.03-.35-.06-.51-.09-.15-.23-.27-.4-.32-.17-.06-.35-.05-.51,.03-.16,.08-.28,.21-.34,.38h0v.02l-1.71,4.77c-.05,.13-.14,.23-.26,.3-.12,.06-.26,.07-.39,.03-.13-.04-.24-.13-.31-.25-.07-.12-.09-.26-.05-.39l1.53-6.06c.06-.17,.06-.37-.01-.53-.07-.17-.21-.3-.38-.37h-.03c-.21-.08-.45-.06-.65,.04-.15,.1-.26,.25-.29,.43h0l-1.67,6.19c-.04,.13-.12,.25-.24,.32-.12,.07-.26,.09-.4,.06-.13-.03-.25-.11-.33-.23-.07-.12-.1-.26-.07-.39h0l1.07-5.29h0c.03-.18,0-.35-.09-.49-.09-.14-.22-.25-.39-.3l-.06-.02c-.18-.04-.37-.01-.53,.09-.14,.09-.24,.23-.28,.39h0l-2,8.99c-.03,.11-.08,.21-.17,.28-.08,.07-.19,.12-.3,.13-.11,.01-.22-.01-.32-.07-.1-.06-.17-.14-.22-.24h0l-1.22-2.67v-.03c-.21-.66-.68-1.2-1.3-1.48-.12-.05-.26-.07-.39-.05-.13,.02-.26,.08-.36,.16-.07,.08-.12,.19-.13,.3s0,.22,.05,.32l1.78,5.07c1,2.84,2.17,3.22,3.65,3.69l.91,.29c3.48,1.11,5.15-1.11,5.94-3.17,1.08-2.83,2.06-5.75,2.1-5.87h0Z"/></g></g></svg></span></button></div></div>';
                                        jQuery(toggleButton).after(customButtonHTML);
                                        var daCodeButton = parentDocument.find('.et-fb-page-settings-bar__toggle-button + #pac_da_theme_option_css_button');
                                        jQuery(daCodeButton).click(function() {
                                            var elmnt = document.getElementById("pac_da_theme_options_css");
                                            if(elmnt.style.display === "block"){
                                                elmnt.style.display = "none";
                                            }
                                            else{
                                                elmnt.style.display = '';
                                                var currentStyle = elmnt.getAttribute('style') || '';
                                                elmnt.setAttribute('style', currentStyle + 'display:block !important');
                                            }
                                        });
                                    }else{
                                        observer.observe(document.body, { childList: true, subtree: true });
                                    }
                                }
                            }, 1000);
                        });
                    </script>
                    <?php
                }
            }
        }
    }
}
add_action( 'wp_body_open', 'pac_da_theme_option_css' );


// Process Ajax Request
function update_theme_options_css_callback() {
    // Check for nonce and verify it
    if(isset($_POST['_ajax_nonce']) && wp_verify_nonce(sanitize_text_field($_POST['_ajax_nonce']), 'update_theme_options_code_nonce')){
        // Validate and sanitize inputs
        $cssCode = isset($_POST['cssCode']) ? $_POST['cssCode'] : ''; // phpcs:ignore
        $jqueryCode = isset($_POST['jqueryCode']) ? $_POST['jqueryCode'] : ''; // phpcs:ignore
        $phpCode = isset($_POST['phpCode']) ? wp_unslash($_POST['phpCode']) : ''; // phpcs:ignore

        $codeData = json_decode(get_option('pacDaCodeData', '{"css":false,"jquery":false,"php":false,"boxHeight":false,"boxHeightValue":"600"}'));
        $enableCSS = isset($codeData->css) ? $codeData->css : false;
        $enableJquery = isset($codeData->jquery) ? $codeData->jquery : false;
        $enablePhp = isset($codeData->php) ? $codeData->php : false;

        $et_divi = get_option('et_divi', false);
        if ($et_divi !== false && ($enableCSS || $enableJquery)) {
            if($enableCSS){
                $et_divi['divi_custom_css'] = wp_unslash(wp_strip_all_tags($cssCode));
            }
            if($enableJquery){
                $et_divi['divi_integration_head'] = wp_unslash($jqueryCode);
            }
            wp_update_custom_css_post(wp_unslash(wp_strip_all_tags($cssCode)));
            update_option('et_divi', $et_divi);
        }
        if($enablePhp){
            update_option('pacDaCustomSnippetPhp', wp_unslash($phpCode));
        }
        echo wp_json_encode(array('success' => true));
    }
    else{
        echo wp_json_encode(array('success' => false, 'message' => 'Failed to update theme options becasue ajax nonce expire. Please reload the page and try again.'));
    }
    wp_die();
}
add_action('wp_ajax_update_theme_options_css', 'update_theme_options_css_callback');

// Show Theme Builder Templates As CPTs In Menu
$themeBuilderCPT = isset($utilityCards->themeBuilderCPT) ? $utilityCards->themeBuilderCPT : false;
if(boolval($themeBuilderCPT) && boolval($utilitySettings)){
    function modify_et_theme_builder_postypes( $args, $post_type ){
        if ( 'et_header_layout' == $post_type || 'et_footer_layout' == $post_type || 'et_body_layout' == $post_type) {
            $args['show_ui'] = true;
            $args['show_in_menu'] = true;
        }
        return $args;
    }
    add_filter('register_post_type_args', 'modify_et_theme_builder_postypes', 10, 2);
}

// Add ShortCode To divi Library
add_action( 'init', function() {
    $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"diviLibSC":false}'));
    $diviLibSC = isset($utilityCards->diviLibSC) ? $utilityCards->diviLibSC : false;
    $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
    $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
    if(boolval($diviLibSC) && boolval($utilitySettings)){
        add_shortcode('DiviAsisstantShortcode', 'pac_da_shortcode_callback');
        if(current_user_can('administrator')){
            add_filter( 'manage_et_pb_layout_posts_columns', 'pac_da_add_shortcode_column');
            add_action( 'manage_et_pb_layout_posts_custom_column', 'pac_da_manage_shortcode_column', 10, 2 );
            add_action('admin_enqueue_scripts', 'pac_da_copy_shortcode_to_clipboard');
        }
    }
});
function pac_da_shortcode_callback($pac_da_id)
{
	$pac_da_arg = shortcode_atts(array('id' => '*'), $pac_da_id);
	$id = (int) $pac_da_arg['id'];
	return do_shortcode('[et_pb_section global_module="' . esc_attr($id) . ' "][/et_pb_section]');
}
function pac_da_add_shortcode_column( $columns ) {
    $_new_columns = array();
    foreach ( $columns as $column_key => $column ) {
        $_new_columns[ $column_key ] = $column;
        if ( 'taxonomy-layout_type' === $column_key ) {
            $_new_columns['da_shortcode'] = esc_html__( 'Divi Library Shortcode', PAC_DA_PLUGIN_TEXT_DOMAIN );
        }
    }
    return $_new_columns;
}
function pac_da_manage_shortcode_column( $column_key, $post_id ) {
    switch ( $column_key ) {
        case 'da_shortcode':
            echo '<div class="pac_da_dl_shortcode">';
            echo '<svg class="pac_da_dl_shortcode_copiedSvg" style="display:none;" width="28" height="28" viewBox="0 0 28 28" fill="#29C4A9" xmlns="http://www.w3.org/2000/svg"><path d="M11.922 19.4976C11.6633 19.4976 11.4175 19.3941 11.2364 19.213L6.78622 14.7629C6.40459 14.3812 6.40459 13.7668 6.78622 13.3916C7.16785 13.01 7.78233 13.01 8.15749 13.3916L11.922 17.1561L20.2919 8.78622C20.6735 8.40459 21.288 8.40459 21.6632 8.78622C22.0448 9.16785 22.0448 9.78233 21.6632 10.1575L12.6076 19.213C12.4265 19.3941 12.1807 19.4976 11.922 19.4976Z"/></svg>';
            echo '<svg class="pac_da_dl_shortcode_copySvg" width="28" height="28" viewBox="0 0 28 28" fill="#333" xmlns="http://www.w3.org/2000/svg"><path d="M19.9259 8.27273H17.2593V6.90909C17.2593 6.40277 17.0407 5.91718 16.6518 5.55916C16.2628 5.20114 15.7353 5 15.1852 5H8.07407C7.524 5 6.99645 5.20114 6.60748 5.55916C6.21852 5.91718 6 6.40277 6 6.90909V17.8182C6 18.3245 6.21852 18.8101 6.60748 19.1681C6.99645 19.5261 7.524 19.7273 8.07407 19.7273H10.7407V21.0909C10.7407 21.5972 10.9593 22.0828 11.3482 22.4408C11.7372 22.7989 12.2647 23 12.8148 23H19.9259C20.476 23 21.0036 22.7989 21.3925 22.4408C21.7815 22.0828 22 21.5972 22 21.0909V10.1818C22 9.6755 21.7815 9.18991 21.3925 8.83189C21.0036 8.47386 20.476 8.27273 19.9259 8.27273ZM8.07407 18.0909C7.99549 18.0909 7.92013 18.0622 7.86456 18.011C7.80899 17.9599 7.77778 17.8905 7.77778 17.8182V6.90909C7.77778 6.83676 7.80899 6.76739 7.86456 6.71624C7.92013 6.6651 7.99549 6.63636 8.07407 6.63636H15.1852C15.2638 6.63636 15.3391 6.6651 15.3947 6.71624C15.4503 6.76739 15.4815 6.83676 15.4815 6.90909V8.27273H12.8148C12.2647 8.27273 11.7372 8.47386 11.3482 8.83189C10.9593 9.18991 10.7407 9.6755 10.7407 10.1818V18.0909H8.07407ZM20.2222 21.0909C20.2222 21.1632 20.191 21.2326 20.1354 21.2838C20.0799 21.3349 20.0045 21.3636 19.9259 21.3636H12.8148C12.7362 21.3636 12.6609 21.3349 12.6053 21.2838C12.5497 21.2326 12.5185 21.1632 12.5185 21.0909V10.1818C12.5185 10.1095 12.5497 10.0401 12.6053 9.98897C12.6609 9.93782 12.7362 9.90909 12.8148 9.90909H19.9259C20.0045 9.90909 20.0799 9.93782 20.1354 9.98897C20.191 10.0401 20.2222 10.1095 20.2222 10.1818V21.0909Z"/></svg>';
            echo '<span class="pac_da_dl_shortcode_content">[DiviAsisstantShortcode id=\'' . esc_attr($post_id) . '\']</span></div>';
            break;
    }
}
function pac_da_copy_shortcode_to_clipboard()
{
	?>
    <script>
        document.addEventListener("DOMContentLoaded", function() {
            const copyButtons = document.querySelectorAll(".pac_da_dl_shortcode_copySvg");
            const copiedButtons = document.querySelectorAll(".pac_da_dl_shortcode_copiedSvg");
            copyButtons.forEach(copyButton => {
                copyButton.style.cursor = "pointer";
                copyButton.addEventListener("click", function() {
                    const contentElement = this.nextElementSibling;
                    const content = contentElement.textContent;
                    const tempInput = document.createElement("textarea");
                    tempInput.value = content;
                    document.body.appendChild(tempInput);
                    tempInput.select();
                    document.execCommand("copy");
                    document.body.removeChild(tempInput);
                    this.previousElementSibling.style.display = 'block';
                    this.style.display = 'none';
                    setTimeout(() => {
                        this.previousElementSibling.style.display = 'none';
                        this.style.display = 'block';
                    }, 2000);
                });
            });
        });
    </script>
    <?php
}

// Hide Adminbar Permaently
$utilityCards = json_decode(get_option('pacDaUtilityCards', '{"adminbarEverywhere":false,"adminbarFrontend":false,"adminbarHover":false}'));
$adminbarHover = isset($utilityCards->adminbarHover) ? $utilityCards->adminbarHover : false;
$adminbarEverywhere = isset($utilityCards->adminbarEverywhere) ? $utilityCards->adminbarEverywhere : false;
$adminbarFrontend = isset($utilityCards->adminbarFrontend) ? $utilityCards->adminbarFrontend : false;
$enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
$utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
if(!function_exists('hide_admin_bar') && boolval($adminbarHover) === false && (boolval($adminbarEverywhere) || boolval($adminbarFrontend)) && boolval($utilitySettings)):
    function hide_admin_bar(){
        $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"adminbarEverywhere":false,"adminbarFrontend":false,"adminbarHover":false}'));
        $adminbarEverywhere = isset($utilityCards->adminbarEverywhere) ? $utilityCards->adminbarEverywhere : false;
        $adminbarFrontend = isset($utilityCards->adminbarFrontend) ? $utilityCards->adminbarFrontend : false;
        if(boolval($adminbarEverywhere)){
            show_admin_bar(false);
        }elseif(boolval($adminbarFrontend)){
            if (!empty($_GET['et_fb'])) {  // phpcs:ignore
                show_admin_bar(false);
            }
        }
    }
    add_action('init','hide_admin_bar');
endif;


/* Automatically set the image Title & Alt upon upload */
// add_action( 'add_attachment', 'pac_da_set_image_meta_upon_image_upload' );
// function pac_da_set_image_meta_upon_image_upload( $post_ID ) {
//     if ( wp_attachment_is_image( $post_ID ) ) {
//         $my_image_title = get_post( $post_ID )->post_title;
//         $my_image_title = preg_replace( '%\s*[-_\s]+\s*%', ' ',  $my_image_title );
//         $my_image_title = ucwords( strtolower( $my_image_title ) );
//         $my_image_meta = array(
//             'ID'        => $post_ID,
//             'post_title'    => $my_image_title,
//         );
//         update_post_meta( $post_ID, '_wp_attachment_image_alt', $my_image_title );
//         wp_update_post( $my_image_meta );
//     }
// }

// person module
function pac_da_get_output($output, $render_slug, $module){
    $mediaCards = json_decode(get_option('pacDaMediaCards', '{"useAltText":false,"ignoreAltText":false}'));
    $useAltText = isset($mediaCards->useAltText) ? $mediaCards->useAltText : false;
    $enableAddons = json_decode(get_option('pacDaAddons', '{"media":true}'));
    $mediaSettings = isset($enableAddons->media) ? $enableAddons->media : true;
    if(boolval($useAltText) === false && boolval($mediaSettings)){
        return $output;
    }

    if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
        return $output;
    }
    if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
        return $output;
    }
    if (is_admin() || wp_doing_ajax() || is_array($output)) {
        return $output;
    }
    if ('et_pb_team_member' !== $render_slug) {
        return $output;
    }

    $dom = new DOMDocument('1.0', 'UTF-8');
    if (function_exists('mb_convert_encoding')) {
        $dom->loadHTML(mb_convert_encoding($output, 'HTML-ENTITIES', 'UTF-8'), LIBXML_NOERROR | LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
        $dom->encoding = 'utf-8';
    } else {
        $dom->loadHTML('<?xml version="1.0" encoding="UTF-8"?>'."\n".$output, LIBXML_NOERROR | LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
    }

    // Get all img elements
    $images = $dom->getElementsByTagName('img');

    // Loop through img elements to get the src attribute value
    foreach ($images as $image) {
        $src = $image->getAttribute('src');

        $image_url = preg_replace('/-(\d+)x(\d+)\./', '.', $src);
        $post_id = attachment_url_to_postid($image_url);

        // Polylang Translation Post ID
        if (function_exists('pll_get_post') && function_exists('pll_current_language')) {
            $translation_id = pll_get_post($post_id, pll_current_language());
            if ($translation_id) {
                $post_id = $translation_id;
            }
        }
        // WPML Translation Post ID
        if (class_exists('sitepress')) {
            $post_id = apply_filters('wpml_object_id', $post_id, 'attachment', true);
        }
        $lib_alt_text = get_post_meta($post_id, '_wp_attachment_image_alt', true);
        $image->setAttribute('alt', $lib_alt_text);
    }

    $updatedHtml = $dom->saveHTML();

    return $updatedHtml;
}
add_filter('et_module_shortcode_output', 'pac_da_get_output', 10, 3);


// Image Alt Text
add_action( 'init', function() {
    $mediaCards = json_decode(get_option('pacDaMediaCards', '{"useAltText":false,"ignoreAltText":false}'));
    $useAltText = isset($mediaCards->useAltText) ? $mediaCards->useAltText : false;
    $ignoreAltText = isset($mediaCards->ignoreAltText) ? $mediaCards->ignoreAltText : false;
    $enableAddons = json_decode(get_option('pacDaAddons', '{"media":true}'));
    $mediaSettings = isset($enableAddons->media) ? $enableAddons->media : true;
    if((boolval($useAltText) || boolval($ignoreAltText)) && boolval($mediaSettings)){
        add_filter('et_pb_module_shortcode_attributes', 'pac_da_maybe_override_shortcode_attributes', 10, 5);
    }
});
function pac_da_maybe_override_shortcode_attributes($props, $attrs, $render_slug, $_address, $content)
{
    if (function_exists('et_fb_is_enabled') && et_fb_is_enabled()) {
        return $props;
    }
    if (function_exists('et_builder_bfb_enabled') && et_builder_bfb_enabled()) {
        return $props;
    }
    if($render_slug !== 'et_pb_image' && $render_slug !== 'et_pb_blurb' && $render_slug !== 'et_pb_fullwidth_image' && $render_slug !== 'et_pb_fullwidth_header' && $render_slug !== 'et_pb_slide') {
        return $props;
    }
    if('et_pb_image' === $render_slug || 'et_pb_fullwidth_image' === $render_slug){
        $image = isset($props['src']) ? $props['src'] : '';
        if ('' !== $image) {
            $module_alt = isset($props['alt']) ? $props['alt'] : '';
            $props['alt'] = pac_da_set_alt_title_text($image, $module_alt);
        }
        return $props;
    }elseif('et_pb_blurb' === $render_slug) {
        $is_use_icon = isset($props['use_icon']) ? $props['use_icon'] : 'off';
        if ('off' === $is_use_icon) {
            $module_image = isset($props['image']) ? $props['image'] : '';
            $module_alt = isset($props['alt']) ? $props['alt'] : '';
            $props['alt'] = pac_da_set_alt_title_text($module_image, $module_alt);
        }
        return $props;
    }elseif('et_pb_fullwidth_header' === $render_slug) {
        $image = isset($props['logo_image_url']) ? esc_html($props['logo_image_url']) : '';
        if ('' !== $image) {
            $module_alt = isset($props['logo_alt_text']) ? $props['logo_alt_text'] : '';
            $props['logo_alt_text'] = pac_da_set_alt_title_text($image, $module_alt);
        }

        $image = isset($props['header_image_url']) ? esc_html($props['header_image_url']) : '';
        if ('' !== $image) {
            $module_alt = isset($props['image_alt_text']) ? $props['image_alt_text'] : '';
            $props['image_alt_text'] = pac_da_set_alt_title_text($image, $module_alt);
        }
        return $props;
    }elseif('et_pb_slide' === $render_slug) {
        $image = isset($props['image']) ? esc_html($props['image']) : '';
        if ('' !== $image) {
            $module_alt = isset($props['image_alt']) ? $props['image_alt'] : '';
            $props['image_alt'] = pac_da_set_alt_title_text($image, $module_alt);
        }
        return $props;
    }
}
function pac_da_set_alt_title_text($url, $module_alt)
{
    // Get Attachment Details
    $image_url = preg_replace('/-(\d+)x(\d+)\./', '.', $url);
    $post_id = attachment_url_to_postid($image_url);
    // Polylang Translation Post ID
    if (function_exists('pll_get_post') && function_exists('pll_current_language')) {
        $translation_id = pll_get_post($post_id, pll_current_language());
        if ($translation_id) {
            $post_id = $translation_id;
        }
    }
    // WPML Translation Post ID
    if (class_exists('sitepress')) {
        $post_id = apply_filters('wpml_object_id', $post_id, 'attachment', true);
    }
    // Get Image Title and ALT
    $lib_title_text = get_the_title($post_id);
    $lib_alt_text = get_post_meta($post_id, '_wp_attachment_image_alt', true);

    $mediaCards = json_decode(get_option('pacDaMediaCards', '{"useAltText":false,"ignoreAltText":false}'));
    $useAltText = isset($mediaCards->useAltText) ? $mediaCards->useAltText : false;
    $ignoreAltText = isset($mediaCards->ignoreAltText) ? $mediaCards->ignoreAltText : false;

    // ALT Settings
    $alt_text = boolval($ignoreAltText) ? '' : $module_alt;
    if (empty($alt_text) && boolval($useAltText)) {
        $alt_text = $lib_alt_text;
    }

    return $alt_text;
}



/**
 * Disabling Gutenberg
 *
 * @param $use_block_editor
 * @param $post_type
 *
 * @return false|mixed
 */
if (!function_exists('pac_da_disable_gutenberg') && boolval($utilitySettings)):
    function pac_da_disable_gutenberg($use_block_editor, $post_type)
    {
        $postTypeCE = isset(json_decode(get_option('pacDaAllPostTypesCE','{"page":false,"post":false,"project":false}'))->{$post_type}) && json_decode(get_option('pacDaAllPostTypesCE','{"page":false,"post":false,"project":false}'))->{$post_type} !== null ? json_decode(get_option('pacDaAllPostTypesCE','{"page":false,"post":false,"project":false}'))->{$post_type} : false;
        if (boolval($postTypeCE)) {
            $use_block_editor = false;
        }
        return $use_block_editor;
    }

    add_filter('use_block_editor_for_post_type', 'pac_da_disable_gutenberg', 999, 2);
endif;


$duplicatePagePost = isset($utilityCards->duplicatePagePost) ? $utilityCards->duplicatePagePost : false;
/*
* Function for post duplication. Dups appear as drafts. User is redirected to the edit screen
*/
function pac_da_duplicate_post_as_draft()
{
    if (!current_user_can("edit_posts")) {
        return;
    }
    if (!isset($_GET["duplicate_nonce"]) || !wp_verify_nonce(sanitize_text_field($_GET["duplicate_nonce"]), 'duplicate_nonce')) {
        return;
    }
    global $wpdb;
    if (!(isset($_GET["post"]) || isset($_POST["post"]) || (isset($_REQUEST["action"]) && "pac_da_duplicate_post_as_draft" == $_REQUEST["action"]))){
        wp_die("No post to duplicate has been supplied!");
    }
    
    $post_id = isset($_GET["post"]) ? absint($_GET["post"]) : absint($_POST["post"]);
    $post = get_post($post_id);
    $current_user = wp_get_current_user();
    $new_post_author = $current_user->ID;
    if (isset($post) && $post != null) {
        $args = [
            "comment_status" => $post->comment_status,
            "ping_status" => $post->ping_status,
            "post_author" => $new_post_author,
            "post_content" => $post->post_content,
            "post_excerpt" => $post->post_excerpt,
            "post_name" => $post->post_name,
            "post_parent" => $post->post_parent,
            "post_password" => $post->post_password,
            "post_status" => "draft",
            "post_title" => $post->post_title . ' -- Copy',
            "post_type" => $post->post_type,
            "to_ping" => $post->to_ping,
            "menu_order" => $post->menu_order,
        ];

        $new_post_id = wp_insert_post($args);
        $taxonomies = get_object_taxonomies($post->post_type);
        foreach ($taxonomies as $taxonomy) {
            $post_terms = wp_get_object_terms($post_id, $taxonomy, [
                "fields" => "slugs",
            ]);
            wp_set_object_terms($new_post_id, $post_terms, $taxonomy, false);
        }
        $post_meta_infos = $wpdb->get_results($wpdb->prepare("SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id = %d",$post_id)); // phpcs:ignore
        if (count($post_meta_infos) != 0) {
            $sql_query = "INSERT INTO $wpdb->postmeta (post_id, meta_key, meta_value) VALUES ";
            $sql_query_params = array();
            foreach ($post_meta_infos as $meta_info) {
                $meta_key = $meta_info->meta_key;
                if ($meta_key == "_wp_old_slug") {
                    continue;
                }
                $meta_value = $meta_info->meta_value;
                $sql_query .= "(%d, %s, %s),";
                $sql_query_params[] = $new_post_id;
                $sql_query_params[] = $meta_key;
                $sql_query_params[] = $meta_value;
            }
            $sql_query = rtrim($sql_query, ',');
            $wpdb->query($wpdb->prepare($sql_query, $sql_query_params)); // phpcs:ignore
        }
        wp_safe_redirect(admin_url("post.php?action=edit&post=" . $new_post_id));
        exit();
    } else {
        wp_die("Post creation failed, could not find original post: " . absint($post_id));
    }
}
function pac_da_duplicate_post_link($actions, $post)
{
    if (current_user_can('edit_posts')) {
        $actions['duplicate'] = '<a href="' . esc_url(admin_url('admin.php?action=pac_da_duplicate_post_as_draft&post=' . $post->ID . '&duplicate_nonce=' . wp_create_nonce('duplicate_nonce'))) . '" title="Duplicate this item" rel="permalink">Duplicate</a>';
    }
    return $actions;
}
function pac_da_duplicate_page_admin_bar_link()
{
    global $wp_admin_bar, $post;
    $current_object = get_queried_object();
    if (empty($current_object)) {
        return;
    }
    if (!empty($current_object->post_type)
    && ($post_type_object = get_post_type_object($current_object->post_type))
    && ($post_type_object->show_ui || $current_object->post_type == 'attachment')) {
        $wp_admin_bar->add_menu(array(
        'parent' => 'edit',
        'id' => 'duplicate_this',
        'title' => __('Duplicate As Draft', PAC_DA_PLUGIN_TEXT_DOMAIN),
        'href' => isset($post) ? esc_url_raw(admin_url().'admin.php?action=pac_da_duplicate_post_as_draft&amp;post='.intval($post->ID).'&amp;duplicate_nonce='.wp_create_nonce( 'duplicate_nonce')) :'',
        ));
    }
}
if(boolval($duplicatePagePost) && boolval($utilitySettings)){
    add_action("admin_action_pac_da_duplicate_post_as_draft", "pac_da_duplicate_post_as_draft");
    add_filter("post_row_actions", "pac_da_duplicate_post_link", 10, 2);
    add_filter("page_row_actions", "pac_da_duplicate_post_link", 10, 2);
    add_action('wp_before_admin_bar_render', 'pac_da_duplicate_page_admin_bar_link');
}

$disableCommentSettings = isset($utilityCards->disableCommentSettings) ? $utilityCards->disableCommentSettings : false;
if(boolval($disableCommentSettings) && boolval($utilitySettings)){
    // Removes from admin menu
    add_action( 'admin_menu', 'pac_da_remove_comments_from_admin_menus' );
    function pac_da_remove_comments_from_admin_menus() {
        remove_menu_page( 'edit-comments.php' );
    }
    // Removes from post and pages
    add_action('init', 'pac_da_remove_comment_support', 100);
    function pac_da_remove_comment_support() {
        remove_post_type_support( 'post', 'comments' );
        remove_post_type_support( 'page', 'comments' );
    }
    // Removes from admin bar
    function pac_da_theme_admin_bar_render() {
        global $wp_admin_bar;
        $wp_admin_bar->remove_menu('comments');
    }
    add_action( 'wp_before_admin_bar_render', 'pac_da_theme_admin_bar_render' );
}

$imgReplace = isset($mediaCards->imgReplace) ? $mediaCards->imgReplace : false;
if(boolval($imgReplace) && boolval($mediaSettings)){
    add_action('admin_enqueue_scripts', 'pac_da_replace_image_enqueue_scripts');
    function pac_da_replace_image_enqueue_scripts() {
        wp_enqueue_script('pac-da-replace-image', PAC_DA_PLUGIN_URL . 'include/js/pac-da-replace-image.js');
    }

    add_action('edit_attachment', 'pac_da_replace_image_edit_attachment');
    function pac_da_replace_image_edit_attachment($postId) {
        // $nonce = isset($_POST['nonce']) ? $_POST['nonce'] : '';

        // $user  = wp_get_current_user();
		// $uid   = (int) $user->ID;
        // $action = 'pac_da_replace_image_with_other_image';
        // $token = wp_get_session_token();
		// $i = wp_nonce_tick( $action );

		// // Nonce generated 0-12 hours ago.
		// $expected = substr( wp_hash( $i . '|' . $action . '|' . $uid . '|' . $token, 'nonce' ), -12, 10 );
        // _log($expected);

        // if (!wp_verify_nonce($nonce, 'pac_da_replace_image_with_other_image')) {
        //     _log($_POST['nonce']);
        //     return;
        // }
        if (!empty($_POST['replaceWith']) && is_numeric($_POST['replaceWith'])) { // phpcs:ignore
        
            $uploadDir = wp_upload_dir();
            $newFile = $uploadDir['basedir'].'/'.get_post_meta(absint($_POST['replaceWith']), '_wp_attached_file', true); // phpcs:ignore
            
            if (!is_file($newFile)) {
                return false;
            }
            
            pac_da_replace_image_delete_attachment($postId);
            
            $oldFile = $uploadDir['basedir'].'/'.get_post_meta($postId, '_wp_attached_file', true);
            if (!file_exists(dirname($oldFile)))
                mkdir(dirname($oldFile), 0777, true);
            copy($newFile, $oldFile);
            $meta = wp_generate_attachment_metadata($postId, $oldFile);
            wp_update_attachment_metadata($postId, $meta);
            wp_delete_attachment(absint($_POST['replaceWith']), true); // phpcs:ignore
        }
    }

    function pac_da_replace_image_delete_attachment( $post_id){
        $meta = wp_get_attachment_metadata( $post_id );
        $backup_sizes = get_post_meta( $post_id, '_wp_attachment_backup_sizes', true );
        $file = get_attached_file( $post_id );

        if(is_multisite())
            delete_transient('dirsize_cache');

        $uploadpath = wp_get_upload_dir();

        if (!empty($meta['thumb'])) {
            $thumbfile = str_replace(basename($file), $meta['thumb'], $file);
            $thumbfile = apply_filters( 'wp_delete_file', $thumbfile );
            @ unlink( path_join($uploadpath['basedir'], $thumbfile) );
        }

        if(isset( $meta['sizes'] ) && is_array( $meta['sizes'])){
            foreach($meta['sizes'] as $size => $sizeinfo){
                $intermediate_file = str_replace( basename( $file ), $sizeinfo['file'], $file );
                $intermediate_file = apply_filters( 'wp_delete_file', $intermediate_file );
                @ unlink( path_join( $uploadpath['basedir'], $intermediate_file ) );
            }
        }

        if ( is_array($backup_sizes) ) {
            foreach ( $backup_sizes as $size ) {
                $del_file = path_join( dirname($meta['file']), $size['file'] );
                $del_file = apply_filters( 'wp_delete_file', $del_file );
                @ unlink( path_join($uploadpath['basedir'], $del_file) );
            }
        }
        wp_delete_file( $file );
    }

    add_filter('attachment_fields_to_edit', 'pac_da_replace_image_attachment_fields');
    function pac_da_replace_image_attachment_fields($fields) {
        wp_enqueue_media();
        $fields['pac_da_image_replace'] = array();
        $fields['pac_da_image_replace']['label'] = '';
        $fields['pac_da_image_replace']['input'] = 'html';
        $fields['pac_da_image_replace']['html'] = '
            <button type="button" class="button-secondary" onclick="pac_da_replace_image();">Replace Image</button>
            <input type="hidden" id="pac_da_replace_image_with_other_image" name="replaceWith" />
            <p><strong>Warning:</strong> Replacing this image with another one will permanently delete the current image file, and the replacement image will be moved to overwrite this one. In order to work this feature correctly, please disable all WordPress caching plugins during development and disable your browser\'s cache.</p>
        ';
        
        return $fields;
    }


    add_filter('wp_calculate_image_srcset', 'pac_da_replace_image_calculate_image_srcset');
    function pac_da_replace_image_calculate_image_srcset($sources) {
        if (is_admin()) {
            foreach ($sources as $size => $source) {
                $source['url'] .= (strpos($source['url'], '?') === false ? '?' : '&').'_t='.time();
                $sources[$size] = $source;
            }
        }
        return $sources;
    }

    add_filter('wp_get_attachment_image_src', 'pac_da_replace_image_get_attachment_image_src');
    function pac_da_replace_image_get_attachment_image_src($attr) {
        if (is_admin() && !empty($attr[0])) {
            $attr[0] .= (strpos($attr[0], '?') === false ? '?' : '&').'_t='.time();
        }
        return $attr;
    }

    add_filter('wp_prepare_attachment_for_js', 'pac_da_replace_image_prepare_attachment_for_js');
    function pac_da_replace_image_prepare_attachment_for_js($response) {
        if (is_admin()) {
            if (strpos($response['url'], '?') !== false)
                $response['url'] .= (strpos($response['url'], '?') === false ? '?' : '&').'_t='.time();
            if (isset($response['sizes'])) {
                foreach ($response['sizes'] as $sizeName => $size) {
                    $response['sizes'][$sizeName]['url'] .= (strpos($size['url'], '?') === false ? '?' : '&').'_t='.time();
                }
            }
        }
        return $response;
    }
}

register_uninstall_hook( PAC_DA_PLUGIN_FILE, 'pac_da_uninstall' );
function pac_da_uninstall() {
    delete_option('pacDaWebHosting');
    delete_option('pacDaFontCards');
    delete_option('pacDaCustomQuickLinks');
    delete_option('pacDaCustomQuickLinksIcon');
    delete_option('pacDaCustomQuickLinksParent');
    delete_option('pacDaMediaCards');
    delete_option('pacDaDashboardCards');
    delete_option('pacDaCodeData');
    delete_option('pacDaAllowAdmin');
    delete_option('pacDaAllowAdminDefault');
    delete_option('pacDaAllPostTypesCE');
    delete_option('pacDaAllPostTypes');
    delete_option('pacDaAllDefaultPostTypes');
    delete_option('pacDaCustomQuickLinksData');
    delete_option('pacDaMaintenanceCards');
    delete_option('pacDaEnvironmentsData');
    delete_option('pacDaAddons');
    delete_option('pacDaAccessibilityHelper');
    delete_option('pacDaStartupCards');
    delete_option('pacDaUtilityCards');
    delete_option('paDaStylesH1');
    delete_option('paDaStylesH2');
    delete_option('paDaStylesH3');
    delete_option('paDaStylesH4');
    delete_option('paDaStylesH5');
    delete_option('paDaStylesH6');
    delete_option('paDaStylesBT');
    delete_option('paDaStylesLT');
    delete_option('paDaStylesOL');
    delete_option('paDaStylesUL');
    delete_option('pacDaScrollbar');
    delete_option('pacDaBackToTop');
}