<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_Maintenance_ComingSoon_Modes')) {
    class PAC_DA_Maintenance_ComingSoon_Modes
    {
        private static $_instance;

        /**
         * Get Class Instance
         * @return PAC_DA_Maintenance_ComingSoon_Modes
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         * Add/Remove Necessary Actions/Filters
         */
        public function init()
        {
            $enableAddons = json_decode(get_option('pacDaAddons', '{"maintenance":true}'));
            $maintenanceSettings = isset($enableAddons->maintenance) ? $enableAddons->maintenance : true;
            if ($maintenanceSettings) {
                $data = json_decode(get_option('pacDaMaintenanceCards', '{"commingSoon":false,"Maintenance":false,"byPassCommingSoon":"false"}'));
                $commingSoon = isset($data->commingSoon) ? $data->commingSoon : false;
                $Maintenance = isset($data->Maintenance) ? $data->Maintenance : false;
                if ($commingSoon || $Maintenance) {
                    add_filter('init', [$this, 'maybe_clear_cache']);
                    add_action('template_include', [$this, 'maybe_include_template']);
                    add_action('wp_head', [$this, 'pac_da_add_custom_meta_tags']);
                }
                $byPassCommingSoon = isset($data->byPassCommingSoon) ? $data->byPassCommingSoon : false;
                if ($commingSoon && $byPassCommingSoon) {
                    add_filter('home_url', [$this, 'maybe_filter_homeurl'], 10, 4);
                    add_filter('page_link', [$this, 'maybe_filter_pageurl'], 10, 3);
                    add_filter('post_link', [$this, 'maybe_filter_posturl'], 10, 3);
                    add_filter('author_link', [$this, 'maybe_filter_authorurl']);
                }
            }
        }

        /**
         * Clear Cache
         * @return void
         */
        public function maybe_clear_cache()
        {
            $page_on_front = get_option('page_on_front');
            if (0 === $page_on_front) {
                return;
            }
            //define('DOING_CRON', true);
            ET_Core_PageResource::do_remove_static_resources($page_on_front);
        }

        /**
         * Include Template
         *
         * @param $template
         *
         * @return mixed|void
         */
        public function maybe_include_template($template)
        {

            /**
             *  Allow Access To Specific Roles
             */
            if ($this->allow_access_to_admins()) {
                return $template;
            }
            $layout_id = '';
            /*
             * Check If User Has Token To Access Site Allow Accessing
             *
             * */
            $pacbpcsm_token = isset($_GET['pacbpcsm_token']) ? sanitize_text_field($_GET['pacbpcsm_token']) : null; // phpcs:ignore
            if ($pacbpcsm_token !== null) {
                $data = json_decode(get_option('pacDaMaintenanceCards', '{"byPassLink":null}'));
                if ($data->byPassLink !== null && $pacbpcsm_token === $data->byPassLink) {
                    return $template;
                }
            }
            add_filter('body_class', [$this, 'maybe_add_body_class']);
            add_filter('wp_footer', [$this, 'maybe_add_css']);
            add_filter('et_html_top_header', [$this, 'maybe_remove_top_header'], 9999);
            add_filter('et_html_main_header', [$this, 'maybe_remove_header'], 9999);
            $data = json_decode(get_option('pacDaMaintenanceCards', '{"commingSoon":false,"Maintenance":false,"commingSoonPage":"none","MaintenancePage":"none"}'));
            $is_maintenance_mode = boolval($data->Maintenance);
            $is_comingsoon_mode = boolval($data->commingSoon);
            /**
             *  If comingsoon mode false and wp_is_maintenance_mode true or maintenance mode true
             */
            if (!$is_comingsoon_mode && ((function_exists('wp_is_maintenance_mode') && wp_is_maintenance_mode()) || $is_maintenance_mode)) {
                $layout_id = $data->MaintenancePage;
            }
            /**
             *  If maintenance mode false and comingsoon mode true
             */
            if (!$is_maintenance_mode && $is_comingsoon_mode) {
                $layout_id = $data->commingSoonPage;
            }
            /**
             *  If layout id empty returns
             */
            if (empty($layout_id)) {
                return $template;
            }
            $maintenance_tempalte = plugin_dir_path(PAC_DA_PLUGIN_FILE).'include/php/templates/maintenance-helper-template.php';
            if (file_exists($maintenance_tempalte)) {
                $GLOBALS['divi_assistant_layout_id'] = $layout_id;
                global $wp;
                if (get_home_url() !== home_url($wp->request)) {
                    wp_safe_redirect(get_home_url());
                }

                return $maintenance_tempalte;
            }

            return $template;
        }

        /**
         * @param $classes
         *
         * @return mixed
         */
        public function maybe_add_body_class($classes)
        {
            $classes[] = 'divi_assistant_maintenance_helper';

            return $classes;
        }

        /**
         * @return void
         */
        public function maybe_add_css()
        { ?>
            <style id="divi-assistant-maintenance-helper-inline-css-<?php echo esc_attr(wp_rand()) ?>">
                .divi_assistant_maintenance_helper #page-container {
                    padding-top: 0 !important;
                }

                .divi_assistant_maintenance_helper footer, .divi_assistant_maintenance_helper header {
                    display: none !important;
                }
            </style>
            <?php
        }

        public function pac_da_add_custom_meta_tags() {
            echo '<meta charset="UTF-8">' . "\n";
            echo '<meta http-equiv="Cache-Control" content="no-store, no-cache, must-revalidate">' . "\n";
            echo '<meta http-equiv="Pragma" content="no-cache">' . "\n";
            echo '<meta http-equiv="Expires" content="0">' . "\n";
        }

        /**
         * @param $html
         *
         * @return string
         */
        public function maybe_remove_top_header($html)
        {
            return '';
        }

        /**
         * @param $html
         *
         * @return string
         */
        public function maybe_remove_header($html)
        {
            return '';
        }

        /**
         * Filter Home URL
         *
         * @param $url
         * @param $path
         * @param $orig_scheme
         * @param $blog_id
         *
         * @return mixed|string
         */
        public function maybe_filter_homeurl($url, $path, $orig_scheme, $blog_id)
        {
            return $this->get_url($url);
        }

        /**
         * Filter Page URL
         *
         * @param $permalink
         * @param $post
         * @param $leavename
         *
         * @return mixed|string
         */
        public function maybe_filter_pageurl($permalink, $post, $leavename)
        {
            return $this->get_url($permalink);
        }

        /**
         * Filter Post URL
         *
         * @param $permalink
         * @param $post
         * @param $leavename
         *
         * @return mixed|string
         */
        public function maybe_filter_posturl($permalink, $post, $leavename)
        {
            return $this->get_url($permalink);
        }

        /**
         * Filter Author URL
         *
         * @param $url
         *
         * @return mixed|string
         */
        public function maybe_filter_authorurl($url)
        {
            return $this->get_url($url);
        }

        /**
         * Get Queries URL
         *
         * @param $url
         *
         * @return mixed|string
         */
        private function get_url($url)
        {
            $pacbpcsm_token = isset($_GET['pacbpcsm_token']) ? sanitize_text_field($_GET['pacbpcsm_token']) : null; // phpcs:ignore
            if ($pacbpcsm_token !== null) {
                $data = json_decode(get_option('pacDaMaintenanceCards', '{"byPassLink":null}'));
                if ($data->byPassLink !== null && $pacbpcsm_token === $data->byPassLink) {
                    $url = add_query_arg(['pacbpcsm_token' => $data->byPassLink], $url);
                }
            }

            return $url;
        }

        /**
         * Allow Access To Roles
         * @return bool
         */
        private function allow_access_to_admins()
        {
            return (bool)array_intersect(['administrator', 'editor', 'author'], wp_get_current_user()->roles);
        }
    }

    (new PAC_DA_Maintenance_ComingSoon_Modes())->instance()->init();
}