<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');
if (!class_exists('PAC_DA_Quick_Links')) {
    class PAC_DA_Quick_Links
    {
        private static $_instance;

        /**
         * Get Class Instance
         *
         * @return PAC_DA_Quick_Links
         */
        public static function instance()
        {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         *
         * Add/Remove Necessary Actions/Filters
         */
        public function init()
        {
            $utilityCards = json_decode(get_option('pacDaUtilityCards', '{"staticCss":false,"localStorage":false,"hardRefresh":false,"quickLinks":false,"duplicateDiviLib":false,"exportDiviLib":false,"openVisualBuilder":false,"horizontalScroll":false,"cursorHighlight":false,"bgHighlight":"#3399ff","textHighlight":"#ffffff","hideProject":false,"renameProject":false,"pluralName":"Projects","singularName":"Project","slug":"projects","pluralCategory":"Project Categories","singularCategory":"Project Category","slugCategory":"project_category","pluralTag":"Project Tags","singularTag":"Project Tag","slugTag":"project_tag","menuIcon":"dashicons-admin-post","defaultThemes":false,"updateThemes":false,"updatePlugins":false,"themeBuilderCPT":false}'));
            $quickLinks = isset($utilityCards->quickLinks) ? $utilityCards->quickLinks : false;
            $enableAddons = json_decode(get_option('pacDaAddons', '{"utility":true}'));
            $utilitySettings = isset($enableAddons->utility) ? $enableAddons->utility : true;
            if (boolval($quickLinks) && boolval($utilitySettings)) {
                add_action('admin_bar_menu', [$this, 'maybe_add_admin_bar'], 999);
            }
            if (boolval(get_option('pacDaCustomQuickLinks', false)) && boolval($utilitySettings)) {
                add_action('admin_bar_menu', [$this, 'maybe_add_cql_admin_bar'], 999);
            }
        }

        /**
         * Add Links
         *
         * @param $wp_admin_bar
         * @return void
         */
        public function maybe_add_admin_bar($wp_admin_bar)
        {
            $links = [
                [
                    'parent' => 'pac-da-quick-links',
                    'id' => 'divi-assistant',
                    'title' => __('Assistant', 'pac-da'),
                    'href' => esc_url(admin_url('admin.php?page=divi-assistant')),
                    'meta' => [
                        'target' => '_self',
                        'class' => 'divi-assistant',
                    ],
                ],
                [
                    'parent' => 'pac-da-quick-links',
                    'id' => 'divi-theme-options',
                    'title' => __('Theme Options', 'pac-da'),
                    'href' => esc_url(admin_url('admin.php?page=et_divi_options')),
                    'meta' => [
                        'target' => '_self',
                        'class' => 'divi-theme-options',
                    ],
                ],
                [
                    'parent' => 'pac-da-quick-links',
                    'id' => 'divi-theme-builder',
                    'title' => __('Theme Builder', 'pac-da'),
                    'href' => esc_url(admin_url('admin.php?page=et_theme_builder')),
                    'meta' => [
                        'target' => '_self',
                        'class' => 'divi-theme-builder',
                    ],
                ],
                [
                    'parent' => 'pac-da-quick-links',
                    'id' => 'divi-theme-customizer',
                    'title' => __('Theme Customizer', 'pac-da'),
                    'href' => esc_url(wp_customize_url()),
                    'meta' => [
                        'target' => '_self',
                        'class' => 'divi-theme-customizer',
                    ],
                ],
                [
                    'parent' => 'pac-da-quick-links',
                    'id' => 'divi-theme-role-editor',
                    'title' => __('Role Editor', 'pac-da'),
                    'href' => esc_url(admin_url('admin.php?page=et_divi_role_editor')),
                    'meta' => [
                        'target' => '_self',
                        'class' => 'divi-theme-role-editor',
                    ],
                ],
                [
                    'parent' => 'pac-da-quick-links',
                    'id' => 'divi-theme-layout',
                    'title' => __('Library', 'pac-da'),
                    'href' => esc_url(admin_url('edit.php?post_type=et_pb_layout')),
                    'meta' => [
                        'target' => '_self',
                        'class' => 'divi-theme-layout',
                    ],
                ],
                [
                    'parent' => 'pac-da-quick-links',
                    'id' => 'divi-theme-support-center',
                    'title' => __('Support Center', 'pac-da'),
                    'href' => esc_url(admin_url('admin.php?page=et_support_center_divi')),
                    'meta' => [
                        'target' => '_self',
                        'class' => 'divi-theme-support-center',
                    ],
                ],
            ];
            // Build Menu
            $wp_admin_bar->add_node([
                'id' => 'pac-da-quick-links',
                'title' => sprintf('<span class="dashicons dashicons-before"></span><span class="ab-label">%s</span>', __('Divi', 'pac-da')),
                'meta' => [
                    'target' => '_self',
                    'title' => __('Divi', 'pac-da'),
                    'class' => 'pac-da-quick-links',
                ],
            ]);
            foreach ($links as $link) {
                $wp_admin_bar->add_node([
                    'parent' => $link['parent'],
                    'id' => $link['id'],
                    'title' => $link['title'],
                    'href' => $link['href'],
                    'meta' => $link['meta'],
                ]);
            }
        }
        /**
         * Add Links
         *
         * @param $wp_admin_bar
         * @return void
         */
        public function maybe_add_cql_admin_bar($wp_admin_bar)
        {
            $customLinks = [];
            $grandParent = get_option('pacDaCustomQuickLinksParent', 'Custom Quick Links');
            $cqlIcon = get_option('pacDaCustomQuickLinksIcon', '');
            $grandParent_id = $grandParent !== '' ? str_replace(' ', '-', strtolower($grandParent)) : 'pac-da-custom-quick-links';
            $parent = null;
            $customQuickLinks = json_decode(get_option('pacDaCustomQuickLinksData','[{"label": "", "url": "","child": "0","tab": "new"},{"label": "", "url": "","child": "1","tab": "new"}]'));
            foreach ($customQuickLinks as $link) {
                $link = get_object_vars($link);
                $self_id = 'pac-da-'.str_replace(' ', '-', strtolower($link['label']));
                $parent_id = $link['child'] === '0' ? $self_id : $parent_id;
                $customLinks[] = [
                    'parent' => $link['child'] === '0' ?  $grandParent_id : $parent_id,
                    'id' => $self_id,
                    'title' => __($link['label'], 'pac-da'),
                    'href' => esc_url($link['url']),
                    'meta' => [
                        'target' => isset($link['tab']) && $link['tab'] === 'same' ? '_self' : '_blank',
                    ],
                ];
            }
            $wp_admin_bar->add_node([
                'id' => $grandParent_id,
                'title' => sprintf('<span class="dashicons %2$s"></span><span class="ab-label">%1$s</span>', __($grandParent !== '' ? $grandParent : 'Quick Links', 'pac-da'),$cqlIcon),
                'meta' => [
                    'target' => '_self',
                    'title' => __($grandParent, 'pac-da'),
                    'class' => 'pac-da-custom-quick-links',
                ],
            ]);

            foreach ($customLinks as $link) {
                $wp_admin_bar->add_node([
                    'parent' => $link['parent'],
                    'id' => $link['id'],
                    'title' => $link['title'],
                    'href' => $link['href'],
                    'meta' => $link['meta'],
                ]);
            }
        }
    }

    (new PAC_DA_Quick_Links())->instance()->init();
}