<?php
defined('ABSPATH') or die('HEY, WHAT ARE YOU DOING HERE? YOU SILLY HUMAN!');

if (!class_exists('PAC_DA_Tutorials_API')) {

    class PAC_DA_Tutorials_API {

        private static $_instance;
        private static $rest_api_categories_url = 'https://peeayecreative.com/wp-json/wp/v2/categories';
        private static $rest_api_posts_url = 'https://peeayecreative.com/wp-json/wp/v2/posts';
        private static $transient_expiry = DAY_IN_SECONDS; // Expire after 24 hours

        /**
         * Get Class Instance
         *
         * @return PAC_DA_Tutorials_API
         */
        public static function instance() {
            if (self::$_instance == null) {
                self::$_instance = new self();
            }

            return self::$_instance;
        }

        /**
         * Initializer Of The Class
         *
         * Add/Remove Necessary Actions/Filters
         */
        public function init() {
            add_action('wp_ajax_pac_da_tutorials_categories', [$this, 'get_categories']);
            add_action('wp_ajax_pac_da_tutorials_posts', [$this, 'get_posts']);
            // Add nonce verification for the AJAX actions
            add_action('wp_ajax_nopriv_pac_da_tutorials_categories', [$this, 'get_categories']); // For non-logged in users
            add_action('wp_ajax_nopriv_pac_da_tutorials_posts', [$this, 'get_posts']); // For non-logged in users
            add_action('check_ajax_referer', [$this, 'check_ajax_referer']);
        }

        /**
         * Nonce Verification
         */
        public function check_ajax_referer() {
            $nonce_action = 'pac_da_tutorials_nonce_action';

            // Check nonce for the categories and posts actions
            if (isset($_POST['action']) && in_array($_POST['action'], ['pac_da_tutorials_categories', 'pac_da_tutorials_posts'])) {
                check_ajax_referer($nonce_action, 'security');
            }
        }

        /**
         * Get Categories
         *
         * @return array|false|mixed
         */
        public function get_categories() {
            $data = [];
            $transient_key = 'pac_da_tutorials_api_categories';

            // Verify nonce
            check_ajax_referer('pac_da_tutorials_nonce_action', 'security');

            $page = (isset($_POST['page']) && '' !== $_POST['page']) ? sanitize_text_field($_POST['page']) : 1;
            $per_page = (isset($_POST['per_page']) && '' !== $_POST['per_page']) ? sanitize_text_field($_POST['per_page']) : 100;
            $orderby = (isset($_POST['orderby']) && '' !== $_POST['orderby']) ? sanitize_text_field($_POST['orderby']) : 'name';
            $order = (isset($_POST['order']) && '' !== $_POST['order']) ? sanitize_text_field($_POST['order']) : 'asc';
            $exclude = (isset($_POST['exclude']) && '' !== $_POST['exclude']) ? wp_parse_list(sanitize_text_field($_POST['exclude'])) : [];

            $args = [
                'page' => $page,
                'per_page' => $per_page,
                'orderby' => $orderby,
                'order' => $order,
                'hide_empty' => true,
                'exclude' => $exclude,
                '_fields' => 'id,name,slug,description,count,link,parent'
            ];

            delete_transient($transient_key);

            $data = get_transient($transient_key);

            if (false === $data && true) {
                $query_arg = add_query_arg($args, self::$rest_api_categories_url);
                $response = wp_remote_get($query_arg, ['timeout' => 15, 'sslverify' => true]);

                if (!is_wp_error($response) && 200 === wp_remote_retrieve_response_code($response)) {
                    $categories = json_decode(wp_remote_retrieve_body($response), true);

                    if (!empty($categories) && !is_wp_error($categories)) {
                        foreach ($categories as $key => $category) {
                            $data[$key]['ID'] = $category['id'];
                            $data[$key]['parent'] = $category['parent'];
                            $data[$key]['name'] = html_entity_decode($category['name']);
                            $data[$key]['slug'] = $category['slug'];
                            $data[$key]['description'] = html_entity_decode(wp_strip_all_tags($category['description']));
                            $data[$key]['count'] = $category['count'];
                            $data[$key]['permalink'] = $category['link'];
                        }
                        set_transient($transient_key, $data, self::$transient_expiry);
                    }
                }
            }

            return wp_send_json_success($data);
        }

        /**
         * Get Posts
         *
         * @return array|false|mixed
         */
        public function get_posts() {
            $data = [];
            $transient_key = 'pac_da_tutorials_api_posts';

            // Verify nonce
            check_ajax_referer('pac_da_tutorials_nonce_action', 'security');

            $page = (isset($_POST['page']) && '' !== $_POST['page']) ? sanitize_text_field($_POST['page']) : 1;
            $per_page = (isset($_POST['per_page']) && '' !== $_POST['per_page']) ? sanitize_text_field($_POST['per_page']) : 15;
            $orderby = (isset($_POST['orderby']) && '' !== $_POST['orderby']) ? sanitize_text_field($_POST['orderby']) : 'date';
            $order = (isset($_POST['order']) && '' !== $_POST['order']) ? sanitize_text_field($_POST['order']) : 'desc';
            $categories = (isset($_POST['categories']) && '' !== $_POST['categories']) ? wp_parse_list(sanitize_text_field($_POST['categories'])) : [];

            $args = [
                'page' => $page,
                'per_page' => $per_page,
                'orderby' => $orderby,
                'order' => $order,
                'categories' => $categories,
                '_fields' => 'id,title,excerpt,link,date,featured_media,categories,tags,yoast_head_json'
            ];

            delete_transient($transient_key);

            $data = get_transient($transient_key);

            if (false === $data) {
                $query_arg = add_query_arg($args, self::$rest_api_posts_url);
                $response = wp_remote_get($query_arg, ['timeout' => 15, 'sslverify' => true]);

                if (!is_wp_error($response) && 200 === wp_remote_retrieve_response_code($response)) {
                    $posts = json_decode(wp_remote_retrieve_body($response), true);

                    if (!empty($posts) && !is_wp_error($posts)) {
                        foreach ($posts as $key => $post) {
                            $data[$key]['ID'] = $post['id'];
                            $data[$key]['title'] = $post['title']['rendered'];
                            $data[$key]['description'] = html_entity_decode(wp_strip_all_tags($post['excerpt']['rendered']));
                            $data[$key]['datetime'] = date_i18n('Y-m-d h:i:sa', strtotime($post['date']));
                            $data[$key]['thumbnail'] = isset($post['yoast_head_json']['og_image'][0]['url']) ? $post['yoast_head_json']['og_image'][0]['url'] : '';
                            $data[$key]['permalink'] = $post['link'];
                            $data[$key]['categories'] = $post['categories'];
                            $data[$key]['tags'] = $post['tags'];
                        }
                        set_transient($transient_key, $data, self::$transient_expiry);
                    }
                }
            }

            return wp_send_json_success($data);
        }
    }

    (new PAC_DA_Tutorials_API())->instance()->init();
}