<?php
if (!defined('ABSPATH')){exit;}
if (!class_exists( 'Pac_Da_Shortcode_In_Menus_Admin' ) && class_exists( 'Pac_Da_Shortcode_In_Menus' ) ) {
	class Pac_Da_Shortcode_In_Menus_Admin extends Pac_Da_Shortcode_In_Menus {
		protected static $instance = null;
		public function __construct() {
			parent::__construct();
			add_action( 'admin_init', array( $this, 'pac_da_add_shortcode' ) );
			add_action( 'admin_enqueue_scripts', array( $this, 'pac_da_enqueue_menu' ) );
			add_action( 'wp_ajax_pac_da_description_hack', array( $this, 'pac_da_description_hack' ) );
			add_action( 'wp_loaded', array( $this, 'pac_da_security_check' ) );
			add_action( 'wp_ajax_add-menu-item', array( $this, 'ajax_add_menu_item' ), 0 );
		}
		public static function get_instance() {
			if ( null === self::$instance ) {
				self::$instance = new self();
			}
			return self::$instance;
		}
		public function pac_da_add_shortcode() {
			add_meta_box( 'add-shortcode-section', __( 'DA Shortcode', PAC_DA_PLUGIN_TEXT_DOMAIN ), array( $this, 'pac_da_meta_box' ), 'nav-menus', 'side', 'default' );
		}
		public function pac_da_enqueue_menu( $hook ) {
			if ( 'nav-menus.php' !== $hook ) {
				return;
			}
			wp_enqueue_script( 'pac-da-admin', PAC_DA_PLUGIN_URL . 'include/js/pac-da-shortcode-in-menus.js', array( 'nav-menu' ), wp_rand(), true );
		}
		public function pac_da_description_hack() {
			$nonce = filter_input( INPUT_POST, 'description-nonce', FILTER_SANITIZE_STRING );
			if ( ! wp_verify_nonce( $nonce, 'pac_da_sc_menu_nonce' ) ) {
				wp_die();
			}
			$item = filter_input( INPUT_POST, 'menu-item', FILTER_UNSAFE_RAW, FILTER_REQUIRE_ARRAY );
			set_transient( 'pac_da_description_hack_' . $item['menu-item-object-id'], $item['menu-item-description'] );
			$object_id = $this->pac_da_new_object_id( $item['menu-item-object-id'] );
			echo esc_js( $object_id );
			wp_die();
		}
		public function pac_da_security_check() {
			if ( current_user_can( 'activate_plugins' ) ) {
				add_filter( 'clean_url', array( $this, 'pac_da_update_shortcode' ), 99, 3 );
			}
		}
		public function ajax_add_menu_item() {
			check_ajax_referer( 'add-menu_item', 'menu-settings-column-nonce' );
			if(!current_user_can('edit_theme_options')){
				wp_die(-1);
			}
			require_once ABSPATH . 'wp-admin/includes/nav-menu.php';
			$menu_items_data = [];
			// phpcs:ignore WordPressVIPMinimum.Security.PHPFilterFunctions.RestrictedFilter
			$menu_item = filter_input( INPUT_POST, 'menu-item', FILTER_UNSAFE_RAW, FILTER_REQUIRE_ARRAY );
			foreach ( $menu_item as $menu_item_data ) {
				if ( !empty( $menu_item_data['menu-item-type'] ) && 'custom' !== $menu_item_data['menu-item-type'] &&
				'pac_da' !== $menu_item_data['menu-item-type'] && ! empty( $menu_item_data['menu-item-object-id'])) {
					switch ( $menu_item_data['menu-item-type'] ) {
						case 'post_type':
							$_object = get_post( $menu_item_data['menu-item-object-id'] );
							break;
						case 'taxonomy':
							$_object = get_term( $menu_item_data['menu-item-object-id'], $menu_item_data['menu-item-object'] );
							break;
					}
					$_menu_items = array_map( 'wp_setup_nav_menu_item', array( $_object ) );
					$_menu_item  = reset( $_menu_items );
					$menu_item_data['menu-item-description'] = $_menu_item->description;
				}
				$menu_items_data[] = $menu_item_data;
			}
			$item_ids = wp_save_nav_menu_items( 0, $menu_items_data );
			if (is_wp_error($item_ids)){
				wp_die(0);
			}
			$menu_items = array();
			foreach ( (array) $item_ids as $menu_item_id ) {
				$menu_obj = get_post( $menu_item_id );
				if ( ! empty( $menu_obj->ID ) ) {
					$menu_obj        = wp_setup_nav_menu_item( $menu_obj );
					$menu_obj->label = $menu_obj->title;
					$menu_items[]    = $menu_obj;
				}
			}
			$menu = filter_input( INPUT_POST, 'menu', FILTER_SANITIZE_NUMBER_INT );
			// phpcs:ignore WordPress.NamingConventions.PrefixAllGlobals.NonPrefixedHooknameFound
			$walker_class_name = apply_filters( 'wp_edit_nav_menu_walker', 'Walker_Nav_Menu_Edit', $menu );
			if ( ! class_exists( $walker_class_name ) ) {
				wp_die( 0 );
			}
			if ( ! empty( $menu_items ) ) {
				$args = [
					'after'       => '',
					'before'      => '',
					'link_after'  => '',
					'link_before' => '',
					'walker'      => new $walker_class_name(),
				];
				echo walk_nav_menu_tree( $menu_items, 0, (object) $args );
			}
			wp_die();
		}
		public function pac_da_update_shortcode( $url, $original_url, $context ) {
			if ( 'db' === $context && $this->pac_da_check_shortcode( $original_url ) ) {
				return $original_url;
			}
			return $url;
		}
		public function pac_da_new_object_id( $last_object_id ) {
			$object_id = (int) $last_object_id;
			$object_id ++;
			$object_id = ( $object_id < 1 ) ? 1 : $object_id;
			update_option( 'pac_da_last_object_id', $object_id );
			return $object_id;
		}
		public function pac_da_meta_box() {
			global $_nav_menu_placeholder, $nav_menu_selected_id;
			$nav_menu_placeholder = 0 > $_nav_menu_placeholder ? $_nav_menu_placeholder - 1 : -1;
			$last_object_id = get_option( 'pac_da_last_object_id', 0 );
			$object_id = $this->pac_da_new_object_id( $last_object_id );
			?>
			<div class="pac-da-div" id="pac-da-div">
				<input type="hidden" class="menu-item-db-id" name="menu-item[<?php echo esc_attr( $nav_menu_placeholder ); ?>][menu-item-db-id]" value="0" />
				<input type="hidden" class="menu-item-object-id" name="menu-item[<?php echo esc_attr( $nav_menu_placeholder ); ?>][menu-item-object-id]" value="<?php echo esc_attr( $object_id ); ?>" />
				<input type="hidden" class="menu-item-object" name="menu-item[<?php echo esc_attr( $nav_menu_placeholder ); ?>][menu-item-object]" value="pac_da" />
				<input type="hidden" class="menu-item-type" name="menu-item[<?php echo esc_attr( $nav_menu_placeholder ); ?>][menu-item-type]" value="pac_da" />
				<input type="hidden" id="pac_da_sc_menu_nonce" value="<?php echo esc_attr( wp_create_nonce( 'pac_da_sc_menu_nonce' ) ); ?>" />
				<p id="menu-item-title-wrap">
					<label for="pac-da-title"><?php esc_html_e( 'Title', PAC_DA_PLUGIN_TEXT_DOMAIN ); ?></label>
					<input id="pac-da-title" name="menu-item[<?php echo esc_attr( $nav_menu_placeholder ); ?>][menu-item-title]" type="text" class="regular-text menu-item-textbox" title="<?php esc_attr_e( 'Title', PAC_DA_PLUGIN_TEXT_DOMAIN ); ?>" style="width:100%" />
				</p>
				<p id="menu-item-html-wrap">
					<label for="pac-da-title"><?php esc_html_e( 'Place shortcode here', PAC_DA_PLUGIN_TEXT_DOMAIN ); ?></label>
					<textarea style="width:100%;" rows="9" id="pac-da-html" name="menu-item[<?php echo esc_attr( $nav_menu_placeholder ); ?>][menu-item-description]" class="code menu-item-textbox" title="<?php esc_attr_e( 'Text/HTML/shortcode here!', PAC_DA_PLUGIN_TEXT_DOMAIN ); ?>"></textarea>
				</p>
				<p class="button-controls">
					<span class="add-to-menu">
						<input type="submit" <?php wp_nav_menu_disabled_check( $nav_menu_selected_id ); ?> class="button-secondary submit-add-to-menu right" value="<?php esc_attr_e( 'Add to Menu', PAC_DA_PLUGIN_TEXT_DOMAIN ); ?>" name="add-pac-da-menu-item" id="submit-pac-da" />
						<span class="spinner"></span>
					</span>
				</p>
			</div>
			<?php
		}
	}
}