<?php
// This file will create Custom Rest API End Points.
class DA_React_Settings_Rest_Route {
    public function __construct() {
        add_action( 'rest_api_init', [ $this, 'pac_da_create_rest_routes' ] );
    }
    // Create Rest Api
    public function pac_da_create_rest_routes() {
        register_rest_route( 'da/v1', '/daGetSideBarData', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_sidebar_data' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetDashboardData', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_dashboard_data' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daUpdateDashboardCards', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_update_dashboard_cards' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetDiviChangelog', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_divi_changelog' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetDiviAssistantChangelog', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_divi_assistant_changelog' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daSendNewFeatuteSuggestion', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_send_new_feature_suggestion' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetStartupData', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_startup_data' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetStartupCardsValue', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_startup_cards_value' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daUpdateStartupCards', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_update_startup_cards' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daPerformStartupAction', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_perform_startup_action' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetMaintenanceData', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_maintenance_data' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetMaintenanceCards', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_maintenance_cards' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daUpdateMaintenanceCards', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_update_maintenance_cards' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetAllGeneralData', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_all_general_data' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daUpdateAllGeneralData', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_update_all_general_data' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetTutorialsData', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_tutorials_data' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetWebReport', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_web_report' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetCustomQuickLinks', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_custom_quick_links' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetLocalFontData', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_local_font_data' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daUploadFontFile', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_upload_font_file' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daUpdateInFontDb', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_update_in_font_db' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daDeleteInFontDb', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_delete_in_font_db' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetGlobalStyles', [
            'methods' => 'GET',
            'callback' => [ $this, 'da_get_global_styles' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daResetSettings', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_reset_settings' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daImportSettings', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_import_settings' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daCreateChildTheme', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_create_child_theme' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daGetChildThemeImagePath', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_get_child_theme_image_path' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daExportChildTheme', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_export_child_theme' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
        register_rest_route( 'da/v1', '/daDeleteChildThemeZip', [
            'methods' => 'POST',
            'callback' => [ $this, 'da_delete_child_theme_zip' ],
            'permission_callback' => [ $this, 'da_divi_permission' ]
        ]);
    }

    // Delete Export Child theme
    public function da_delete_child_theme_zip($req) {
        $link = sanitize_text_field( $req['link'] );
        wp_delete_file($link);
    }

    // Export Child theme
    public function da_export_child_theme($req) {
        if (!extension_loaded('zip') && !class_exists('ZipArchive')) {
            return;
        }
        if (!is_child_theme()) {
            return;
        }
        $wp_dir = wp_get_upload_dir();
        $theme_dir = get_stylesheet_directory(); // Get the child theme directory
        $theme_name = wp_get_theme()->get_stylesheet();
        $zip_dir = path_join($wp_dir['basedir'], "$theme_name.zip"); // Define the destination zip file path
        $zip_url = path_join($wp_dir['baseurl'], "$theme_name.zip"); // Define the destination zip file path
        if (!file_exists($theme_dir) || count(glob("$theme_dir/*")) === 0) {
            return;
        }
        $zip = new ZipArchive();
        $is_zip_opened = $zip->open($zip_dir, ZIPARCHIVE::CREATE | ZIPARCHIVE::OVERWRITE);
        if ($is_zip_opened) {
            $recursive_dir_iterator = new RecursiveDirectoryIterator($theme_dir);
            $recursive_dir_iterator->setFlags(FilesystemIterator::SKIP_DOTS);
            $recursive_iterator = new RecursiveIteratorIterator($recursive_dir_iterator, RecursiveIteratorIterator::LEAVES_ONLY);
            $theme_dir_abs = realpath($theme_dir);
            foreach ($recursive_iterator as $file) {
                $file = realpath($file);
                if (strpos($file, $theme_dir_abs) === 0) {
                    $relative_path = $theme_name.substr($file, strlen($theme_dir_abs));
                    if (is_dir($file)) {
                        $zip->addEmptyDir($relative_path);
                    } elseif (is_file($file)) {
                        $zip->addFile($file, $relative_path);
                    }
                }
            }
            if ($zip->close()) {
                wp_send_json_success($zip_url);
                exit;
            }
        }
    }

    // Get Child theme Image Link
    public function da_get_child_theme_image_path($req) {
        if (isset($_FILES['file']['name']) && isset($_FILES['file']['tmp_name'])) {
            $tmp_file = $_FILES['file']['tmp_name']; // phpcs:ignore
            $target_dir = PAC_DA_PLUGIN_PATH . '/include/childthemeimage/';
            if (!file_exists($target_dir)) {
                mkdir($target_dir);
            }
            $target_file = $target_dir . 'screenshot.png';

            if(file_exists($target_file)){
                unlink($target_file);
            }
            if (move_uploaded_file($tmp_file, $target_file)) {
                return rest_ensure_response($target_file);
            }else {
                return rest_ensure_response(false);
            }
        } else {
            return rest_ensure_response(false);
        }
    }

    // Create Child Theme
    function da_create_child_theme($req) {

        $Theme_Name  = sanitize_text_field($req['Theme_Name']);
        $Theme_Description  = sanitize_text_field($req['Theme_Description']);
        $Author  = sanitize_text_field($req['Author']);
        $Author_URI  = sanitize_text_field($req['Author_URI']);
        $Version  = sanitize_text_field($req['Version']);
        $Image  = sanitize_text_field($req['Image']);

        $Text_Domain = $outputText = strtolower(str_replace(' ', '-', $Theme_Name));

        $theme_root = get_theme_root();
        $theme_dir = $theme_root.'/'.$Text_Domain;

        if ( file_exists( $theme_dir ) ) {
			$go_url = add_query_arg( array(
                'msg'=> __('Child-theme-already-exists.-Please-try-using-custom-child-theme-feature.','pac-divi-assistant'),
                'error_type' => 'exists'
            ),
            admin_url( 'themes.php' ));
            wp_safe_redirect( $go_url );
			return new WP_Error( 'exists', 'Theme directory already exists!' );
		}
        mkdir( $theme_dir);

        // Make style.css
		ob_start();
		require PAC_DA_PLUGIN_PATH . '/include/php/templates/css.php';
		$css = ob_get_clean();
        if ( ! function_exists( 'WP_Filesystem' ) ) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
        }
        if ( ! WP_Filesystem() ) {
            return rest_ensure_response(false);
        }
        if ( ! file_exists( $theme_dir . '/style.css' ) ) {
            global $wp_filesystem;
            $wp_filesystem->put_contents( $theme_dir . '/style.css', $css, FS_CHMOD_FILE );
        }

        // Make script.js
        mkdir( $theme_dir.'/js');
        $content = '//Place your JavaScript of jQuery snippets here. Remember to remove the <script> tags';
        if ( ! file_exists( $theme_dir . '/js/script.js' ) ) {
            global $wp_filesystem;
            $wp_filesystem->put_contents( $theme_dir . '/js/script.js', $content, FS_CHMOD_FILE );
        }

        $Function_Name = str_replace('-', '_', $Text_Domain) . "_style";
		$Function_Name = preg_replace("/[^A-Za-z0-9?!_]/",'',$Function_Name);

		ob_start();
		require PAC_DA_PLUGIN_PATH . '/include/php/templates/functions.php';
		$wp_function = ob_get_clean();
        if ( ! file_exists( $theme_dir . '/functions.php' ) ) {
            global $wp_filesystem;
            $wp_filesystem->put_contents( $theme_dir . '/functions.php', $wp_function, FS_CHMOD_FILE );
        }
        if ($Image !== 'default_image' && file_exists($Image)) {
            $target_file = $theme_dir.'/'.'screenshot.png';
            copy($Image, $target_file);
            unlink($Image);
        }
        else{
            $default_file = PAC_DA_PLUGIN_PATH . '/include/img/screenshot.png';
            if(file_exists($default_file)){
                copy( $default_file, $theme_dir.'/screenshot.png');
            }
        }
        switch_theme($Text_Domain);
        return rest_ensure_response($Text_Domain);
    }

    // Get Sidebar Data
    function da_get_sidebar_data( $req ) {
        $sidebarData = [];
        $sidebarData['name'] = PAC_DA_CURRENT_USERNAME;
        $sidebarData['avatar'] =  esc_url(get_avatar_url(PAC_DA_CURRENT_USER_EMAIL));
        return rest_ensure_response($sidebarData);
    }
    // Get Dashboard Data
    function da_get_dashboard_data( $req ) {
        $dashboardData = [];
        // Get divi credentials
        $divi_credentials = [];
        $username_api_key = get_option('et_automatic_updates_options');
        $divi_credentials['username'] = $username_api_key['username'];
        $divi_credentials['api_key'] = $username_api_key['api_key'];
        $divi_credentials['status'] = get_option('et_account_status');
        $dashboardData['divi_credentials'] = $divi_credentials;
        $dashboardData['blog_public'] = get_option('blog_public');

        // New Divi Feature Update!
        $elegant_posts = wp_remote_get('https://www.elegantthemes.com/blog/category/theme-releases');
        if (!is_wp_error($elegant_posts)) {
            $html = wp_remote_retrieve_body($elegant_posts);
            $data = [];
            if (!empty($html) && !is_wp_error($html)) {
                $dom = new DOMDocument('1.0', 'UTF-8');
                $dom->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'), LIBXML_NOERROR | LIBXML_HTML_NOIMPLIED | LIBXML_HTML_NODEFDTD);
                $dom_xpath = new DOMXPath($dom);
                $nodes = $dom_xpath->query('//article[contains(@id,"post-")]');
                if (isset($nodes->length) && 0 !== $nodes->length) {
                    if (isset($nodes[0]->getElementsByTagName('h3')->length) && $nodes[0]->getElementsByTagName('h3')->length > 0) {
                        $data['title'] = $nodes[0]->getElementsByTagName('h3')->item(0)->nodeValue;
                    }
                    if (isset($nodes[0]->getElementsByTagName('a')->length) && 0 !== $nodes[0]->getElementsByTagName('a')->length) {
                        $data['url'] = $nodes[0]->getElementsByTagName('a')->item(1)->getAttribute('href');
                    }
                }else{
                    $data['title'] = 'Introducing Divi Code AI, Your Personal Divi Coding Assistant';
                    $data['url'] = 'https://www.elegantthemes.com/blog/theme-releases/introducing-divi-code-ai';
                }
            }else{
                $data['title'] = 'Introducing Divi Code AI, Your Personal Divi Coding Assistant';
                $data['url'] = 'https://www.elegantthemes.com/blog/theme-releases/introducing-divi-code-ai';
            }
            $dashboardData['new_divi_feature_update']   = $data;
        }        

        // Get Notification
        $notifications_data = [];
        $response = wp_remote_get('https://www.peeayecreative.com/wp-content/uploads/pac_da_api/notification.json');
        if (!is_wp_error($response)) {
            $data = json_decode(wp_remote_retrieve_body($response), true);
            if (!empty($data) && !is_wp_error($data)) {
                $DashboardCards = [];
                foreach($data as $ind => $val) {
                    $notifications_data[] = $val;
                    $slug = $val['ID'];
                    $DashboardCards[$slug] = isset(json_decode(get_option('pacDaDashboardCards','{"systemStatus":false,"featureUpdate":false,"blogPublic":false}'))->{$slug}) ? json_decode(get_option('pacDaDashboardCards','{"systemStatus":false,"featureUpdate":false,"blogPublic":false}'))->{$slug} : false;
                }
                $ddActualCards = json_decode(get_option('pacDaDashboardCards', '{"systemStatus":false,"featureUpdate":false,"blogPublic":false}'));
                $DashboardCards['featureUpdate'] = $ddActualCards->featureUpdate;
                $DashboardCards['systemStatus'] = $ddActualCards->systemStatus;
                $dashboardData['DashboardCards'] = $DashboardCards;
            }
            else{
                $dashboardData['DashboardCards']    = json_decode(get_option('pacDaDashboardCards', '{"systemStatus":false,"featureUpdate":false,"blogPublic":false}'));
                $notifications_data = 'File Not Found';
            }
        }
        else{
            $dashboardData['DashboardCards']  = json_decode(get_option('pacDaDashboardCards', '{"systemStatus":false,"featureUpdate":false,"blogPublic":false}'));
            $notifications_data = 'File Not Found';
        }

        $dashboardData['notificationsData'] = $notifications_data;

        return rest_ensure_response($dashboardData);
    }

    // Update Dashboard Cards
    function da_update_dashboard_cards( $req ) {
        $card = sanitize_text_field( $req['card'] );
        $DashboardCards    = json_decode(get_option('pacDaDashboardCards', '{"systemStatus":false,"featureUpdate":false,"blogPublic":false}'));
        $DashboardCards->{$card} = true;
        update_option( 'pacDaDashboardCards',wp_json_encode($DashboardCards));
        return rest_ensure_response($DashboardCards);
    }

    // Get Divi Changelog
    function da_get_divi_changelog($req) {
        $options_data = [];
        $versions_data = [];
        $max_up_to_3_0 = true;
    
        function change_date_format($date) {
            $date = explode("-",$date);
            switch ($date[0]) {
                case "01":
                    $date[0] = "January";
                    break;
                case "02":
                    $date[0] = "February";
                    break;
                case "03":
                    $date[0] = "March";
                    break;
                case "04":
                    $date[0] = "April";
                    break;
                case "05":
                    $date[0] = "May";
                    break;
                case "06":
                    $date[0] = "June";
                    break;
                case "07":
                    $date[0] = "July";
                    break;
                case "08":
                    $date[0] = "August";
                    break;
                case "09":
                    $date[0] = "September";
                    break;
                case "10":
                    $date[0] = "October";
                    break;
                case "11":
                    $date[0] = "November";
                    break;
                case "12":
                    $date[0] = "December";
                    break;
                default:
                    break;
            }
            if(isset($date[1])){
				$date[1] = $date[1] . ',';
			}
            $date = implode(" ",$date);
            return $date;
        }

        $changelog_data = wp_remote_get('https://www.elegantthemes.com/api/changelog/divi.txt');
        if (!is_wp_error($changelog_data)) {
            $body = wp_remote_retrieve_body($changelog_data);
            $lines = explode("\n", $body);
            $option_data = [];
            $version_data = [];
            $version_points = [];
    
            foreach ($lines as $line) {
                $line = trim($line);
                if (preg_match('/^version (\d+(\.\d+){0,2})\b/', $line, $matches)) {
                    $version = $matches[1];
                    if (substr_count($version, '.') === 1) {
                        $version .= '.0';
                        $line = preg_replace('/^version \d+(\.\d+){0,2}/', 'version ' . $version, $line);
                    }
                
                    if (version_compare($version, '3.0.0') >= 0) {
                        $option_data['label'] = $line;
                        $option_data['value'] = str_replace('.', '_', $version);
                        $version_data['id'] = $option_data['value'];
                        $version_data['version'] = $version;
                        preg_match('/(\d{1,2}-\d{1,2}-\d{2,4})/', $line, $dates);
                        if(isset($dates[0])){
                            $version_data['date'] = change_date_format($dates[0]);
                        }else{
                            $version_data['date'] = '(Not mentioned)';
                            $version_points[] = 'version skipped for product version consistency';
                        }
                    }
                } elseif (!empty($line) && strpos($line, '*') !== 0) {
                    $version_points[] = $line;
                } elseif (empty($line) && !empty($option_data) && !empty($version_points)) {
                    $version_data['points'] = $version_points;
                    $options_data[] = $option_data;
                    $versions_data[] = $version_data;
                    $option_data = [];
                    $version_data = [];
                    $version_points = [];
                }
            }
        }
    
        $theme = !is_child_theme() ? wp_get_theme() : wp_get_theme()->parent();
        $Version = $theme->get('Version');
    
        $response = [
            'options' => $options_data,
            'versions' => $versions_data,
            'divi_version' => $Version,
        ];
    
        return rest_ensure_response($response);
    }

    // Get Divi Assistant Changelog
    function da_get_divi_assistant_changelog( $req ) {
        $points = [];
        $data = [];
        $changelog = [];
        if ( ! function_exists( 'WP_Filesystem' ) ) {
            require_once ABSPATH . 'wp-admin/includes/file.php';
        }
        if ( ! WP_Filesystem() ) {
            return rest_ensure_response( null );
        }
        global $wp_filesystem;
        $fh = $wp_filesystem->get_contents( PAC_DA_PLUGIN_PATH . 'readme.txt' );
        if ( false !== $fh ) {
            function change_date_format($date) {
                $date = explode("-",$date);
                switch ($date[0]) {
                    case "01":
                        $date[0] = "January";
                        break;
                    case "02":
                        $date[0] = "February";
                        break;
                    case "03":
                        $date[0] = "March";
                        break;
                    case "04":
                        $date[0] = "April";
                        break;
                    case "05":
                        $date[0] = "May";
                        break;
                    case "06":
                        $date[0] = "June";
                        break;
                    case "07":
                        $date[0] = "July";
                        break;
                    case "08":
                        $date[0] = "August";
                        break;
                    case "09":
                        $date[0] = "September";
                        break;
                    case "10":
                        $date[0] = "October";
                        break;
                    case "11":
                        $date[0] = "November";
                        break;
                    case "12":
                        $date[0] = "December";
                        break;
                    default:
                        break;
                }
                if(isset($date[1])){
                    $date[1] = $date[1] . ',';
                }
                $date = implode(" ",$date);
                return $date;
            }
            $lines = explode("\n", $fh);
            foreach ($lines as $line) {
                if(strlen($line) !== 0 && explode(" ", $line)[0] == "version"){
                    $line = explode(" ",$line);
                    $version = $line[1];
                    $date = change_date_format($line[4]);
                }else if(strlen($line) !== 0){
                    $line = str_replace("-", "", $line);
                    $points[] = rtrim($line);
                }else if(strlen($line) === 0){
                    if($points !== null){
                        $data['version'] = $version;
                        $data['date'] = $date;
                        $data['points'] = $points;
                        $changelog[] = $data;
                        $points = null;
                        $data = null;
                    }
                }
            }
            if($points !== null){
                $data['version'] = $version;
                $data['date'] = $date;
                $data['points'] = $points;
                $changelog[] = $data;
                $points = null;
                $data = null;
            }
            return rest_ensure_response( $changelog );
        } else {
            return rest_ensure_response( null );
        }
    }

    // Send New Feature Suggestion
    function da_send_new_feature_suggestion($req) {
        $from_name = sanitize_text_field($req['name']);
        $title = 'Divi Assistant Feature Request: ' . sanitize_text_field($req['title']);
        $body = wp_strip_all_tags(sanitize_text_field($req['message']));
        $from_email = PAC_DA_CURRENT_USER_EMAIL;
        $result = wp_mail( 'nelson@peeayecreative.com', $title, $body, "From: $from_name <$from_email>" );
        return rest_ensure_response($result);
    }

    // Get Startup Data
    function da_get_startup_data( $req ) {    
        $Data = [];
        // Get Plugins Data
        if ( ! function_exists('get_plugins')){
            require_once ABSPATH . 'wp-admin/includes/plugin.php';
        }
        $allPlugin = get_plugins();
        $allPlugins = [];
        $defaultPlugins = [];
        $defaultPlugins['Hello_Dolly'] = false;
        $defaultPlugins['Akismet_Anti_Spam'] = false;
        foreach($allPlugin as $key => $plugin){
            if($plugin['TextDomain'] === 'hello-dolly'){
                $defaultPlugins['Hello_Dolly'] = true;
            }
            elseif($plugin['TextDomain'] === 'akismet'){
                $defaultPlugins['Akismet_Anti_Spam'] = true;
            }

            // Check if installed plugin available in WP repositry
            $response = wp_remote_get( "https://api.wordpress.org/plugins/info/1.2/?action=plugin_information&request[slug]=".$plugin['TextDomain']);
            if ( !is_wp_error( $response ) ) {
                $body = wp_remote_retrieve_body( $response );
                $data = json_decode( $body );
                if ( !isset( $data->error ) ) {
                    $allPlugins[$plugin['TextDomain']] = $plugin['Title'];
                }else{
                    $ind = explode('/', $key)[0];
                    if($ind !== $plugin['TextDomain']){
                        $response = wp_remote_get( "https://api.wordpress.org/plugins/info/1.2/?action=plugin_information&request[slug]=".$ind);
                        if ( !is_wp_error( $response ) ) {
                            $body = wp_remote_retrieve_body( $response );
                            $data = json_decode( $body );
                            if ( !isset( $data->error ) ) {
                                $allPlugins[$ind] = $plugin['Title'];
                            }
                        }
                    }
                }
            }
        }
        // Themes
        $themes = [];
        $allThemes = wp_get_themes();
        $current_theme = wp_get_theme();
        if (!empty($current_theme->get('Template'))) {
            unset($allThemes[$current_theme->get('TextDomain')]);
            unset($allThemes['Divi']);
        }else{
            unset($allThemes['Divi']);
        }
        foreach ($allThemes as $slug => $theme) {
            $themes[$slug] = $theme->get('Name');
        }
        $Data['allThemes'] = $themes;



        $defaultThemes = [];
        $defaultThemes['twenty_twenty'] = false;
        $defaultThemes['twenty_twenty_one'] = false;
        $defaultThemes['twenty_twenty_two'] = false;
        $defaultThemes['twenty_twenty_three'] = false;
        foreach($allThemes as $key => $theme){
            if($key === 'twentytwenty'){
                $defaultThemes['twenty_twenty'] = true;
            }
            elseif($key === 'twentytwentyone'){
                $defaultThemes['twenty_twenty_one'] = true;
            }
            elseif($key === 'twentytwentytwo'){
                $defaultThemes['twenty_twenty_two'] = true;
            }
            elseif($key === 'twentytwentythree'){
                $defaultThemes['twenty_twenty_three'] = true;
            }
        }
        // Pages
        $allPages = get_pages();
        $defaultPages = [];
        $defaultPages['privacy_policy'] = false;
        $defaultPages['sample_page'] = false;
        foreach($allPages as $key => $page){
            if($page->post_name === 'privacy-policy'){
                $defaultPages['privacy_policy'] = true;
            }
            elseif($page->post_name === 'sample-page'){
                $defaultPages['sample_page'] = true;
            }
        }
        // Posts
        $defaultPosts = [];
        $defaultPosts['hello_world'] = false;
        $args = array(
            'post_type' => 'post',
            'posts_per_page' => -1
        );
        $the_query = new WP_Query( $args );
        if ( $the_query->have_posts() && $the_query->post->post_name === 'hello-world'){
            $defaultPosts['hello_world'] = true;
        }
        $Data['defaultPlugins'] = $defaultPlugins;
        $Data['defaultThemes'] = $defaultThemes;
        $Data['defaultPages'] = $defaultPages;
        $Data['defaultPosts'] = $defaultPosts;
        $Data['allPlugins'] = $allPlugins;
        return rest_ensure_response($Data);
    }

    // Get Startup Cards Value
    function da_get_startup_cards_value( $req ) {
        $data = json_decode(get_option('pacDaStartupCards', '{"import":false,"plugin":false,"theme":false,"page":false,"post":false,"widgets":false,"homepage":false,"menu":false,"disableComments":false,"permalink":false,"installPlugins":false}'));
        return rest_ensure_response($data);
    }

    // Update Startup Cards Value
    function da_update_startup_cards( $req ) {
        $card = sanitize_text_field( $req['card'] );
        $StartupCards = json_decode(get_option('pacDaStartupCards', '{"import":false,"plugin":false,"theme":false,"page":false,"post":false,"widgets":false,"homepage":false,"menu":false,"disableComments":false,"permalink":false,"installPlugins":false}'));
        if($card === 'import'){
            $StartupCards->import = true;
        }elseif($card === 'plugin'){
            $StartupCards->plugin = true;
        }elseif($card === 'theme'){
            $StartupCards->theme = true;
        }elseif($card === 'page'){
            $StartupCards->page = true;
        }elseif($card === 'post'){
            $StartupCards->post = true;
        }elseif($card === 'widgets'){
            $StartupCards->widgets = true;
        }elseif($card === 'homepage'){
            $StartupCards->homepage = true;
        }elseif($card === 'menu'){
            $StartupCards->menu = true;
        }elseif($card === 'permalink'){
            $StartupCards->permalink = true;
        }elseif($card === 'installPlugins'){
            $StartupCards->installPlugins = true;
        }elseif($card === 'disableComments'){
            $StartupCards->disableComments = true;
        }
        update_option( 'pacDaStartupCards',wp_json_encode($StartupCards));
        return rest_ensure_response(true);
    }

    // Perform Startup Action
    function da_perform_startup_action( $req ) {
        $action = sanitize_text_field( $req['action']);
        if($action === 'plugin' | $action === 'theme' | $action === 'page' | $action === 'post'){
            $data = json_decode(sanitize_text_field( $req['data']));
        }
        if($action === 'plugin'){
            $Hello_Dolly = $data->Hello_Dolly;
            $Akismet_Anti_Spam = $data->Akismet_Anti_Spam;
            if (file_exists(WP_PLUGIN_DIR.'/hello-dolly/hello.php') | file_exists(WP_PLUGIN_DIR.'/akismet/akismet.php')) {
                require_once(ABSPATH.'wp-admin/includes/plugin.php');
                require_once(ABSPATH.'wp-admin/includes/file.php');
                if ($Hello_Dolly) {
                    delete_plugins([
                        'hello-dolly/hello.php',
                    ]);
                }
                if ($Akismet_Anti_Spam) {
                    delete_plugins([
                        'akismet/akismet.php',
                    ]);
                }
                $response = true;
            }else{
                $response = 'No Default Plugin Eixts';
            }
        }
        elseif($action === 'theme'){
            foreach ($data as $key => $value) {
                if($value){
                    if(!function_exists('delete_theme')){
                        require_once( ABSPATH . 'wp-admin/includes/theme.php' );
                    }
                    delete_theme($key);
                }
            }
            $response = true;
        }
        elseif($action === 'page'){
            $SamplePage = $data->sample_page;
            $PrivacyPage = $data->privacy_policy;
            $pages = get_pages();
            foreach($pages as $page){
                if($page->post_name === 'privacy-policy' & $PrivacyPage){
                    wp_delete_post($page->ID, true);
                }
                elseif($page->post_name === 'sample-page' & $SamplePage){
                    wp_delete_post($page->ID, true);
                }
            }
            $response = true;
        }
        elseif($action === 'post'){
            $HelloWorld = $data->hello_world;
            $args = array(
                'post_type' => 'post',
                'posts_per_page' => -1
            );
            $the_query = new WP_Query( $args );
            if ( $the_query->have_posts() & $the_query->post->post_name === 'hello-world' & $HelloWorld){
                wp_delete_post($the_query->post->ID, true);
            }
            $response = true;
        }
        elseif($action === 'widgets'){
            $sidebars_widgets = wp_get_sidebars_widgets();
            foreach($sidebars_widgets as $ind => $value) {
                $sidebars_widgets[$ind] = [];
            }
            $current_theme = wp_get_theme();
            $theme_name = $current_theme->get('Name');
            $data['theme_mods_'.$theme_name] = get_option('theme_mods_'.$theme_name,false);
            if($data['theme_mods_'.$theme_name] !== false){
                $data['theme_mods_'.$theme_name]['sidebars_widgets']['data'] = $sidebars_widgets;
                update_option( 'theme_mods_'.$theme_name, $data['theme_mods_'.$theme_name]);
            }
            wp_set_sidebars_widgets( $sidebars_widgets );
            update_option( 'sidebars_widgets', $sidebars_widgets);
            $response = true;
        }
        elseif($action === 'homepage'){
            $current_user = wp_get_current_user();
            $front_id = (int) get_option( 'page_on_front' );
            if(!$front_id){
                 // create post object
                $page = array(
                  'post_title'  => __( 'Home' ),
                  'post_status' => 'publish',
                  'post_author' => $current_user->ID,
                  'post_type'   => 'page',
                );
                
                // insert the post/page into the database
                wp_insert_post( $page );
                
                // Use a static front page
                $home = get_page_by_title( 'Home' );
                update_option( 'page_on_front', $home->ID );
                update_option( 'show_on_front', 'page' );
                
                //Enable Divi builder on page
                update_post_meta( $home->ID, '_et_pb_use_builder', 'on' );
            
                $response = true;
            }else{
                $response = false;
            }
        }
        elseif($action === 'menu'){
            $locations = get_theme_mod('nav_menu_locations');
            wp_delete_nav_menu('Primary Menu');
            $menu_id = wp_create_nav_menu('Primary Menu');
            $front_id = (int) get_option( 'page_on_front' );
            if(!$front_id){
                $page = get_page_by_title('Home');
                $page_id = $page->ID;
                $title = 'Home';
            }else{
                $page_id = $front_id;
                $title = get_the_title( $ID );
            }
            wp_update_nav_menu_item($menu_id, 0, array(
                'menu-item-title' => $title,
                'menu-item-object-id' => $page_id,
                'menu-item-object' => 'page',
                'menu-item-status' => 'publish',
                'menu-item-type' => 'post_type',
            ));
            $locations = get_theme_mod('nav_menu_locations');
            $locations['primary-menu'] = $menu_id;
            set_theme_mod( 'nav_menu_locations', $locations );
            $response = true;
        }
        elseif($action === 'permalink'){
            global $wp_rewrite;
            $wp_rewrite->set_permalink_structure('/%postname%/');
            $wp_rewrite->flush_rules();
            $response = true;
        }
        elseif($action === 'installPlugins'){
            $selectedPlugins = json_decode(sanitize_text_field( $req['selectedPlugins']));
            $plugins = get_plugins();
            foreach ($selectedPlugins as $key => $plugin_name) {
                foreach ( $plugins as $plugin_path => $plugin ) {
                    $ind = explode('/', $plugin_path)[0];
                    if ( $plugin_name === $plugin['TextDomain'] || $plugin_name === $ind) {
                        unset($selectedPlugins[$key]);
                    }
                }
            }
            require_once( ABSPATH . 'wp-admin/includes/plugin-install.php' );
            require_once( ABSPATH . 'wp-admin/includes/class-wp-upgrader.php' );
            require_once( ABSPATH . 'wp-admin/includes/class-wp-ajax-upgrader-skin.php' );
            require_once( ABSPATH . 'wp-admin/includes/class-plugin-upgrader.php' );
            $skin     = new WP_Ajax_Upgrader_Skin();
            $upgrader = new Plugin_Upgrader( $skin );
            foreach ($selectedPlugins as $plugin_name) {
                $api_url = 'https://api.wordpress.org/plugins/info/1.0/' . $plugin_name . '.json';
                $response = json_decode(wp_remote_retrieve_body(wp_remote_get($api_url)), true);
                $download_link = $response['download_link'];
                $upgrader->install( $download_link );
            }
            $plugins = get_plugins();
            foreach ($selectedPlugins as $plugin_name) {
                foreach ( $plugins as $plugin_path => $plugin ) {
                    $ind = explode('/', $plugin_path)[0];
                    if ( $plugin_name === $plugin['TextDomain'] || $plugin_name === $ind) {
                        if( ! is_plugin_active( $plugin_path ) ) {
                            activate_plugin( $plugin_path );
                        }
                    }
                }
            }
            $response = true;
        }
        elseif($action === 'disableComments'){
            update_option( 'default_comment_status','closed');
            global $wpdb;
            $wpdb->query("UPDATE wp_posts SET comment_status = 'closed'"); // phpcs:ignore
            $response = true;
        }
        else{
            $response = false;
        }
        return rest_ensure_response($response);
    }

    // Get Maintenance Data
    function da_get_maintenance_data( $req ) {
        $layouts = get_posts(array('post_type' => 'et_pb_layout', 'posts_per_page' => -1));
        foreach($layouts as $ind => $val) {
            $layouts[$ind]->post_title = 'Divi Library Layout: ' . $val->post_title;
        }
        $pages = get_posts(array('post_type' => 'page', 'posts_per_page' => -1));
        foreach($pages as $ind => $val) {
            $pages[$ind]->post_title = 'Page: ' . $val->post_title;
        }
        $data = array_merge($layouts,$pages);
        $data = array_column($data, 'post_title', 'ID');

        return rest_ensure_response($data);
    }

    // Get Maintenance Cards Value
    function da_get_maintenance_cards( $req ) {
        $data = json_decode(get_option('pacDaMaintenanceCards', '{"commingSoon":false,"Maintenance":false,"commingSoonPage":"none","MaintenancePage":"none","byPassCommingSoon":"false","byPassLink":null,"autoClearCache":"disable","clearOnExitsVB":false,"clearOnUpdatePlugin":false,"clearOnUpdateTheme":false}'));
        return rest_ensure_response($data);
    }

    // Update Maintenance Cards Value
    function da_update_maintenance_cards( $req ) {
        $value = sanitize_text_field( $req['value']);
        update_option( 'pacDaMaintenanceCards',$value);
        $utilityStg = sanitize_text_field( $req['utilityStg']);
        if(!empty($utilityStg) && $utilityStg !== null){
            update_option( 'pacDaUtilityCards',$utilityStg);
        }
        return rest_ensure_response(true);
    }

    // Get All General Data
    function da_get_all_general_data( $req ) {
        $data = [];
        $dataToExport = [];
        // Get Color Palette
        $et_divi  = get_option('et_divi');


        $dataToExport['et_divi'] = $et_divi;
        $dataToExport['wp_get_custom_css_post'] = wp_get_custom_css_post();
        $dataToExport['get_global_presets'] = ET_Builder_Global_Presets_Settings::instance()->get_global_presets();
        $data['dataToExport'] = $dataToExport;


        $data['et_global_colors']  = et_builder_get_all_global_colors();
        $data['diviColorPalette']  = $et_divi['divi_color_palette'] !== null ? $et_divi['divi_color_palette'] : "#000000|#FFFFFF|#E02B20|#E09900|#EDF000|#7CDA24|#0C71C3|#8300E9";
        // Get Cards
        $data['utilityCards'] = json_decode(get_option('pacDaUtilityCards', '{"staticCss":false,"localStorage":false,"hardRefresh":false,"quickLinks":false,"tBTDetails":false,"removeHowdy":false,"adminbarEverywhere":false,"adminbarFrontend":false,"adminbarHover":false,"duplicateDiviLib":false,"exportDiviLib":false,"diviLibWidget":false,"diviLibSC":false,"openVisualBuilder":false,"disableCommentSettings":false,"duplicatePagePost":false,"escKey":false,"hideLayout":false,"disableAi":false,"hideExploreBtn":false,"horizontalScroll":false,"cursorHighlight":false,"bgHighlight":"#3399ff","textHighlight":"#ffffff","hideProject":false,"renameProject":false,"pluralName":"Projects","singularName":"Project","slug":"projects","pluralCategory":"Project Categories","singularCategory":"Project Category","slugCategory":"project_category","pluralTag":"Project Tags","singularTag":"Project Tag","slugTag":"project_tag","menuIcon":"dashicons-admin-post","defaultThemes":false,"updateThemes":false,"updatePlugins":false,"themeBuilderCPT":false,"fullScreen":false,"edidorBtn":false,"stickyToolbar":false,"htmlArea":false,"htmlAreaValue":"400px","popupHeight":false,"popupHeightValue":"500px","iconAreaHeight":false,"iconAreaHeightValue":"300px","textPopover":false,"rowWidth":false,"swapSandGbtn":false,"deleteData":false}'));
        $data['mediaCards'] = json_decode(get_option('pacDaMediaCards', '{"svgUploads":false,"svgUploadsValue":"default","fileSize":false,"fileSizeValue":"512kb","imgReplace":false,"imgTitle":false,"useAltText":false,"ignoreAltText":false}'));
        $data['fontCards'] = (bool)get_option('pacDaFontCards', false);
        $data['environmentsData'] = json_decode(get_option('pacDaEnvironmentsData', '{"enable":false,"environment":"default","prodLabel":"Production","prodClr":"#00D263","stagLabel":"Staging","stagClr":"#7846FF","devLabel":"Development","devClr":"#F15A24"}'));
        $data['codeData'] = json_decode(get_option('pacDaCodeData', '{"css":false,"jquery":false,"php":false,"runPhp":false,"enableResize":false,"boxHeight":false,"boxHeightValue":"313px","enableResizeCe":false,"boxHeightCe":false,"boxHeightValueCe":"313px"}'));
        $data['enableAddons'] = json_decode(get_option('pacDaAddons', '{"startUp":true,"maintenance":true,"utility":true,"media":true,"learning":true,"support":true,"fonts":true,"styles":true,"code":true,"frontend":true,"accessibility":true}'));
        $data['scrollbar'] = json_decode(get_option('pacDaScrollbar', '{"scrollbar":false,"barWidth":"17px","barBgColor":"#f1f1f1","barRaduis":"3px","barHandleColor":"#c1c1c1","barHandleHColor":"#c1c1c1"}'));
        $data['backToTop'] = json_decode(get_option('pacDaBackToTop', '{"backToTop":false,"devices":"all","btnBgColor":"rgba(0,0,0,0.4)","btnBgHColor":"rgba(0,0,0,0.4)","btnRadius":"5px","right":"0px","bottom":"125px","btnTextColor":"#ffffff","btnTextHColor":"#ffffff","btnContent":"icon","btnIcon":"","btnText":"","btnIconPlacement":"left"}'));
        $data['textReplace'] = (bool)get_option('pacDaTextReplace', false);
        $data['textReplaceData'] = json_decode(get_option('pacDaTextReplaceData','[{"selector": "", "customText": ""}]'));
        $data['accessibilityHelperData'] = json_decode(get_option('pacDaAccessibilityHelper', '{"focusable":false,"outline":false,"outlineColor":"#E1271A","ariaSupport":false,"iconsAria":false,"Underline":false,"underlineHeading":false,"underlineBtns":false,"underlineMenu":false,"skipNavigation":false,"hideSkipNavigation":false,"duplicateMenu":false,"dropdownMenu":false,"improveScreenReader":false,"pinchZoom":false,"Tota11y":false}'));
        
        // Enable Divi Builder By Default For All Post types
        $postTypeSetting = [];
        $postTypeCE = [];
        $postType = [];
        $postTypeNames = [];
        $postTypeDefault = [];
        $postTypes = get_post_types(['show_in_nav_menus' => true], 'objects');
        foreach($postTypes as $slug => $Name) {
            $postTypeNames[$slug] = $Name->labels->name;
            $postTypeCE[$slug] = isset(json_decode(get_option('pacDaAllPostTypesCE','{"page":false,"post":false,"project":false}'))->{$slug}) && json_decode(get_option('pacDaAllPostTypesCE','{"page":false,"post":false,"project":false}'))->{$slug} !== null ? json_decode(get_option('pacDaAllPostTypesCE','{"page":false,"post":false,"project":false}'))->{$slug} : false;
            $postType[$slug] = isset(json_decode(get_option('pacDaAllPostTypes','{"page":false,"post":false,"project":false}'))->{$slug}) && json_decode(get_option('pacDaAllPostTypes','{"page":false,"post":false,"project":false}'))->{$slug} !== null ? json_decode(get_option('pacDaAllPostTypes','{"page":false,"post":false,"project":false}'))->{$slug} : false;
            $postTypeDefault[$slug] = false;
        }
        $postTypeSetting['postTypeNames'] = $postTypeNames;
        $postTypeSetting['postTypeCE'] = $postTypeCE;
        $postTypeSetting['postType'] = $postType;
        $postTypeSetting['DefaultPostType']  = $postTypeDefault;
        update_option( 'pacDaAllDefaultPostTypes', wp_json_encode($postTypeDefault));
        $data['postTypeSetting'] = $postTypeSetting;

        function pac_change_styles($styles) {
            $new_styles = [];
            $styles = array_filter(explode(",",$styles), function ($var) { return (strpos($var, 'italic') === false); });
            foreach($styles as $ind => $value) {
                switch ($value) {
                    case "100":
                        $value = "Thin";
                        $ind = '100';
                        break;
                    case "200":
                        $value = "Ultra Light";
                        $ind = '200';
                        break;
                    case "300":
                        $value = "Light";
                        $ind = '300';
                        break;
                    case "regular":
                        $value = "Regular";
                        $ind = '400';
                        break;
                    case "400":
                        $value = "Regular";
                        $ind = '400';
                        break;
                    case "500":
                        $value = "Medium";
                        $ind = '500';
                        break;
                    case "600":
                        $value = "Semi Bold";
                        $ind = '600';
                        break;
                    case "700":
                        $value = "Bold";
                        $ind = '700';
                        break;
                    case "800":
                        $value = "Ultra Bold";
                        $ind = '800';
                        break;
                    case "900":
                        $value = "Heavy";
                        $ind = '900';
                        break;
                    default:
                        break;
                }
                $new_styles[$ind] = $value;
            }
            return $new_styles;
        }
        $fontFamily = [];
        $fontFamily['Initial']['name'] = 'Default';
        $fontFamily['Initial']['styles'] = [400 => 'Regular', 500 => 'Medium', 600 => 'Semi Bold', 700 => 'Bold', 800 => 'Ultra Bold'];
        $fontFamily['Initial']['type'] = '';
        $font_data  = et_get_google_fonts();
        $Font = get_option( 'et_uploaded_fonts', []);
        $font_data  = empty($Font) ? $font_data : array_merge($font_data,$Font);
        foreach($font_data as $ind => $value) {
            $fontFamily[$ind]['name'] = $ind;
            $fontFamily[$ind]['styles'] = pac_change_styles($value['styles']);
            $fontFamily[$ind]['type'] = et_builder_get_websafe_font_stack($value['type']);
        }
        $data['fontFamily'] = $fontFamily;

        $admins = get_users( array(
            'role__in' => 'administrator',
            'fields'   => array( 'user_login' ),
        ));
        $logins = array_merge( get_super_admins(), wp_list_pluck( $admins, 'user_login'));
        $admins = get_users( array(
            'login__in' => $logins,
            'fields'    => ['ID','display_name'],
        ));

        $allowAdmin = [];
        $allowAdminDefault = [];
        foreach($admins as $ind => $value) {
            if(isset($value) && isset($value->id)){
                $metaData = get_user_meta($value->id);
                $value->first_name = $metaData['first_name'][0];
                $value->last_name = $metaData['last_name'][0];
                $admins[$ind] = $value;
                $allowAdmin[$value->id] = isset(json_decode(get_option('pacDaAllowAdmin'))->{$value->id}) && json_decode(get_option('pacDaAllowAdmin'))->{$value->id} !== null ? json_decode(get_option('pacDaAllowAdmin'))->{$value->id} : true;
                $allowAdminDefault[$value->id] = true;
            }
        }
        update_option( 'pacDaAllowAdminDefault', wp_json_encode($allowAdminDefault));
        $data['adminsData'] = $admins;
        $data['allowAdmin'] = $allowAdmin;
        $data['allowAdminDefault'] = $allowAdminDefault;

        return rest_ensure_response($data);
    }

    // Update All General Data
    function da_update_all_general_data( $req ) {
        $card = $req['card'];
        $value = $req['value'];
        if($card === 'AdminBar'){
            update_option( 'pacDaUtilityCards',$value);
            $environment = sanitize_text_field($req['environment']);
            update_option( 'pacDaEnvironmentsData',$environment);
            $CQL = sanitize_text_field($req['CQL']);
            $Parent = sanitize_text_field($req['Parent']);
            $Icon = sanitize_text_field($req['Icon']);
            $Json = sanitize_text_field($req['Json']);
            update_option( 'pacDaCustomQuickLinks',$CQL);
            update_option( 'pacDaCustomQuickLinksParent',$Parent);
            update_option( 'pacDaCustomQuickLinksIcon',$Icon);
            update_option( 'pacDaCustomQuickLinksData',$Json);
        }elseif($card === 'Editor'){
            update_option( 'pacDaUtilityCards',$value);
            $posttype = sanitize_text_field($req['posttype']);
            update_option( 'pacDaAllPostTypes',$posttype);
            $posttypeCE = sanitize_text_field($req['posttypeCE']);
            update_option( 'pacDaAllPostTypesCE',$posttypeCE);
        }elseif($card === 'VisualBuilder' || $card === 'Updates' || $card === 'Miscellaneous' || $card === 'DiviLibrary' || $card === 'PostTypes'){
            if($card === 'VisualBuilder'){
                $utilityCards = json_decode($value);
                if(boolval($utilityCards->disableAi) === true){
                    $et_pb_role_settings = get_option('et_pb_role_settings');
                    $et_pb_role_settings['administrator']['divi_ai'] = 'off';
                    $et_pb_role_settings['editor']['divi_ai'] = 'off';
                    update_option( 'et_pb_role_settings',$et_pb_role_settings);
                }
            }
            update_option( 'pacDaUtilityCards',$value);
        }elseif($card === 'Media'){
            update_option( 'pacDaMediaCards',$value);
        }elseif($card === 'Font'){
            update_option( 'pacDaFontCards',$value);
        }elseif($card === 'Code'){
            update_option( 'pacDaCodeData',$value);
        }elseif($card === 'Accessibility'){
            update_option( 'pacDaAccessibilityHelper',$value);
        }elseif($card === 'Styles'){
            $H2  = sanitize_text_field( $req['H2']);
            $H3  = sanitize_text_field( $req['H3']);
            $H4  = sanitize_text_field( $req['H4']);
            $H5  = sanitize_text_field( $req['H5']);
            $H6  = sanitize_text_field( $req['H6']);
            $BT   = sanitize_text_field( $req['BT']);
            $LT   = sanitize_text_field( $req['LT']);
            $OL   = sanitize_text_field( $req['OL']);
            $UL   = sanitize_text_field( $req['UL']);
            update_option( 'paDaStylesH1', $value);
            update_option( 'paDaStylesH2', $H2);
            update_option( 'paDaStylesH3', $H3);
            update_option( 'paDaStylesH4', $H4);
            update_option( 'paDaStylesH5', $H5);
            update_option( 'paDaStylesH6', $H6);
            update_option( 'paDaStylesBT', $BT);
            update_option( 'paDaStylesLT', $LT);
            update_option( 'paDaStylesOL', $OL);
            update_option( 'paDaStylesUL', $UL);
        }elseif($card === 'Addons'){
            update_option( 'pacDaAddons',$value);
        }elseif($card === 'Scrollbar'){
            update_option( 'pacDaScrollbar',$value);
        }elseif($card === 'BackToTop'){
            update_option( 'pacDaBackToTop',$value);
        }elseif($card === 'TextReplace'){
            update_option( 'pacDaTextReplace',$value);
            $Json = sanitize_text_field($req['Json']);
            update_option( 'pacDaTextReplaceData',$Json);
        }elseif($card === 'updateGlobalColors'){
            et_update_option( 'et_global_colors', json_decode($value, true));
            return rest_ensure_response(true);
        }elseif($card === 'adminSettings'){
            update_option( 'pacDaAllowAdmin',$value);
            $utilityCards = $req['utilityCards'];
            update_option( 'pacDaUtilityCards',$utilityCards);
            return rest_ensure_response(true);
        }
        return rest_ensure_response(true);
    }

    // Get Tutorilas
    function da_get_tutorials_data( $req ) {
        $tutorials_data = [];
        $tutorials_posts = [];
        $ctgR = [];
        $ctgS = [];
        $checkBoxId = [];
        $checkBoxVal = [];
        $response = wp_remote_get('https://www.peeayecreative.com/wp-content/uploads/pac_da_api/tuts-categories.json');
        if (!is_wp_error($response) || 200 === wp_remote_retrieve_response_code($response)) {
            $data = json_decode(wp_remote_retrieve_body($response), true);
            if (!empty($data) && !is_wp_error($data)) {
                $ctgA = $data;
            }
        }
        foreach($ctgA as $ind => $val) {
            if ($val['name'] === 'Divi FAQ' | $val['name'] === 'Featured' | $val['name'] === 'Uncategorized'){
                $ctgR[$val['name']] = $val['ID'];
            }
            elseif($val['name'] === 'Tutorials'){
                foreach($val['children'] as $indC => $valC) {
                    $valC['name'] = str_replace("&amp;", "&", $valC['name']);
                    $ctgS[$valC['name']] = $valC['ID'];
                    $checkBoxId[] = $valC['ID'];
                    $checkBoxVal[] = false;
                }
            }
            else{
                $ctgS[$val['name']] = $val['ID'];
                $checkBoxId[] = $val['ID'];
                $checkBoxVal[] = false;
            }
        }

        $response = wp_remote_get('https://www.peeayecreative.com/wp-content/uploads/pac_da_api/tuts-posts.json?getNew=' . wp_rand(1,99999));
        if (!is_wp_error($response) || 200 === wp_remote_retrieve_response_code($response)) {
            $data = json_decode(wp_remote_retrieve_body($response), true);
            if (!empty($data) && !is_wp_error($data)) {
                $pacPosts = $data;
            }
        }
        if (!isset($pacPosts) || empty($pacPosts)) {
            return rest_ensure_response(null);
        }
        foreach($pacPosts as $ind => $val) {
            if(empty(array_intersect($ctgR, $val['categories']))){
                $tutorials_posts[] = $val;
            }
            elseif(!empty(array_intersect($ctgS, $val['categories']))){
                $tutorials_posts[] = $val;
            }
        }

        $tutorials_data['ctgS'] = array_flip($ctgS);
        $tutorials_data['checkBoxId'] = array_flip($checkBoxId);
        $tutorials_data['checkBoxVal'] = $checkBoxVal;
        $tutorials_data['posts'] = $tutorials_posts;
        return rest_ensure_response($tutorials_data);
    }

    // Get Web Report
    function da_get_web_report( $req ) {
        $report = [];
        global $wp_version;
        $report['website_name'] = get_bloginfo('name');
        $report['php_version'] = phpversion();
        $website_url = esc_url( home_url( '/' ) );
        $remove_schemes = array( "https://", "http://" );
        $website_url = str_replace( $remove_schemes, "", rtrim($website_url, '/') );
        $report['website_url'] = $website_url;
        if(ini_get('memory_limit')) {
            $memory_limit = ini_get('memory_limit');
        } else {
            $memory_limit = 'N/A';
        }
        $report['memory_limit'] = $memory_limit;

        if(strpos($website_url, '.local') !== false & strpos($website_url, '.local') !== ''){
            $report['hosting_name'] = 'Local Host';
        }
        else{
            $hosting = get_option('pacDaWebHosting');
            if($hosting !== 'null'){
                $report['hosting_name'] = $hosting;
            }
            else{
                if (!function_exists('pa_get_hosting_info')):
                    function pa_get_hosting_info($url, $key = '')
                    {
                        $data = [];
                        $query_arg = add_query_arg(['key' => 'wblljgr58tapsydu1baivzwbk6ntadmfe9l2vafs1bim88m4omodkl8hxq236vkrk5dwym', 'url' => $url], 'https://www.who-hosts-this.com/API/Host');
                        $response = wp_remote_get($query_arg, ['timeout' => 15, 'sslverify' => false]);
                        if (!is_wp_error($response) || 200 === wp_remote_retrieve_response_code($response)) {
                            $response = json_decode(wp_remote_retrieve_body($response), true);
                            if (isset($response['results'][0])) {
                                $data = $response['results'][0];
                                if ('' !== $key) {
                                    $data = isset($data[$key]) ? $data[$key] : '';
                                }
                            }
                        }
                        return $data;
                    }
                endif;
                // Specific
                $response = pa_get_hosting_info($website_url,'isp_name');
                $report['hosting_name'] = $response;
                update_option( 'pac_da_hosting', $response );
            }
        }
        if(ini_get('max_execution_time')) {
			$max_execute = ini_get('max_execution_time') . 's';
		} else {
			$max_execute = 'N/A';
		}
        $report['max_execute_time'] = $max_execute;
        $report['wp_version'] = $wp_version;
        if(ini_get('max_input_time')) {
			$max_input_time = ini_get('max_input_time') . 's';
		} else {
			$max_input_time = 'N/A';
		}
        $report['max_input_time'] = $max_input_time;
        $theme = !is_child_theme() ? wp_get_theme() : wp_get_theme()->parent();
        $report['divi_version'] = $theme->get( 'Version');
        if ( is_ssl() ){
            $connection_status = 'Connection Is Secure With HTTPS';
        }else{
            $connection_status = 'Connection Is Insecure';
        }
        $report['connection_status'] = $connection_status;
        $current_theme = wp_get_theme();
        if ( ! empty( $current_theme->get( 'Template' ) ) ) {
            $report['child_theme'] = $current_theme->get( 'Name' );
        }else{
            $report['child_theme'] = 'None';
        }
        global $da_start, $da_elapsed, $da_max_time, $da_iterations;
        $da_max_time = ini_get('max_execution_time') ? (float)(ini_get('max_execution_time') / 2) : (float)(30);
        $dir = WP_CONTENT_DIR . '/cache';
        $da_start = microtime(true);
        $da_iterations = 0;
        function da_format_size_units($bytes){
            if ($bytes >= 1073741824)
            {
                $bytes = number_format($bytes / 1073741824, 0) . 'gb';
            }
            elseif ($bytes >= 1048576)
            {
                $bytes = number_format($bytes / 1048576, 0) . 'mb';
            }
            elseif ($bytes >= 1024)
            {
                $bytes = number_format($bytes / 1024, 0) . 'kb';
            }
            elseif ($bytes > 1)
            {
                $bytes = $bytes . ' bytes';
            }
            elseif ($bytes == 1)
            {
                $bytes = $bytes . ' byte';
            }
            else
            {
                $bytes = '0 bytes';
            }
        
            return $bytes;
        }
        function da_folder_size( $dir ){
            global $da_start, $da_elapsed, $da_max_time, $da_iterations;//usleep(100000);
            $da_iterations++;
            $size = 0;
            $da_elapsed = microtime(true) - $da_start;//echo $da_elapsed.'<br>';
            if ( $da_elapsed >= $da_max_time ) {
                return $size;
            }
            foreach (glob(rtrim($dir, '/').'/*', GLOB_NOSORT) as $each) {
                $size += is_file($each) ? filesize($each) : da_folder_size($each);
            }
            return $size;
        }
        if ( is_dir( $dir ) ) {
            $folder_size = da_format_size_units( da_folder_size( $dir ) );
            if ( $da_elapsed >= $da_max_time ){
                $cache_size = $folder_size . "+";
            } else {
                $cache_size = $folder_size;
            }
        } else {
            $cache_size = 'N/A';
        }
        $report['cache_size'] = $cache_size;
        $plugins = [];
        $all = get_plugins();
        $active = get_option('active_plugins');
        foreach( $all as $key => $value ){
            if( in_array( $key, $active ) ){
                $plugins[] = $value["Name"];
            }
        }
        $plugins = implode( ", ", $plugins );
        $report['plugins'] = $plugins;
        $report['time'] = current_time('F j, Y \a\t g:i A T');
        return $report;
    }

    // Get Custom Quick Links
    function da_get_custom_quick_links( $req ) {
        $data = [];
        $data['customQuickLinks'] = (bool)get_option('pacDaCustomQuickLinks', false);
        $data['customQuickLinksParent'] = get_option('pacDaCustomQuickLinksParent','');
        $data['customQuickLinksIcon'] = get_option('pacDaCustomQuickLinksIcon','');
        $data['customQuickLinksData'] = json_decode(get_option('pacDaCustomQuickLinksData','[{"label": "", "url": "","child": "0","tab": "new"},{"label": "", "url": "","child": "1","tab": "new"}]'));
        return $data;
    }

    // Get Custom Quick Links
    function da_get_local_font_data( $req ) {
        $data = [];
        $data['Font'] = get_option( 'et_uploaded_fonts', []);
        $data['allowedFileTypes'] = get_allowed_font_file_types();
        return $data;
    }

    // Upload Font File
    function da_upload_font_file($req) {
        if (isset($_FILES['file']['name']) && isset($_FILES['file']['tmp_name'])) {
            $filename = $_FILES['file']['name']; // phpcs:ignore
            $tmp_file = $_FILES['file']['tmp_name']; // phpcs:ignore
            $upload_dir = wp_upload_dir();
            $target_dir = $upload_dir['basedir'] . '/et-fonts/';
            // Create the 'fonts' directory if it doesn't exist
            if (!file_exists($target_dir)) {
                mkdir($target_dir);
            }
            $target_file = $target_dir . $filename;
            if (move_uploaded_file($tmp_file, $target_file)) {
                return rest_ensure_response('Font uploaded successfully.');
            } else {
                return rest_ensure_response('Font upload failed.');
            }
        } else {
            return rest_ensure_response(false);
        }
    }

    // Update et_uploaded_fonts
    function da_update_in_font_db( $req ) {

        $Front_fonts = [];
        $FF_fonts = [];
        $Front_data = [];
        $et_uploaded_fonts = get_option('et_uploaded_fonts');
        $fontName = sanitize_text_field( $req['fontName'] );
        $fileName = sanitize_text_field( $req['fileName'] );
        $fontStyleAll = (bool)sanitize_text_field( $req['fontStyleAll'] );
        $fontStyleR = $req['fontStyleR'];

        $upload_dir = wp_upload_dir();
        $target_path = $upload_dir['baseurl'] . '/et-fonts/' . $fileName;

        $fontWeight = '';
        foreach ($fontStyleR as $index => $value) {
            if ($value) {
                $fontWeight .= $index . ',';
            }
        }
        $fontWeight = rtrim($fontWeight, ',');
        $fontWeight = $fontStyleAll === true ? '100,200,300,400,500,600,700,800,900' : $fontWeight;

        $fontFileArray = explode(".", $fileName);
        $newFonts = array(
            'font_file' => array(end($fontFileArray) => ''),
            'font_url' => array(end($fontFileArray) => $target_path),
            'styles' => $fontWeight,
            'type' => 'sans-serif',
        );

        function pac_change_styles($styles) {
            $new_styles = [];
            $styles = array_filter(explode(",",$styles), function ($var) { return (strpos($var, 'italic') === false); });
            foreach($styles as $ind => $value) {
                switch ($value) {
                    case "100":
                        $value = "Thin";
                        $ind = '100';
                        break;
                    case "200":
                        $value = "Ultra Light";
                        $ind = '200';
                        break;
                    case "300":
                        $value = "Light";
                        $ind = '300';
                        break;
                    case "regular":
                        $value = "Regular";
                        $ind = '400';
                        break;
                    case "400":
                        $value = "Regular";
                        $ind = '400';
                        break;
                    case "500":
                        $value = "Medium";
                        $ind = '500';
                        break;
                    case "600":
                        $value = "Semi Bold";
                        $ind = '600';
                        break;
                    case "700":
                        $value = "Bold";
                        $ind = '700';
                        break;
                    case "800":
                        $value = "Ultra Bold";
                        $ind = '800';
                        break;
                    case "900":
                        $value = "Heavy";
                        $ind = '900';
                        break;
                    default:
                        break;
                }
                $new_styles[$ind] = $value;
            }
            return $new_styles;
        }
        $Front_fonts['name'] = $fontName;
        $Front_fonts['styles'] = $newFonts['styles'];
        $Front_fonts['type'] = et_builder_get_websafe_font_stack($newFonts['type']);
        $FF_fonts['name'] = $fontName;
        $FF_fonts['styles'] = pac_change_styles($newFonts['styles']);
        $FF_fonts['type'] = et_builder_get_websafe_font_stack($newFonts['type']);
        $Front_data['FF_fonts'] = $FF_fonts;
        $Front_data['Front_fonts'] = $Front_fonts;
        if (is_array($et_uploaded_fonts)) {
            $et_uploaded_fonts[$fontName] = $newFonts;
        }
        else{
            $et_uploaded_fonts = [];
            $et_uploaded_fonts[$fontName] = $newFonts;
        }

        $result = update_option( 'et_uploaded_fonts', $et_uploaded_fonts);

        return rest_ensure_response($result ? $Front_data : $result);
    }

    // Delete font
    function da_delete_in_font_db( $req ) {
        $fontName = sanitize_text_field( $req['fontName'] );
        $et_uploaded_fonts = get_option('et_uploaded_fonts',[]);
        if (!is_array($et_uploaded_fonts) || empty($et_uploaded_fonts)) {
            $et_uploaded_fonts = [];
        }
        if(!empty($et_uploaded_fonts)){
            foreach ($et_uploaded_fonts[$fontName]['font_url'] as $value) {
                $file_path = ABSPATH . substr($value, strpos($value, "wp-content/uploads/et-fonts"));
                if (file_exists($file_path)) {
                    unlink($file_path);
                }
                unset($et_uploaded_fonts[$fontName]);
                if(count($et_uploaded_fonts) === 0){
                    $result = delete_option('et_uploaded_fonts');
                    return rest_ensure_response($result);
                }else{
                    $result = update_option( 'et_uploaded_fonts', $et_uploaded_fonts);
                    return rest_ensure_response($result);
                }
            }
        }
        return rest_ensure_response(false);
    }

    function da_get_global_styles( $req ) {
        $styles = [];
        $styles['stylesH1']  = json_decode(get_option('paDaStylesH1', '{"H1":false,"H1DpFF":"Initial","H1DpFW":"400","H1DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1DpUColor":"#333","H1DpUStyle":"solid","H1DpColor":"#333","H1DpTS":"30px","H1DpLS":"0px","H1DpLH":"1em","H1TbFF":"Initial","H1TbFW":"400","H1TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1TbUColor":"#333","H1TbUStyle":"solid","H1TbColor":"#333","H1TbTS":"30px","H1TbLS":"0px","H1TbLH":"1em","H1PhFF":"Initial","H1PhFW":"400","H1PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1PhUColor":"#333","H1PhUStyle":"solid","H1PhColor":"#333","H1PhTS":"30px","H1PhLS":"0px","H1PhLH":"1em"}'));
        $styles['stylesH2']  = json_decode(get_option('paDaStylesH2', '{"H2":false,"H2DpFF":"Initial","H2DpFW":"400","H2DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2DpUColor":"#333","H2DpUStyle":"solid","H2DpColor":"#333","H2DpTS":"26px","H2DpLS":"0px","H2DpLH":"1em","H2TbFF":"Initial","H2TbFW":"400","H2TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2TbUColor":"#333","H2TbUStyle":"solid","H2TbColor":"#333","H2TbTS":"26px","H2TbLS":"0px","H2TbLH":"1em","H2PhFF":"Initial","H2PhFW":"400","H2PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2PhUColor":"#333","H2PhUStyle":"solid","H2PhColor":"#333","H2PhTS":"26px","H2PhLS":"0px","H2PhLH":"1em"}'));
        $styles['stylesH3']  = json_decode(get_option('paDaStylesH3', '{"H3":false,"H3DpFF":"Initial","H3DpFW":"400","H3DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3DpUColor":"#333","H3DpUStyle":"solid","H3DpColor":"#333","H3DpTS":"22px","H3DpLS":"0px","H3DpLH":"1em","H3TbFF":"Initial","H3TbFW":"400","H3TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3TbUColor":"#333","H3TbUStyle":"solid","H3TbColor":"#333","H3TbTS":"22px","H3TbLS":"0px","H3TbLH":"1em","H3PhFF":"Initial","H3PhFW":"400","H3PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3PhUColor":"#333","H3PhUStyle":"solid","H3PhColor":"#333","H3PhTS":"22px","H3PhLS":"0px","H3PhLH":"1em"}'));
        $styles['stylesH4']  = json_decode(get_option('paDaStylesH4', '{"H4":false,"H4DpFF":"Initial","H4DpFW":"400","H4DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4DpUColor":"#333","H4DpUStyle":"solid","H4DpColor":"#333","H4DpTS":"18px","H4DpLS":"0px","H4DpLH":"1em","H4TbFF":"Initial","H4TbFW":"400","H4TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4TbUColor":"#333","H4TbUStyle":"solid","H4TbColor":"#333","H4TbTS":"18px","H4TbLS":"0px","H4TbLH":"1em","H4PhFF":"Initial","H4PhFW":"400","H4PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4PhUColor":"#333","H4PhUStyle":"solid","H4PhColor":"#333","H4PhTS":"18px","H4PhLS":"0px","H4PhLH":"1em"}'));
        $styles['stylesH5']  = json_decode(get_option('paDaStylesH5', '{"H5":false,"H5DpFF":"Initial","H5DpFW":"400","H5DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5DpUColor":"#333","H5DpUStyle":"solid","H5DpColor":"#333","H5DpTS":"16px","H5DpLS":"0px","H5DpLH":"1em","H5TbFF":"Initial","H5TbFW":"400","H5TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5TbUColor":"#333","H5TbUStyle":"solid","H5TbColor":"#333","H5TbTS":"16px","H5TbLS":"0px","H5TbLH":"1em","H5PhFF":"Initial","H5PhFW":"400","H5PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5PhUColor":"#333","H5PhUStyle":"solid","H5PhColor":"#333","H5PhTS":"16px","H5PhLS":"0px","H5PhLH":"1em"}'));
        $styles['stylesH6']  = json_decode(get_option('paDaStylesH6', '{"H6":false,"H6DpFF":"Initial","H6DpFW":"400","H6DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6DpUColor":"#333","H6DpUStyle":"solid","H6DpColor":"#333","H6DpTS":"14px","H6DpLS":"0px","H6DpLH":"1em","H6TbFF":"Initial","H6TbFW":"400","H6TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6TbUColor":"#333","H6TbUStyle":"solid","H6TbColor":"#333","H6TbTS":"14px","H6TbLS":"0px","H6TbLH":"1em","H6PhFF":"Initial","H6PhFW":"400","H6PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6PhUColor":"#333","H6PhUStyle":"solid","H6PhColor":"#333","H6PhTS":"14px","H6PhLS":"0px","H6PhLH":"1em"}'));
        $styles['stylesBT']  = json_decode(get_option('paDaStylesBT', '{"BT":false, "BTDpFF":"Initial","BTDpFW":"400","BTDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTDpUColor":"#666","BTDpUStyle":"solid","BTDpColor":"#666","BTDpTS":"14px","BTDpLS":"0px","BTDpLH":"1em","BTTbFF":"Initial","BTTbFW":"400","BTTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTTbUColor":"#666","BTTbUStyle":"solid","BTTbColor":"#666","BTTbTS":"14px","BTTbLS":"0px","BTTbLH":"1em","BTPhFF":"Initial","BTPhFW":"400","BTPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTPhUColor":"#666","BTPhUStyle":"solid","BTPhColor":"#666","BTPhTS":"14px","BTPhLS":"0px","BTPhLH":"1em"}'));
        $styles['stylesLT']  = json_decode(get_option('paDaStylesLT', '{"LT":false, "LTDpFF":"Initial","LTDpFW":"400","LTDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTDpUColor":"#2ea3f2","LTDpUStyle":"solid","LTDpColor":"#2ea3f2","LTDpHColor":"#2ea3f2","LTDpTS":"14px","LTDpLS":"0px","LTDpLH":"1em","LTTbFF":"Initial","LTTbFW":"400","LTTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTTbUColor":"#2ea3f2","LTTbUStyle":"solid","LTTbColor":"#2ea3f2","LTTbHColor":"#2ea3f2","LTTbTS":"14px","LTTbLS":"0px","LTTbLH":"1em","LTPhFF":"Initial","LTPhFW":"400","LTPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTPhUColor":"#2ea3f2","LTPhUStyle":"solid","LTPhColor":"#2ea3f2","LTPhHColor":"#2ea3f2","LTPhTS":"14px","LTPhLS":"0px","LTPhLH":"1em"}'));
        $styles['stylesOL']  = json_decode(get_option('paDaStylesOL', '{"OL":false, "OLDpFF":"Initial","OLDpFW":"400","OLDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLDpUColor":"#666","OLDpUStyle":"solid","OLDpColor":"#666","OLDpTS":"14px","OLDpLS":"0px","OLDpLH":"1em","OLDpT":"decimal","OLDpP":"outside","OLDpI":"0px","OLTbFF":"Initial","OLTbFW":"400","OLTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLTbUColor":"#666","OLTbUStyle":"solid","OLTbColor":"#666","OLTbTS":"14px","OLTbLS":"0px","OLTbLH":"1em","OLTbT":"decimal","OLTbP":"outside","OLTbI":"0px","OLPhFF":"Initial","OLPhFW":"400","OLPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLPhUColor":"#666","OLPhUStyle":"solid","OLPhColor":"#666","OLPhTS":"14px","OLPhLS":"0px","OLPhLH":"1em","OLPhT":"decimal","OLPhP":"outside","OLPhI":"0px"}'));
        $styles['stylesUL']  = json_decode(get_option('paDaStylesUL', '{"UL":false, "ULDpFF":"Initial","ULDpFW":"400","ULDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULDpUColor":"#666","ULDpUStyle":"solid","ULDpColor":"#666","ULDpTS":"14px","ULDpLS":"0px","ULDpLH":"1em","ULDpT":"disc","ULDpP":"outside","ULDpI":"0px","ULTbFF":"Initial","ULTbFW":"400","ULTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULTbUColor":"#666","ULTbUStyle":"solid","ULTbColor":"#666","ULTbTS":"14px","ULTbLS":"0px","ULTbLH":"1em","ULTbT":"disc","ULTbP":"outside","ULTbI":"0px","ULPhFF":"Initial","ULPhFW":"400","ULPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULPhUColor":"#666","ULPhUStyle":"solid","ULPhColor":"#666","ULPhTS":"14px","ULPhLS":"0px","ULPhLH":"1em","ULPhT":"disc","ULPhP":"outside","ULPhI":"0px"}'));
        return rest_ensure_response($styles);
    }

    // Reset Settings
    function da_reset_settings( $req ) {
        $val = sanitize_text_field( $req['value'] );
        if(boolval($val)){
            update_option('pacDaFontCards', false);
            update_option('pacDaCustomQuickLinks', false);
            update_option('pacDaCustomQuickLinksIcon', '');
            update_option('pacDaCustomQuickLinksParent', '');
            update_option('pacDaMediaCards', '{"svgUploads":false,"svgUploadsValue":"default","fileSize":false,"fileSizeValue":"512kb","imgReplace":false,"imgTitle":false,"useAltText":false,"ignoreAltText":false}');
            update_option('pacDaDashboardCards', '{"systemStatus":false,"featureUpdate":false,"blogPublic":false}');
            update_option('pacDaCodeData', '{"css":false,"jquery":false,"php":false,"runPhp":false,"enableResize":false,"boxHeight":false,"boxHeightValue":"313px","enableResizeCe":false,"boxHeightCe":false,"boxHeightValueCe":"313px"}');
            update_option('pacDaAllowAdmin', get_option('pacDaAllowAdminDefault'));
            update_option('pacDaAllPostTypesCE', get_option('pacDaAllDefaultPostTypes','{"page":false,"post":false,"project":false}'));
            update_option('pacDaAllPostTypes', get_option('pacDaAllDefaultPostTypes','{"page":false,"post":false,"project":false}'));
            update_option('pacDaCustomQuickLinksData', '[{"label": "", "url": "","child": "0","tab": "new"},{"label": "", "url": "","child": "1","tab": "new"}]');
            update_option('pacDaMaintenanceCards', '{"commingSoon":false,"Maintenance":false,"commingSoonPage":"none","MaintenancePage":"none","byPassCommingSoon":"false","byPassLink":null,"autoClearCache":"disable","clearOnExitsVB":false,"clearOnUpdatePlugin":false,"clearOnUpdateTheme":false}');
            update_option('pacDaEnvironmentsData', '{"enable":false,"environment":"default","prodLabel":"Production","prodClr":"#00D263","stagLabel":"Staging","stagClr":"#7846FF","devLabel":"Development","devClr":"#F15A24"}');
            update_option('pacDaAddons', '{"startUp":true,"maintenance":true,"utility":true,"media":true,"learning":true,"support":true,"fonts":true,"styles":true,"code":true,"frontend":true,"accessibility":true}');
            update_option('pacDaAccessibilityHelper', '{"focusable":false,"outline":false,"outlineColor":"#E1271A","ariaSupport":false,"iconsAria":false,"Underline":false,"underlineHeading":false,"underlineBtns":false,"underlineMenu":false,"skipNavigation":false,"hideSkipNavigation":false,"duplicateMenu":false,"dropdownMenu":false,"improveScreenReader":false,"pinchZoom":false,"Tota11y":false}');
            update_option('pacDaStartupCards', '{"import":false,"plugin":false,"theme":false,"page":false,"post":false,"widgets":false,"homepage":false,"menu":false,"disableComments":false,"permalink":false,"installPlugins":false}');
            update_option('pacDaUtilityCards', '{"staticCss":false,"localStorage":false,"hardRefresh":false,"quickLinks":false,"tBTDetails":false,"removeHowdy":false,"adminbarEverywhere":false,"adminbarFrontend":false,"adminbarHover":false,"duplicateDiviLib":false,"exportDiviLib":false,"diviLibWidget":false,"diviLibSC":false,"openVisualBuilder":false,"disableCommentSettings":false,"duplicatePagePost":false,"escKey":false,"hideLayout":false,"disableAi":false,"hideExploreBtn":false,"horizontalScroll":false,"cursorHighlight":false,"bgHighlight":"#3399ff","textHighlight":"#ffffff","hideProject":false,"renameProject":false,"pluralName":"Projects","singularName":"Project","slug":"projects","pluralCategory":"Project Categories","singularCategory":"Project Category","slugCategory":"project_category","pluralTag":"Project Tags","singularTag":"Project Tag","slugTag":"project_tag","menuIcon":"dashicons-admin-post","defaultThemes":false,"updateThemes":false,"updatePlugins":false,"themeBuilderCPT":false,"fullScreen":false,"edidorBtn":false,"stickyToolbar":false,"htmlArea":false,"htmlAreaValue":"400px","popupHeight":false,"popupHeightValue":"500px","iconAreaHeight":false,"iconAreaHeightValue":"300px","textPopover":false,"rowWidth":false,"swapSandGbtn":false,"deleteData":false}');
            update_option('paDaStylesH1', '{"H1":false,"H1DpFF":"Initial","H1DpFW":"400","H1DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1DpUColor":"#333","H1DpUStyle":"solid","H1DpColor":"#333","H1DpTS":"30px","H1DpLS":"0px","H1DpLH":"1em","H1TbFF":"Initial","H1TbFW":"400","H1TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1TbUColor":"#333","H1TbUStyle":"solid","H1TbColor":"#333","H1TbTS":"30px","H1TbLS":"0px","H1TbLH":"1em","H1PhFF":"Initial","H1PhFW":"400","H1PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H1PhUColor":"#333","H1PhUStyle":"solid","H1PhColor":"#333","H1PhTS":"30px","H1PhLS":"0px","H1PhLH":"1em"}');
            update_option('paDaStylesH2', '{"H2":false,"H2DpFF":"Initial","H2DpFW":"400","H2DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2DpUColor":"#333","H2DpUStyle":"solid","H2DpColor":"#333","H2DpTS":"26px","H2DpLS":"0px","H2DpLH":"1em","H2TbFF":"Initial","H2TbFW":"400","H2TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2TbUColor":"#333","H2TbUStyle":"solid","H2TbColor":"#333","H2TbTS":"26px","H2TbLS":"0px","H2TbLH":"1em","H2PhFF":"Initial","H2PhFW":"400","H2PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H2PhUColor":"#333","H2PhUStyle":"solid","H2PhColor":"#333","H2PhTS":"26px","H2PhLS":"0px","H2PhLH":"1em"}');
            update_option('paDaStylesH3', '{"H3":false,"H3DpFF":"Initial","H3DpFW":"400","H3DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3DpUColor":"#333","H3DpUStyle":"solid","H3DpColor":"#333","H3DpTS":"22px","H3DpLS":"0px","H3DpLH":"1em","H3TbFF":"Initial","H3TbFW":"400","H3TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3TbUColor":"#333","H3TbUStyle":"solid","H3TbColor":"#333","H3TbTS":"22px","H3TbLS":"0px","H3TbLH":"1em","H3PhFF":"Initial","H3PhFW":"400","H3PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H3PhUColor":"#333","H3PhUStyle":"solid","H3PhColor":"#333","H3PhTS":"22px","H3PhLS":"0px","H3PhLH":"1em"}');
            update_option('paDaStylesH4', '{"H4":false,"H4DpFF":"Initial","H4DpFW":"400","H4DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4DpUColor":"#333","H4DpUStyle":"solid","H4DpColor":"#333","H4DpTS":"18px","H4DpLS":"0px","H4DpLH":"1em","H4TbFF":"Initial","H4TbFW":"400","H4TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4TbUColor":"#333","H4TbUStyle":"solid","H4TbColor":"#333","H4TbTS":"18px","H4TbLS":"0px","H4TbLH":"1em","H4PhFF":"Initial","H4PhFW":"400","H4PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H4PhUColor":"#333","H4PhUStyle":"solid","H4PhColor":"#333","H4PhTS":"18px","H4PhLS":"0px","H4PhLH":"1em"}');
            update_option('paDaStylesH5', '{"H5":false,"H5DpFF":"Initial","H5DpFW":"400","H5DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5DpUColor":"#333","H5DpUStyle":"solid","H5DpColor":"#333","H5DpTS":"16px","H5DpLS":"0px","H5DpLH":"1em","H5TbFF":"Initial","H5TbFW":"400","H5TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5TbUColor":"#333","H5TbUStyle":"solid","H5TbColor":"#333","H5TbTS":"16px","H5TbLS":"0px","H5TbLH":"1em","H5PhFF":"Initial","H5PhFW":"400","H5PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H5PhUColor":"#333","H5PhUStyle":"solid","H5PhColor":"#333","H5PhTS":"16px","H5PhLS":"0px","H5PhLH":"1em"}');
            update_option('paDaStylesH6', '{"H6":false,"H6DpFF":"Initial","H6DpFW":"400","H6DpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6DpUColor":"#333","H6DpUStyle":"solid","H6DpColor":"#333","H6DpTS":"14px","H6DpLS":"0px","H6DpLH":"1em","H6TbFF":"Initial","H6TbFW":"400","H6TbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6TbUColor":"#333","H6TbUStyle":"solid","H6TbColor":"#333","H6TbTS":"14px","H6TbLS":"0px","H6TbLH":"1em","H6PhFF":"Initial","H6PhFW":"400","H6PhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"H6PhUColor":"#333","H6PhUStyle":"solid","H6PhColor":"#333","H6PhTS":"14px","H6PhLS":"0px","H6PhLH":"1em"}');
            update_option('paDaStylesBT', '{"BT":false, "BTDpFF":"Initial","BTDpFW":"400","BTDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTDpUColor":"#666","BTDpUStyle":"solid","BTDpColor":"#666","BTDpTS":"14px","BTDpLS":"0px","BTDpLH":"1em","BTTbFF":"Initial","BTTbFW":"400","BTTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTTbUColor":"#666","BTTbUStyle":"solid","BTTbColor":"#666","BTTbTS":"14px","BTTbLS":"0px","BTTbLH":"1em","BTPhFF":"Initial","BTPhFW":"400","BTPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"BTPhUColor":"#666","BTPhUStyle":"solid","BTPhColor":"#666","BTPhTS":"14px","BTPhLS":"0px","BTPhLH":"1em"}');
            update_option('paDaStylesLT', '{"LT":false, "LTDpFF":"Initial","LTDpFW":"400","LTDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTDpUColor":"#2ea3f2","LTDpUStyle":"solid","LTDpColor":"#2ea3f2","LTDpHColor":"#2ea3f2","LTDpTS":"14px","LTDpLS":"0px","LTDpLH":"1em","LTTbFF":"Initial","LTTbFW":"400","LTTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTTbUColor":"#2ea3f2","LTTbUStyle":"solid","LTTbColor":"#2ea3f2","LTTbHColor":"#2ea3f2","LTTbTS":"14px","LTTbLS":"0px","LTTbLH":"1em","LTPhFF":"Initial","LTPhFW":"400","LTPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"LTPhUColor":"#2ea3f2","LTPhUStyle":"solid","LTPhColor":"#2ea3f2","LTPhHColor":"#2ea3f2","LTPhTS":"14px","LTPhLS":"0px","LTPhLH":"1em"}');
            update_option('paDaStylesOL', '{"OL":false, "OLDpFF":"Initial","OLDpFW":"400","OLDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLDpUColor":"#666","OLDpUStyle":"solid","OLDpColor":"#666","OLDpTS":"14px","OLDpLS":"0px","OLDpLH":"1em","OLDpT":"decimal","OLDpP":"outside","OLDpI":"0px","OLTbFF":"Initial","OLTbFW":"400","OLTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLTbUColor":"#666","OLTbUStyle":"solid","OLTbColor":"#666","OLTbTS":"14px","OLTbLS":"0px","OLTbLH":"1em","OLTbT":"decimal","OLTbP":"outside","OLTbI":"0px","OLPhFF":"Initial","OLPhFW":"400","OLPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"OLPhUColor":"#666","OLPhUStyle":"solid","OLPhColor":"#666","OLPhTS":"14px","OLPhLS":"0px","OLPhLH":"1em","OLPhT":"decimal","OLPhP":"outside","OLPhI":"0px"}');
            update_option('paDaStylesUL', '{"UL":false, "ULDpFF":"Initial","ULDpFW":"400","ULDpFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULDpUColor":"#666","ULDpUStyle":"solid","ULDpColor":"#666","ULDpTS":"14px","ULDpLS":"0px","ULDpLH":"1em","ULDpT":"disc","ULDpP":"outside","ULDpI":"0px","ULTbFF":"Initial","ULTbFW":"400","ULTbFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULTbUColor":"#666","ULTbUStyle":"solid","ULTbColor":"#666","ULTbTS":"14px","ULTbLS":"0px","ULTbLH":"1em","ULTbT":"disc","ULTbP":"outside","ULTbI":"0px","ULPhFF":"Initial","ULPhFW":"400","ULPhFS":{"italic":false,"uppercase":false,"capitalize":false,"underline":false,"line_through":false},"ULPhUColor":"#666","ULPhUStyle":"solid","ULPhColor":"#666","ULPhTS":"14px","ULPhLS":"0px","ULPhLH":"1em","ULPhT":"disc","ULPhP":"outside","ULPhI":"0px"}');
            update_option('pacDaScrollbar', '{"scrollbar":false,"barWidth":"17px","barBgColor":"#f1f1f1","barRaduis":"3px","barHandleColor":"#c1c1c1","barHandleHColor":"#c1c1c1"}');
            update_option('pacDaBackToTop', '{"backToTop":false,"devices":"all","btnBgColor":"rgba(0,0,0,0.4)","btnBgHColor":"rgba(0,0,0,0.4)","btnRadius":"5px","right":"0px","bottom":"125px","btnTextColor":"#ffffff","btnTextHColor":"#ffffff","btnContent":"icon","btnIcon":"","btnText":"","btnIconPlacement":"left"}');
        }
        return rest_ensure_response('Done');
    }
    
    function da_import_settings( $req ) {
        $enableAddons  = sanitize_text_field($req['enableAddons']);
        update_option( 'pacDaAddons',$enableAddons);
        $dashboardCardsDismiss  = sanitize_text_field($req['dashboardCardsDismiss']);
        $startupCards  = sanitize_text_field($req['startupCards']);
        $maintenanceCards  = sanitize_text_field($req['maintenanceCards']);
        $enableVbAllPosttype  = sanitize_text_field($req['enableVbAllPosttype']);
        $enableVbAllPosttypeCE  = sanitize_text_field($req['enableVbAllPosttypeCE']);
        $utilityCards  = sanitize_text_field($req['utilityCards']);
        $mediaCards  = sanitize_text_field($req['mediaCards']);
        $fontCards  = sanitize_text_field($req['fontCards']);
        update_option( 'pacDaDashboardCards',$dashboardCardsDismiss);
        update_option( 'pacDaStartupCards',$startupCards);
        update_option( 'pacDaMaintenanceCards',$maintenanceCards);
        $postTypes = get_post_types(['show_in_nav_menus' => true], 'objects');
        $updatePostTypesData = [];
        $updatePostTypesCE = [];
        $updatePostTypes = [];
        foreach($postTypes as $slug => $Name) {
            $updatePostTypesCE[$slug] = json_decode($enableVbAllPosttypeCE)->{$slug} !== null ? json_decode($enableVbAllPosttypeCE)->{$slug} : json_decode(get_option('pacDaAllPostTypesCE'))->{$slug};
        }
        $updatePostTypesData['updatePostTypesCE'] = $updatePostTypesCE;
        foreach($postTypes as $slug => $Name) {
            $updatePostTypes[$slug] = json_decode($enableVbAllPosttype)->{$slug} !== null ? json_decode($enableVbAllPosttype)->{$slug} : json_decode(get_option('pacDaAllPostTypes'))->{$slug};
        }
        $updatePostTypesData['updatePostTypes'] = $updatePostTypes;

        update_option( 'pacDaAllPostTypesCE',wp_json_encode($updatePostTypesCE));
        update_option( 'pacDaAllPostTypes',wp_json_encode($updatePostTypes));
        update_option( 'pacDaUtilityCards',$utilityCards);
        update_option( 'pacDaMediaCards',$mediaCards);
        update_option( 'pacDaFontCards',$fontCards);
        $codeData  = sanitize_text_field($req['codeData']);
        $customQuickLinks  = sanitize_text_field($req['customQuickLinks']);
        $customQuickLinksIcon  = sanitize_text_field($req['customQuickLinksIcon']);
        $customQuickLinksParent  = sanitize_text_field($req['customQuickLinksParent']);
        $customQuickLinksJson  = sanitize_text_field($req['customQuickLinksJson']);
        $environmentsData  = sanitize_text_field($req['environmentsData']);
        $accessibilityHelperData  = sanitize_text_field($req['accessibilityHelperData']);
        update_option( 'pacDaCodeData',$codeData);
        update_option( 'pacDaCustomQuickLinks',$customQuickLinks);
        update_option( 'pacDaCustomQuickLinksParent',$customQuickLinksParent);
        update_option( 'pacDaCustomQuickLinksIcon',$customQuickLinksIcon);
        update_option( 'pacDaCustomQuickLinksData',$customQuickLinksJson);
        update_option( 'pacDaEnvironmentsData',$environmentsData);
        update_option( 'pacDaAccessibilityHelper',$accessibilityHelperData);

        $stylesH1  = sanitize_text_field($req['stylesH1']);
        $stylesH2  = sanitize_text_field($req['stylesH2']);
        $stylesH3  = sanitize_text_field($req['stylesH3']);
        $stylesH4  = sanitize_text_field($req['stylesH4']);
        $stylesH5  = sanitize_text_field($req['stylesH5']);
        $stylesH6  = sanitize_text_field($req['stylesH6']);
        $stylesBT  = sanitize_text_field($req['stylesBT']);
        $stylesLT  = sanitize_text_field($req['stylesLT']);
        $stylesOL  = sanitize_text_field($req['stylesOL']);
        $stylesUL  = sanitize_text_field($req['stylesUL']);
        update_option( 'paDaStylesH1', $stylesH1);
        update_option( 'paDaStylesH2', $stylesH2);
        update_option( 'paDaStylesH3', $stylesH3);
        update_option( 'paDaStylesH4', $stylesH4);
        update_option( 'paDaStylesH5', $stylesH5);
        update_option( 'paDaStylesH6', $stylesH6);
        update_option( 'paDaStylesBT', $stylesBT);
        update_option( 'paDaStylesLT', $stylesLT);
        update_option( 'paDaStylesOL', $stylesOL);
        update_option( 'paDaStylesUL', $stylesUL);
        $scrollBar  = sanitize_text_field($req['scrollBar']);
        $backToTop  = sanitize_text_field($req['backToTop']);
        update_option( 'pacDaScrollbar', $scrollBar);
        update_option( 'pacDaBackToTop', $backToTop);
        $diviGlobalColor  = sanitize_text_field($req['diviGlobalColor']);
        if($diviGlobalColor !== false && !empty($diviGlobalColor)){
            et_update_option('et_global_colors', json_decode($diviGlobalColor, true));
        }
        $et_divi  = sanitize_text_field($req['et_divi']);
        if($et_divi !== false && !empty($et_divi)){
            et_update_option('et_divi', json_decode($et_divi, true));
        }
        $wp_get_custom_css_post  = sanitize_text_field($req['wp_get_custom_css_post']);
        if($wp_get_custom_css_post !== false && !empty($wp_get_custom_css_post)){
            et_update_option('theme_mods_Divi', json_decode($wp_get_custom_css_post, true));
        }
        $get_global_presets  = sanitize_text_field($req['get_global_presets']);
        if($get_global_presets !== false && !empty($get_global_presets)){
            et_update_option(ET_Builder_Global_Presets_Settings::instance()::GLOBAL_PRESETS_OPTION, json_decode($get_global_presets, true), false, '', '', true);
        }
        return rest_ensure_response($updatePostTypesData);
    }

    // Premission Function
    function da_divi_permission() {
        return PAC_DA_USER_PREMISSION;
    }
}
new DA_React_Settings_Rest_Route();