<?php
if( ! defined( 'ABSPATH' ) ) : exit(); endif; // No direct access allowed
if (!function_exists('rgbaToString')) :
    function rgbaToString($obj) {
        if (!is_object($obj) || !property_exists($obj, 'r') || !property_exists($obj, 'g') || !property_exists($obj, 'b') || !property_exists($obj, 'a')) {
            return $obj;
        }
        $r = isset($obj->r) ? $obj->r : 0;
        $g = isset($obj->g) ? $obj->g : 0;
        $b = isset($obj->b) ? $obj->b : 0;
        $a = isset($obj->a) ? $obj->a : 1.0;

        $r = max(0, min(255, intval($r)));
        $g = max(0, min(255, intval($g)));
        $b = max(0, min(255, intval($b)));
        $a = max(0.0, min(1.0, floatval($a)));
    
        return "rgba($r, $g, $b, $a)";
    }
endif;
if (!function_exists('pac_da_check_global_color_gcid')) :
    function pac_da_check_global_color_gcid($color) {
        if(preg_match("/" . preg_quote('gcid', "/") . "/", $color)){
            $et_divi  = get_option('et_divi');
            if(isset($et_divi['et_global_colors'])){
                $et_global_colors  = $et_divi['et_global_colors'];
                if(isset($et_global_colors[$color])){
                    $color = $et_global_colors[$color]['color'];
                }
            }
        }
        return rgbaToString($color);
    }
endif;