<?php
get_header();
$layout_id = isset($GLOBALS['divi_assistant_layout_id']) ? sanitize_text_field($GLOBALS['divi_assistant_layout_id']) : '';
if (empty($layout_id)) {
    return;
}
?>
    <div id="main-content">
        <div id="content-area" class="clearfix">
            <article id="post-<?php echo esc_attr($layout_id); ?>" <?php post_class(); ?>>
                <?php
                $content = et_builder_get_layout_opening_wrapper();
                if ('page' === get_post_type($layout_id)) {
                    $content .= do_shortcode(get_post($layout_id)->post_content);
                } else {
                    $is_critical_enabled = apply_filters('et_builder_critical_css_enabled', false);
                    $content .= $is_critical_enabled ? ET_Builder_Element::get_style(false, $layout_id, true).ET_Builder_Element::get_style(true, $layout_id, true) : ET_Builder_Element::get_style(false, $layout_id).ET_Builder_Element::get_style(true, $layout_id);
                    $content .= do_shortcode("[et_pb_section global_module='".$layout_id."']");
                }
                $content .= et_builder_get_layout_closing_wrapper();
                $allowed_html = wp_kses_allowed_html('post');
                $allowed_html['input'] = [
                    'type' => true,
                    'name' => true,
                    'value' => true,
                    'placeholder' => true,
                ];
                echo wp_kses($content, $allowed_html);
                ?>
            </article>
        </div>
    </div>
<?php
get_footer();