module.exports = {
    entry: "./src/index.js",
    output: {
        path: __dirname,
        filename: "./dist/bundle.js"
    },
    module: {
        loaders: [{
            test: /.js$/,
            loader: "babel-loader",
            exclude: /node_modules/,
            options: {
                presets: [
                    ["env", "react"]
                ],
                plugins: ["transform-class-properties"]
            }
        }, {
            test: /\.css$/,
            loader: "style-loader!css-loader"
        }, {
            test: /\.(jpe?g|png|gif|woff|woff2|eot|ttf|svg)(\?[a-z0-9=.]+)?$/,
            loader: 'url-loader?limit=100000'
        }]
    }
};