(function ($) {
    "use strict";
    $(document).ready(function () {
        const rfTemplate = $('#renderform__template');
        const rfChangesList = $('#renderform__changes_list');
        const rfChangesListItem = $($('#renderform__changes_item_template').html());
        const rfNonce = $('input[name=renderform_nonce]').val();
        const rfAddChangesButton = $('#renderform__add_change_button');
        const rfRenderImageButton = $('#renderform__render_image');
        const rfFeaturedImageButton = $('#renderform__set_featured_image');
        const rfImagePreview = $('#renderform__image_preview');
        const rfHiddenImageUrl = $('#renderform__image_url');


        var newListItem = rfChangesListItem;
        var maxChangesListItems = Number($('input[name=renderform__maxChangesListItems]').val());

        function resetUI() {
            rfChangesList.empty();
            maxChangesListItems = 0;
            updateUI();
            rfImagePreview.attr('src', '').attr('alt', '');
            rfHiddenImageUrl.val('');
            rfFeaturedImageButton.show();
        }

        rfTemplate.on('change', function () {
            const data = {
                action: 'renderform_get_template_data',
                _wpnonce: rfNonce,
                template_id: $(this).val()
            };

            resetUI();

            $.post(ajaxurl, data, function (response) {
                if (response.success) {
                    maxChangesListItems = response.data.length;
                    renderChangesListItem(response.data);
                    updateUI();
                }
            });
        });

        rfTemplate.on('renderform:init', function () {
            const data = {
                action: 'renderform_get_template_data',
                _wpnonce: rfNonce,
                template_id: $(this).val()
            };
            $.post(ajaxurl, data, function (response) {
                if (response.success) {
                    newListItem = rfChangesListItem.clone();
                    const selectField = $("select", newListItem);
                    $.each(response.data, function (i, changeItem) {
                        selectField.append('<option value="' + changeItem.key + '">' + changeItem.key + '</option>');
                    });
                    if (maxChangesListItems === 0) {
                        renderChangesListItem(response.data);
                    }
                    maxChangesListItems = response.data.length;
                    updateUI();
                    console.info('RenderForm Metabox Initialized');
                }
            });
        })

        function renderChangesListItem(changesArray) {
            newListItem = rfChangesListItem.clone();
            const selectField = $("select", newListItem);
            $.each(changesArray, function (i, changeItem) {
                selectField.append('<option value="' + changeItem.key + '">' + changeItem.key + '</option>');
            });
            rfChangesList.append(newListItem.clone());
        }

        rfAddChangesButton.on('click', function (e) {
            e.preventDefault();
            rfChangesList.append(newListItem.clone());
            updateUI();
        });

        function updateUI() {
            const isVisible = rfChangesList.children().length < maxChangesListItems;
            rfAddChangesButton.toggle(isVisible);
            $('.renderform__is_visible_not_empty').toggle(rfChangesList.children().length > 0);
            $('.renderform__is_visible_with_image_preview').toggle(rfImagePreview.attr('src').length !== 0);
        }

        rfRenderImageButton.on('click', function (e) {
            e.preventDefault();
            var changes = [];
            $('li', '#renderform__changes_list').each(function () {
                const changeObject = {
                    'key': $('select', this).val(),
                    'value': $('input', this).val()
                };
                changes.push(changeObject);
            });

            const data = {
                action: 'renderform_render_image',
                _wpnonce: rfNonce,
                template_id: rfTemplate.val(),
                changes: changes
            };

            rfImagePreview.attr('src', '').attr('alt', 'Please wait...');
            rfHiddenImageUrl.val('');
            updateUI();

            $.post(ajaxurl, data, function (response) {
                if (response.success) {
                    const imageUrl = response.data;
                    rfImagePreview.attr('src', imageUrl).attr('alt', 'Rendered Image Preview');
                    rfFeaturedImageButton.prop('disabled', false).show();
                    rfHiddenImageUrl.val(imageUrl);
                } else {
                    rfImagePreview.attr('src', '').attr('alt', 'Error!');
                    rfHiddenImageUrl.val('');
                }
                updateUI();
            });
        });

        rfFeaturedImageButton.on('click', function (e) {
            e.preventDefault();

            const data = {
                action: 'renderform_set_featured_image',
                _wpnonce: rfNonce,
                template_id: rfTemplate.val(),
                image: rfHiddenImageUrl.val(),
                post_id: $('#post_ID').val()
            };

            if (!data.image || !data.post_id) {
                return;
            }

            rfFeaturedImageButton.prop('disabled', true);

            $.post(ajaxurl, data, function (response) {
                if (response.success) {
                    rfFeaturedImageButton.fadeOut('fast');
                    if(wp.data) {
                        wp.data.dispatch( 'core/editor' ).editPost({ featured_media: response.data });
                    } else {
                        wp.media.featuredImage.set(response.data);
                    }
                } else {
                    rfFeaturedImageButton.prop('disabled', false);
                }
            });
        });

        // Initialization

        updateUI();
        rfTemplate.trigger('renderform:init');
    });
})(jQuery);