<?php
/**
 * Plugin Name:       RenderForm.io
 * Plugin URI:        https://renderform.io
 * Description:       RenderForm integration
 * Version:           1.0.1
 * Requires PHP:      7.4
 * Author:            Krzysztof Piątkowski
 * Author URI:        https://github.com/piatkowski
 * License:           GPLv2
 * License URI:       https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain:       renderform
 */

if ( ! class_exists( 'RenderForm_Plugin' ) ) {

	include __DIR__ . '/loader.php';

	class RenderForm_Plugin {
		const VERSION = '1.0.1';

		public static function run() {
			RenderForm_Settings::init();
			RenderForm_Gutenberg_Metabox::init();
			RenderForm_Gutenberg_Ajax::register_actions();
			RenderForm_Post::init();
		}

		public static function get_path() {
			return __FILE__;
		}
	}

	RenderForm_Plugin::run();
}