<?php

class RenderForm_Gutenberg_Metabox {
	public static function init() {
		add_action( 'add_meta_boxes', [ __CLASS__, 'add_metabox' ] );
		add_action( 'enqueue_block_editor_assets', [ __CLASS__, 'enqueue_scripts' ] );
		add_action( 'load-post.php', [ __CLASS__, 'enqueue_scripts' ] );
		add_action( 'load-post-new.php', [ __CLASS__, 'enqueue_scripts' ] );
	}

	public static function add_metabox() {
		$icon_url = plugins_url( 'assets/img/renderform-icon.svg', RenderForm_Plugin::get_path() );

		add_meta_box(
			'renderform_metabox',
			'<img src="' . $icon_url . '" width="24" height="24" alt="" /><span>RenderForm</span>',
			[ __CLASS__, 'render_html_metabox_content' ],
			null,
			'side'
		);
	}

	public static function enqueue_scripts() {
		wp_register_script(
			'renderform-gutenberg-metabox-js',
			plugins_url( 'assets/js/gutenberg-metabox.min.js', RenderForm_Plugin::get_path() ),
			[ 'jquery' ],
			RenderForm_Plugin::VERSION,
			true,
		);
		wp_register_style(
			'renderform-gutenberg-metabox-css',
			plugins_url( 'assets/css/gutenberg-metabox.min.css', RenderForm_Plugin::get_path() ),
			null,
			RenderForm_Plugin::VERSION,
		);

		wp_enqueue_script( 'renderform-gutenberg-metabox-js' );
		wp_enqueue_style( 'renderform-gutenberg-metabox-css' );
	}

	private static function render_html_changes_options( $template_data, $selected_key = '' ) {
		$output = [];
		try {
			foreach ( $template_data as $item ) {
				if ( ! empty( $item['key'] ) ) {
					$output[] = '<option value="' . esc_attr( $item['key'] ) . '"' . selected( $item['key'], $selected_key, false ) . '>' . esc_html( $item['key'] ) . '</option>';
				}
			}
		} catch ( RenderForm_API_Exception $e ) {
			return '';
		}

		return join( "\n", $output );
	}

	public static function render_html_metabox_content() {
		try {
			$api             = new RenderForm_API();
			$post_id         = absint( $_REQUEST['post'] ?? 0 );
			$rf_metabox_data = RenderForm_Post::get_metabox_data( $post_id );

			$template_data = ! empty( $rf_metabox_data['template'] ) ? $api->get_template_data( $rf_metabox_data['template'] ) : [];

			?>

            <script type="text/html" id="renderform__changes_item_template">
                <li>
                    <select name="renderform__changes_key[]" autocomplete="off">
                        <option value="0" selected><?php _e( 'Select property', 'renderform' ); ?></option>
                    </select>
                    <input type="text" name="renderform__changes_value[]" autocomplete="off"
                           placeholder="<?php _e( 'Your value', 'renderform' ); ?>">
                </li>
            </script>

            <input type="hidden" name="renderform__maxChangesListItems"
                   value="<?php echo ! empty( $rf_metabox_data['changes'] ) ? count( $template_data ) : 0; ?>">
			<?php wp_nonce_field( RenderForm_Gutenberg_Ajax::NONCE, 'renderform_nonce', false ); ?>

            <div class="form-control">
                <label class="first">
					<?php _e( 'Template', 'renderform' ); ?>
                </label>
                <select id="renderform__template" name="renderform__template" class="full-width" autocomplete="off">
					<?php
					foreach ( $api->get_templates() as $item ) :
						?>
                        <option value="<?php esc_attr_e( $item['id'] ); ?>"<?php selected( $item['id'], $rf_metabox_data['template'] ); ?>><?php esc_html_e( $item['name'] ); ?></option>
					<?php
					endforeach;
					?>
                </select>
            </div>
            <div class="form-control renderform__is_visible_not_empty">
                <label><?php _e( 'Changes', 'renderform' ); ?></label>
                <ul class="changes__items" id="renderform__changes_list">
					<?php
					if ( ! empty( $rf_metabox_data['changes'] ) ) {
						foreach ( $rf_metabox_data['changes'] as $key => $value ) {
							?>
                            <li>
                                <select name="renderform__changes_key[]" autocomplete="off">
                                    <option value="0"><?php _e( 'Select property', 'renderform' ); ?></option>

									<?php echo ! empty( $template_data ) ? wp_kses( self::render_html_changes_options( $template_data, $key ), [
										'option' => [
											'value'    => true,
											'selected' => true
										]
									] ) : ''; ?>
                                </select>
                                <input type="text" name="renderform__changes_value[]" autocomplete="off"
                                       value="<?php esc_attr_e( $value ); ?>">
                            </li>
							<?php
						}
					}
					?>
                </ul>
                <button id="renderform__add_change_button"
                        class="button-secondary"><?php _e( 'Add change', 'renderform' ); ?></button>
            </div>
            <div class="form-control">
                <button id="renderform__render_image"
                        class="button-primary"><?php _e( 'Render image', 'renderform' ); ?></button>
            </div>
            <div class="form-control">
                <img src="<?php echo esc_url( $rf_metabox_data['image_url'] ); ?>" id="renderform__image_preview"
                     alt="">
                <input type="hidden" id="renderform__image_url" name="renderform__image_url"
                       value="<?php echo esc_url( $rf_metabox_data['image_url'] ); ?>">
            </div>
            <div class="form-control renderform__is_visible_with_image_preview">
                <button id="renderform__set_featured_image"
                        class="button-primary"><?php _e( 'Use as featured image', 'renderform' ); ?></button>
            </div>
			<?php
		} catch ( RenderForm_API_Exception $e ) {
			?>
            <div class="form-control">
                <a href="<?php echo RenderForm_Settings::get_admin_url(); ?>"><?php _e( 'Add API KEY', 'renderform' ); ?></a>
            </div>
			<?php
		}
	}
}