<?php

class RenderForm_Post {
	const META_KEY = '_renderform';

	public static function init() {
		add_action( 'save_post', [ __CLASS__, 'save_post' ], 10, 2 );
	}

	/**
	 * Updates RenderForm metabox data on Post save
	 *
	 * @param $post_id
	 * @param $post
	 *
	 * @return void
	 */
	public static function save_post( $post_id, $post ) {
		$capability = $post->post_type === 'page' ? 'edit_page' : 'edit_post';
		if ( ! current_user_can( $capability, $post_id ) || ! post_type_supports( $post->post_type, 'thumbnail' ) || defined( 'DOING_AUTOSAVE' ) ) {
			return;
		}

		if ( isset( $_POST['renderform_nonce'] ) && wp_verify_nonce( $_POST['renderform_nonce'], RenderForm_Gutenberg_Ajax::NONCE ) ) {

			$changes = [];
			if (
				! empty( $_POST['renderform__changes_key'] )
				&& is_array( $_POST['renderform__changes_key'] )
				&& ! empty( $_POST['renderform__changes_value'] )
				&& is_array( $_POST['renderform__changes_value'] )
			) {
				foreach ( $_POST['renderform__changes_key'] as $i => $key ) {
					$value = $_POST['renderform__changes_value'][ $i ] ?? '';
					if ( $value ) {
						$changes[ $key ] = $value;
					}
				}
			}

			if ( ! empty( $_POST['renderform__template'] ) ) {
				$renderform_data = [
					'template'  => sanitize_text_field( $_POST['renderform__template'] ),
					'changes'   => $changes,
					'image_url' => sanitize_url( $_POST['renderform__image_url'] ?? '' )
				];
				update_post_meta( $post_id, self::META_KEY, $renderform_data );
			} else {
				delete_post_meta( $post_id, self::META_KEY );
			}
		}
	}

	/**
	 * Gets RenderForm metabox data
	 *
	 * @param int $post_id
	 *
	 * @return array
	 */
	public static function get_metabox_data( int $post_id ): array {
		$post_meta = get_post_meta( $post_id, self::META_KEY, true );

		return [
			'template' => $post_meta['template'] ?? '',
			'changes'  => (array) ( $post_meta['changes'] ?? [] ),
			'image_url' => $post_meta['image_url'] ?? ''
		];
	}

}