<?php

namespace SEOPressPro\Actions\Api\Metas;

if ( ! defined('ABSPATH')) {
    exit;
}

use SEOPress\Core\Hooks\ExecuteHooks;

class GoogleNewsSettings implements ExecuteHooks {
    /**
     * @var int|null
     */
    private $current_user;

    public function hooks() {
        $this->current_user = wp_get_current_user()->ID;
        add_action('rest_api_init', [$this, 'register']);
    }

    /**
     * @since 5.0.0
     *
     * @return void
     */
    public function register() {
        register_rest_route('seopress/v1', '/posts/(?P<id>\d+)/google-news-settings', [
            'methods'             => 'GET',
            'callback'            => [$this, 'processGet'],
            'args'                => [
                'id' => [
                    'validate_callback' => function ($param, $request, $key) {
                        return is_numeric($param);
                    },
                ],
            ],
            'permission_callback' => function($request) {
                $post_id = $request['id'];
                $current_user = $this->current_user ? $this->current_user : wp_get_current_user()->ID;

                if ( ! user_can( $current_user, 'edit_post', $post_id )) {
                    return false;
                }

                return true;
            },
        ]);

        register_rest_route('seopress/v1', '/posts/(?P<id>\d+)/google-news-settings', [
            'methods'             => 'PUT',
            'callback'            => [$this, 'processPut'],
            'args'                => [
                'id' => [
                    'validate_callback' => function ($param, $request, $key) {
                        return is_numeric($param);
                    },
                ],
            ],
            'permission_callback' => function ($request) {
                $post_id = $request['id'];
                return current_user_can('edit_post', $post_id);
            },
        ]);
    }

    /**
     * @since 5.1.0
     */
    public function processPut(\WP_REST_Request $request) {
        $id     = $request->get_param('id');
        $params = $request->get_params();

        try {
            if(isset($params['_seopress_news_disabled']) && $params['_seopress_news_disabled'] === 'yes'){
                update_post_meta($id, '_seopress_news_disabled', 'yes');
            }
            else{

                delete_post_meta($id, '_seopress_news_disabled');
            }


            return new \WP_REST_Response([
                'code' => 'success',
            ]);
        } catch (\Exception $e) {
            return new \WP_REST_Response([
                'code'         => 'error',
                'code_message' => 'execution_failed',
            ], 403);
        }
    }

    /**
     * @since 5.1.0
     */
    public function processGet(\WP_REST_Request $request) {
        $id    = $request->get_param('id');

        $data = [
            [
                'key'                => '_seopress_news_disabled',
                'type'               => 'checkbox',
                'placeholder'        => '',
                'use_default'        => '',
                'default'            => '',
                'value'              => !empty(get_post_meta($id, '_seopress_news_disabled', true)),
                'label'              => __(' Exclude this post from Google News Sitemap?', 'wp-seopress-pro'),
                'visible'            => true,
                'description'        => '',
            ]
        ];

        return new \WP_REST_Response($data);
    }
}
