<?php
/**
 * Admin: DiviExtensions init.
 *
 * @package Divi
 * @since ??
 */

namespace ET\Builder\Admin\DiviExtensions;

if ( ! defined( 'ABSPATH' ) ) {
	die( 'Direct access forbidden.' );
}

use ET\Builder\Framework\DependencyManagement\Interfaces\DependencyInterface;
use ET\Builder\Framework\DependencyManagement\DependencyTree;
use ET\Builder\Framework\Utility\Conditions;


/**
 * Admin's DiviExtensions initialize class.
 *
 * This class is responsible for initializing DiviExtensions class on the admin area. It accepts
 * a DependencyTree on construction, specifying the dependencies and their priorities for loading.
 *
 * @since ??
 *
 * @param DependencyTree $dependencyTree The dependency tree instance specifying the dependencies and priorities.
 */
class DiviExtensions implements DependencyInterface {

	/**
	 * Initialize DiviExtensions class.
	 *
	 * @since ??
	 */
	public function load() {
		if ( ! Conditions::has_divi_4_only_extension() ) {
			return;
		}

		add_action( 'current_screen', [ $this, 'initialize_divi_extensions_class' ] );
	}

	/**
	 * Initializes DiviExtensions class.
	 *
	 * @since ??
	 *
	 * @return void
	 */
	public static function initialize_divi_extensions_class(): void {
		require_once get_template_directory() . '/includes/builder/api/DiviExtensions.php';
	}
}
